/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.crankstart.core.commands;

import java.io.InputStream;
import java.net.URL;
import org.apache.sling.crankstart.api.CrankstartCommand;
import org.apache.sling.crankstart.api.CrankstartCommandLine;
import org.apache.sling.crankstart.api.CrankstartContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallBundle
implements CrankstartCommand {
    public static final String I_BUNDLE = "bundle";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public boolean appliesTo(CrankstartCommandLine commandLine) {
        return I_BUNDLE.equals(commandLine.getVerb());
    }

    public String getDescription() {
        return "bundle: install a bundle, without starting it";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CrankstartContext crankstartContext, CrankstartCommandLine commandLine) throws Exception {
        String bundleRef = commandLine.getQualifier();
        URL url = new URL(bundleRef);
        BundleContext ctx = crankstartContext.getOsgiFramework().getBundleContext();
        InputStream bundleStream = url.openStream();
        try {
            Bundle b = ctx.installBundle(bundleRef, url.openStream());
            int level = this.getStartLevel(crankstartContext);
            if (level > 0) {
                BundleStartLevel bsl = (BundleStartLevel)b.adapt(BundleStartLevel.class);
                if (bsl == null) {
                    this.log.warn("Bundle does not adapt to BundleStartLevel, cannot set start level", (Object)bundleRef);
                }
                bsl.setStartLevel(level);
            }
            this.log.info("bundle installed at start level {}: {}", (Object)level, (Object)bundleRef);
        }
        finally {
            bundleStream.close();
        }
    }

    private int getStartLevel(CrankstartContext ctx) {
        int result = 0;
        String str = (String)ctx.getDefaults().get("crankstart.bundle.start.level");
        if (str == null) {
            this.log.debug("{} default value is not set, using default bundle start level", (Object)"crankstart.bundle.start.level");
        } else {
            try {
                result = Integer.valueOf(str);
            }
            catch (NumberFormatException nfe) {
                this.log.warn("Invalid {} value [{}], will use default bundle start level", (Object)"crankstart.bundle.start.level", (Object)str);
            }
        }
        return result;
    }
}

