/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.mime.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.commons.mime.MimeTypeProvider;
import org.apache.sling.commons.mime.MimeTypeService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={MimeTypeService.class}, property={"service.vendor=The Apache Software Foundation", "service.description=Apache Sling Commons MIME Type Service"})
@Designate(ocd=Config.class)
public class MimeTypeServiceImpl
implements MimeTypeService,
BundleListener {
    public static final String CORE_MIME_TYPES = "/META-INF/core_mime.types";
    public static final String MIME_TYPES = "/META-INF/mime.types";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, String> mimeMap = new HashMap<String, String>();
    private Map<String, String> extensionMap = new HashMap<String, String>();
    private MimeTypeProvider[] typeProviders;
    private List<MimeTypeProvider> typeProviderList = new ArrayList<MimeTypeProvider>();

    @Override
    public String getMimeType(String name) {
        if (name == null) {
            return null;
        }
        String ext = name.substring(name.lastIndexOf(46) + 1);
        String type = this.mimeMap.get(ext = ext.toLowerCase());
        if (type == null) {
            MimeTypeProvider[] mtp = this.getMimeTypeProviders();
            for (int i = 0; type == null && i < mtp.length; ++i) {
                type = mtp[i].getMimeType(ext);
            }
        }
        return type;
    }

    @Override
    public String getExtension(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        String ext = this.extensionMap.get(mimeType = mimeType.toLowerCase());
        if (ext == null) {
            MimeTypeProvider[] mtp = this.getMimeTypeProviders();
            for (int i = 0; ext == null && i < mtp.length; ++i) {
                ext = mtp[i].getExtension(mimeType);
            }
        }
        return ext;
    }

    @Override
    public void registerMimeType(String mimeType, String ... extensions) {
        if (mimeType == null || mimeType.length() == 0 || extensions == null || extensions.length == 0) {
            return;
        }
        mimeType = mimeType.toLowerCase();
        String defaultExtension = this.extensionMap.get(mimeType);
        for (String extension : extensions) {
            if (extension == null || extension.length() <= 0) continue;
            String oldMimeType = this.mimeMap.get(extension = extension.toLowerCase());
            if (oldMimeType == null) {
                this.log.debug("registerMimeType: Add mapping " + extension + "=" + mimeType);
                this.mimeMap.put(extension, mimeType);
                if (defaultExtension != null) continue;
                defaultExtension = extension;
                continue;
            }
            this.log.info("registerMimeType: Ignoring mapping " + extension + "=" + mimeType + ": Mapping " + extension + "=" + oldMimeType + " already exists");
        }
        if (defaultExtension != null) {
            this.extensionMap.put(mimeType, defaultExtension);
        }
    }

    @Override
    public void registerMimeType(InputStream mimeTabStream) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(mimeTabStream, "ISO-8859-1"));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            this.registerMimeType(line);
        }
    }

    @Activate
    protected void activate(BundleContext context, Config config) {
        context.addBundleListener((BundleListener)this);
        Bundle bundle = context.getBundle();
        this.registerMimeType(bundle.getEntry(CORE_MIME_TYPES));
        this.registerMimeType(bundle.getEntry(MIME_TYPES));
        Bundle[] bundles = context.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            if ((bundles[i].getState() & 0x3C) == 0 || bundles[i].getBundleId() == bundle.getBundleId()) continue;
            this.registerMimeType(bundles[i].getEntry(MIME_TYPES));
        }
        if (config.mime_types() != null) {
            for (String configType : config.mime_types()) {
                this.registerMimeType(configType);
            }
        }
    }

    @Deactivate
    protected void deactivate(BundleContext context) {
        context.removeBundleListener((BundleListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindMimeTypeProvider(MimeTypeProvider mimeTypeProvider) {
        List<MimeTypeProvider> list = this.typeProviderList;
        synchronized (list) {
            this.typeProviderList.add(mimeTypeProvider);
            this.typeProviders = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindMimeTypeProvider(MimeTypeProvider mimeTypeProvider) {
        List<MimeTypeProvider> list = this.typeProviderList;
        synchronized (list) {
            this.typeProviderList.remove(mimeTypeProvider);
            this.typeProviders = null;
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32) {
            try {
                this.registerMimeType(event.getBundle().getEntry(MIME_TYPES));
            }
            catch (IllegalStateException ie) {
                this.log.info("bundleChanged: an issue while registering the mime type occurred");
            }
        }
    }

    @Override
    public Map<String, String> getMimeMap() {
        return this.mimeMap;
    }

    @Override
    public Map<String, String> getExtensionMap() {
        return this.extensionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeTypeProvider[] getMimeTypeProviders() {
        MimeTypeProvider[] list = this.typeProviders;
        if (list == null) {
            List<MimeTypeProvider> list2 = this.typeProviderList;
            synchronized (list2) {
                this.typeProviders = this.typeProviderList.toArray(new MimeTypeProvider[this.typeProviderList.size()]);
                list = this.typeProviders;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMimeType(URL mimetypes) {
        if (mimetypes != null) {
            InputStream ins = null;
            try {
                ins = mimetypes.openStream();
                this.registerMimeType(ins);
            }
            catch (IOException ioe) {
                this.log.warn("An error occurred reading " + mimetypes, (Throwable)ioe);
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void registerMimeType(String line) {
        String[] parts = line.split("\\s+");
        if (parts.length > 1) {
            String[] extensions = new String[parts.length - 1];
            System.arraycopy(parts, 1, extensions, 0, extensions.length);
            this.registerMimeType(parts[0], extensions);
        }
    }

    @ObjectClassDefinition(name="Apache Sling Commons MIME Type Service", description="The Sling Commons MIME Type Service provides support for maintaining and configuring MIME Type mappings.")
    public static @interface Config {
        @AttributeDefinition(name="MIME Types", description="Configures additional MIME type mappings in the traditional mime.types file format: Each property is a blank space separated list of strings where the first string is the MIME type and the rest of the strings are filename extensions referring to the MIME type. Using this property additional MIME type mappings may be defined. Existing MIME type mappings cannot be redefined and setting such mappings in this property has no effect. For a list of existing mappings refer to the MIME Types page.")
        public String[] mime_types();
    }
}

