/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.messaging.mail.internal;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(name="Apache Sling Commons Messaging Mail \u201cSimple Mail Service\u201d", description="Simple mail service sending MIME messages via SMTPS")
@interface SimpleMailServiceConfiguration {
    @AttributeDefinition(name="Names", description="names of this service", required=false)
    public String[] names() default {"default"};

    @AttributeDefinition(name="ThreadPool name", description="name of the ThreadPool to use for sending mails")
    public String threadpool_name() default "default";

    @AttributeDefinition(name="SMTP SSL check server identity", description="check the server identity as specified by RFC 2595")
    public boolean mail_smtps_ssl_checkserveridentity() default true;

    @AttributeDefinition(name="SMTP from", description="from address")
    public String mail_smtps_from();

    @AttributeDefinition(name="SMTP host", description="host of SMTP server")
    public String mail_smtps_host() default "localhost";

    @AttributeDefinition(name="SMTP port", description="port of SMTP server")
    public int mail_smtps_port() default 465;

    @AttributeDefinition(name="Username", description="username for SMTP server")
    public String username();

    @AttributeDefinition(name="Password", description="password for SMTP server", type=AttributeType.PASSWORD)
    public String password();

    @AttributeDefinition(name="Message ID Provider target", description="filter expression to target a Message ID Provider", required=false)
    public String messageIdProvider_target();

    @AttributeDefinition(name="Crypto Service target", description="filter expression to target a Crypto Service", required=false)
    public String cryptoService_target();

    @AttributeDefinition(name="Connection Listeners target", description="filter expression to target Connection Listeners", required=false)
    public String connectionListeners_target();

    @AttributeDefinition(name="Transport Listeners target", description="filter expression to target Transport Listeners", required=false)
    public String transportListeners_target();

    public String webconsole_configurationFactory_nameHint() default "{names} {username}@{mail_smtps_host}:{mail_smtps_port}";
}

