/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class ItemList {
    private static final Logger log = LoggerFactory.getLogger(ItemList.class);
    private final int count;
    private final int end;
    private final List<Resource> items;
    private final int page;
    private final Integer[] pages;
    private final String query;
    private final int start;

    @Inject
    public ItemList(@Self SlingHttpServletRequest request, @RequestAttribute @Named(value="limit") String limit, @RequestAttribute @Named(value="query") String query) {
        this.query = query;
        HashSet<String> distinct = new HashSet<String>();
        if (request.getRequestPathInfo().getSuffix() != null) {
            query = query.replace("{SUFFIX}", request.getRequestPathInfo().getSuffix());
        }
        log.debug("Listing results of: {}", (Object)query);
        ArrayList<Resource> queryItems = new ArrayList<Resource>();
        Iterator res = request.getResourceResolver().findResources(query, "JCR-SQL2");
        while (res.hasNext()) {
            Resource result = (Resource)res.next();
            if (distinct.contains(result.getPath())) continue;
            queryItems.add(result);
            distinct.add(result.getPath());
        }
        this.count = queryItems.size();
        log.debug("Found {} results", (Object)this.count);
        if (StringUtils.isNotBlank((CharSequence)request.getParameter("page")) && request.getParameter("page").matches("\\d+")) {
            this.page = Integer.parseInt(request.getParameter("page"), 10) - 1;
            log.debug("Using page {}", (Object)this.page);
        } else {
            this.page = 0;
            log.debug("Page not specified or not valid");
        }
        int l = Integer.parseInt(limit, 10);
        this.start = this.page * l >= this.count ? this.count : this.page * l;
        log.debug("Using start {}", (Object)this.start);
        this.end = this.page * l + l >= this.count ? this.count : this.page * l + l;
        log.debug("Using end {}", (Object)this.end);
        this.items = queryItems.subList(this.start, this.end);
        ArrayList<Integer> pgs = new ArrayList<Integer>();
        int max = (int)Math.ceil((double)this.count / (double)l) + 1;
        for (int i = 1; i < max; ++i) {
            pgs.add(i);
        }
        this.pages = pgs.toArray(new Integer[pgs.size()]);
        if (log.isDebugEnabled()) {
            log.debug("Loaded pages {}", (Object)Arrays.toString((Object[])this.pages));
        }
    }

    public int getCount() {
        return this.count;
    }

    public int getCurrentPage() {
        return this.page + 1;
    }

    public int getEnd() {
        return this.end;
    }

    public Integer[] getPages() {
        return this.pages;
    }

    public String getQuery() {
        return this.query;
    }

    public List<Resource> getItems() {
        return this.items;
    }

    public int getStart() {
        return this.start;
    }

    public boolean isFirst() {
        return this.page == 0;
    }

    public boolean isLast() {
        if (this.pages.length > 0) {
            return this.page + 1 == this.pages[this.pages.length - 1];
        }
        return true;
    }
}

