/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.cms.PageManager;
import org.apache.sling.cms.PublishableResource;
import org.apache.sling.cms.ResourceTree;
import org.apache.sling.cms.reference.forms.FormAction;
import org.apache.sling.cms.reference.forms.FormActionResult;
import org.apache.sling.cms.reference.forms.FormException;
import org.apache.sling.cms.reference.forms.FormRequest;
import org.apache.sling.cms.reference.forms.impl.FormRequestImpl;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=reference/components/forms/form", "sling.servlet.methods=POST", "sling.servlet.extensions=html", "sling.servlet.selectors=allowpost"})
public class FormHandler
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(FormHandler.class);
    private transient List<FormAction> formActions;
    private static final long serialVersionUID = -8149443208959899098L;

    @Activate
    public FormHandler(@Reference(policyOption=ReferencePolicyOption.GREEDY) List<FormAction> formActions) {
        this.formActions = formActions;
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        ValueMap properties = request.getResource().getValueMap();
        String pagePath = Optional.ofNullable((PageManager)request.getResource().adaptTo(PageManager.class)).map(PageManager::getPage).map(PublishableResource::getPath).orElse(StringUtils.substringBefore((String)request.getResource().getPath(), (String)"/jcr:content"));
        String successPage = null;
        String errorPage = pagePath;
        StringSubstitutor sub = null;
        try {
            log.debug("Extracting form request...");
            FormRequest formRequest = (FormRequest)request.adaptTo(FormRequest.class);
            if (formRequest == null) {
                log.warn("Unable to create form request");
                response.sendRedirect(this.resolveUrl(request, errorPage, "error=init"));
                return;
            }
            log.debug("Loading fields...");
            boolean fieldsLoadSucceeded = ((FormRequestImpl)formRequest).initFields();
            sub = new StringSubstitutor((Map)formRequest.getFormData());
            errorPage = sub.replace((String)properties.get("errorPage", (Object)pagePath));
            if (!fieldsLoadSucceeded) {
                log.warn("Field initialization failed, check logs");
                response.sendRedirect(this.resolveUrl(request, errorPage, "error=fields"));
                return;
            }
            request.getSession().setAttribute(formRequest.getSessionId(), (Object)formRequest.getFormData());
            log.debug("Calling actions...");
            this.callActions(request, formRequest);
            successPage = sub.replace((String)properties.get("successPage", (Object)pagePath));
            request.getSession().removeAttribute(formRequest.getSessionId());
        }
        catch (FormException e) {
            log.warn("Exception executing actions", (Throwable)e);
            response.sendRedirect(request.getResourceResolver().map((HttpServletRequest)request, pagePath) + ".html?error=actions");
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)successPage)) {
            if ("forward".equals(properties.get("successAction", String.class))) {
                SlingHttpServletRequestWrapper requestWrapper = new SlingHttpServletRequestWrapper(request){

                    public String getMethod() {
                        return "GET";
                    }
                };
                request.getRequestDispatcher(successPage).forward((ServletRequest)requestWrapper, (ServletResponse)response);
            } else {
                response.sendRedirect(this.resolveUrl(request, successPage, "message=success"));
            }
        } else {
            response.sendRedirect(this.resolveUrl(request, pagePath, "message=success"));
        }
    }

    private void callActions(SlingHttpServletRequest request, FormRequest formRequest) throws FormException {
        Resource actions = request.getResource().getChild("actions");
        if (actions == null) {
            throw new FormException("No actions provided to handle this form submission");
        }
        List actionResources = ResourceTree.stream((Resource)actions).map(ResourceTree::getResource).collect(Collectors.toList());
        for (Resource actionResource : actionResources) {
            log.debug("Finding action handler for: {}", (Object)actionResource);
            FormAction action = this.formActions.stream().filter(fa -> fa.handles(actionResource)).findFirst().orElse(null);
            if (action == null) continue;
            FormActionResult result = action.handleForm(actionResource, formRequest);
            if (!result.isSucceeded()) {
                throw new FormException("Failed to invoke action: " + action + " with message: " + result.getMessage());
            }
            log.debug("Successfully invoked action: {}", (Object)result.getMessage());
        }
    }

    private String resolveUrl(SlingHttpServletRequest request, String url, String qs) {
        qs = url.contains("?") ? "&" + qs : "?" + qs;
        if (url.startsWith("/")) {
            if (!url.contains(".html")) {
                url = url + ".html";
            }
            url = url + qs;
            return request.getResourceResolver().map((HttpServletRequest)request, url);
        }
        return url + qs;
    }

    protected FormRequest getFormRequest(SlingHttpServletRequest request) throws FormException {
        FormRequest fr = (FormRequest)request.adaptTo(FormRequest.class);
        if (fr != null) {
            ((FormRequestImpl)fr).initFields();
            return fr;
        }
        throw new FormException("Unable to adapt to a form request");
    }
}

