/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.impl.metadata;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.caconfig.annotation.Configuration;
import org.apache.sling.caconfig.annotation.Property;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.apache.sling.caconfig.spi.metadata.PropertyMetadata;

public final class AnnotationClassParser {
    private static final Pattern METHOD_NAME_MAPPING = Pattern.compile("(\\$\\$)|(\\$)|(__)|(_)");

    private AnnotationClassParser() {
    }

    public static boolean isContextAwareConfig(Class<?> clazz) {
        return clazz.isAnnotation() && clazz.isAnnotationPresent(Configuration.class);
    }

    public static String getConfigurationName(Class<?> clazz) {
        Configuration configAnnotation = clazz.getAnnotation(Configuration.class);
        if (configAnnotation == null) {
            return null;
        }
        return AnnotationClassParser.getConfigurationName(clazz, configAnnotation);
    }

    private static String getConfigurationName(Class<?> clazz, Configuration configAnnotation) {
        String configName = configAnnotation.name();
        if (StringUtils.isBlank((CharSequence)configName)) {
            configName = clazz.getName();
        }
        return configName;
    }

    public static String getPropertyName(String methodName) {
        Matcher matcher = METHOD_NAME_MAPPING.matcher(methodName);
        StringBuffer mappedName = new StringBuffer();
        while (matcher.find()) {
            String replacement = "";
            if (matcher.group(1) != null) {
                replacement = "\\$";
            }
            if (matcher.group(2) != null) {
                replacement = "";
            }
            if (matcher.group(3) != null) {
                replacement = "_";
            }
            if (matcher.group(4) != null) {
                replacement = ".";
            }
            matcher.appendReplacement(mappedName, replacement);
        }
        matcher.appendTail(mappedName);
        return mappedName.toString();
    }

    public static ConfigurationMetadata buildConfigurationMetadata(Class<?> clazz) {
        Configuration configAnnotation = clazz.getAnnotation(Configuration.class);
        if (configAnnotation == null) {
            throw new IllegalArgumentException("Class has not @Configuration annotation: " + clazz.getName());
        }
        String configName = AnnotationClassParser.getConfigurationName(clazz, configAnnotation);
        ConfigurationMetadata configMetadata = (ConfigurationMetadata)((ConfigurationMetadata)((ConfigurationMetadata)new ConfigurationMetadata(configName, AnnotationClassParser.buildConfigurationMetadata_PropertyMetadata(clazz), configAnnotation.collection()).label(AnnotationClassParser.emptyToNull(configAnnotation.label()))).description(AnnotationClassParser.emptyToNull(configAnnotation.description()))).properties(AnnotationClassParser.propsArrayToMap(configAnnotation.property()));
        return configMetadata;
    }

    private static ConfigurationMetadata buildConfigurationMetadata_Nested(Class<?> clazz, String configName, boolean collection) {
        return new ConfigurationMetadata(configName, AnnotationClassParser.buildConfigurationMetadata_PropertyMetadata(clazz), collection);
    }

    private static Collection<PropertyMetadata<?>> buildConfigurationMetadata_PropertyMetadata(Class<?> clazz) {
        Method[] propertyMethods;
        TreeSet propertyMetadataSet = new TreeSet(new Comparator<PropertyMetadata<?>>(){

            @Override
            public int compare(PropertyMetadata<?> o1, PropertyMetadata<?> o2) {
                int compare = Integer.compare(o1.getOrder(), o2.getOrder());
                if (compare == 0) {
                    String sort1 = StringUtils.defaultString((String)o1.getLabel(), (String)o1.getName());
                    String sort2 = StringUtils.defaultString((String)o2.getLabel(), (String)o2.getName());
                    compare = sort1.compareTo(sort2);
                }
                return compare;
            }
        });
        for (Method propertyMethod : propertyMethods = clazz.getDeclaredMethods()) {
            PropertyMetadata<?> propertyMetadata = AnnotationClassParser.buildPropertyMetadata(propertyMethod, propertyMethod.getReturnType());
            propertyMetadataSet.add(propertyMetadata);
        }
        return propertyMetadataSet;
    }

    private static <T> PropertyMetadata<T> buildPropertyMetadata(Method propertyMethod, Class<T> type) {
        PropertyMetadata propertyMetadata;
        ConfigurationMetadata nestedConfigMetadata;
        String propertyName = AnnotationClassParser.getPropertyName(propertyMethod.getName());
        if (type.isArray() && type.getComponentType().isAnnotation()) {
            nestedConfigMetadata = AnnotationClassParser.buildConfigurationMetadata_Nested(type.getComponentType(), propertyName, true);
            propertyMetadata = new PropertyMetadata(propertyName, ConfigurationMetadata[].class).configurationMetadata(nestedConfigMetadata);
        } else if (type.isAnnotation()) {
            nestedConfigMetadata = AnnotationClassParser.buildConfigurationMetadata_Nested(type, propertyName, false);
            propertyMetadata = new PropertyMetadata(propertyName, ConfigurationMetadata.class).configurationMetadata(nestedConfigMetadata);
        } else {
            propertyMetadata = new PropertyMetadata(propertyName, type).defaultValue(propertyMethod.getDefaultValue());
        }
        Property propertyAnnotation = propertyMethod.getAnnotation(Property.class);
        if (propertyAnnotation != null) {
            ((PropertyMetadata)((PropertyMetadata)((PropertyMetadata)propertyMetadata.label(AnnotationClassParser.emptyToNull(propertyAnnotation.label()))).description(AnnotationClassParser.emptyToNull(propertyAnnotation.description()))).properties(AnnotationClassParser.propsArrayToMap(propertyAnnotation.property()))).order(propertyAnnotation.order());
        } else {
            Map emptyMap = Collections.emptyMap();
            propertyMetadata.properties(emptyMap);
        }
        return propertyMetadata;
    }

    private static String emptyToNull(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return value;
    }

    private static Map<String, String> propsArrayToMap(String[] properties) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (String property : properties) {
            int index = StringUtils.indexOf((CharSequence)property, (CharSequence)"=");
            if (index < 0) continue;
            String key = property.substring(0, index);
            String value = property.substring(index + 1);
            props.put(key, value);
        }
        return props;
    }
}

