/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets.impl;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.sling.bgservlets.JobProgressInfo;
import org.apache.sling.bgservlets.JobStatus;

public class SuspendableOutputStream
extends FilterOutputStream
implements JobStatus {
    private JobStatus.State state = JobStatus.State.NEW;
    private boolean closed = false;

    public SuspendableOutputStream(OutputStream os) {
        super(os);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkWritePermission();
        super.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkWritePermission();
        super.write(b);
    }

    @Override
    public void write(int b) throws IOException {
        this.checkWritePermission();
        super.write(b);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.state = JobStatus.State.DONE;
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkWritePermission() throws IOException {
        if (this.closed) {
            throw new IOException("Attempt to write to closed stream");
        }
        if (this.state == JobStatus.State.STOP_REQUESTED || this.state == JobStatus.State.STOPPED) {
            this.state = JobStatus.State.STOPPED;
            this.flush();
            throw new StreamStoppedException();
        }
        if (this.state == JobStatus.State.SUSPEND_REQUESTED || this.state == JobStatus.State.SUSPENDED) {
            SuspendableOutputStream suspendableOutputStream = this;
            synchronized (suspendableOutputStream) {
                if (this.state == JobStatus.State.SUSPEND_REQUESTED || this.state == JobStatus.State.SUSPENDED) {
                    this.state = JobStatus.State.SUSPENDED;
                }
                try {
                    while (this.state == JobStatus.State.SUSPENDED) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    throw (IOException)new IOException("InterruptedException in checkWritePermission()").initCause(e);
                }
            }
        }
    }

    @Override
    public JobStatus.State getState() {
        return this.state;
    }

    @Override
    public synchronized void requestStateChange(JobStatus.State s) {
        boolean illegal = false;
        if (this.state != JobStatus.State.DONE) {
            if (s == JobStatus.State.SUSPENDED) {
                if (this.state == JobStatus.State.NEW || this.state == JobStatus.State.QUEUED || this.state == JobStatus.State.RUNNING) {
                    this.state = JobStatus.State.SUSPEND_REQUESTED;
                    this.notify();
                } else if (this.state != JobStatus.State.SUSPEND_REQUESTED && this.state != JobStatus.State.SUSPENDED) {
                    illegal = true;
                }
            } else if (s == JobStatus.State.STOPPED) {
                if (this.state == JobStatus.State.NEW || this.state == JobStatus.State.QUEUED || this.state == JobStatus.State.RUNNING || this.state == JobStatus.State.SUSPEND_REQUESTED || this.state == JobStatus.State.SUSPENDED) {
                    this.state = JobStatus.State.STOP_REQUESTED;
                    this.notify();
                } else if (this.state != JobStatus.State.STOP_REQUESTED && this.state != JobStatus.State.STOPPED) {
                    illegal = true;
                }
            } else if (s == JobStatus.State.RUNNING) {
                if (this.state == JobStatus.State.QUEUED || this.state == JobStatus.State.SUSPEND_REQUESTED || this.state == JobStatus.State.SUSPENDED) {
                    this.state = JobStatus.State.RUNNING;
                    this.notify();
                }
            } else {
                this.state = s;
                this.notify();
            }
        }
        if (illegal) {
            throw new IllegalStateException("Illegal state change:" + (Object)((Object)this.state) + " -> " + (Object)((Object)s));
        }
    }

    @Override
    public JobStatus.State[] getAllowedHumanStateChanges() {
        return SuspendableOutputStream.getAllowedStates(this.state);
    }

    static JobStatus.State[] getAllowedStates(JobStatus.State s) {
        JobStatus.State[] result = new JobStatus.State[]{};
        if (s == JobStatus.State.RUNNING) {
            result = new JobStatus.State[]{JobStatus.State.SUSPENDED, JobStatus.State.STOPPED};
        } else if (s == JobStatus.State.SUSPEND_REQUESTED || s == JobStatus.State.SUSPENDED) {
            result = new JobStatus.State[]{JobStatus.State.RUNNING, JobStatus.State.STOPPED};
        }
        return result;
    }

    @Override
    public String getPath() {
        throw new UnsupportedOperationException("getPath() is not applicable to this class");
    }

    @Override
    public String getStreamPath() {
        throw new UnsupportedOperationException("getStreamPath() is not applicable to this class");
    }

    @Override
    public Date getCreationTime() {
        throw new UnsupportedOperationException("getCreationTime() is not applicable to this class");
    }

    @Override
    public JobProgressInfo getProgressInfo() {
        throw new UnsupportedOperationException("getProgressInfo() is not applicable to this class");
    }

    public static class StreamStoppedException
    extends RuntimeException {
        StreamStoppedException() {
            super("Stopped by " + SuspendableOutputStream.class.getSimpleName());
        }
    }
}

