/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.actions;

import javax.jcr.nodetype.NodeType;
import org.apache.sling.ide.eclipse.core.ServerUtil;
import org.apache.sling.ide.eclipse.ui.actions.NewNodeDialog;
import org.apache.sling.ide.eclipse.ui.internal.Activator;
import org.apache.sling.ide.eclipse.ui.internal.SelectionUtils;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrNode;
import org.apache.sling.ide.transport.NodeTypeRegistry;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.RepositoryException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class JcrNewNodeHandler
extends AbstractHandler {
    private boolean doNotAskAgain;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        NodeType nodeType;
        NodeTypeRegistry ntManager;
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        JcrNode node = SelectionUtils.getFirst(sel, JcrNode.class);
        if (node == null) {
            return null;
        }
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (!node.canCreateChild()) {
            MessageDialog.openInformation((Shell)shell, (String)"Cannot create node", (String)"Node is not covered by the workspace filter as defined in filter.xml");
            return null;
        }
        Repository repository = ServerUtil.getDefaultRepository((IProject)node.getProject());
        NodeTypeRegistry nodeTypeRegistry = ntManager = repository == null ? null : repository.getNodeTypeRegistry();
        if (ntManager == null && !this.doNotAskAgain) {
            MessageDialog dialog = new MessageDialog(null, "Unable to validate node type", null, "Unable to validate node types since project " + node.getProject().getName() + " is not associated with a server or the server is not started.", 6, new String[]{"Cancel", "Continue (do not ask again)", "Continue"}, 1){

                protected void configureShell(Shell shell) {
                    super.configureShell(shell);
                    this.setShellStyle(this.getShellStyle() | 0x10000000);
                }
            };
            int choice = dialog.open();
            if (choice <= 0) {
                return null;
            }
            if (choice == 1) {
                this.doNotAskAgain = true;
            }
        }
        if ((nodeType = node.getNodeType()) != null && nodeType.getName() != null && nodeType.getName().equals("nt:file")) {
            MessageDialog.openInformation((Shell)shell, (String)"Cannot create node", (String)"Node of type nt:file cannot have children");
            return null;
        }
        try {
            NewNodeDialog nnd = new NewNodeDialog(shell, node, ntManager);
            if (nnd.open() == 0) {
                node.createChild(nnd.getValue(), nnd.getChosenNodeType());
                return null;
            }
        }
        catch (RepositoryException e1) {
            Activator.getDefault().getPluginLogger().warn("Could not open NewNodeDialog due to " + String.valueOf((Object)e1), (Throwable)e1);
        }
        return null;
    }
}

