/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal;

import org.apache.sling.ide.eclipse.core.ProjectUtil;
import org.apache.sling.ide.eclipse.core.internal.ProjectHelper;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ContentResourceTester
extends PropertyTester {
    private static final String PN_CAN_BE_EXPORTED = "canBeExported";
    private static final String PN_CAN_BE_IMPORTED = "canBeImported";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!PN_CAN_BE_EXPORTED.equals(property) && !PN_CAN_BE_IMPORTED.equals(property)) {
            return false;
        }
        if (receiver instanceof IProject) {
            return this.isContentProject(receiver);
        }
        if (receiver instanceof IResource) {
            IResource resource = (IResource)receiver;
            IProject project = resource.getProject();
            boolean contentProject = this.isContentProject(project);
            if (!contentProject) {
                return false;
            }
            IFolder syncDirectory = ProjectUtil.getSyncDirectory(project);
            if (syncDirectory == null) {
                return false;
            }
            return syncDirectory.getFullPath().isPrefixOf(resource.getFullPath());
        }
        return false;
    }

    private boolean isContentProject(Object receiver) {
        IProject project = (IProject)receiver;
        return project != null && project.isOpen() && ProjectHelper.isContentProject(project);
    }
}

