/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.AbstractSingleCRS;
import org.apache.sis.referencing.crs.ParametricCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.datum.DefaultParametricDatum;

@XmlType(name="ParametricCRSType", propOrder={"coordinateSystem", "datum"})
@XmlRootElement(name="ParametricCRS")
public class DefaultParametricCRS
extends AbstractSingleCRS<DefaultParametricDatum>
implements ParametricCRS {
    private static final long serialVersionUID = -5443671973122639841L;

    public DefaultParametricCRS(Map<String, ?> properties, DefaultParametricDatum datum, DefaultDatumEnsemble<DefaultParametricDatum> ensemble, DefaultParametricCS cs) {
        super(properties, DefaultParametricDatum.class, datum, ensemble, cs);
        DefaultParametricCRS.checkDimension(1, 1, cs);
    }

    private DefaultParametricCRS(DefaultParametricCRS original, AbstractCS cs) {
        super(original, null, cs);
    }

    protected DefaultParametricCRS(DefaultParametricCRS crs) {
        super(crs);
    }

    @Override
    @XmlElement(name="parametricDatum", required=true)
    public DefaultParametricDatum getDatum() {
        return (DefaultParametricDatum)super.getDatum();
    }

    @Override
    public DefaultDatumEnsemble<DefaultParametricDatum> getDatumEnsemble() {
        return super.getDatumEnsemble();
    }

    @Override
    @XmlElement(name="parametricCS", required=true)
    public DefaultParametricCS getCoordinateSystem() {
        return (DefaultParametricCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultParametricCRS forConvention(AxesConvention convention) {
        return (DefaultParametricCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(AbstractCS cs) {
        return new DefaultParametricCRS(this, cs);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return DefaultParametricCRS.isBaseCRS(formatter) ? "BaseParamCRS" : "ParametricCRS";
    }

    private DefaultParametricCRS() {
    }

    private void setDatum(DefaultParametricDatum value) {
        this.setDatum("parametricDatum", value);
    }

    private void setCoordinateSystem(DefaultParametricCS cs) {
        this.setCoordinateSystem("parametricCS", cs);
    }
}

