/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.infra.merge.result.impl.memory;

import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import java.sql.SQLException;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.mockito.Mockito.RETURNS_DEEP_STUBS;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

class MemoryQueryResultRowTest {
    
    private MemoryQueryResultRow memoryResultSetRow;
    
    @BeforeEach
    void setUp() throws SQLException {
        QueryResult queryResult = mock(QueryResult.class, RETURNS_DEEP_STUBS);
        when(queryResult.getMetaData().getColumnCount()).thenReturn(1);
        when(queryResult.getValue(1, Object.class)).thenReturn("value");
        memoryResultSetRow = new MemoryQueryResultRow(queryResult);
    }
    
    @Test
    void assertGetCell() {
        assertThat(memoryResultSetRow.getCell(1).toString(), is("value"));
    }
    
    @Test
    void assertGetCellWithNegativeColumnIndex() {
        assertThrows(IllegalArgumentException.class, () -> memoryResultSetRow.getCell(-1));
    }
    
    @Test
    void assertGetCellWithColumnIndexOutOfRange() {
        assertThrows(IllegalArgumentException.class, () -> memoryResultSetRow.getCell(2));
    }
    
    @Test
    void assertSetCell() {
        memoryResultSetRow.setCell(1, "new");
        assertThat(memoryResultSetRow.getCell(1).toString(), is("new"));
    }
    
    @Test
    void assertSetCellWithNegativeColumnIndex() {
        assertThrows(IllegalArgumentException.class, () -> memoryResultSetRow.setCell(-1, "new"));
    }
    
    @Test
    void assertSetCellWithColumnIndexOutOfRange() {
        assertThrows(IllegalArgumentException.class, () -> memoryResultSetRow.setCell(2, "new"));
    }
}
