/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.authentication.provider;

import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.config.ConfigurationChangedEvent;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.registry.api.DiscoveryInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class AccessController {
    private static final Logger LOG = LoggerFactory.getLogger(AccessController.class);
    private static final String KEY_WHITE_LIST_PREFIX = "servicecomb.publicKey.accessControl.white";
    private static final String KEY_BLACK_LIST_PREFIX = "servicecomb.publicKey.accessControl.black";
    private static final String KEY_PROPERTY_NAME = "%s.%s.propertyName";
    private static final String KEY_CATEGORY = "%s.%s.category";
    private static final String KEY_RULE_POSTFIX = ".rule";
    private final Environment environment;
    private Map<String, ConfigurationItem> whiteList = new HashMap<String, ConfigurationItem>();
    private Map<String, ConfigurationItem> blackList = new HashMap<String, ConfigurationItem>();

    public AccessController(Environment environment) {
        this.environment = environment;
        this.loadConfigurations(KEY_BLACK_LIST_PREFIX);
        this.loadConfigurations(KEY_WHITE_LIST_PREFIX);
        EventManager.register((Object)this);
    }

    public boolean isAllowed(DiscoveryInstance microservice) {
        return this.whiteAllowed(microservice) && !this.blackDenied(microservice);
    }

    private boolean whiteAllowed(DiscoveryInstance microservice) {
        if (this.whiteList.isEmpty()) {
            return true;
        }
        return this.matchFound(microservice, this.whiteList);
    }

    private boolean blackDenied(DiscoveryInstance microservice) {
        if (this.blackList.isEmpty()) {
            return false;
        }
        return this.matchFound(microservice, this.blackList);
    }

    private boolean matchFound(DiscoveryInstance microservice, Map<String, ConfigurationItem> ruleList) {
        boolean matched = false;
        for (ConfigurationItem item : ruleList.values()) {
            if (!"property".equals(item.category) || !this.matchMicroserviceField(microservice, item) && !this.matchMicroserviceProperties(microservice, item)) continue;
            return true;
        }
        return matched;
    }

    private boolean matchMicroserviceProperties(DiscoveryInstance microservice, ConfigurationItem item) {
        Map properties = microservice.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            if (!((String)entry.getKey()).equals(item.propertyName)) continue;
            return this.isPatternMatch((String)entry.getValue(), item.rule);
        }
        return false;
    }

    private boolean matchMicroserviceField(DiscoveryInstance microservice, ConfigurationItem item) {
        String fieldValue = "version".equals(item.propertyName) ? microservice.getVersion() : ("serviceName".equals(item.propertyName) ? microservice.getServiceName() : (String)microservice.getProperties().get(item.propertyName));
        return this.isPatternMatch(fieldValue, item.rule);
    }

    private boolean isPatternMatch(String value, String pattern) {
        if (pattern.startsWith("*")) {
            return value.endsWith(pattern.substring(1));
        }
        if (pattern.endsWith("*")) {
            return value.startsWith(pattern.substring(0, pattern.length() - 1));
        }
        return value.equals(pattern);
    }

    @Subscribe
    public void onConfigurationChangedEvent(ConfigurationChangedEvent event) {
        for (String changed : event.getChanged()) {
            if (!changed.startsWith(KEY_WHITE_LIST_PREFIX)) continue;
            this.loadConfigurations(KEY_WHITE_LIST_PREFIX);
            break;
        }
        for (String changed : event.getChanged()) {
            if (!changed.startsWith(KEY_BLACK_LIST_PREFIX)) continue;
            this.loadConfigurations(KEY_BLACK_LIST_PREFIX);
            break;
        }
    }

    private void loadConfigurations(String prefix) {
        HashMap<String, ConfigurationItem> configurations = new HashMap<String, ConfigurationItem>();
        Set configsItems = ConfigUtil.propertiesWithPrefix((Environment)((ConfigurableEnvironment)this.environment), (String)prefix);
        for (String pathKey : configsItems) {
            if (!pathKey.endsWith(KEY_RULE_POSTFIX)) continue;
            ConfigurationItem configurationItem = new ConfigurationItem();
            String rule = this.environment.getProperty(pathKey);
            if (StringUtils.isEmpty((CharSequence)rule)) continue;
            configurationItem.rule = rule;
            String pathKeyItem = pathKey.substring(prefix.length() + 1, pathKey.length() - KEY_RULE_POSTFIX.length());
            configurationItem.propertyName = this.environment.getProperty(String.format(KEY_PROPERTY_NAME, prefix, pathKeyItem));
            if (StringUtils.isEmpty((CharSequence)configurationItem.propertyName)) continue;
            configurationItem.category = this.environment.getProperty(String.format(KEY_CATEGORY, prefix, pathKeyItem));
            if (StringUtils.isEmpty((CharSequence)configurationItem.category)) continue;
            configurations.put(pathKeyItem, configurationItem);
        }
        if (KEY_WHITE_LIST_PREFIX.equals(prefix)) {
            this.whiteList = configurations;
            this.logConfigurations(configurations, true);
        } else {
            this.blackList = configurations;
            this.logConfigurations(configurations, false);
        }
    }

    private void logConfigurations(Map<String, ConfigurationItem> configurations, boolean isWhite) {
        configurations.forEach((key, item) -> LOG.info((isWhite ? "White list " : "Black list ") + "config item: key=" + key + ";category=" + item.category + ";propertyName=" + item.propertyName + ";rule=" + item.rule));
    }

    static class ConfigurationItem {
        static final String CATEGORY_PROPERTY = "property";
        String category;
        String propertyName;
        String rule;

        ConfigurationItem() {
        }
    }
}

