/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.utils;

import com.netflix.hystrix.contrib.javanica.aop.aspectj.WeavingMode;
import java.util.Arrays;

public final class EnvUtils {
    private static final String WEAVING_MODE = System.getProperty("weavingMode", WeavingMode.RUNTIME.name()).toUpperCase();

    private EnvUtils() {
    }

    public static WeavingMode getWeavingMode() {
        try {
            return WeavingMode.valueOf(WEAVING_MODE);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("wrong 'weavingMode' property, supported: " + Arrays.toString((Object[])WeavingMode.values()) + ", actual = " + WEAVING_MODE, e);
        }
    }

    public static boolean isCompileWeaving() {
        return WeavingMode.COMPILE == EnvUtils.getWeavingMode();
    }
}

