/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.servo.http;

import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Timer;
import io.reactivex.netty.metrics.HttpServerMetricEventsListener;
import io.reactivex.netty.server.ServerMetricsEvent;
import io.reactivex.netty.servo.ServoUtils;
import io.reactivex.netty.servo.tcp.TcpServerListener;
import java.util.concurrent.TimeUnit;

public class HttpServerListener
extends TcpServerListener<ServerMetricsEvent<?>> {
    private final LongGauge requestBacklog = ServoUtils.newLongGauge("requestBacklog");
    private final LongGauge inflightRequests = ServoUtils.newLongGauge("inflightRequests");
    private final Counter processedRequests;
    private final Counter failedRequests;
    private final Counter responseWriteFailed;
    private final Timer responseWriteTimes = Monitors.newTimer((String)"responseWriteTimes");
    private final Timer requestReadTimes = Monitors.newTimer((String)"requestReadTimes");
    private final HttpServerMetricEventsListenerImpl delegate;

    protected HttpServerListener(String monitorId) {
        super(monitorId);
        this.processedRequests = Monitors.newCounter((String)"processedRequests");
        this.failedRequests = Monitors.newCounter((String)"failedRequests");
        this.responseWriteFailed = Monitors.newCounter((String)"responseWriteFailed");
        this.delegate = new HttpServerMetricEventsListenerImpl();
    }

    public void onEvent(ServerMetricsEvent<?> event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
        this.delegate.onEvent(event, duration, timeUnit, throwable, value);
    }

    public long getRequestBacklog() {
        return ((Number)this.requestBacklog.getValue()).longValue();
    }

    public long getInflightRequests() {
        return ((Number)this.inflightRequests.getValue()).longValue();
    }

    public long getProcessedRequests() {
        return ((Number)this.processedRequests.getValue()).longValue();
    }

    public long getFailedRequests() {
        return ((Number)this.failedRequests.getValue()).longValue();
    }

    public long getResponseWriteFailed() {
        return ((Number)this.responseWriteFailed.getValue()).longValue();
    }

    public Timer getResponseWriteTimes() {
        return this.responseWriteTimes;
    }

    public Timer getRequestReadTimes() {
        return this.requestReadTimes;
    }

    public static HttpServerListener newHttpListener(String monitorId) {
        return new HttpServerListener(monitorId);
    }

    private class HttpServerMetricEventsListenerImpl
    extends HttpServerMetricEventsListener {
        private HttpServerMetricEventsListenerImpl() {
        }

        protected void onRequestHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.processedRequests.increment();
            ServoUtils.decrementLongGauge(HttpServerListener.this.inflightRequests);
            HttpServerListener.this.failedRequests.increment();
        }

        protected void onRequestHandlingSuccess(long duration, TimeUnit timeUnit) {
            ServoUtils.decrementLongGauge(HttpServerListener.this.inflightRequests);
            HttpServerListener.this.processedRequests.increment();
        }

        protected void onResponseContentWriteSuccess(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.responseWriteTimes.record(duration, timeUnit);
        }

        protected void onResponseHeadersWriteSuccess(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.responseWriteTimes.record(duration, timeUnit);
        }

        protected void onResponseContentWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.responseWriteFailed.increment();
        }

        protected void onResponseHeadersWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.responseWriteFailed.increment();
        }

        protected void onRequestReceiveComplete(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.requestReadTimes.record(duration, timeUnit);
        }

        protected void onRequestHandlingStart(long duration, TimeUnit timeUnit) {
            ServoUtils.decrementLongGauge(HttpServerListener.this.requestBacklog);
        }

        protected void onNewRequestReceived() {
            ServoUtils.incrementLongGauge(HttpServerListener.this.requestBacklog);
            ServoUtils.incrementLongGauge(HttpServerListener.this.inflightRequests);
        }

        protected void onConnectionHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.onConnectionHandlingFailed(duration, timeUnit, throwable);
        }

        protected void onConnectionHandlingSuccess(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.onConnectionHandlingSuccess(duration, timeUnit);
        }

        protected void onConnectionHandlingStart(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.onConnectionHandlingStart(duration, timeUnit);
        }

        protected void onNewClientConnected() {
            HttpServerListener.this.onNewClientConnected();
        }

        protected void onByteRead(long bytesRead) {
            HttpServerListener.this.onByteRead(bytesRead);
        }

        protected void onFlushFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.onFlushFailed(duration, timeUnit, throwable);
        }

        protected void onFlushSuccess(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.onFlushSuccess(duration, timeUnit);
        }

        protected void onFlushStart() {
            HttpServerListener.this.onFlushStart();
        }

        protected void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.onWriteFailed(duration, timeUnit, throwable);
        }

        protected void onWriteSuccess(long duration, TimeUnit timeUnit, long bytesWritten) {
            HttpServerListener.this.onWriteSuccess(duration, timeUnit, bytesWritten);
        }

        protected void onWriteStart() {
            HttpServerListener.this.onWriteStart();
        }
    }
}

