/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.config.YAMLUtil;
import org.apache.servicecomb.foundation.common.utils.JvmUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigMapping {
    private static Map<String, Object> configMap = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigMapping.class);

    private ConfigMapping() {
    }

    public static String map(String key) {
        return (String)configMap.get(key);
    }

    public static Map<String, Object> getMapping() {
        return configMap;
    }

    public static Map<String, Object> getConvertedMap(Map<String, Object> oldMap) {
        if (configMap == null) {
            return new LinkedHashMap<String, Object>();
        }
        LinkedHashMap<String, Object> retMap = new LinkedHashMap<String, Object>();
        retMap.putAll(oldMap);
        for (Map.Entry<String, Object> entry : configMap.entrySet()) {
            String key = entry.getKey();
            Object configValue = oldMap.get(key);
            if (configValue == null) continue;
            if (entry.getValue() instanceof List) {
                List newKeys = (List)entry.getValue();
                for (String newKey : newKeys) {
                    retMap.put(newKey, configValue);
                }
                continue;
            }
            String newKey = (String)entry.getValue();
            retMap.put(newKey, configValue);
        }
        return retMap;
    }

    public static Map<String, Object> getConvertedMap(Configuration config) {
        if (configMap == null) {
            return new LinkedHashMap<String, Object>();
        }
        LinkedHashMap<String, Object> retMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : configMap.entrySet()) {
            String key = entry.getKey();
            Object configValue = config.getProperty(key);
            if (configValue == null) continue;
            if (entry.getValue() instanceof List) {
                List newKeys = (List)entry.getValue();
                for (String newKey : newKeys) {
                    retMap.put(newKey, configValue);
                }
                continue;
            }
            String newKey = (String)entry.getValue();
            retMap.put(newKey, configValue);
        }
        return retMap;
    }

    static {
        ClassLoader loader = JvmUtils.findClassLoader();
        ArrayList<URL> urlList = new ArrayList<URL>();
        configMap = new HashMap<String, Object>();
        try {
            Enumeration<URL> urls = loader.getResources("mapping.yaml");
            while (urls.hasMoreElements()) {
                urlList.add(urls.nextElement());
            }
            for (URL url : urlList) {
                InputStream in = url.openStream();
                Throwable throwable = null;
                try {
                    configMap.putAll(YAMLUtil.yaml2Properties(in));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("get config mapping file error!", (Throwable)e);
        }
    }
}

