/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx.accesslog.element.impl;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.ext.web.RoutingContext;
import org.apache.servicecomb.transport.rest.vertx.accesslog.AccessLogParam;
import org.apache.servicecomb.transport.rest.vertx.accesslog.element.AccessLogItem;

public class RequestProtocolItem
implements AccessLogItem<RoutingContext> {
    public static final String EMPTY_RESULT = "-";

    @Override
    public String getFormattedItem(AccessLogParam<RoutingContext> accessLogParam) {
        HttpServerRequest request = accessLogParam.getContextData().request();
        if (null == request) {
            return EMPTY_RESULT;
        }
        if (null == request.version()) {
            return EMPTY_RESULT;
        }
        return this.getStringVersion(request.version());
    }

    private String getStringVersion(HttpVersion version) {
        switch (version) {
            case HTTP_2: {
                return "HTTP/2.0";
            }
            case HTTP_1_0: {
                return "HTTP/1.0";
            }
            case HTTP_1_1: {
                return "HTTP/1.1";
            }
        }
        return EMPTY_RESULT;
    }
}

