/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.niws.client.http;

import com.google.common.collect.Lists;
import com.netflix.client.ClientException;
import com.netflix.client.DefaultLoadBalancerRetryHandler;
import com.netflix.client.config.IClientConfig;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.List;
import org.apache.http.ConnectionClosedException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpHostConnectException;

public class HttpClientLoadBalancerErrorHandler
extends DefaultLoadBalancerRetryHandler {
    protected List<Class<? extends Throwable>> retriable = Lists.newArrayList((Object[])new Class[]{ConnectException.class, SocketTimeoutException.class, ConnectTimeoutException.class, NoHttpResponseException.class, ConnectionPoolTimeoutException.class, ConnectionClosedException.class, HttpHostConnectException.class});
    protected List<Class<? extends Throwable>> circuitRelated = Lists.newArrayList((Object[])new Class[]{SocketException.class, SocketTimeoutException.class, ConnectTimeoutException.class, ConnectionClosedException.class, HttpHostConnectException.class});

    public HttpClientLoadBalancerErrorHandler() {
    }

    public HttpClientLoadBalancerErrorHandler(IClientConfig clientConfig) {
        super(clientConfig);
    }

    public HttpClientLoadBalancerErrorHandler(int retrySameServer, int retryNextServer, boolean retryEnabled) {
        super(retrySameServer, retryNextServer, retryEnabled);
    }

    public boolean isCircuitTrippingException(Throwable e) {
        if (e instanceof ClientException) {
            return ((ClientException)e).getErrorType() == ClientException.ErrorType.SERVER_THROTTLED;
        }
        return super.isCircuitTrippingException(e);
    }

    public boolean isRetriableException(Throwable e, boolean sameServer) {
        ClientException ce;
        if (e instanceof ClientException && (ce = (ClientException)e).getErrorType() == ClientException.ErrorType.SERVER_THROTTLED) {
            return !sameServer && this.retryEnabled;
        }
        return super.isRetriableException(e, sameServer);
    }

    protected List<Class<? extends Throwable>> getRetriableExceptions() {
        return this.retriable;
    }

    protected List<Class<? extends Throwable>> getCircuitRelatedExceptions() {
        return this.circuitRelated;
    }
}

