/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicyFactory;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancedRetryPolicy;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerContext;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;

public class RibbonLoadBalancedRetryPolicyFactory
implements LoadBalancedRetryPolicyFactory {
    private SpringClientFactory clientFactory;

    public RibbonLoadBalancedRetryPolicyFactory(SpringClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public LoadBalancedRetryPolicy create(String serviceId, ServiceInstanceChooser loadBalanceChooser) {
        RibbonLoadBalancerContext lbContext = this.clientFactory.getLoadBalancerContext(serviceId);
        return new RibbonLoadBalancedRetryPolicy(serviceId, lbContext, loadBalanceChooser, this.clientFactory.getClientConfig(serviceId));
    }
}

