/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.model.Import;
import io.protostuff.compiler.parser.FileReader;
import io.protostuff.compiler.parser.Importer;
import io.protostuff.compiler.parser.ProtoContext;
import io.protostuff.compiler.parser.ProtoContextPostProcessor;
import javax.inject.Inject;

public class ImportsPostProcessor
implements ProtoContextPostProcessor {
    private final Importer importer;

    @Inject
    public ImportsPostProcessor(Importer importer) {
        this.importer = importer;
    }

    @Override
    public void process(ProtoContext context) {
        this.resolveImports(context);
    }

    private void resolveImports(ProtoContext context) {
        for (Import anImport : context.getProto().getImports()) {
            FileReader reader = context.getFileReader();
            String file = anImport.getValue();
            ProtoContext importedContext = this.importer.importFile(reader, file);
            if (anImport.isPublic()) {
                context.addPublicImport(importedContext);
            } else {
                context.addImport(importedContext);
            }
            anImport.setProto(importedContext.getProto());
        }
    }
}

