/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.client.http;

import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.ProxyOptions;
import org.apache.servicecomb.foundation.common.encrypt.Encryptions;
import org.apache.servicecomb.foundation.vertx.VertxTLSBuilder;
import org.apache.servicecomb.serviceregistry.client.http.AbstractClientPool;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientPool
extends AbstractClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientPool.class);
    public static final HttpClientPool INSTANCE = new HttpClientPool();

    private HttpClientPool() {
    }

    @Override
    protected boolean isWorker() {
        return false;
    }

    @Override
    public HttpClientOptions createHttpClientOptions() {
        HttpVersion ver = ServiceRegistryConfig.INSTANCE.getHttpVersion();
        HttpClientOptions httpClientOptions = new HttpClientOptions();
        httpClientOptions.setProtocolVersion(ver);
        httpClientOptions.setConnectTimeout(ServiceRegistryConfig.INSTANCE.getConnectionTimeout());
        httpClientOptions.setIdleTimeout(ServiceRegistryConfig.INSTANCE.getIdleConnectionTimeout());
        if (ServiceRegistryConfig.INSTANCE.isProxyEnable().booleanValue()) {
            ProxyOptions proxy = new ProxyOptions();
            proxy.setHost(ServiceRegistryConfig.INSTANCE.getProxyHost());
            proxy.setPort(ServiceRegistryConfig.INSTANCE.getProxyPort());
            proxy.setUsername(ServiceRegistryConfig.INSTANCE.getProxyUsername());
            proxy.setPassword(Encryptions.decode((String)ServiceRegistryConfig.INSTANCE.getProxyPasswd(), (String)"sc.consumer"));
            httpClientOptions.setProxyOptions(proxy);
        }
        if (ver == HttpVersion.HTTP_2) {
            LOGGER.debug("service center client protocol version is HTTP/2");
            httpClientOptions.setHttp2ClearTextUpgrade(false);
        }
        if (ServiceRegistryConfig.INSTANCE.isSsl()) {
            LOGGER.debug("service center client performs requests over TLS");
            VertxTLSBuilder.buildHttpClientOptions((String)"sc.consumer", (HttpClientOptions)httpClientOptions);
        }
        return httpClientOptions;
    }
}

