// Copyright 2013 The Closure Library Authors. All Rights Reserved.
// Use of this source code is governed by the Apache License, Version 2.0.

////////////////////////// NOTE ABOUT EDITING THIS FILE ///////////////////////
//                                                                           //
// Any edits to this file must be applied to vec4f_test.js by running:       //
//   swap_type.sh vec4d_test.js > vec4f_test.js                              //
//                                                                           //
////////////////////////// NOTE ABOUT EDITING THIS FILE ///////////////////////

goog.provide('goog.vec.vec4dTest');
goog.setTestOnly('goog.vec.vec4dTest');

goog.require('goog.testing.jsunit');
goog.require('goog.vec.vec4d');

function testCreate() {
  var v = goog.vec.vec4d.create();
  assertElementsEquals([0, 0, 0, 0], v);
}

function testCreateFromArray() {
  var v = goog.vec.vec4d.createFromArray([1, 2, 3, 4]);
  assertElementsEquals([1, 2, 3, 4], v);
}

function testCreateFromValues() {
  var v = goog.vec.vec4d.createFromValues(1, 2, 3, 4);
  assertElementsEquals([1, 2, 3, 4], v);
}

function testClone() {
  var v0 = goog.vec.vec4d.createFromValues(1, 2, 3, 4);
  var v1 = goog.vec.vec4d.clone(v0);
  assertElementsEquals([1, 2, 3, 4], v1);
}

function testSet() {
  var v = goog.vec.vec4d.create();
  goog.vec.vec4d.setFromValues(v, 1, 2, 3, 4);
  assertElementsEquals([1, 2, 3, 4], v);

  goog.vec.vec4d.setFromArray(v, [4, 5, 6, 7]);
  assertElementsEquals([4, 5, 6, 7], v);
}

function testAdd() {
  var v0 = goog.vec.vec4d.setFromArray(goog.vec.vec4d.create(), [1, 2, 3, 4]);
  var v1 = goog.vec.vec4d.setFromArray(goog.vec.vec4d.create(), [5, 6, 7, 8]);
  var v2 = goog.vec.vec4d.setFromVec4d(goog.vec.vec4d.create(), v0);

  goog.vec.vec4d.add(v2, v1, v2);
  assertElementsEquals([1, 2, 3, 4], v0);
  assertElementsEquals([5, 6, 7, 8], v1);
  assertElementsEquals([6, 8, 10, 12], v2);

  goog.vec.vec4d.add(goog.vec.vec4d.add(v0, v1, v2), v0, v2);
  assertElementsEquals([7, 10, 13, 16], v2);
}

function testSubtract() {
  var v0 = goog.vec.vec4d.setFromArray(goog.vec.vec4d.create(), [4, 3, 2, 1]);
  var v1 = goog.vec.vec4d.setFromArray(goog.vec.vec4d.create(), [5, 6, 7, 8]);
  var v2 = goog.vec.vec4d.setFromVec4d(goog.vec.vec4d.create(), v0);

  goog.vec.vec4d.subtract(v2, v1, v2);
  assertElementsEquals([4, 3, 2, 1], v0);
  assertElementsEquals([5, 6, 7, 8], v1);
  assertElementsEquals([-1, -3, -5, -7], v2);

  goog.vec.vec4d.setFromValues(v2, 0, 0, 0, 0);
  goog.vec.vec4d.subtract(v1, v0, v2);
  assertElementsEquals([1, 3, 5, 7], v2);

  goog.vec.vec4d.subtract(goog.vec.vec4d.subtract(v1, v0, v2), v0, v2);
  assertElementsEquals([-3, 0, 3, 6], v2);
}

function testNegate() {
  var v0 = goog.vec.vec4d.setFromArray(goog.vec.vec4d.create(), [1, 2, 3, 4]);
  var v1 = goog.vec.vec4d.create();

  goog.vec.vec4d.negate(v0, v1);
  assertElementsEquals([-1, -2, -3, -4], v1);
  assertElementsEquals([1, 2, 3, 4], v0);

  goog.vec.vec4d.negate(v0, v0);
  assertElementsEquals([-1, -2, -3, -4], v0);
}

function testAbs() {
  var v0 = goog.vec.vec4d.setFromArray(goog.vec.vec4d.create(), [-1, -2, -3, -4]);
  var v1 = goog.vec.vec4d.create();

  goog.vec.vec4d.abs(v0, v1);
  assertElementsEquals([1, 2, 3, 4], v1);
  assertElementsEquals([-1, -2, -3, -4], v0);

  goog.vec.vec4d.abs(v0, v0);
  assertElementsEquals([1, 2, 3, 4], v0);
}

function testScale() {
  var v0 = goog.vec.vec4d.setFromArray(goog.vec.vec4d.create(), [1, 2, 3, 4]);
  var v1 = goog.vec.vec4d.create();

  goog.vec.vec4d.scale(v0, 4, v1);
  assertElementsEquals([4, 8, 12, 16], v1);
  assertElementsEquals([1, 2, 3, 4], v0);

  goog.vec.vec4d.setFromArray(v1, v0);
  goog.vec.vec4d.scale(v1, 5, v1);
  assertElementsEquals([5, 10, 15, 20], v1);
}

function testMagnitudeSquared() {
  var v0 = goog.vec.vec4d.setFromArray(goog.vec.vec4d.create(), [1, 2, 3, 4]);
  assertEquals(30, goog.vec.vec4d.magnitudeSquared(v0));
}

function testMagnitude() {
  var v0 = goog.vec.vec4d.setFromArray(goog.vec.vec4d.create(), [1, 2, 3, 4]);
  assertEquals(Math.sqrt(30), goog.vec.vec4d.magnitude(v0));
}

function testNormalize() {
  var v0 = goog.vec.vec4d.setFromArray(goog.vec.vec4d.create(), [2, 3, 4, 5]);
  var v1 = goog.vec.vec4d.create();
  var v2 = goog.vec.vec4d.create();
  goog.vec.vec4d.scale(v0, 1 / goog.vec.vec4d.magnitude(v0), v2);

  goog.vec.vec4d.normalize(v0, v1);
  assertElementsEquals(v2, v1);
  assertElementsEquals([2, 3, 4, 5], v0);

  goog.vec.vec4d.setFromArray(v1, v0);
  goog.vec.vec4d.normalize(v1, v1);
  assertElementsEquals(v2, v1);
}

function testDot() {
  var v0 = goog.vec.vec4d.setFromArray(goog.vec.vec4d.create(), [1, 2, 3, 4]);
  var v1 = goog.vec.vec4d.setFromArray(goog.vec.vec4d.create(), [5, 6, 7, 8]);
  assertEquals(70, goog.vec.vec4d.dot(v0, v1));
  assertEquals(70, goog.vec.vec4d.dot(v1, v0));
}

function testLerp() {
  var v0 = goog.vec.vec4d.setFromValues(goog.vec.vec4d.create(), 1, 2, 3, 4);
  var v1 = goog.vec.vec4d.setFromValues(goog.vec.vec4d.create(), 10, 20, 30, 40);
  var v2 = goog.vec.vec4d.setFromVec4d(goog.vec.vec4d.create(), v0);

  goog.vec.vec4d.lerp(v2, v1, 0, v2);
  assertElementsEquals([1, 2, 3, 4], v2);
  goog.vec.vec4d.lerp(v2, v1, 1, v2);
  assertElementsEquals([10, 20, 30, 40], v2);
  goog.vec.vec4d.lerp(v0, v1, .5, v2);
  assertElementsEquals([5.5, 11, 16.5, 22], v2);
}

function testMax() {
  var v0 = goog.vec.vec4d.setFromValues(goog.vec.vec4d.create(), 10, 20, 30, 40);
  var v1 = goog.vec.vec4d.setFromValues(goog.vec.vec4d.create(), 5, 25, 35, 30);
  var v2 = goog.vec.vec4d.create();

  goog.vec.vec4d.max(v0, v1, v2);
  assertElementsEquals([10, 25, 35, 40], v2);
  goog.vec.vec4d.max(v1, v0, v1);
  assertElementsEquals([10, 25, 35, 40], v1);
  goog.vec.vec4d.max(v2, 20, v2);
  assertElementsEquals([20, 25, 35, 40], v2);
}

function testMin() {
  var v0 = goog.vec.vec4d.setFromValues(goog.vec.vec4d.create(), 10, 20, 30, 40);
  var v1 = goog.vec.vec4d.setFromValues(goog.vec.vec4d.create(), 5, 25, 35, 30);
  var v2 = goog.vec.vec4d.create();

  goog.vec.vec4d.min(v0, v1, v2);
  assertElementsEquals([5, 20, 30, 30], v2);
  goog.vec.vec4d.min(v1, v0, v1);
  assertElementsEquals([5, 20, 30, 30], v1);
  goog.vec.vec4d.min(v2, 20, v2);
  assertElementsEquals([5, 20, 20, 20], v2);
}

function testEquals() {
  var v0 = goog.vec.vec4d.setFromValues(goog.vec.vec4d.create(), 1, 2, 3, 4);
  var v1 = goog.vec.vec4d.setFromVec4d(goog.vec.vec4d.create(), v0);
  assertElementsEquals(v0, v1);

  v1[0] = 5;
  assertFalse(goog.vec.vec4d.equals(v0, v1));

  v1 = goog.vec.vec4d.setFromVec4d(goog.vec.vec4d.create(), v0);
  v1[1] = 5;
  assertFalse(goog.vec.vec4d.equals(v0, v1));

  v1 = goog.vec.vec4d.setFromVec4d(goog.vec.vec4d.create(), v0);
  v1[2] = 5;
  assertFalse(goog.vec.vec4d.equals(v0, v1));

  v1 = goog.vec.vec4d.setFromVec4d(goog.vec.vec4d.create(), v0);
  v1[3] = 5;
  assertFalse(goog.vec.vec4d.equals(v0, v1));
}
