/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.dom.strokes;

import java.util.Collection;
import org.apache.royale.compiler.fxg.FXGVersion;
import org.apache.royale.compiler.internal.fxg.dom.AbstractFXGNode;
import org.apache.royale.compiler.internal.fxg.dom.DOMParserHelper;
import org.apache.royale.compiler.internal.fxg.dom.GraphicNode;
import org.apache.royale.compiler.internal.fxg.dom.IStrokeNode;
import org.apache.royale.compiler.internal.fxg.dom.types.Caps;
import org.apache.royale.compiler.internal.fxg.dom.types.Joints;
import org.apache.royale.compiler.internal.fxg.dom.types.ScaleMode;
import org.apache.royale.compiler.problems.FXGUnknownAttributeValueProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;

public abstract class AbstractStrokeNode
extends AbstractFXGNode
implements IStrokeNode {
    protected static final double MITERLIMIT_MIN_INCLUSIVE = 1.0;
    protected static final double MITERLIMIT_MAX_INCLUSIVE = 255.0;
    protected static final double WEIGHT_MIN_INCLUSIVE = 0.0;
    protected static final double WEIGHT_MAX_INCLUSIVE = 255.0;
    protected String id;
    public ScaleMode scaleMode = ScaleMode.NORMAL;
    public Caps caps = Caps.ROUND;
    public boolean pixelHinting = false;
    public Joints joints = Joints.ROUND;
    public double miterLimit = 3.0;
    private double weight = Double.NaN;
    protected double weight_v_1 = 0.0;
    protected double weight_v_1_later = 1.0;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        this.id = value;
    }

    public double getWeight() {
        if (Double.isNaN(this.weight)) {
            this.weight = ((GraphicNode)this.getDocumentNode()).getVersion().equals(FXGVersion.v1_0) ? this.weight_v_1 : this.weight_v_1_later;
        }
        return this.weight;
    }

    public double getScaleX() {
        return Double.NaN;
    }

    public double getScaleY() {
        return Double.NaN;
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("scaleMode".equals(name)) {
            this.scaleMode = this.getScaleMode(value, problems);
        } else if ("caps".equals(name)) {
            this.caps = this.getCaps(value, problems);
        } else if ("weight".equals(name)) {
            this.weight = DOMParserHelper.parseDouble(this, value, name, 0.0, 255.0, this.weight, problems);
        } else if ("pixelHinting".equals(name)) {
            this.pixelHinting = DOMParserHelper.parseBoolean(this, value, name, this.pixelHinting, problems);
        } else if ("joints".equals(name)) {
            this.joints = this.getJoints(value, problems);
        } else if ("miterLimit".equals(name)) {
            this.miterLimit = DOMParserHelper.parseDouble(this, value, name, 1.0, 255.0, this.miterLimit, problems);
        } else if ("id".equals(name)) {
            this.id = value;
        } else {
            super.setAttribute(name, value, problems);
        }
    }

    protected Caps getCaps(String value, Collection<ICompilerProblem> problems) {
        if ("round".equals(value)) {
            return Caps.ROUND;
        }
        if ("square".equals(value)) {
            return Caps.SQUARE;
        }
        if ("none".equals(value)) {
            return Caps.NONE;
        }
        problems.add(new FXGUnknownAttributeValueProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), "caps", value));
        return this.caps;
    }

    protected Joints getJoints(String value, Collection<ICompilerProblem> problems) {
        if ("round".equals(value)) {
            return Joints.ROUND;
        }
        if ("miter".equals(value)) {
            return Joints.MITER;
        }
        if ("bevel".equals(value)) {
            return Joints.BEVEL;
        }
        problems.add(new FXGUnknownAttributeValueProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), "joints", value));
        return this.joints;
    }

    protected ScaleMode getScaleMode(String value, Collection<ICompilerProblem> problems) {
        if ("none".equals(value)) {
            return ScaleMode.NONE;
        }
        if ("vertical".equals(value)) {
            return ScaleMode.VERTICAL;
        }
        if ("normal".equals(value)) {
            return ScaleMode.NORMAL;
        }
        if ("horizontal".equals(value)) {
            return ScaleMode.HORIZONTAL;
        }
        problems.add(new FXGUnknownAttributeValueProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), "scaleMode", value));
        return this.scaleMode;
    }
}

