/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.dom.richtext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.royale.compiler.fxg.dom.IFXGNode;
import org.apache.royale.compiler.internal.fxg.dom.types.AlignmentBaseline;
import org.apache.royale.compiler.internal.fxg.dom.types.BlockProgression;
import org.apache.royale.compiler.internal.fxg.dom.types.BreakOpportunity;
import org.apache.royale.compiler.internal.fxg.dom.types.DigitCase;
import org.apache.royale.compiler.internal.fxg.dom.types.DigitWidth;
import org.apache.royale.compiler.internal.fxg.dom.types.Direction;
import org.apache.royale.compiler.internal.fxg.dom.types.DominantBaseline;
import org.apache.royale.compiler.internal.fxg.dom.types.FontStyle;
import org.apache.royale.compiler.internal.fxg.dom.types.FontWeight;
import org.apache.royale.compiler.internal.fxg.dom.types.JustificationRule;
import org.apache.royale.compiler.internal.fxg.dom.types.JustificationStyle;
import org.apache.royale.compiler.internal.fxg.dom.types.Kerning;
import org.apache.royale.compiler.internal.fxg.dom.types.LeadingModel;
import org.apache.royale.compiler.internal.fxg.dom.types.LigatureLevel;
import org.apache.royale.compiler.internal.fxg.dom.types.LineBreak;
import org.apache.royale.compiler.internal.fxg.dom.types.TextAlign;
import org.apache.royale.compiler.internal.fxg.dom.types.TextDecoration;
import org.apache.royale.compiler.internal.fxg.dom.types.TextJustify;
import org.apache.royale.compiler.internal.fxg.dom.types.TextRotation;
import org.apache.royale.compiler.internal.fxg.dom.types.TypographicCase;
import org.apache.royale.compiler.internal.fxg.dom.types.VerticalAlign;
import org.apache.royale.compiler.internal.fxg.dom.types.WhiteSpaceCollapse;
import org.apache.royale.compiler.problems.FXGInvalidTabStopsProblem;
import org.apache.royale.compiler.problems.FXGUnknownAttributeValueProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;

public class TextHelper {
    protected static final double ALPHA_MIN_INCLUSIVE = 0.0;
    protected static final double ALPHA_MAX_INCLUSIVE = 1.0;
    protected static Pattern whitespacePattern = Pattern.compile("(\\s+)");
    protected static Pattern tabstopsExceptDNumericPattern = Pattern.compile("([S s E e C c]?[0-9]*[.]?[0-9]*\\s*)");
    protected static Pattern tabstopsExceptDScientificPattern = Pattern.compile("([S s E e C c]?[+ -]?[0-9]*[.][0-9]*[E e][+ -]?[0-9]+\\s*)");
    protected static Pattern tabstopsDNumericPattern = Pattern.compile("([D d][0-9]*[.]?[0-9]*([|].+)?\\s*)");
    protected static Pattern tabstopsDScientificPattern = Pattern.compile("([D d][-]?[0-9]*[.][0-9]*[E e][+][0-9]*([|].+)?\\s*)");
    protected static Pattern tabstopsNumberPattern = Pattern.compile("([+ -]?[0-9]*[.]?[0-9]*[E e]?[+ -]?[0-9]*)");

    public static boolean ignorableWhitespace(String value) {
        Matcher m = whitespacePattern.matcher(value);
        return m.matches();
    }

    public static FontStyle getFontStyle(IFXGNode node, String value, FontStyle defaultValue, Collection<ICompilerProblem> problems) {
        if ("normal".equals(value)) {
            return FontStyle.NORMAL;
        }
        if ("italic".equals(value)) {
            return FontStyle.ITALIC;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "fontStyle", value));
        return defaultValue;
    }

    public static FontWeight getFontWeight(IFXGNode node, String value, FontWeight defaultValue, Collection<ICompilerProblem> problems) {
        if ("normal".equals(value)) {
            return FontWeight.NORMAL;
        }
        if ("bold".equals(value)) {
            return FontWeight.BOLD;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "fontWeight", value));
        return defaultValue;
    }

    public static TextDecoration getTextDecoration(IFXGNode node, String value, TextDecoration defaultValue, Collection<ICompilerProblem> problems) {
        if ("none".equals(value)) {
            return TextDecoration.NONE;
        }
        if ("underline".equals(value)) {
            return TextDecoration.UNDERLINE;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "textDecoration", value));
        return defaultValue;
    }

    public static Kerning getKerning(IFXGNode node, String value, Kerning defaultValue, Collection<ICompilerProblem> problems) {
        if ("auto".equals(value)) {
            return Kerning.AUTO;
        }
        if ("on".equals(value)) {
            return Kerning.ON;
        }
        if ("off".equals(value)) {
            return Kerning.OFF;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "kerning", value));
        return defaultValue;
    }

    public static WhiteSpaceCollapse getWhiteSpaceCollapse(IFXGNode node, String value, WhiteSpaceCollapse defaultValue, Collection<ICompilerProblem> problems) {
        if ("preserve".equals(value)) {
            return WhiteSpaceCollapse.PRESERVE;
        }
        if ("collapse".equals(value)) {
            return WhiteSpaceCollapse.COLLAPSE;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "whiteSpaceCollapse", value));
        return defaultValue;
    }

    public static BreakOpportunity getBreakOpportunity(IFXGNode node, String value, BreakOpportunity defaultValue, Collection<ICompilerProblem> problems) {
        if ("auto".equals(value)) {
            return BreakOpportunity.AUTO;
        }
        if ("any".equals(value)) {
            return BreakOpportunity.ANY;
        }
        if ("none".equals(value)) {
            return BreakOpportunity.NONE;
        }
        if ("all".equals(value)) {
            return BreakOpportunity.ALL;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "breakOpportunity", value));
        return defaultValue;
    }

    public static DigitCase getDigitCase(IFXGNode node, String value, DigitCase defaultValue, Collection<ICompilerProblem> problems) {
        if ("default".equals(value)) {
            return DigitCase.DEFAULT;
        }
        if ("lining".equals(value)) {
            return DigitCase.LINING;
        }
        if ("oldStyle".equals(value)) {
            return DigitCase.OLDSTYLE;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "digitCase", value));
        return defaultValue;
    }

    public static DigitWidth getDigitWidth(IFXGNode node, String value, DigitWidth defaultValue, Collection<ICompilerProblem> problems) {
        if ("default".equals(value)) {
            return DigitWidth.DEFAULT;
        }
        if ("proportional".equals(value)) {
            return DigitWidth.PROPORTIONAL;
        }
        if ("tabular".equals(value)) {
            return DigitWidth.TABULAR;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "digitWidth", value));
        return defaultValue;
    }

    public static DominantBaseline getDominantBaseline(IFXGNode node, String value, DominantBaseline defaultValue, Collection<ICompilerProblem> problems) {
        if ("auto".equals(value)) {
            return DominantBaseline.AUTO;
        }
        if ("roman".equals(value)) {
            return DominantBaseline.ROMAN;
        }
        if ("ascent".equals(value)) {
            return DominantBaseline.ASCENT;
        }
        if ("descent".equals(value)) {
            return DominantBaseline.DESCENT;
        }
        if ("ideographicTop".equals(value)) {
            return DominantBaseline.IDEOGRAPHICTOP;
        }
        if ("ideographicCenter".equals(value)) {
            return DominantBaseline.IDEOGRAPHICCENTER;
        }
        if ("ideographicBottom".equals(value)) {
            return DominantBaseline.IDEOGRAPHICBOTTOM;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "dominantBaseline", value));
        return defaultValue;
    }

    public static AlignmentBaseline getAlignmentBaseline(IFXGNode node, String value, AlignmentBaseline defaultValue, Collection<ICompilerProblem> problems) {
        if ("useDominantBaseline".equals(value)) {
            return AlignmentBaseline.USEDOMINANTBASELINE;
        }
        if ("roman".equals(value)) {
            return AlignmentBaseline.ROMAN;
        }
        if ("ascent".equals(value)) {
            return AlignmentBaseline.ASCENT;
        }
        if ("descent".equals(value)) {
            return AlignmentBaseline.DESCENT;
        }
        if ("ideographicTop".equals(value)) {
            return AlignmentBaseline.IDEOGRAPHICTOP;
        }
        if ("ideographicCenter".equals(value)) {
            return AlignmentBaseline.IDEOGRAPHICCENTER;
        }
        if ("ideographicBottom".equals(value)) {
            return AlignmentBaseline.IDEOGRAPHICBOTTOM;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "alignmentBaseline", value));
        return defaultValue;
    }

    public static LigatureLevel getLigatureLevel(IFXGNode node, String value, LigatureLevel defaultValue, Collection<ICompilerProblem> problems) {
        if ("minimum".equals(value)) {
            return LigatureLevel.MINIMUM;
        }
        if ("common".equals(value)) {
            return LigatureLevel.COMMON;
        }
        if ("uncommon".equals(value)) {
            return LigatureLevel.UNCOMMON;
        }
        if ("exotic".equals(value)) {
            return LigatureLevel.EXOTIC;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "ligatureLevel", value));
        return defaultValue;
    }

    public static TypographicCase getTypographicCase(IFXGNode node, String value, TypographicCase defaultValue, Collection<ICompilerProblem> problems) {
        if ("default".equals(value)) {
            return TypographicCase.DEFAULT;
        }
        if ("capsToSmallCaps".equals(value)) {
            return TypographicCase.CAPSTOSMALLCAPS;
        }
        if ("uppercase".equals(value)) {
            return TypographicCase.UPPERCASE;
        }
        if ("lowercase".equals(value)) {
            return TypographicCase.LOWERCASE;
        }
        if ("lowercaseToSmallCaps".equals(value)) {
            return TypographicCase.LOWERCASETOSMALLCAPS;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "typographicCase", value));
        return defaultValue;
    }

    public static TextRotation getTextRotation(IFXGNode node, String value, TextRotation defaultValue, Collection<ICompilerProblem> problems) {
        if ("auto".equals(value)) {
            return TextRotation.AUTO;
        }
        if ("rotate0".equals(value)) {
            return TextRotation.ROTATE_0;
        }
        if ("rotate90".equals(value)) {
            return TextRotation.ROTATE_90;
        }
        if ("rotate180".equals(value)) {
            return TextRotation.ROTATE_180;
        }
        if ("rotate270".equals(value)) {
            return TextRotation.ROTATE_270;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "textRotation", value));
        return defaultValue;
    }

    public static TextAlign getTextAlign(IFXGNode node, String value, TextAlign defaultValue, Collection<ICompilerProblem> problems) {
        if ("start".equals(value)) {
            return TextAlign.START;
        }
        if ("end".equals(value)) {
            return TextAlign.END;
        }
        if ("left".equals(value)) {
            return TextAlign.LEFT;
        }
        if ("center".equals(value)) {
            return TextAlign.CENTER;
        }
        if ("right".equals(value)) {
            return TextAlign.RIGHT;
        }
        if ("justify".equals(value)) {
            return TextAlign.JUSTIFY;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "textAlign", value));
        return defaultValue;
    }

    public static Direction getDirection(IFXGNode node, String value, Direction defaultValue, Collection<ICompilerProblem> problems) {
        if ("ltr".equals(value)) {
            return Direction.LTR;
        }
        if ("rtl".equals(value)) {
            return Direction.RTL;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "direction", value));
        return defaultValue;
    }

    public static JustificationRule getJustificationRule(IFXGNode node, String value, JustificationRule defaultValue, Collection<ICompilerProblem> problems) {
        if ("auto".equals(value)) {
            return JustificationRule.AUTO;
        }
        if ("space".equals(value)) {
            return JustificationRule.SPACE;
        }
        if ("eastAsian".equals(value)) {
            return JustificationRule.EASTASIAN;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "justificationRule", value));
        return defaultValue;
    }

    public static JustificationStyle getJustificationStyle(IFXGNode node, String value, JustificationStyle defaultValue, Collection<ICompilerProblem> problems) {
        if ("auto".equals(value)) {
            return JustificationStyle.AUTO;
        }
        if ("prioritizeLeastAdjustment".equals(value)) {
            return JustificationStyle.PRIORITIZELEASTADJUSTMENT;
        }
        if ("pushInKinsoku".equals(value)) {
            return JustificationStyle.PUSHINKINSOKU;
        }
        if ("pushOutOnly".equals(value)) {
            return JustificationStyle.PUSHOUTONLY;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "justificationStyle", value));
        return defaultValue;
    }

    public static TextJustify getTextJustify(IFXGNode node, String value, TextJustify defaultValue, Collection<ICompilerProblem> problems) {
        if ("interWord".equals(value)) {
            return TextJustify.INTERWORD;
        }
        if ("distribute".equals(value)) {
            return TextJustify.DISTRIBUTE;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "textJustify", value));
        return defaultValue;
    }

    public static LeadingModel getLeadingModel(IFXGNode node, String value, LeadingModel defaultValue, Collection<ICompilerProblem> problems) {
        if ("auto".equals(value)) {
            return LeadingModel.AUTO;
        }
        if ("romanUp".equals(value)) {
            return LeadingModel.ROMANUP;
        }
        if ("ideographicTopUp".equals(value)) {
            return LeadingModel.IDEOGRAPHICTOPUP;
        }
        if ("ideographicCenterUp".equals(value)) {
            return LeadingModel.IDEOGRAPHICCENTERUP;
        }
        if ("ascentDescentUp".equals(value)) {
            return LeadingModel.ASCENTDESCENTUP;
        }
        if ("ideographicTopDown".equals(value)) {
            return LeadingModel.IDEOGRAPHICTOPDOWN;
        }
        if ("ideographicCenterDown".equals(value)) {
            return LeadingModel.IDEOGRAPHICCENTERDOWN;
        }
        if ("approximateTextField".equals(value)) {
            return LeadingModel.APPROXIMATETEXTFIELD;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "leadingModel", value));
        return defaultValue;
    }

    public static BlockProgression getBlockProgression(IFXGNode node, String value, BlockProgression defaultValue, Collection<ICompilerProblem> problems) {
        if ("tb".equals(value)) {
            return BlockProgression.TB;
        }
        if ("rl".equals(value)) {
            return BlockProgression.RL;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "blockProgression", value));
        return defaultValue;
    }

    public static LineBreak getLineBreak(IFXGNode node, String value, LineBreak defaultValue, Collection<ICompilerProblem> problems) {
        if ("toFit".equals(value)) {
            return LineBreak.TOFIT;
        }
        if ("explicit".equals(value)) {
            return LineBreak.EXPLICIT;
        }
        if ("inherit".equals(value)) {
            return LineBreak.INHERIT;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "lineBreak", value));
        return defaultValue;
    }

    public static VerticalAlign getVerticalAlign(IFXGNode node, String value, VerticalAlign defaultValue, Collection<ICompilerProblem> problems) {
        if ("top".equals(value)) {
            return VerticalAlign.TOP;
        }
        if ("bottom".equals(value)) {
            return VerticalAlign.BOTTOM;
        }
        if ("middle".equals(value)) {
            return VerticalAlign.MIDDLE;
        }
        if ("justify".equals(value)) {
            return VerticalAlign.JUSTIFY;
        }
        if ("inherit".equals(value)) {
            return VerticalAlign.INHERIT;
        }
        problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "verticalAlign", value));
        return defaultValue;
    }

    public static String parseTabStops(IFXGNode node, String value, String defaultValue, Collection<ICompilerProblem> problems) {
        String[] tabStops = value.trim().split("\\s+");
        ArrayList<Object> finalTabStops = new ArrayList<Object>(tabStops.length);
        int iFinal = -1;
        boolean escaped = false;
        for (int i = 0; i < tabStops.length; ++i) {
            if (escaped) {
                finalTabStops.add(iFinal, (String)finalTabStops.get(iFinal) + tabStops[i]);
            } else {
                finalTabStops.add(tabStops[i]);
                ++iFinal;
            }
            escaped = tabStops[i].endsWith("\\");
        }
        String tabStopsVal = null;
        for (int i = 0; i < finalTabStops.size(); ++i) {
            tabStopsVal = (String)finalTabStops.get(i);
            if (TextHelper.matchPattern(tabStopsVal, tabstopsExceptDNumericPattern) || TextHelper.matchPattern(tabStopsVal, tabstopsExceptDScientificPattern) || TextHelper.matchPattern(tabStopsVal, tabstopsDNumericPattern) || TextHelper.matchPattern(tabStopsVal, tabstopsDScientificPattern)) continue;
            problems.add(new FXGInvalidTabStopsProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), value));
            return defaultValue;
        }
        return value;
    }

    private static boolean matchPattern(String value, Pattern pattern) {
        Matcher m = pattern.matcher(value);
        return m.matches();
    }
}

