/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.tree.as.BaseLiteralContainerNode;
import org.apache.royale.compiler.internal.tree.as.ContainerNode;
import org.apache.royale.compiler.internal.tree.as.LiteralNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;

public class ArrayLiteralNode
extends BaseLiteralContainerNode {
    public ArrayLiteralNode() {
        super(new LiteralNode(ILiteralNode.LiteralType.ARRAY, ""));
    }

    protected ArrayLiteralNode(ArrayLiteralNode other) {
        super(other);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.ArrayLiteralID;
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.ARRAY);
    }

    @Override
    protected ArrayLiteralNode copy() {
        return new ArrayLiteralNode(this);
    }

    @Override
    public boolean isDynamicExpression(ICompilerProject project) {
        return true;
    }

    @Override
    public ILiteralNode.LiteralType getLiteralType() {
        return ILiteralNode.LiteralType.ARRAY;
    }

    @Override
    public String getValue() {
        return this.getValue(false);
    }

    @Override
    public String getValue(boolean rawValue) {
        StringBuilder builder = new StringBuilder();
        ContainerNode contents = this.getContentsNode();
        int childcount = contents.getChildCount();
        for (int i = 0; i < childcount; ++i) {
            IASNode child = contents.getChild(i);
            if (child instanceof ILiteralNode) {
                builder.append(((ILiteralNode)child).getValue(rawValue));
            } else if (child instanceof IIdentifierNode) {
                builder.append(((IIdentifierNode)child).getName());
            }
            if (i + 1 >= childcount) continue;
            builder.append(",");
        }
        return "[" + builder.toString() + "]";
    }
}

