/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.AIRLaunchInfo;
import flash.tools.debugger.Frame;
import flash.tools.debugger.IDebuggerCallbacks;
import flash.tools.debugger.ILauncher;
import flash.tools.debugger.InProgressException;
import flash.tools.debugger.Isolate;
import flash.tools.debugger.IsolateController;
import flash.tools.debugger.IsolateSession;
import flash.tools.debugger.Location;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSupportedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SessionManager;
import flash.tools.debugger.SourceFile;
import flash.tools.debugger.SourceLocator;
import flash.tools.debugger.SuspendedException;
import flash.tools.debugger.SwfInfo;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.VersionException;
import flash.tools.debugger.Watch;
import flash.tools.debugger.concrete.BinaryOp;
import flash.tools.debugger.concrete.DIsolate;
import flash.tools.debugger.concrete.DLocation;
import flash.tools.debugger.concrete.DManager;
import flash.tools.debugger.concrete.DMessage;
import flash.tools.debugger.concrete.DMessageCache;
import flash.tools.debugger.concrete.DMessageCounter;
import flash.tools.debugger.concrete.DProtocol;
import flash.tools.debugger.concrete.DProtocolNotifierIF;
import flash.tools.debugger.concrete.DStackContext;
import flash.tools.debugger.concrete.DSuspendInfo;
import flash.tools.debugger.concrete.DSwfInfo;
import flash.tools.debugger.concrete.DValue;
import flash.tools.debugger.concrete.DVariable;
import flash.tools.debugger.concrete.DWatch;
import flash.tools.debugger.concrete.IsolatePlayerSession;
import flash.tools.debugger.concrete.PlayerSessionIsolateStatus;
import flash.tools.debugger.concrete.PlayerSessionManager;
import flash.tools.debugger.events.DebugEvent;
import flash.tools.debugger.events.ExceptionFault;
import flash.tools.debugger.events.FaultEvent;
import flash.tools.debugger.expression.ECMA;
import flash.tools.debugger.expression.PlayerFaultException;
import flash.util.Trace;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class PlayerSession
implements Session,
DProtocolNotifierIF,
Runnable,
IsolateController {
    public static final int MAX_STACK_DEPTH = 256;
    public static final long MAX_TERMINATE_WAIT_MILLIS = 10000L;
    private Socket m_socket;
    private DProtocol m_protocol;
    private DManager m_manager;
    private IDebuggerCallbacks m_debuggerCallbacks;
    private Process m_process;
    private Map<String, Object> m_prefs;
    private static final String s_newline = System.getProperty("line.separator");
    private volatile boolean m_isConnected = false;
    private volatile boolean m_isHalted = false;
    private volatile boolean m_incoming;
    private volatile boolean m_lastResponse;
    private volatile HashMap<Integer, PlayerSessionIsolateStatus> m_isolateStatus = new HashMap();
    private int m_watchTransactionTag;
    private Boolean m_playerCanCallFunctions;
    private Boolean m_playerSupportsWatchpoints;
    private Boolean m_playerCanBreakOnAllExceptions;
    private Boolean m_playerSupportsConcurrency;
    private Boolean m_playerSupportsWideLine;
    private ILauncher launcher;
    private String m_launchUrl;
    private AIRLaunchInfo m_airLaunchInfo;
    static volatile boolean m_debugMsgOn;
    volatile int m_debugMsgSize;
    static volatile boolean m_debugMsgFileOn;
    volatile int m_debugMsgFileSize;
    private Map<String, Boolean> m_evalIsAndInstanceofCache = new HashMap<String, Boolean>();
    private volatile int m_lastPreIsolate = 1;
    private final Map<Integer, IsolateSession> m_isolateSessions;
    private static final String DEBUG_MESSAGES = "$debug_messages";
    private static final String DEBUG_MESSAGE_SIZE = "$debug_message_size";
    private static final String DEBUG_MESSAGE_FILE = "$debug_message_file";
    private static final String DEBUG_MESSAGE_FILE_SIZE = "$debug_message_file_size";
    private static final String CONSOLE_ERRORS = "$console_errors";
    private static final String FLASH_PREFIX = "$flash_";
    Writer m_trace;

    PlayerSession(Socket socket, DProtocol dProtocol, DManager dManager, IDebuggerCallbacks iDebuggerCallbacks) {
        this.m_socket = socket;
        this.m_protocol = dProtocol;
        this.m_manager = dManager;
        this.m_prefs = Collections.synchronizedMap(new HashMap());
        this.m_incoming = false;
        m_debugMsgOn = false;
        this.m_debugMsgSize = 16;
        m_debugMsgFileOn = false;
        this.m_debugMsgFileSize = 128;
        this.m_watchTransactionTag = 1;
        this.m_playerCanCallFunctions = null;
        this.m_debuggerCallbacks = iDebuggerCallbacks;
        this.m_isolateSessions = Collections.synchronizedMap(new HashMap());
    }

    private static PlayerSession createFromSocketHelper(Socket socket, IDebuggerCallbacks iDebuggerCallbacks, DProtocol dProtocol) throws IOException {
        DManager dManager = new DManager();
        PlayerSession playerSession = new PlayerSession(socket, dProtocol, dManager, iDebuggerCallbacks);
        return playerSession;
    }

    public static PlayerSession createFromSocket(Socket socket, IDebuggerCallbacks iDebuggerCallbacks) throws IOException {
        DProtocol dProtocol = DProtocol.createFromSocket(socket);
        return PlayerSession.createFromSocketHelper(socket, iDebuggerCallbacks, dProtocol);
    }

    public static PlayerSession createFromSocketWithOptions(Socket socket, IDebuggerCallbacks iDebuggerCallbacks, SessionManager sessionManager) throws IOException {
        DProtocol dProtocol = DProtocol.createFromSocket(socket, sessionManager);
        return PlayerSession.createFromSocketHelper(socket, iDebuggerCallbacks, dProtocol);
    }

    public DMessageCounter getMessageCounter() {
        return this.m_protocol.getMessageCounter();
    }

    @Override
    public String getURI() {
        return this.m_manager.getURI();
    }

    public boolean playerSupportsGet() {
        return this.m_manager.isGetSupported();
    }

    public int playerVersion() {
        return this.m_manager.getVersion();
    }

    @Override
    public SourceLocator getSourceLocator() {
        return this.m_manager.getSourceLocator();
    }

    @Override
    public void setSourceLocator(SourceLocator sourceLocator) {
        this.m_manager.setSourceLocator(sourceLocator);
    }

    void setProcess(Process process) {
        this.m_process = process;
    }

    @Override
    public Process getLaunchProcess() {
        return this.m_process;
    }

    public void setPreferences(Map<String, ? extends Object> map) {
        this.m_prefs.putAll(map);
        this.mapBack();
    }

    public Set<String> keySet() {
        return this.m_prefs.keySet();
    }

    public Object getPreferenceAsObject(String string) {
        return this.m_prefs.get(string);
    }

    @Override
    public void setPreference(String string, int n) {
        this.m_prefs.put(string, n);
        this.mapBack();
        if (string.equals(CONSOLE_ERRORS)) {
            this.sendConsoleErrorsAsTrace(n == 1);
        }
        if (string.startsWith(FLASH_PREFIX)) {
            this.sendOptionMessage(string.substring(FLASH_PREFIX.length()), Integer.toString(n));
        }
    }

    private int mapBackOnePreference(String string, int n) {
        Object object = this.getPreferenceAsObject(string);
        if (object != null) {
            return (Integer)object;
        }
        return n;
    }

    private boolean mapBackOnePreference(String string, boolean bl) {
        Object object = this.getPreferenceAsObject(string);
        if (object != null) {
            return (Integer)object != 0;
        }
        return bl;
    }

    private void mapBack() {
        m_debugMsgOn = this.mapBackOnePreference(DEBUG_MESSAGES, m_debugMsgOn);
        this.m_debugMsgSize = this.mapBackOnePreference(DEBUG_MESSAGE_SIZE, this.m_debugMsgSize);
        m_debugMsgFileOn = this.mapBackOnePreference(DEBUG_MESSAGE_FILE, m_debugMsgFileOn);
        this.m_debugMsgFileSize = this.mapBackOnePreference(DEBUG_MESSAGE_FILE_SIZE, this.m_debugMsgFileSize);
    }

    @Override
    public int getPreference(String string) {
        int n = 0;
        Integer n2 = (Integer)this.m_prefs.get(string);
        if (n2 == null) {
            throw new NullPointerException();
        }
        n = n2;
        return n;
    }

    @Override
    public boolean isConnected() {
        return this.m_isConnected;
    }

    @Override
    public boolean isSuspended() throws NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return this.m_isHalted;
    }

    @Override
    public boolean isWorkerSuspended(int n) throws NotConnectedException {
        if (n == 1) {
            return this.isSuspended();
        }
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (this.m_isolateStatus.containsKey(n)) {
            return this.m_isolateStatus.get((Object)Integer.valueOf((int)n)).m_isHalted;
        }
        return false;
    }

    @Override
    public boolean bind() throws VersionException {
        boolean bl = false;
        if (this.m_isConnected) {
            return false;
        }
        this.m_isConnected = true;
        this.m_protocol.addListener(DProtocol.ListenerIndex.PlayerSession, this);
        bl = this.m_protocol.bind();
        this.sendStopWarning();
        this.sendStopOnFault();
        this.sendEnumerateOverride();
        this.sendFailureNotify();
        this.sendInvokeSetters();
        this.sendSwfloadNotify();
        this.sendGetterTimeout();
        this.sendSetterTimeout();
        boolean bl2 = this.sendSquelch(true, 1);
        this.setPreference("$playersupportsget", this.playerSupportsGet() ? 1 : 0);
        if (this.supportsConcurrency()) {
            this.sendConcurrentDebugger();
        }
        if (this.supportsWideLineNumbers()) {
            this.sendWideLineDebugger();
        }
        Thread thread = new Thread((Runnable)this, "SWF/SWD reader");
        thread.setDaemon(true);
        thread.start();
        if (!bl2) {
            throw new VersionException();
        }
        return bl;
    }

    @Override
    public void unbind() {
        this.unbind(false);
    }

    private boolean unbind(boolean bl) {
        bl = bl && this.playerCanTerminate();
        DMessage dMessage = DMessageCache.alloc(1);
        dMessage.setType(13);
        dMessage.putByte((byte)(bl ? 1 : 0));
        this.sendMessage(dMessage);
        this.m_protocol.unbind();
        try {
            this.m_socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_isConnected = false;
        this.m_isHalted = false;
        return bl;
    }

    private String executeAppleScript(String[] stringArray, String[] stringArray2) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add("/usr/bin/osascript");
            linkedList.add("-");
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    linkedList.add(stringArray2[i]);
                }
            }
            Process process = Runtime.getRuntime().exec(linkedList.toArray(new String[linkedList.size()]));
            OutputStream outputStream = process.getOutputStream();
            PrintWriter printWriter = new PrintWriter(outputStream, true);
            printWriter.println("on run argv");
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.println(stringArray[i]);
            }
            printWriter.println("end run");
            printWriter.close();
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            while ((n = inputStreamReader.read()) != -1) {
                stringBuilder.append((char)n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString().replaceAll("\n$", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeAppleScript(String string, String[] stringArray) throws IOException {
        try (InputStream inputStream = null;){
            String string2;
            inputStream = PlayerSession.class.getResourceAsStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(string2);
            }
            String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
            String string3 = this.executeAppleScript(stringArray2, stringArray);
            return string3;
        }
    }

    private Set<String> runningApplications() {
        String string = this.executeAppleScript(new String[]{"tell application \"System Events\"", "\tname of processes", "end tell"}, null);
        String[] stringArray = string.split(", ");
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        return hashSet;
    }

    @Override
    public void terminate() {
        block25: {
            boolean bl = false;
            try {
                bl = this.unbind(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl) {
                if (System.getProperty("os.name").toLowerCase().startsWith("mac os x") && this.m_airLaunchInfo == null && this.m_launchUrl != null && this.m_launchUrl.length() > 0) {
                    String string;
                    String[] stringArray;
                    boolean bl2 = false;
                    Set<String> set = this.runningApplications();
                    if (set.contains("Safari")) {
                        try {
                            stringArray = this.m_launchUrl.replaceAll(" ", "%20");
                            string = this.executeAppleScript("appleScriptCloseSafariWindow.txt", new String[]{stringArray});
                            if ("true".equals(string)) {
                                bl2 = true;
                            } else if ("appquit".equals(string)) {
                                bl2 = true;
                                set = this.waitForMacAppQuit("Safari");
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!bl2 && set.contains("Camino")) {
                        stringArray = this.m_launchUrl.replaceFirst("^file:///", "file://localhost/");
                        try {
                            string = this.executeAppleScript("appleScriptCloseCaminoWindow.txt", new String[]{stringArray});
                            if ("true".equals(string)) {
                                bl2 = true;
                            } else if ("appquit".equals(string)) {
                                bl2 = true;
                                set = this.waitForMacAppQuit("Camino");
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    stringArray = new String[]{"Flash Player Debugger", "Flash Player", "SAFlashPlayer", "standalone"};
                    for (int i = 0; !bl2 && i < stringArray.length; ++i) {
                        if (!set.contains(stringArray[i])) continue;
                        this.executeAppleScript(new String[]{"tell application \"" + stringArray[i] + "\" to quit"}, null);
                        this.waitForMacAppQuit(stringArray[i]);
                        bl2 = true;
                    }
                }
                if (this.m_process != null) {
                    try {
                        if (null != this.launcher) {
                            this.m_debuggerCallbacks.terminateDebugTarget(this.m_process, this.launcher);
                            break block25;
                        }
                        this.m_debuggerCallbacks.terminateDebugTarget(this.m_process);
                    }
                    catch (IOException iOException) {}
                }
            } else if (this.m_process != null) {
                try {
                    this.m_process.waitFor();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.m_isConnected = false;
        this.m_isHalted = false;
    }

    private Set<String> waitForMacAppQuit(String string) {
        Set<String> set;
        boolean bl = true;
        long l = System.currentTimeMillis();
        do {
            if ((set = this.runningApplications()).contains(string)) {
                bl = false;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    return set;
                }
                long l2 = System.currentTimeMillis();
                if (l2 - l < 10000L) continue;
                break;
            }
            bl = true;
        } while (!bl);
        return set;
    }

    @Override
    public void resume() throws NotSuspendedException, NotConnectedException, NoResponseException {
        this.resumeWorker(1);
    }

    @Override
    public void suspend() throws SuspendedException, NotConnectedException, NoResponseException {
        this.suspendWorker(1);
    }

    public DSuspendInfo getSuspendInfo() {
        return this.getSuspendInfoIsolate(1);
    }

    @Override
    public int suspendReason() {
        DSuspendInfo dSuspendInfo = this.getSuspendInfo();
        return dSuspendInfo.getReason();
    }

    public int getSuspendOffset() {
        DSuspendInfo dSuspendInfo = this.getSuspendInfo();
        return dSuspendInfo.getOffset();
    }

    public int getSuspendActionIndex() {
        DSuspendInfo dSuspendInfo = this.getSuspendInfo();
        return dSuspendInfo.getActionIndex();
    }

    @Override
    public SwfInfo[] getSwfs() throws NoResponseException {
        return this.getSwfsWorker(1);
    }

    public void requestSwfInfo(int n, int n2) throws NoResponseException {
        DMessage dMessage = DMessageCache.alloc(4);
        dMessage.setType(38);
        dMessage.setTargetIsolate(n2);
        dMessage.putWord(n);
        dMessage.putWord(0);
        int n3 = this.getPreference("$contextresponsetimeout");
        if (!this.simpleRequestResponseMessage(dMessage, 42, n3)) {
            throw new NoResponseException(n3);
        }
    }

    public byte[] getActions(int n, int n2, int n3) throws NoResponseException {
        byte[] byArray = null;
        DMessage dMessage = DMessageCache.alloc(12);
        dMessage.setType(36);
        dMessage.putWord(n);
        dMessage.putWord(0);
        dMessage.putDWord(n2);
        dMessage.putDWord(n3);
        int n4 = this.getPreference("$contextresponsetimeout");
        if (!this.simpleRequestResponseMessage(dMessage, 41, n4)) {
            throw new NoResponseException(n4);
        }
        byArray = this.m_manager.getActions();
        return byArray;
    }

    @Override
    public void stepInto() throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.stepIntoWorker(1);
    }

    @Override
    public void stepOut() throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.stepOutWorker(1);
    }

    @Override
    public void stepOver() throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.stepOverWorker(1);
    }

    @Override
    public void stepContinue() throws NotSuspendedException, NoResponseException, NotConnectedException {
        if (!this.isSuspended()) {
            throw new NotSuspendedException();
        }
        if (!this.simpleRequestResponseMessage(31, 17)) {
            throw new NoResponseException(this.getPreference("$responsetimeout"));
        }
    }

    public void requestFunctionNames(int n, int n2, int n3) throws VersionException, NoResponseException {
        if (this.m_manager.getVersion() >= 9) {
            DMessage dMessage = DMessageCache.alloc(8);
            dMessage.setType(40);
            dMessage.setTargetIsolate(n3);
            dMessage.putDWord(n);
            dMessage.putDWord(n2);
            if (!this.simpleRequestResponseMessage(dMessage, 45)) {
                throw new NoResponseException(0);
            }
        } else {
            throw new VersionException();
        }
    }

    public SourceFile getFile(int n, int n2) {
        return this.m_manager.getSource(n, n2);
    }

    @Override
    public Location[] getBreakpointList() {
        return this.m_manager.getBreakpoints(1);
    }

    @Override
    public Location setBreakpoint(int n, int n2) throws NoResponseException, NotConnectedException {
        return this.setBreakpointWorker(n, n2, 1);
    }

    @Override
    public Location clearBreakpoint(Location location) {
        SourceFile sourceFile = location.getFile();
        int n = sourceFile.getId();
        int n2 = location.getLine();
        int n3 = DLocation.encodeId(n, n2);
        int n4 = location.getIsolateId();
        DLocation dLocation = null;
        dLocation = this.m_manager.getBreakpoint(n3, n4);
        if (dLocation != null) {
            int n5 = 0;
            if (this.supportsWideLineNumbers()) {
                n5 = 4;
            }
            DMessage dMessage = DMessageCache.alloc(8 + n5);
            dMessage.setType(18);
            dMessage.setTargetIsolate(n4);
            dMessage.putDWord(1);
            if (!this.supportsWideLineNumbers()) {
                dMessage.putDWord(n3);
            } else {
                dMessage.putDWord(n);
                dMessage.putDWord(n2);
            }
            this.sendMessage(dMessage);
            this.m_manager.removeBreakpoint(n3, n4);
        }
        return dLocation;
    }

    @Override
    public Watch[] getWatchList() throws NoResponseException, NotConnectedException {
        return this.getWatchListWorker(1);
    }

    @Override
    public Watch[] getWatchListWorker(int n) throws NoResponseException, NotConnectedException {
        return this.m_manager.getWatchpoints(n);
    }

    private Watch setWatch(long l, String string, int n, int n2) throws NoResponseException, NotConnectedException, NotSupportedException {
        DWatch dWatch;
        int n3;
        int n4;
        DWatch dWatch2 = null;
        if (this.addWatch(l, string, n, n4 = this.m_watchTransactionTag++, n2) && (n3 = this.m_manager.getWatchpointCount(n2)) > 0 && (dWatch = this.m_manager.getWatchpoint(n3 - 1, n2)).getTag() == n4) {
            dWatch2 = dWatch;
        }
        return dWatch2;
    }

    @Override
    public Watch setWatch(Value value, String string, int n) throws NoResponseException, NotConnectedException, NotSupportedException {
        return this.setWatch(value.getId(), string, n, value.getIsolateId());
    }

    @Override
    public Watch setWatch(Watch watch) throws NoResponseException, NotConnectedException, NotSupportedException {
        return this.setWatch(watch.getValueId(), watch.getMemberName(), watch.getKind(), watch.getIsolateId());
    }

    @Override
    public Watch clearWatch(Watch watch) throws NoResponseException, NotConnectedException {
        Watch[] watchArray = this.getWatchListWorker(watch.getIsolateId());
        Watch watch2 = null;
        if (this.removeWatch(watch.getValueId(), watch.getMemberName(), watch.getIsolateId()) && this.m_manager.getWatchpointCount(watch.getIsolateId()) < watchArray.length) {
            Watch[] watchArray2 = this.getWatchListWorker(watch.getIsolateId());
            for (int i = 0; i < watchArray2.length; ++i) {
                if (watchArray[i] == watchArray2[i]) continue;
                watch2 = watchArray[i];
                break;
            }
            if (watch2 == null) {
                watch2 = watchArray[watchArray.length - 1];
            }
        }
        return watch2;
    }

    @Override
    public Variable[] getVariableList() throws NotSuspendedException, NoResponseException, NotConnectedException, VersionException {
        return this.getVariableListWorker(1);
    }

    @Override
    public Variable[] getVariableListWorker(int n) throws NotSuspendedException, NoResponseException, NotConnectedException, VersionException {
        if (!this.isWorkerSuspended(n)) {
            throw new NotSuspendedException();
        }
        this.requestFrame(0, n);
        this.getValueWorker(-2L, n);
        this.getValueWorker(-3L, n);
        this.getValueWorker(-4L, n);
        int n2 = 0;
        Value value = null;
        do {
            value = this.getValueWorker(-300L - (long)n2, n);
        } while (n2++ < 128 && value != null);
        value = this.m_manager.getValue(-100L, n);
        if (value == null) {
            throw new VersionException();
        }
        return value.getMembers(this);
    }

    @Override
    public Frame[] getFrames() throws NotConnectedException {
        return this.m_manager.getFrames(1);
    }

    public void requestFrame(int n, int n2) throws NotSuspendedException, NoResponseException, NotConnectedException {
        if (this.playerSupportsGet()) {
            if (!this.isWorkerSuspended(n2)) {
                throw new NotSuspendedException();
            }
            int n3 = this.getPreference("$contextresponsetimeout");
            DMessage dMessage = DMessageCache.alloc(4);
            dMessage.setType(26);
            dMessage.setTargetIsolate(n2);
            dMessage.putDWord(n);
            if (!this.simpleRequestResponseMessage(dMessage, 31, n3)) {
                throw new NoResponseException(n3);
            }
            this.pullUpActivationObjectVariables(n, n2);
        }
    }

    private void pullUpActivationObjectVariables(int n, int n2) throws NotSuspendedException, NoResponseException, NotConnectedException {
        DVariable[] dVariableArray;
        DVariable dVariable4;
        int n3;
        DValue dValue = this.m_manager.getValue(-100L - (long)n, n2);
        if (dValue == null) {
            return;
        }
        DStackContext dStackContext = this.m_manager.getFrame(n, n2);
        DVariable[] dVariableArray2 = (DVariable[])dValue.getMembers(this);
        LinkedHashMap<String, DVariable> linkedHashMap = new LinkedHashMap<String, DVariable>(dVariableArray2.length);
        ArrayList<DVariable> arrayList = new ArrayList<DVariable>();
        Pattern pattern = Pattern.compile("^.*\\$\\d+$");
        for (n3 = 0; n3 < dVariableArray2.length; ++n3) {
            dVariable4 = dVariableArray2[n3];
            dVariableArray = pattern.matcher(dVariable4.getName());
            if (dVariableArray.matches()) {
                arrayList.add(dVariable4);
                continue;
            }
            linkedHashMap.put(dVariable4.getName(), dVariable4);
        }
        if (arrayList.size() == 0) {
            return;
        }
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            dVariable4 = (DVariable)arrayList.get(n3);
            dVariableArray = (DVariable[])dVariable4.getValue().getMembers(this);
            for (int i = 0; i < dVariableArray.length; ++i) {
                DVariable dVariable2 = dVariableArray[i];
                int n4 = dVariable2.getAttributes();
                if ((n4 & 0x200000) != 0) continue;
                n4 &= 0xFC7FFFFF;
                dVariable2.setAttributes(n4 |= 0);
                String string = dVariable2.getName();
                DVariable dVariable3 = (DVariable)linkedHashMap.get(string);
                int n5 = dVariable3 != null ? dVariable3.getAttributes() & 0x10020 : 32;
                dVariable2.setAttributes(dVariable2.getAttributes() | n5);
                linkedHashMap.put(string, dVariable2);
            }
            dStackContext.convertLocalToActivationObject(dVariable4);
        }
        for (DVariable dVariable4 : linkedHashMap.values()) {
            dValue.addMember(dVariable4);
            if (dVariable4.isAttributeSet(32)) {
                dStackContext.addLocal(dVariable4);
                continue;
            }
            if (!dVariable4.isAttributeSet(65536)) continue;
            if (dVariable4.getName().equals("this")) {
                dStackContext.setThis(dVariable4);
                continue;
            }
            dStackContext.addArgument(dVariable4);
        }
    }

    @Override
    public Value getValue(long l) throws NotSuspendedException, NoResponseException, NotConnectedException {
        return this.getValueWorker(l, 1);
    }

    @Override
    public Value getValueWorker(long l, int n) throws NotSuspendedException, NoResponseException, NotConnectedException {
        DValue dValue = null;
        if (!this.isWorkerSuspended(n)) {
            throw new NotSuspendedException();
        }
        dValue = this.m_manager.getValue(l, n);
        if (dValue == null) {
            if (l < -1L) {
                this.requestFrame(0, n);
            } else if (l > -1L) {
                this.requestVariable(l, null, n);
            }
            dValue = this.m_manager.getValue(l, n);
        }
        return dValue;
    }

    public Value getRawValue(long l, int n) {
        return this.m_manager.getValue(l, n);
    }

    public Value getPreviousValue(long l, int n) {
        return this.m_manager.getPreviousValue(l, n);
    }

    void obtainMembers(long l, int n) throws NoResponseException, NotConnectedException, NotSuspendedException {
        if (!this.isWorkerSuspended(n)) {
            throw new NotSuspendedException();
        }
        DValue dValue = this.m_manager.getValue(l, n);
        if (dValue != null && !dValue.membersObtained()) {
            this.requestVariable(l, null, false, true, n);
        }
    }

    @Override
    public Value getGlobal(String string) throws NotSuspendedException, NoResponseException, NotConnectedException {
        return this.getGlobalWorker(string, 1);
    }

    @Override
    public Value getGlobalWorker(String string, int n) throws NotSuspendedException, NoResponseException, NotConnectedException {
        Value value = this.getValue(0L, string, n);
        if (value == null || value.getType() == 7) {
            return null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Value getValue(long l, String string, int n) throws NotSuspendedException, NoResponseException, NotConnectedException {
        void var5_9;
        Object var5_4 = null;
        if (!this.isWorkerSuspended(n)) throw new NotSuspendedException();
        int n2 = this.getPreference("$invokegetters");
        this.m_manager.clearLastVariable(n);
        this.m_manager.enableChildAttach(false, n);
        try {
            this.requestVariable(l, string, n2 != 0, false, n);
            DVariable dVariable = this.m_manager.lastVariable(n);
            if (dVariable != null) {
                Value value = dVariable.getValue();
                return var5_9;
            } else {
                DValue dValue = DValue.forPrimitive(Value.UNDEFINED, n);
            }
            return var5_9;
        }
        catch (NoResponseException noResponseException) {
            if (n2 == 0) throw noResponseException;
            DValue dValue = new DValue(2, "String", "String", 262144, noResponseException.getLocalizedMessage(), n);
            if (l == 0L) return var5_9;
            DVariable dVariable = new DVariable(string, dValue, n);
            this.m_manager.enableChildAttach(true, n);
            this.m_manager.addVariableMember(l, dVariable, n);
            return var5_9;
        }
        finally {
            this.m_manager.enableChildAttach(true, n);
        }
    }

    private void requestVariable(long l, String string, int n) throws NoResponseException, NotConnectedException, NotSuspendedException {
        this.requestVariable(l, string, false, false, n);
    }

    private Value callFunction(Value value, boolean bl, String string, Value[] valueArray, int n) throws PlayerDebugException {
        if (!this.isWorkerSuspended(n)) {
            throw new NotSuspendedException();
        }
        if (!this.playerCanCallFunctions(n)) {
            throw new NotSupportedException(PlayerSessionManager.getLocalizationManager().getLocalizedTextString("functionCallsNotSupported"));
        }
        this.m_manager.clearLastFunctionCall(n);
        DMessage dMessage = this.buildCallFunctionMessage(bl, value, string, valueArray);
        dMessage.setTargetIsolate(n);
        this.m_manager.beginPlayerCodeExecution(n);
        int n2 = this.getPreference("$getvarresponsetimeout");
        boolean bl2 = this.simpleRequestResponseMessage(dMessage, 54, n2 += 500);
        this.m_manager.endPlayerCodeExecution(n);
        if (!bl2) {
            throw new NoResponseException(n2);
        }
        DVariable dVariable = this.m_manager.lastFunctionCall(n);
        if (dVariable != null) {
            return dVariable.getValue();
        }
        return DValue.forPrimitive(Value.UNDEFINED, n);
    }

    @Override
    public Value callFunction(Value value, String string, Value[] valueArray) throws PlayerDebugException {
        return this.callFunctionWorker(value, string, valueArray, 1);
    }

    @Override
    public Value callFunctionWorker(Value value, String string, Value[] valueArray, int n) throws PlayerDebugException {
        Value value2 = this.callPseudoFunction(value, string, valueArray, n);
        if (value2 != null) {
            return value2;
        }
        return this.callFunction(value, false, string, valueArray, n);
    }

    private Value callPseudoFunction(Value value, String string, Value[] valueArray, int n) throws PlayerDebugException {
        if ((value.getType() == 7 || value.getType() == 6) && "$obj".equals(string)) {
            return this.callObjPseudoFunction(valueArray, n);
        }
        return null;
    }

    private Value callObjPseudoFunction(Value[] valueArray, int n) throws PlayerDebugException {
        if (valueArray.length != 1) {
            return DValue.forPrimitive(DValue.UNDEFINED, n);
        }
        double d = ECMA.toNumber(this, valueArray[0]);
        long l = (long)d;
        if ((double)l != d) {
            return DValue.forPrimitive(DValue.UNDEFINED, n);
        }
        DValue dValue = this.m_manager.getValue(l, n);
        if (dValue == null) {
            return DValue.forPrimitive(DValue.UNDEFINED, n);
        }
        return dValue;
    }

    @Override
    public Value callConstructor(String string, Value[] valueArray) throws PlayerDebugException {
        return this.callConstructorWorker(string, valueArray, 1);
    }

    @Override
    public Value callConstructorWorker(String string, Value[] valueArray, int n) throws PlayerDebugException {
        return this.callFunction(DValue.forPrimitive(null, n), true, string, valueArray, n);
    }

    private DMessage buildCallFunctionMessage(boolean bl, Value value, String string, Value[] valueArray) {
        string = string == null ? "" : string;
        int n = 8;
        String string2 = DVariable.typeNameFor(value.getType());
        String string3 = value.getValueAsString();
        n += DMessage.getStringLength(string2) + 1;
        n += DMessage.getStringLength(string3) + 1;
        n += DMessage.getStringLength(string) + 1;
        n += 4;
        String[] stringArray = new String[valueArray.length];
        String[] stringArray2 = new String[valueArray.length];
        for (int i = 0; i < valueArray.length; ++i) {
            stringArray[i] = DVariable.typeNameFor(valueArray[i].getType());
            stringArray2[i] = valueArray[i].getValueAsString();
            n += DMessage.getStringLength(stringArray2[i]) + 1;
            n += DMessage.getStringLength(stringArray[i]) + 1;
        }
        DMessage dMessage = DMessageCache.alloc(n);
        dMessage.setType(48);
        try {
            dMessage.putDWord(bl ? 1 : 0);
            dMessage.putDWord(0);
            dMessage.putString(string2);
            dMessage.putString(string3);
            dMessage.putString(string);
            dMessage.putDWord(valueArray.length);
            for (int i = 0; i < valueArray.length; ++i) {
                dMessage.putString(stringArray[i]);
                dMessage.putString(stringArray2[i]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            dMessage.putByte((byte)0);
        }
        return dMessage;
    }

    private void requestVariable(long l, String string, boolean bl, boolean bl2, int n) throws NoResponseException, NotConnectedException, NotSuspendedException {
        if (!this.isWorkerSuspended(n)) {
            throw new NotSuspendedException();
        }
        string = this.getRawMemberName(l, string, n);
        DMessage dMessage = this.buildOutGetMessage(l, string, bl, bl2);
        dMessage.setTargetIsolate(n);
        this.m_manager.beginPlayerCodeExecution(n);
        int n2 = this.getPreference("$getvarresponsetimeout");
        boolean bl3 = this.simpleRequestResponseMessage(dMessage, 30, n2 += 500);
        this.m_manager.endPlayerCodeExecution(n);
        if (!bl3) {
            throw new NoResponseException(n2);
        }
    }

    private DMessage buildOutGetMessage(long l, String string, boolean bl, boolean bl2) {
        string = string == null ? "" : string;
        DMessage dMessage = DMessageCache.alloc(DMessage.getSizeofPtr() + DMessage.getStringLength(string) + 1 + 4);
        dMessage.setType(!bl ? 25 : 34);
        dMessage.putPtr(l);
        try {
            dMessage.putString(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            dMessage.putByte((byte)0);
        }
        int n = 4;
        if (bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 0xA;
        }
        dMessage.putDWord(n);
        return dMessage;
    }

    public FaultEvent setScalarMember(long l, String string, int n, String string2, int n2) throws NotSuspendedException, NoResponseException, NotConnectedException {
        int n3;
        Object object;
        DVariable dVariable;
        if (!this.isWorkerSuspended(n2)) {
            throw new NotSuspendedException();
        }
        if (l <= -100L && l > -300L && (dVariable = ((DStackContext)(object = this.m_manager.getFrame(n3 = (int)(-100L - l), n2))).getActivationObject()) != null) {
            l = dVariable.getValue().getId();
        }
        string = this.getRawMemberName(l, string, n2);
        FaultEvent faultEvent = this.requestSetVariable(this.isPseudoVarId(l) ? 0L : l, string, n, string2, n2);
        if (this.isPseudoVarId(l) && this.m_manager.getFrameCount(n2) > 0) {
            this.m_manager.getFrame(0, n2).markStale();
        } else {
            object = this.m_manager.getValue(l, n2);
            if (object != null) {
                ((DValue)object).removeAllMembers();
            }
        }
        return faultEvent;
    }

    private boolean isPseudoVarId(long l) {
        return l < 0L && l > -65535L;
    }

    private String getRawMemberName(long l, String string, int n) {
        int n2;
        String string2;
        DVariable dVariable;
        DValue dValue;
        if (string != null && (dValue = this.m_manager.getValue(l, n)) != null && (dVariable = dValue.findMember(string2 = (n2 = string.indexOf("::")) == -1 ? string : string.substring(n2 + 2))) != null) {
            string = dVariable.getRawName();
        }
        return string;
    }

    private FaultEvent requestSetVariable(long l, String string, int n, String string2, int n2) throws NoResponseException {
        String string3 = DVariable.typeNameFor(n);
        DMessage dMessage = this.buildOutSetMessage(l, string, string3, string2);
        dMessage.setTargetIsolate(n2);
        FaultEvent faultEvent = null;
        this.m_manager.beginPlayerCodeExecution(n2);
        this.sendSquelch(false, n2);
        int n3 = this.getPreference("$getvarresponsetimeout");
        if (!this.simpleRequestResponseMessage(dMessage, n == 2 ? 10 : 28, n3)) {
            throw new NoResponseException(this.getPreference("$responsetimeout"));
        }
        this.sendSquelch(true, n2);
        faultEvent = this.m_manager.endPlayerCodeExecution(n2);
        this.m_manager.freeValueCache(n2);
        return faultEvent;
    }

    private DMessage buildOutSetMessage(long l, String string, String string2, String string3) {
        DMessage dMessage = DMessageCache.alloc(DMessage.getSizeofPtr() + DMessage.getStringLength(string) + DMessage.getStringLength(string2) + DMessage.getStringLength(string3) + 3);
        dMessage.setType(11);
        dMessage.putPtr(l);
        try {
            dMessage.putString(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            dMessage.putByte((byte)0);
        }
        try {
            dMessage.putString(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            dMessage.putByte((byte)0);
        }
        try {
            dMessage.putString(string3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            dMessage.putByte((byte)0);
        }
        return dMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForEvent() throws NotConnectedException, InterruptedException {
        Object object;
        Object object2 = object = this.m_manager.getEventNotifier();
        synchronized (object2) {
            while (this.getEventCount() == 0 && this.isConnected()) {
                object.wait();
            }
        }
        if (this.getEventCount() == 0 && !this.isConnected()) {
            throw new NotConnectedException();
        }
    }

    @Override
    public int getEventCount() {
        return this.m_manager.getEventCount();
    }

    @Override
    public DebugEvent nextEvent() {
        return this.m_manager.nextEvent();
    }

    public boolean addWatch(long l, String string, int n, int n2, int n3) throws NoResponseException, NotConnectedException, NotSupportedException {
        if (!this.supportsWatchpoints(n3)) {
            throw new NotSupportedException(PlayerSessionManager.getLocalizationManager().getLocalizedTextString("watchpointsNotSupported"));
        }
        string = this.getRawMemberName(l, string, n3);
        DMessage dMessage = DMessageCache.alloc(4 + DMessage.getSizeofPtr() + DMessage.getStringLength(string) + 1);
        dMessage.setType(49);
        dMessage.setTargetIsolate(n3);
        dMessage.putPtr(l);
        try {
            dMessage.putString(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            dMessage.putByte((byte)0);
        }
        dMessage.putWord(n);
        dMessage.putWord(n2);
        int n4 = this.getPreference("$getvarresponsetimeout");
        boolean bl = this.simpleRequestResponseMessage(dMessage, 55, n4);
        return bl;
    }

    public boolean removeWatch(long l, String string, int n) throws NoResponseException, NotConnectedException {
        string = this.getRawMemberName(l, string, n);
        DMessage dMessage = DMessageCache.alloc(DMessage.getSizeofPtr() + DMessage.getStringLength(string) + 1);
        dMessage.setType(50);
        dMessage.putPtr(l);
        try {
            dMessage.putString(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            dMessage.putByte((byte)0);
        }
        int n2 = this.getPreference("$getvarresponsetimeout");
        boolean bl = this.simpleRequestResponseMessage(dMessage, 55, n2);
        return bl;
    }

    void sendMessage(int n) {
        DMessage dMessage = DMessageCache.alloc(0);
        dMessage.setType(n);
        this.sendMessage(dMessage);
    }

    void sendMessageIsolate(int n, int n2) {
        DMessage dMessage = DMessageCache.alloc(0);
        dMessage.setTargetIsolate(n2);
        dMessage.setType(n);
        this.sendMessage(dMessage);
    }

    synchronized void sendMessage(DMessage dMessage) {
        block4: {
            try {
                int n;
                if (dMessage.getType() != 54 && (n = dMessage.getTargetIsolate()) != this.getActiveIsolate().getId()) {
                    DMessage dMessage2 = DMessageCache.alloc(4);
                    dMessage2.setTargetIsolate(n);
                    dMessage2.setType(54);
                    dMessage2.putDWord(n);
                    this.sendMessage(dMessage2);
                    this.m_manager.setActiveIsolate(this.m_manager.getIsolate(n));
                }
                this.m_protocol.txMessage(dMessage);
                if (m_debugMsgOn || m_debugMsgFileOn) {
                    this.trace(dMessage, false);
                }
            }
            catch (IOException iOException) {
                if (!Trace.error) break block4;
                Trace.trace("Attempt to send message " + dMessage.outToString() + " failed");
                iOException.printStackTrace();
            }
        }
        DMessageCache.free(dMessage);
    }

    boolean sendSquelch(boolean bl, int n) {
        DMessage dMessage = DMessageCache.alloc(4);
        dMessage.setType(24);
        dMessage.setTargetIsolate(n);
        dMessage.putDWord(bl ? 1 : 0);
        boolean bl2 = this.simpleRequestResponseMessage(dMessage, 29);
        return bl2;
    }

    void sendStopWarning() {
        String string = "disable_script_stuck_dialog";
        String string2 = "on";
        this.sendOptionMessage(string, string2);
        string = "disable_script_stuck";
        string2 = "on";
        this.sendOptionMessage(string, string2);
    }

    void sendStopOnFault() {
        String string = "break_on_fault";
        String string2 = "on";
        this.sendOptionMessage(string, string2);
    }

    void sendEnumerateOverride() {
        String string = "enumerate_override";
        String string2 = "on";
        this.sendOptionMessage(string, string2);
    }

    void sendFailureNotify() {
        String string = "notify_on_failure";
        String string2 = "on";
        this.sendOptionMessage(string, string2);
    }

    void sendInvokeSetters() {
        String string = "invoke_setters";
        String string2 = "on";
        this.sendOptionMessage(string, string2);
    }

    void sendSwfloadNotify() {
        String string = "swf_load_messages";
        String string2 = "on";
        this.sendOptionMessage(string, string2);
    }

    void sendConsoleErrorsAsTrace(boolean bl) {
        String string = "console_errors";
        String string2 = bl ? "on" : "off";
        this.sendOptionMessage(string, string2);
    }

    void sendGetterTimeout() {
        String string = "getter_timeout";
        String string2 = "" + this.getPreference("$getvarresponsetimeout");
        this.sendOptionMessage(string, string2);
    }

    void sendSetterTimeout() {
        String string = "setter_timeout";
        String string2 = "" + this.getPreference("$setvarresponsetimeout");
        this.sendOptionMessage(string, string2);
    }

    void sendConcurrentDebugger() {
        String string = "concurrent_debugger";
        String string2 = "on";
        this.sendOptionMessage(string, string2);
    }

    void sendWideLineDebugger() {
        String string = "wide_line_debugger";
        String string2 = "on";
        this.sendOptionMessage(string, string2);
        this.m_manager.setWideLines(true);
    }

    void sendOptionMessage(String string, String string2) {
        int n = DMessage.getStringLength(string) + DMessage.getStringLength(string2) + 2;
        DMessage dMessage = DMessageCache.alloc(n);
        dMessage.setType(28);
        try {
            dMessage.putString(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            dMessage.putByte((byte)0);
        }
        try {
            dMessage.putString(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            dMessage.putByte((byte)0);
        }
        this.simpleRequestResponseMessage(dMessage, 32);
    }

    @Override
    public boolean supportsWatchpoints() {
        return this.supportsWatchpoints(1);
    }

    @Override
    public boolean supportsWatchpoints(int n) {
        if (this.m_playerSupportsWatchpoints == null) {
            this.m_playerSupportsWatchpoints = this.getOption("can_set_watchpoints", false, n);
        }
        return this.m_playerSupportsWatchpoints;
    }

    public boolean playerCanBreakOnAllExceptions() {
        return this.playerCanBreakOnAllExceptions(1);
    }

    @Override
    public boolean playerCanBreakOnAllExceptions(int n) {
        if (this.m_playerCanBreakOnAllExceptions == null) {
            this.m_playerCanBreakOnAllExceptions = this.getOption("can_break_on_all_exceptions", false, n);
        }
        return this.m_playerCanBreakOnAllExceptions;
    }

    public boolean supportsConcurrency(int n) {
        if (this.m_playerSupportsConcurrency == null) {
            this.m_playerSupportsConcurrency = this.getOption("concurrent_player", false, n);
        }
        return this.m_playerSupportsConcurrency;
    }

    @Override
    public boolean supportsConcurrency() {
        return this.supportsConcurrency(1);
    }

    public boolean supportsWideLineNumbers() {
        return this.supportsWideLineNumbers(1);
    }

    @Override
    public boolean supportsWideLineNumbers(int n) {
        if (this.m_playerSupportsWideLine == null) {
            this.m_playerSupportsWideLine = this.getOption("wide_line_player", false, n);
        }
        return this.m_playerSupportsWideLine;
    }

    public boolean playerCanTerminate() {
        return this.getOption("can_terminate", false, 1);
    }

    public boolean playerCanCallFunctions() {
        return this.playerCanCallFunctions(1);
    }

    @Override
    public boolean playerCanCallFunctions(int n) {
        if (this.m_playerCanCallFunctions == null) {
            this.m_playerCanCallFunctions = this.getOption("can_call_functions", false, n);
        }
        return this.m_playerCanCallFunctions;
    }

    public boolean getOption(String string, boolean bl, int n) {
        boolean bl2 = bl;
        String string2 = this.getOption(string, null, n);
        if (string2 != null) {
            bl2 = Boolean.valueOf(string2);
        }
        return bl2;
    }

    public String getOption(String string, String string2, int n) {
        String string3 = string2;
        int n2 = DMessage.getStringLength(string) + 1;
        DMessage dMessage = DMessageCache.alloc(n2);
        dMessage.setTargetIsolate(n);
        dMessage.setType(27);
        try {
            dMessage.putString(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            dMessage.putByte((byte)0);
        }
        if (this.simpleRequestResponseMessage(dMessage, 32)) {
            string3 = this.m_manager.getOption(string);
        }
        return string3;
    }

    long getMessageInCount(DMessageCounter dMessageCounter, long l, int n) {
        if (l == 1L) {
            return dMessageCounter.getInCount(n);
        }
        return dMessageCounter.getIsolateInCount(l, n);
    }

    Object getMessageInLock(DMessageCounter dMessageCounter, long l) {
        if (l == 1L) {
            return dMessageCounter.getInLock();
        }
        return dMessageCounter.getIsolateInLock(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean simpleRequestResponseMessage(DMessage dMessage, int n, int n2) {
        boolean bl = false;
        n2 = n2 > 0 ? n2 : this.getPreference("$responsetimeout");
        DMessageCounter dMessageCounter = this.getMessageCounter();
        int n3 = dMessage.getTargetIsolate();
        long l = this.getMessageInCount(dMessageCounter, n3, n);
        long l2 = l + 1L;
        this.sendMessage(dMessage);
        long l3 = System.currentTimeMillis();
        this.m_incoming = false;
        Object object = this.getMessageInLock(dMessageCounter, n3);
        synchronized (object) {
            while (l2 > this.getMessageInCount(dMessageCounter, n3, n) && System.currentTimeMillis() < l3 + (long)n2 && this.isConnected()) {
                try {
                    this.getMessageInLock(dMessageCounter, n3).wait(n2);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                PlayerSession playerSession = this;
                synchronized (playerSession) {
                    if (this.m_incoming) {
                        l3 = System.currentTimeMillis();
                        this.m_incoming = false;
                    }
                }
            }
        }
        if (this.getMessageInCount(dMessageCounter, n3, n) >= l2) {
            bl = true;
        } else if (n2 <= 0 && Trace.error) {
            Trace.trace("Timed-out waiting for " + DMessage.inTypeName(n) + " response to message " + dMessage.outToString());
        }
        this.m_lastResponse = bl;
        return bl;
    }

    boolean simpleRequestResponseMessage(DMessage dMessage, int n) {
        return this.simpleRequestResponseMessage(dMessage, n, -1);
    }

    boolean simpleRequestResponseMessageIsolate(DMessage dMessage, int n, int n2) {
        return this.simpleRequestResponseMessageIsolate(dMessage, n, -1, n2);
    }

    boolean simpleRequestResponseMessageIsolate(DMessage dMessage, int n, int n2, int n3) {
        dMessage.setTargetIsolate(n3);
        return this.simpleRequestResponseMessage(dMessage, n, n2);
    }

    boolean simpleRequestResponseMessage(int n, int n2) {
        return this.simpleRequestResponseMessage(n, n2, -1);
    }

    boolean simpleRequestResponseMessageIsolate(int n, int n2, int n3) {
        return this.simpleRequestResponseMessageIsolate(n, n2, -1, n3);
    }

    boolean simpleRequestResponseMessageIsolate(int n, int n2, int n3, int n4) {
        DMessage dMessage = DMessageCache.alloc(0);
        dMessage.setType(n);
        dMessage.setTargetIsolate(n4);
        return this.simpleRequestResponseMessage(dMessage, n2, n3);
    }

    boolean simpleRequestResponseMessage(int n, int n2, int n3) {
        DMessage dMessage = DMessageCache.alloc(0);
        dMessage.setType(n);
        return this.simpleRequestResponseMessage(dMessage, n2, n3);
    }

    @Override
    public void disconnected() {
        this.m_isHalted = false;
        this.m_isConnected = false;
        this.m_manager.disconnected();
    }

    @Override
    public void messageArrived(DMessage dMessage, DProtocol dProtocol) {
        this.preMessageArrived(dMessage, dProtocol);
        dMessage.reset();
        this.m_manager.messageArrived(dMessage, dProtocol);
        dMessage.reset();
        this.postMessageArrived(dMessage, dProtocol);
    }

    private void preMessageArrived(DMessage dMessage, DProtocol dProtocol) {
        switch (dMessage.getType()) {
            case 62: {
                this.m_lastPreIsolate = (int)dMessage.getDWord();
                break;
            }
            case 15: 
            case 16: 
            case 27: {
                if (this.m_lastPreIsolate == 1) {
                    this.m_isHalted = true;
                    break;
                }
                this.updateHaltIsolateStatus(this.m_lastPreIsolate, true);
            }
        }
    }

    private void postMessageArrived(DMessage dMessage, DProtocol dProtocol) {
        if (m_debugMsgOn || m_debugMsgFileOn) {
            this.trace(dMessage, true);
        }
        int n = dMessage.getType();
        switch (n) {
            case 2: {
                this.m_isConnected = false;
                break;
            }
            case 25: {
                this.sendMessageIsolate(23, dMessage.getTargetIsolate());
                break;
            }
            case 17: {
                if (dMessage.getTargetIsolate() == 1) {
                    this.m_isHalted = false;
                    break;
                }
                this.updateHaltIsolateStatus(dMessage.getTargetIsolate(), false);
                break;
            }
            case 32: {
                if (dMessage.getTargetIsolate() != 1) break;
                String string = dMessage.getString();
                String string2 = dMessage.getString();
                this.m_prefs.put(string, string2);
                break;
            }
            case 14: 
            case 21: 
            case 42: {
                this.m_evalIsAndInstanceofCache.clear();
                this.m_incoming = true;
                break;
            }
            default: {
                this.m_incoming = true;
            }
        }
        this.m_lastResponse = true;
    }

    private void updateHaltIsolateStatus(int n, boolean bl) {
        if (!this.m_isolateStatus.containsKey(n)) {
            PlayerSessionIsolateStatus playerSessionIsolateStatus = new PlayerSessionIsolateStatus();
            playerSessionIsolateStatus.m_isHalted = bl;
            this.m_isolateStatus.put(n, playerSessionIsolateStatus);
        } else {
            this.m_isolateStatus.get((Object)Integer.valueOf((int)n)).m_isHalted = bl;
        }
    }

    @Override
    public void run() {
        long l = 0L;
        while (this.isConnected()) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                long l2 = this.m_protocol.messagesReceived();
                long l3 = l - l2;
                l = l2;
                if (!this.m_lastResponse || !this.isSuspended() && l3 > 5L) {
                    throw new NotSuspendedException();
                }
                for (DIsolate dIsolate : this.m_manager.getIsolates()) {
                    int n = dIsolate.getId();
                    if (n != 1 && !this.isWorkerSuspended(n) && l3 > 5L) {
                        throw new NotSuspendedException();
                    }
                    int n2 = this.m_manager.getSwfInfoCount(n);
                    for (int i = 0; i < n2; ++i) {
                        DSwfInfo dSwfInfo = this.m_manager.getSwfInfo(i, n);
                        if (dSwfInfo == null || dSwfInfo.isUnloaded() || dSwfInfo.isPopulated() || dSwfInfo.getVmVersion() > 0) continue;
                        dSwfInfo.getSwdSize(this);
                        if (dSwfInfo.getVmVersion() > 0) {
                            dSwfInfo.setPopulated();
                            continue;
                        }
                        if (dSwfInfo.isSwdLoading() || dSwfInfo.isUnloaded()) continue;
                        if (dSwfInfo.getSwf() == null && !dSwfInfo.isUnloaded()) {
                            dSwfInfo.setSwf(this.requestSwf(i));
                        }
                        if (dSwfInfo.getSwd() == null && !dSwfInfo.isUnloaded()) {
                            dSwfInfo.setSwd(this.requestSwd(i));
                        }
                        try {
                            if (dSwfInfo.isUnloaded()) continue;
                            dSwfInfo.parseSwfSwd(this.m_manager);
                            continue;
                        }
                        catch (Exception exception) {
                            if (Trace.error) {
                                Trace.trace("Error while parsing swf/swd '" + dSwfInfo.getUrl() + "'. Giving up and marking it processed");
                                exception.printStackTrace();
                            }
                            dSwfInfo.setPopulated();
                        }
                    }
                }
            }
            catch (InProgressException inProgressException) {
            }
            catch (NoResponseException noResponseException) {
            }
            catch (NotSuspendedException notSuspendedException) {
            }
            catch (Exception exception) {
                if (!Trace.error) continue;
                Trace.trace("Exception in background swf/swd processing thread");
                exception.printStackTrace();
            }
        }
    }

    byte[] requestSwf(int n) throws NoResponseException {
        int n2 = this.getPreference("$swfswdloadtimeout");
        byte[] byArray = null;
        DMessage dMessage = DMessageCache.alloc(2);
        dMessage.setType(32);
        dMessage.putWord(n);
        if (!this.simpleRequestResponseMessage(dMessage, 34, n2)) {
            throw new NoResponseException(n2);
        }
        byArray = this.m_manager.getSWF();
        return byArray;
    }

    byte[] requestSwd(int n) throws NoResponseException {
        int n2 = this.getPreference("$swfswdloadtimeout");
        byte[] byArray = null;
        DMessage dMessage = DMessageCache.alloc(2);
        dMessage.setType(33);
        dMessage.putWord(n);
        if (!this.simpleRequestResponseMessage(dMessage, 35, n2)) {
            throw new NoResponseException(n2);
        }
        byArray = this.m_manager.getSWD();
        return byArray;
    }

    synchronized void trace(DMessage dMessage, boolean bl) {
        try {
            if (m_debugMsgOn) {
                System.out.println(bl ? dMessage.inToString(this.m_debugMsgSize) : dMessage.outToString(this.m_debugMsgSize));
            }
            if (m_debugMsgFileOn) {
                this.traceFile().write(bl ? dMessage.inToString(this.m_debugMsgFileSize) : dMessage.outToString(this.m_debugMsgFileSize));
                this.m_trace.write(s_newline);
                this.m_trace.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Writer traceFile() throws IOException {
        if (this.m_trace == null) {
            block6: {
                this.m_trace = new FileWriter("mm_debug_api_trace.txt");
                try {
                    this.m_trace.write(new Date().toString());
                }
                catch (Exception exception) {
                    this.m_trace.write("Date unknown");
                }
                try {
                    this.m_trace.write(s_newline);
                    Properties properties = System.getProperties();
                    properties.list(new PrintWriter(this.m_trace));
                    this.m_trace.write(s_newline);
                    for (String string : this.m_prefs.keySet()) {
                        Object object = this.m_prefs.get(string);
                        this.m_trace.write(string);
                        this.m_trace.write(" = ");
                        this.m_trace.write(object.toString());
                        this.m_trace.write(s_newline);
                    }
                }
                catch (Exception exception) {
                    if (!Trace.error) break block6;
                    exception.printStackTrace();
                }
            }
            this.m_trace.write(s_newline);
        }
        return this.m_trace;
    }

    public void setLaunchUrl(String object) {
        if (((String)object).startsWith("/")) {
            object = "file://" + (String)object;
        }
        this.m_launchUrl = object;
    }

    public void setAIRLaunchInfo(AIRLaunchInfo aIRLaunchInfo) {
        this.m_airLaunchInfo = aIRLaunchInfo;
    }

    @Override
    public void breakOnCaughtExceptions(boolean bl) throws NotSupportedException, NoResponseException {
        this.breakOnCaughtExceptions(bl, 1);
    }

    @Override
    public void breakOnCaughtExceptions(boolean bl, int n) throws NotSupportedException, NoResponseException {
        if (!this.playerCanBreakOnAllExceptions(n)) {
            throw new NotSupportedException(PlayerSessionManager.getLocalizationManager().getLocalizedTextString("exceptionBreakpointsNotSupported"));
        }
        DMessage dMessage = DMessageCache.alloc(1);
        dMessage.setType(51);
        dMessage.putByte((byte)(bl ? 1 : 0));
        dMessage.setTargetIsolate(n);
        if (!this.simpleRequestResponseMessage(dMessage, 56)) {
            throw new NoResponseException(this.getPreference("$responsetimeout"));
        }
    }

    @Override
    public boolean evalIs(Value value, Value value2) throws PlayerDebugException, PlayerFaultException {
        return this.evalIsOrInstanceof(BinaryOp.Is, value, value2, 1);
    }

    @Override
    public boolean evalIs(Value value, String string) throws PlayerDebugException, PlayerFaultException {
        return this.evalIsOrInstanceof(BinaryOp.Is, value, string, 1);
    }

    @Override
    public boolean evalInstanceof(Value value, Value value2) throws PlayerDebugException, PlayerFaultException {
        return this.evalIsOrInstanceof(BinaryOp.Instanceof, value, value2, 1);
    }

    @Override
    public boolean evalInstanceof(Value value, String string) throws PlayerDebugException, PlayerFaultException {
        return this.evalIsOrInstanceof(BinaryOp.Instanceof, value, string, 1);
    }

    @Override
    public boolean evalIsWorker(Value value, Value value2, int n) throws PlayerDebugException, PlayerFaultException {
        return this.evalIsOrInstanceof(BinaryOp.Is, value, value2, n);
    }

    @Override
    public boolean evalIsWorker(Value value, String string, int n) throws PlayerDebugException, PlayerFaultException {
        return this.evalIsOrInstanceof(BinaryOp.Is, value, string, n);
    }

    @Override
    public boolean evalInstanceofWorker(Value value, Value value2, int n) throws PlayerDebugException, PlayerFaultException {
        return this.evalIsOrInstanceof(BinaryOp.Instanceof, value, value2, n);
    }

    @Override
    public boolean evalInstanceofWorker(Value value, String string, int n) throws PlayerDebugException, PlayerFaultException {
        return this.evalIsOrInstanceof(BinaryOp.Instanceof, value, string, n);
    }

    private boolean evalIsOrInstanceof(BinaryOp binaryOp, Value value, Value value2, int n) throws PlayerDebugException, PlayerFaultException {
        String string = value.getTypeName() + " " + binaryOp + " " + value2.getTypeName() + " " + String.valueOf(n);
        Boolean bl = this.m_evalIsAndInstanceofCache.get(string);
        if (bl == null) {
            bl = ECMA.toBoolean(this.evalBinaryOp(binaryOp, value, value2, n));
            this.m_evalIsAndInstanceofCache.put(string, bl);
        }
        return bl;
    }

    private boolean evalIsOrInstanceof(BinaryOp binaryOp, Value value, String string, int n) throws PlayerDebugException, PlayerFaultException {
        String string2 = value.getTypeName() + " " + binaryOp + " " + string + " " + String.valueOf(n);
        Boolean bl = this.m_evalIsAndInstanceofCache.get(string2);
        if (bl == null) {
            Value value2 = this.getGlobalWorker(string, n);
            bl = value2 == null ? Boolean.FALSE : Boolean.valueOf(ECMA.toBoolean(this.evalBinaryOp(binaryOp, value, value2, n)));
            this.m_evalIsAndInstanceofCache.put(string2, bl);
        }
        return bl;
    }

    @Override
    public boolean evalIn(Value value, Value value2) throws PlayerDebugException, PlayerFaultException {
        return ECMA.toBoolean(this.evalBinaryOp(BinaryOp.In, value, value2, 1));
    }

    @Override
    public Value evalAs(Value value, Value value2) throws PlayerDebugException, PlayerFaultException {
        return this.evalBinaryOp(BinaryOp.As, value, value2, 1);
    }

    private Value evalBinaryOp(BinaryOp binaryOp, Value value, Value value2, int n) throws PlayerDebugException, PlayerFaultException {
        if (!this.isWorkerSuspended(n)) {
            throw new NotSuspendedException();
        }
        if (!this.playerCanCallFunctions(n)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("operator", binaryOp.getName());
            String string = PlayerSessionManager.getLocalizationManager().getLocalizedTextString("operatorNotSupported", hashMap);
            throw new NotSupportedException(string);
        }
        int n2 = (int)(Math.random() * 65536.0);
        DMessage dMessage = this.buildBinaryOpMessage(n2, binaryOp, value, value2);
        dMessage.setTargetIsolate(n);
        this.m_manager.clearLastBinaryOp(n);
        this.m_manager.beginPlayerCodeExecution(n);
        int n3 = this.getPreference("$getvarresponsetimeout");
        boolean bl = this.simpleRequestResponseMessage(dMessage, 57, n3 += 500);
        this.m_manager.endPlayerCodeExecution(n);
        if (!bl) {
            throw new NoResponseException(n3);
        }
        DVariable dVariable = this.m_manager.lastBinaryOp(n);
        Value value3 = dVariable != null ? dVariable.getValue() : DValue.forPrimitive(Value.UNDEFINED, n);
        if (value3.isAttributeSet(262144)) {
            throw new PlayerFaultException(new ExceptionFault(value3.getValueAsString(), false, value3, n));
        }
        return value3;
    }

    private DMessage buildBinaryOpMessage(int n, BinaryOp binaryOp, Value value, Value value2) {
        int n2 = 5;
        String string = DVariable.typeNameFor(value.getType());
        String string2 = value.getValueAsString();
        String string3 = DVariable.typeNameFor(value2.getType());
        String string4 = value2.getValueAsString();
        n2 += DMessage.getStringLength(string) + 1;
        n2 += DMessage.getStringLength(string2) + 1;
        n2 += DMessage.getStringLength(string3) + 1;
        DMessage dMessage = DMessageCache.alloc(n2 += DMessage.getStringLength(string4) + 1);
        dMessage.setType(52);
        try {
            dMessage.putDWord(n);
            dMessage.putByte((byte)binaryOp.getValue());
            dMessage.putString(string);
            dMessage.putString(string2);
            dMessage.putString(string3);
            dMessage.putString(string4);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            dMessage.putByte((byte)0);
        }
        return dMessage;
    }

    @Override
    public Exception getDisconnectCause() {
        if (this.m_protocol != null) {
            return this.m_protocol.getDisconnectCause();
        }
        return null;
    }

    @Override
    public Isolate[] refreshWorkers() throws NotSupportedException, NotSuspendedException, NoResponseException, NotConnectedException {
        if (!this.supportsConcurrency()) {
            throw new NotSupportedException(PlayerSessionManager.getLocalizationManager().getLocalizedTextString("concurrencyNotSupported"));
        }
        if (!this.isSuspended()) {
            throw new NotSuspendedException();
        }
        boolean bl = this.simpleRequestResponseMessage(53, 60);
        if (bl) {
            return this.m_manager.getIsolates();
        }
        return null;
    }

    private Isolate getActiveIsolate() {
        return this.m_manager.getActiveIsolate();
    }

    @Override
    public Isolate[] getWorkers() {
        return this.m_manager.getIsolates();
    }

    @Override
    public void resumeWorker(int n) throws NotSuspendedException, NotConnectedException, NoResponseException {
        if (!this.isWorkerSuspended(n)) {
            throw new NotSuspendedException();
        }
        if (!this.simpleRequestResponseMessageIsolate(15, 17, n)) {
            throw new NoResponseException(this.getPreference("$responsetimeout"));
        }
    }

    @Override
    public int suspendReasonWorker(int n) throws NotConnectedException {
        DSuspendInfo dSuspendInfo = this.getSuspendInfoIsolate(n);
        return dSuspendInfo.getReason();
    }

    public DSuspendInfo getSuspendInfoIsolate(int n) {
        DSuspendInfo dSuspendInfo = this.m_manager.getSuspendInfo(n);
        if (dSuspendInfo == null) {
            if (this.simpleRequestResponseMessageIsolate(35, 40, n)) {
                dSuspendInfo = this.m_manager.getSuspendInfo(n);
            }
            if (dSuspendInfo == null) {
                dSuspendInfo = new DSuspendInfo();
            }
        }
        return dSuspendInfo;
    }

    @Override
    public void stepContinueWorker(int n) throws NotSuspendedException, NoResponseException, NotConnectedException {
        if (!this.isWorkerSuspended(n)) {
            throw new NotSuspendedException();
        }
        if (!this.simpleRequestResponseMessageIsolate(31, 17, n)) {
            throw new NoResponseException(this.getPreference("$responsetimeout"));
        }
    }

    @Override
    public Location setBreakpointWorker(int n, int n2, int n3) throws NoResponseException, NotConnectedException {
        DLocation dLocation = null;
        int n4 = DLocation.encodeId(n, n2);
        int n5 = 0;
        if (this.supportsWideLineNumbers()) {
            n5 = 4;
        }
        DMessage dMessage = DMessageCache.alloc(8 + n5);
        dMessage.setType(17);
        dMessage.putDWord(1);
        if (!this.supportsWideLineNumbers()) {
            dMessage.putDWord(n4);
        } else {
            dMessage.putDWord(n);
            dMessage.putDWord(n2);
        }
        boolean bl = this.simpleRequestResponseMessageIsolate(dMessage, 19, n3);
        if (!bl) {
            throw new NoResponseException(this.getPreference("$responsetimeout"));
        }
        dLocation = this.m_manager.getBreakpoint(n4, n3);
        return dLocation;
    }

    @Override
    public Frame[] getFramesWorker(int n) throws NotConnectedException {
        return this.m_manager.getFrames(n);
    }

    @Override
    public SwfInfo[] getSwfsWorker(int n) throws NoResponseException {
        int n2 = 0;
        n2 = this.m_manager.getSwfInfoCount(n);
        if (n2 == 0) {
            this.requestSwfInfo(0, n);
        }
        ArrayList<DSwfInfo> arrayList = new ArrayList<DSwfInfo>();
        for (DSwfInfo dSwfInfo : this.m_manager.getSwfInfos(n)) {
            arrayList.add(dSwfInfo);
        }
        return arrayList.toArray(new SwfInfo[0]);
    }

    @Override
    public void stepIntoWorker(int n) throws NotSuspendedException, NoResponseException, NotConnectedException {
        if (this.isWorkerSuspended(n)) {
            if (!this.simpleRequestResponseMessageIsolate(21, 17, n)) {
                throw new NoResponseException(this.getPreference("$responsetimeout"));
            }
        } else {
            throw new NotSuspendedException();
        }
    }

    @Override
    public void stepOutWorker(int n) throws NotSuspendedException, NoResponseException, NotConnectedException {
        if (this.isWorkerSuspended(n)) {
            if (!this.simpleRequestResponseMessageIsolate(22, 17, n)) {
                throw new NoResponseException(this.getPreference("$responsetimeout"));
            }
        } else {
            throw new NotSuspendedException();
        }
    }

    @Override
    public void stepOverWorker(int n) throws NotSuspendedException, NoResponseException, NotConnectedException {
        if (this.isWorkerSuspended(n)) {
            if (!this.simpleRequestResponseMessageIsolate(20, 17, n)) {
                throw new NoResponseException(this.getPreference("$responsetimeout"));
            }
        } else {
            throw new NotSuspendedException();
        }
    }

    @Override
    public boolean evalInWorker(Value value, Value value2, int n) throws PlayerDebugException, PlayerFaultException {
        return ECMA.toBoolean(this.evalBinaryOp(BinaryOp.In, value, value2, n));
    }

    @Override
    public Value evalAsWorker(Value value, Value value2, int n) throws PlayerDebugException, PlayerFaultException {
        return this.evalBinaryOp(BinaryOp.As, value, value2, n);
    }

    @Override
    public void suspendWorker(int n) throws SuspendedException, NotConnectedException, NoResponseException {
        int n2;
        int n3 = 50;
        if (this.isWorkerSuspended(n)) {
            throw new SuspendedException();
        }
        for (n2 = this.getPreference("$suspendwait"); !this.isWorkerSuspended(n) && n2 > 0; n2 -= n3) {
            this.simpleRequestResponseMessageIsolate(16, 27, n3, n);
        }
        if (!this.isWorkerSuspended(n)) {
            throw new NoResponseException(n2);
        }
    }

    @Override
    public IsolateSession getWorkerSession(int n) {
        if (this.m_isolateSessions.containsKey(n)) {
            return this.m_isolateSessions.get(n);
        }
        IsolatePlayerSession isolatePlayerSession = new IsolatePlayerSession(n, this);
        this.m_isolateSessions.put(n, isolatePlayerSession);
        return isolatePlayerSession;
    }

    @Override
    public boolean setExceptionBreakpoint(String string) throws NoResponseException, NotConnectedException {
        return this.setExceptionBreakpointWorker(string, 1);
    }

    @Override
    public boolean setExceptionBreakpointWorker(String string, int n) throws NoResponseException, NotConnectedException {
        int n2 = DMessage.getStringLength(string) + 1;
        DMessage dMessage = DMessageCache.alloc(n2);
        dMessage.setType(55);
        dMessage.setTargetIsolate(n);
        try {
            dMessage.putString(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            dMessage.putByte((byte)0);
        }
        boolean bl = this.simpleRequestResponseMessageIsolate(dMessage, 63, n);
        if (bl) {
            return true;
        }
        throw new NoResponseException(this.getPreference("$responsetimeout"));
    }

    @Override
    public boolean clearExceptionBreakpoint(String string) throws NoResponseException, NotConnectedException {
        return this.clearExceptionBreakpointWorker(string, 1);
    }

    @Override
    public boolean clearExceptionBreakpointWorker(String string, int n) throws NoResponseException, NotConnectedException {
        int n2 = DMessage.getStringLength(string) + 1;
        DMessage dMessage = DMessageCache.alloc(n2);
        dMessage.setType(56);
        dMessage.setTargetIsolate(n);
        try {
            dMessage.putString(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            dMessage.putByte((byte)0);
        }
        boolean bl = this.simpleRequestResponseMessageIsolate(dMessage, 64, n);
        if (bl) {
            return true;
        }
        throw new NoResponseException(this.getPreference("$responsetimeout"));
    }

    @Override
    public void setLauncher(ILauncher iLauncher) {
        this.launcher = iLauncher;
    }
}

