/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.report;

import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.royale.test.ant.report.Report;

public class Reports
extends HashMap<String, Report> {
    private static final long serialVersionUID = 2078272511659655555L;
    private static final String TEST_INFO = "Tests run: {0}, Failures: {1}, Errors: {2}, Skipped: {3}, Time elapsed: {4} sec";

    public String getSummary() {
        Object summary = "";
        int runs = 0;
        int errors = 0;
        int failures = 0;
        int skips = 0;
        long time = 0L;
        for (Report report : this.values()) {
            runs += report.suite.getTests();
            errors += report.suite.getErrors();
            failures += report.suite.getFailures();
            skips += report.suite.getSkips();
            time += report.suite.getTime();
            summary = (String)summary + report.getSummary() + "\n";
        }
        summary = (String)summary + "\nResults :\n\n";
        try {
            summary = (String)summary + MessageFormat.format(TEST_INFO, runs, failures, errors, skips, this.formatTime(time));
        }
        catch (Exception e) {
            summary = (String)summary + "Error occurred while generating summary ...";
        }
        summary = (String)summary + "\n";
        return summary;
    }

    private String formatTime(long time) {
        return String.format("%.3f", (double)time / 1000.0);
    }

    public boolean hasFailures() {
        for (Report report : this.values()) {
            if (!report.hasFailures()) continue;
            return true;
        }
        return false;
    }
}

