/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;

public class SuperCallEmitter
extends JSSubEmitter {
    public SuperCallEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    public void emit(IASNode node, String type) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        IFunctionNode fnode = node instanceof IFunctionNode ? (IFunctionNode)node : null;
        FunctionCallNode fcnode = node instanceof IFunctionCallNode ? (FunctionCallNode)node : null;
        IClassDefinition thisClass = this.getModel().getCurrentClass();
        if (type == "replaceSuperFunction") {
            if (fnode == null) {
                fnode = (IFunctionNode)fcnode.getAncestorOfType(IFunctionNode.class);
            }
            if (fnode != null && fnode.isConstructor() && !EmitterUtils.hasSuperClass(this.getProject(), (IDefinitionNode)fnode)) {
                return;
            }
            IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
            boolean isGetterSetter = false;
            if (fcnode != null) {
                IExpressionNode fcNameNode = fcnode.getNameNode();
                MemberAccessExpressionNode mae = null;
                if (fcNameNode.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                    mae = (MemberAccessExpressionNode)fcNameNode;
                }
                if (mae != null && (mae.getRightOperandNode().getNodeID() == ASTNodeID.GetterID || mae.getRightOperandNode().getNodeID() == ASTNodeID.SetterID)) {
                    isGetterSetter = true;
                }
            } else if (fnode != null && (fnode.getNodeID() == ASTNodeID.GetterID || fnode.getNodeID() == ASTNodeID.SetterID)) {
                isGetterSetter = true;
            }
            if (isGetterSetter) {
                BinaryOperatorAssignmentNode bnode;
                IFunctionNode pnode;
                if (cnode == null && thisClass != null) {
                    this.write(this.getEmitter().formatQualifiedName(thisClass.getQualifiedName()));
                } else {
                    this.write(this.getEmitter().formatQualifiedName(cnode.getQualifiedName()));
                }
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(JSGoogEmitterTokens.SUPERCLASS);
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                if (fnode.getNodeID() == ASTNodeID.GetterID) {
                    this.write(fjs.formatGetter(fnode.getName()));
                } else {
                    this.write(fjs.formatSetter(fnode.getName()));
                }
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(JSEmitterTokens.APPLY);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(ASEmitterTokens.THIS);
                IExpressionNode[] anodes = null;
                boolean writeArguments = false;
                if (fcnode != null) {
                    anodes = fcnode.getArgumentNodes();
                    writeArguments = anodes.length > 0;
                } else if (fnode != null && fnode.isConstructor()) {
                    anodes = fnode.getParameterNodes();
                    writeArguments = anodes != null && anodes.length > 0;
                } else if (node instanceof IFunctionNode && node instanceof BinaryOperatorAssignmentNode && (pnode = (IFunctionNode)(bnode = (BinaryOperatorAssignmentNode)node).getAncestorOfType(IFunctionNode.class)).getNodeID() == ASTNodeID.SetterID) {
                    this.writeToken(ASEmitterTokens.COMMA);
                    this.writeToken(ASEmitterTokens.SQUARE_OPEN);
                    this.getWalker().walk((IASNode)bnode.getRightOperandNode());
                    this.writeToken(ASEmitterTokens.SQUARE_CLOSE);
                }
                if (writeArguments) {
                    int len = anodes.length;
                    for (int i = 0; i < len; ++i) {
                        this.writeToken(ASEmitterTokens.COMMA);
                        this.writeToken(ASEmitterTokens.SQUARE_OPEN);
                        this.getWalker().walk((IASNode)anodes[i]);
                        this.writeToken(ASEmitterTokens.SQUARE_CLOSE);
                    }
                }
                this.write(ASEmitterTokens.PAREN_CLOSE);
                return;
            }
        }
        this.super_emitSuperCall(node, type);
    }

    protected void super_emitSuperCall(IASNode node, String type) {
        FunctionCallNode fcnode;
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        IFunctionNode fnode = node instanceof IFunctionNode ? (IFunctionNode)node : null;
        FunctionCallNode functionCallNode = fcnode = node instanceof IFunctionCallNode ? (FunctionCallNode)node : null;
        if (type == "emptyConstructor") {
            this.indentPush();
            this.writeNewline();
            this.indentPop();
        } else if (type == "replaceSuperFunction" && fnode == null) {
            fnode = (IFunctionNode)fcnode.getAncestorOfType(IFunctionNode.class);
        }
        if (fnode.isConstructor() && !EmitterUtils.hasSuperClass(this.getProject(), (IDefinitionNode)fnode)) {
            return;
        }
        IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
        if (cnode == null) {
            IClassDefinition cdef = this.getModel().getCurrentClass();
            this.write(fjs.formatQualifiedName(cdef.getQualifiedName()));
        } else {
            this.write(fjs.formatQualifiedName(cnode.getQualifiedName()));
        }
        if (fnode.isConstructor()) {
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSGoogEmitterTokens.GOOG_BASE);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.THIS);
            this.writeToken(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(JSGoogEmitterTokens.GOOG_CONSTRUCTOR);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
        }
        boolean usingApply = false;
        if (fnode != null && !fnode.isConstructor()) {
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSGoogEmitterTokens.SUPERCLASS);
            IExpressionNode namenode = fcnode.getNameNode();
            IDefinition def = namenode.resolve(this.getWalker().getProject());
            String superName = fnode.getName();
            if (namenode instanceof MemberAccessExpressionNode && (namenode = ((MemberAccessExpressionNode)namenode).getRightOperandNode()) instanceof IdentifierNode) {
                superName = ((IdentifierNode)namenode).getName();
            }
            if (def instanceof FunctionDefinition && fjs.isCustomNamespace((FunctionDefinition)def)) {
                INamespaceDefinition nsDef = ((FunctionDefinition)def).getNamespaceReference().resolveNamespaceReference(this.getProject());
                if (nsDef.getContainingScope() != null) {
                    fjs.formatQualifiedName(nsDef.getQualifiedName());
                }
                String s = nsDef.getURI();
                this.write(JSRoyaleEmitter.formatNamespacedProperty(s, superName, true));
            } else {
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(superName);
            }
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.APPLY);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.THIS);
            usingApply = true;
        }
        IExpressionNode[] anodes = null;
        boolean writeArguments = false;
        if (fcnode != null) {
            anodes = fcnode.getArgumentNodes();
            writeArguments = anodes.length > 0;
        } else if (fnode.isConstructor()) {
            // empty if block
        }
        if (writeArguments) {
            if (usingApply) {
                this.writeToken(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.SQUARE_OPEN);
            }
            int len = anodes.length;
            for (int i = 0; i < len; ++i) {
                if (!usingApply || i > 0) {
                    this.writeToken(ASEmitterTokens.COMMA);
                }
                this.getWalker().walk((IASNode)anodes[i]);
            }
            if (usingApply) {
                this.write(ASEmitterTokens.SQUARE_CLOSE);
            }
        }
        this.write(ASEmitterTokens.PAREN_CLOSE);
        if (type == "fullConstructor") {
            this.write(ASEmitterTokens.SEMICOLON);
            this.writeNewline();
        } else if (type == "emptyConstructor") {
            this.write(ASEmitterTokens.SEMICOLON);
        }
    }
}

