/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl;

import apache.rocketmq.v2.PrintThreadStackTraceCommand;
import apache.rocketmq.v2.RecoverOrphanedTransactionCommand;
import apache.rocketmq.v2.Settings;
import apache.rocketmq.v2.TelemetryCommand;
import apache.rocketmq.v2.VerifyMessageCommand;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.java.impl.producer.ClientSessionHandler;
import org.apache.rocketmq.client.java.misc.ClientId;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSessionImpl
implements StreamObserver<TelemetryCommand> {
    static final Duration REQUEST_OBSERVER_RENEW_BACKOFF_DELAY = Duration.ofSeconds(1L);
    private static final Logger log = LoggerFactory.getLogger(ClientSessionImpl.class);
    private static final Duration SETTINGS_INITIALIZATION_TIMEOUT = Duration.ofSeconds(3L);
    private final ClientSessionHandler sessionHandler;
    private final Endpoints endpoints;
    private final SettableFuture<Settings> future;
    private volatile StreamObserver<TelemetryCommand> requestObserver;

    protected ClientSessionImpl(ClientSessionHandler sessionHandler, Duration tolerance, Endpoints endpoints) throws ClientException {
        this.sessionHandler = sessionHandler;
        this.endpoints = endpoints;
        this.future = SettableFuture.create();
        Futures.withTimeout(this.future, (long)SETTINGS_INITIALIZATION_TIMEOUT.plus(tolerance).toMillis(), (TimeUnit)TimeUnit.MILLISECONDS, (ScheduledExecutorService)sessionHandler.getScheduler());
        this.requestObserver = sessionHandler.telemetry(endpoints, this);
    }

    private void renewRequestObserver() {
        ClientId clientId = this.sessionHandler.getClientId();
        try {
            if (this.sessionHandler.isEndpointsDeprecated(this.endpoints)) {
                log.info("Endpoints is deprecated, no longer to renew requestObserver, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
                this.sessionHandler.removeClientSession(this.endpoints, this);
                return;
            }
            log.info("Try to renew requestObserver, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
            this.requestObserver = this.sessionHandler.telemetry(this.endpoints, this);
        }
        catch (Throwable t) {
            log.error("Failed to renew requestObserver, attempt to renew later, endpoints={}, delay={}, clientId={}", new Object[]{this.endpoints, REQUEST_OBSERVER_RENEW_BACKOFF_DELAY, clientId, t});
            this.sessionHandler.getScheduler().schedule(this::renewRequestObserver, REQUEST_OBSERVER_RENEW_BACKOFF_DELAY.toNanos(), TimeUnit.NANOSECONDS);
            return;
        }
        log.info("Sync setting to remote after requestObserver is renewed, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
        this.syncSettings0();
    }

    protected ListenableFuture<Settings> syncSettings() {
        this.syncSettings0();
        return this.future;
    }

    private void syncSettings0() {
        TelemetryCommand settings = this.sessionHandler.settingsCommand();
        this.write(settings);
    }

    public void release() {
        ClientId clientId = this.sessionHandler.getClientId();
        if (null == this.requestObserver) {
            log.error("[Bug] request observer does not exist, no need to release, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
            return;
        }
        log.info("Begin to release client session, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
        try {
            this.requestObserver.onCompleted();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void write(TelemetryCommand command) {
        if (null == this.requestObserver) {
            log.error("[Bug] Request observer does not exist, ignore current command, endpoints={}, command={}, clientId={}", new Object[]{this.endpoints, command, this.sessionHandler.getClientId()});
            return;
        }
        this.requestObserver.onNext((Object)command);
    }

    public void onNext(TelemetryCommand command) {
        ClientId clientId = this.sessionHandler.getClientId();
        try {
            switch (command.getCommandCase()) {
                case SETTINGS: {
                    Settings settings = command.getSettings();
                    log.info("Receive settings from remote, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
                    this.sessionHandler.onSettingsCommand(this.endpoints, settings);
                    if (this.future.set((Object)settings)) {
                        log.info("Init settings successfully, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
                    }
                    break;
                }
                case RECOVER_ORPHANED_TRANSACTION_COMMAND: {
                    RecoverOrphanedTransactionCommand recoverOrphanedTransactionCommand = command.getRecoverOrphanedTransactionCommand();
                    log.info("Receive orphaned transaction recovery command from remote, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
                    this.sessionHandler.onRecoverOrphanedTransactionCommand(this.endpoints, recoverOrphanedTransactionCommand);
                    break;
                }
                case VERIFY_MESSAGE_COMMAND: {
                    VerifyMessageCommand verifyMessageCommand = command.getVerifyMessageCommand();
                    log.info("Receive message verification command from remote, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
                    this.sessionHandler.onVerifyMessageCommand(this.endpoints, verifyMessageCommand);
                    break;
                }
                case PRINT_THREAD_STACK_TRACE_COMMAND: {
                    PrintThreadStackTraceCommand printThreadStackTraceCommand = command.getPrintThreadStackTraceCommand();
                    log.info("Receive thread stack print command from remote, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
                    this.sessionHandler.onPrintThreadStackTraceCommand(this.endpoints, printThreadStackTraceCommand);
                    break;
                }
                default: {
                    log.warn("Receive unrecognized command from remote, endpoints={}, command={}, clientId={}", new Object[]{this.endpoints, command, clientId});
                    break;
                }
            }
        }
        catch (Throwable t) {
            log.error("[Bug] unexpected exception raised while receiving command from remote, command={}, clientId={}", new Object[]{command, clientId, t});
        }
    }

    public void onError(Throwable throwable) {
        ClientId clientId = this.sessionHandler.getClientId();
        log.error("Exception raised from stream response observer, clientId={}, endpoints={}", new Object[]{clientId, this.endpoints, throwable});
        this.release();
        if (!this.sessionHandler.isRunning()) {
            log.info("Session handler is not running, forgive to renew request observer, clientId={}, endpoints={}", (Object)clientId, (Object)this.endpoints);
            return;
        }
        this.sessionHandler.getScheduler().schedule(this::renewRequestObserver, REQUEST_OBSERVER_RENEW_BACKOFF_DELAY.toNanos(), TimeUnit.NANOSECONDS);
    }

    public void onCompleted() {
        ClientId clientId = this.sessionHandler.getClientId();
        log.info("Receive completion for stream response observer, clientId={}, endpoints={}", (Object)clientId, (Object)this.endpoints);
        this.release();
        if (!this.sessionHandler.isRunning()) {
            log.info("Session handler is not running, forgive to renew request observer, clientId={}, endpoints={}", (Object)clientId, (Object)this.endpoints);
            return;
        }
        this.sessionHandler.getScheduler().schedule(this::renewRequestObserver, REQUEST_OBSERVER_RENEW_BACKOFF_DELAY.toNanos(), TimeUnit.NANOSECONDS);
    }
}

