/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.producer;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.producer.Transaction;
import org.apache.rocketmq.client.apis.producer.TransactionResolution;
import org.apache.rocketmq.client.java.impl.producer.ProducerImpl;
import org.apache.rocketmq.client.java.impl.producer.SendReceiptImpl;
import org.apache.rocketmq.client.java.message.PublishingMessageImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransactionImpl
implements Transaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerImpl.class);
    private static final int MAX_MESSAGE_NUM = 1;
    private final ProducerImpl producerImpl;
    @GuardedBy(value="messagesLock")
    private final Set<PublishingMessageImpl> messages;
    private final ReadWriteLock messagesLock;
    private final ConcurrentMap<PublishingMessageImpl, SendReceiptImpl> messageSendReceiptMap;

    public TransactionImpl(ProducerImpl producerImpl) {
        this.producerImpl = producerImpl;
        this.messages = new HashSet<PublishingMessageImpl>();
        this.messagesLock = new ReentrantReadWriteLock();
        this.messageSendReceiptMap = new ConcurrentHashMap<PublishingMessageImpl, SendReceiptImpl>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublishingMessageImpl tryAddMessage(Message message) throws IOException {
        this.messagesLock.readLock().lock();
        try {
            if (this.messages.size() > 1) {
                throw new IllegalArgumentException("Message in transaction has exceeded the threshold: 1");
            }
        }
        finally {
            this.messagesLock.readLock().unlock();
        }
        this.messagesLock.writeLock().lock();
        try {
            if (this.messages.size() >= 1) {
                throw new IllegalArgumentException("Message in transaction has exceeded the threshold: 1");
            }
            PublishingMessageImpl publishingMessage = new PublishingMessageImpl(message, this.producerImpl.producerSettings, true);
            this.messages.add(publishingMessage);
            PublishingMessageImpl publishingMessageImpl = publishingMessage;
            return publishingMessageImpl;
        }
        finally {
            this.messagesLock.writeLock().unlock();
        }
    }

    public void tryAddReceipt(PublishingMessageImpl publishingMessage, SendReceiptImpl sendReceipt) {
        this.messagesLock.readLock().lock();
        try {
            if (!this.messages.contains(publishingMessage)) {
                LOGGER.warn("message(s) is not contained in current transaction");
                return;
            }
            this.messageSendReceiptMap.put(publishingMessage, sendReceipt);
        }
        finally {
            this.messagesLock.readLock().unlock();
        }
    }

    public void commit() throws ClientException {
        if (this.messageSendReceiptMap.isEmpty()) {
            throw new IllegalStateException("Transactional message has not been sent yet");
        }
        for (Map.Entry entry : this.messageSendReceiptMap.entrySet()) {
            PublishingMessageImpl publishingMessage = (PublishingMessageImpl)entry.getKey();
            SendReceiptImpl sendReceipt = (SendReceiptImpl)entry.getValue();
            this.producerImpl.endTransaction(sendReceipt.getEndpoints(), publishingMessage.getMessageCommon(), sendReceipt.getMessageId(), sendReceipt.getTransactionId(), TransactionResolution.COMMIT);
        }
    }

    public void rollback() throws ClientException {
        if (this.messageSendReceiptMap.isEmpty()) {
            throw new IllegalStateException("Transactional message has not been sent yet");
        }
        for (Map.Entry entry : this.messageSendReceiptMap.entrySet()) {
            PublishingMessageImpl publishingMessage = (PublishingMessageImpl)entry.getKey();
            SendReceiptImpl sendReceipt = (SendReceiptImpl)entry.getValue();
            this.producerImpl.endTransaction(sendReceipt.getEndpoints(), publishingMessage.getMessageCommon(), sendReceipt.getMessageId(), sendReceipt.getTransactionId(), TransactionResolution.ROLLBACK);
        }
    }
}

