/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.index.rocksdb;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.MixAll;

public class IndexRocksDBRecord {
    public static final String KEY_SPLIT = "@";
    public static final byte[] KEY_SPLIT_BYTES = "@".getBytes(StandardCharsets.UTF_8);
    private static final int VALUE_LENGTH = 8;
    private long storeTime;
    private String topic;
    private String key;
    private String tag;
    private String uniqKey;
    private long offsetPy;

    public IndexRocksDBRecord(String topic, String key, String tag, long storeTime, String uniqKey, long offsetPy) {
        this.topic = topic;
        this.key = key;
        this.tag = tag;
        this.storeTime = storeTime;
        this.uniqKey = uniqKey;
        this.offsetPy = offsetPy;
    }

    public byte[] getKeyBytes() {
        if (StringUtils.isEmpty((CharSequence)this.topic) || StringUtils.isEmpty((CharSequence)this.uniqKey) || this.offsetPy < 0L || this.storeTime <= 0L) {
            return null;
        }
        long storeTimeHour = MixAll.dealTimeToHourStamps((long)this.storeTime);
        if (storeTimeHour <= 0L) {
            return null;
        }
        String keyMiddleStr = !StringUtils.isEmpty((CharSequence)this.key) ? KEY_SPLIT + this.topic + KEY_SPLIT + "K" + KEY_SPLIT + this.key + KEY_SPLIT + this.uniqKey + KEY_SPLIT : (!StringUtils.isEmpty((CharSequence)this.tag) ? KEY_SPLIT + this.topic + KEY_SPLIT + "T" + KEY_SPLIT + this.tag + KEY_SPLIT + this.uniqKey + KEY_SPLIT : KEY_SPLIT + this.topic + KEY_SPLIT + "U" + KEY_SPLIT + this.uniqKey + KEY_SPLIT);
        if (StringUtils.isEmpty((CharSequence)keyMiddleStr)) {
            return null;
        }
        byte[] keyMiddleBytes = keyMiddleStr.getBytes(StandardCharsets.UTF_8);
        int keyLength = 8 + keyMiddleBytes.length + 8;
        return ByteBuffer.allocate(keyLength).putLong(storeTimeHour).put(keyMiddleBytes).putLong(this.offsetPy).array();
    }

    public byte[] getValueBytes() {
        if (this.storeTime <= 0L) {
            return null;
        }
        return ByteBuffer.allocate(8).putLong(this.storeTime).array();
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public long getStoreTime() {
        return this.storeTime;
    }

    public void setStoreTime(long storeTime) {
        this.storeTime = storeTime;
    }

    public String getUniqKey() {
        return this.uniqKey;
    }

    public void setUniqKey(String uniqKey) {
        this.uniqKey = uniqKey;
    }

    public long getOffsetPy() {
        return this.offsetPy;
    }

    public void setOffsetPy(long offsetPy) {
        this.offsetPy = offsetPy;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

