/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.auth.authorization.provider;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Metadata;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.rocketmq.auth.authorization.builder.AuthorizationContextBuilder;
import org.apache.rocketmq.auth.authorization.builder.DefaultAuthorizationContextBuilder;
import org.apache.rocketmq.auth.authorization.chain.AclAuthorizationHandler;
import org.apache.rocketmq.auth.authorization.chain.UserAuthorizationHandler;
import org.apache.rocketmq.auth.authorization.context.DefaultAuthorizationContext;
import org.apache.rocketmq.auth.authorization.enums.Decision;
import org.apache.rocketmq.auth.authorization.provider.AuthorizationProvider;
import org.apache.rocketmq.auth.config.AuthConfig;
import org.apache.rocketmq.common.action.Action;
import org.apache.rocketmq.common.chain.Handler;
import org.apache.rocketmq.common.chain.HandlerChain;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizationProvider
implements AuthorizationProvider<DefaultAuthorizationContext> {
    protected final Logger log = LoggerFactory.getLogger((String)"RocketmqAuthAudit");
    protected AuthConfig authConfig;
    protected Supplier<?> metadataService;
    protected AuthorizationContextBuilder authorizationContextBuilder;

    @Override
    public void initialize(AuthConfig config) {
        this.initialize(config, null);
    }

    @Override
    public void initialize(AuthConfig config, Supplier<?> metadataService) {
        this.authConfig = config;
        this.metadataService = metadataService;
        this.authorizationContextBuilder = new DefaultAuthorizationContextBuilder(config);
    }

    @Override
    public CompletableFuture<Void> authorize(DefaultAuthorizationContext context) {
        return ((CompletableFuture)this.newHandlerChain().handle((Object)context)).whenComplete((nil, ex) -> this.doAuditLog(context, (Throwable)ex));
    }

    @Override
    public List<DefaultAuthorizationContext> newContexts(Metadata metadata, GeneratedMessageV3 message) {
        return this.authorizationContextBuilder.build(metadata, message);
    }

    @Override
    public List<DefaultAuthorizationContext> newContexts(ChannelHandlerContext context, RemotingCommand command) {
        return this.authorizationContextBuilder.build(context, command);
    }

    protected HandlerChain<DefaultAuthorizationContext, CompletableFuture<Void>> newHandlerChain() {
        return HandlerChain.create().addNext((Handler)new UserAuthorizationHandler(this.authConfig, this.metadataService)).addNext((Handler)new AclAuthorizationHandler(this.authConfig, this.metadataService));
    }

    protected void doAuditLog(DefaultAuthorizationContext context, Throwable ex) {
        if (context.getSubject() == null) {
            return;
        }
        Decision decision = Decision.ALLOW;
        if (ex != null) {
            decision = Decision.DENY;
        }
        String subject = context.getSubject().getSubjectKey();
        String actions = context.getActions().stream().map(Action::getName).collect(Collectors.joining(","));
        String sourceIp = context.getSourceIp();
        String resource = context.getResource().getResourceKey();
        String request = context.getRpcCode();
        String format = "[AUTHORIZATION] Subject = {} is {} Action = {} from sourceIp = {} on resource = {} for request = {}.";
        if (decision == Decision.ALLOW) {
            this.log.debug(format, new Object[]{subject, decision.getName(), actions, sourceIp, resource, request});
        } else {
            this.log.info(format, new Object[]{subject, decision.getName(), actions, sourceIp, resource, request});
        }
    }
}

