/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.compression;

public enum CompressionType {
    LZ4(1),
    ZSTD(2),
    ZLIB(3);

    private final int value;

    private CompressionType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static CompressionType of(String name) {
        switch (name.trim().toUpperCase()) {
            case "LZ4": {
                return LZ4;
            }
            case "ZSTD": {
                return ZSTD;
            }
            case "ZLIB": {
                return ZLIB;
            }
        }
        throw new RuntimeException("Unsupported compress type name: " + name);
    }

    public static CompressionType findByValue(int value) {
        switch (value) {
            case 1: {
                return LZ4;
            }
            case 2: {
                return ZSTD;
            }
            case 0: 
            case 3: {
                return ZLIB;
            }
        }
        throw new RuntimeException("Unknown compress type value: " + value);
    }

    public int getCompressionFlag() {
        switch (this.value) {
            case 1: {
                return 256;
            }
            case 2: {
                return 512;
            }
            case 3: {
                return 768;
            }
        }
        throw new RuntimeException("Unsupported compress type flag: " + this.value);
    }
}

