/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.pagecache;

import io.netty.channel.FileRegion;
import io.netty.util.AbstractReferenceCounted;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.apache.rocketmq.store.GetMessageResult;

public class ManyMessageTransfer
extends AbstractReferenceCounted
implements FileRegion {
    private final ByteBuffer byteBufferHeader;
    private final GetMessageResult getMessageResult;
    private long transferred;

    public ManyMessageTransfer(ByteBuffer byteBufferHeader, GetMessageResult getMessageResult) {
        this.byteBufferHeader = byteBufferHeader;
        this.getMessageResult = getMessageResult;
    }

    public long position() {
        int pos = this.byteBufferHeader.position();
        List messageBufferList = this.getMessageResult.getMessageBufferList();
        for (ByteBuffer bb : messageBufferList) {
            pos += bb.position();
        }
        return pos;
    }

    public long transfered() {
        return this.transferred;
    }

    public long transferred() {
        return this.transferred;
    }

    public long count() {
        return this.byteBufferHeader.limit() + this.getMessageResult.getBufferTotalSize();
    }

    public long transferTo(WritableByteChannel target, long position) throws IOException {
        if (this.byteBufferHeader.hasRemaining()) {
            this.transferred += (long)target.write(this.byteBufferHeader);
            return this.transferred;
        }
        List messageBufferList = this.getMessageResult.getMessageBufferList();
        for (ByteBuffer bb : messageBufferList) {
            if (!bb.hasRemaining()) continue;
            this.transferred += (long)target.write(bb);
            return this.transferred;
        }
        return 0L;
    }

    public FileRegion retain() {
        super.retain();
        return this;
    }

    public FileRegion retain(int increment) {
        super.retain(increment);
        return this;
    }

    public FileRegion touch() {
        return this;
    }

    public FileRegion touch(Object hint) {
        return this;
    }

    public void close() {
        this.deallocate();
    }

    protected void deallocate() {
        this.getMessageResult.release();
    }
}

