/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.route;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.rocketmq.common.message.MessageQueue;

public class AddressableMessageQueue
implements Comparable<AddressableMessageQueue> {
    private final MessageQueue messageQueue;
    private final String brokerAddr;

    public AddressableMessageQueue(MessageQueue messageQueue, String brokerAddr) {
        this.messageQueue = messageQueue;
        this.brokerAddr = brokerAddr;
    }

    @Override
    public int compareTo(AddressableMessageQueue o) {
        return this.messageQueue.compareTo(o.messageQueue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddressableMessageQueue)) {
            return false;
        }
        AddressableMessageQueue queue = (AddressableMessageQueue)o;
        return Objects.equals(this.messageQueue, queue.messageQueue);
    }

    public int hashCode() {
        return this.messageQueue == null ? 1 : this.messageQueue.hashCode();
    }

    public int getQueueId() {
        return this.messageQueue.getQueueId();
    }

    public String getBrokerName() {
        return this.messageQueue.getBrokerName();
    }

    public String getTopic() {
        return this.messageQueue.getTopic();
    }

    public MessageQueue getMessageQueue() {
        return this.messageQueue;
    }

    public String getBrokerAddr() {
        return this.brokerAddr;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("messageQueue", (Object)this.messageQueue).add("brokerAddr", (Object)this.brokerAddr).toString();
    }
}

