/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.file;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.tieredstore.common.AppendResult;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.file.TieredFileAllocator;
import org.apache.rocketmq.tieredstore.file.TieredFlatFile;
import org.apache.rocketmq.tieredstore.provider.TieredFileSegment;
import org.apache.rocketmq.tieredstore.util.MessageBufferUtil;

public class TieredCommitLog {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    public static final int CODA_SIZE = 16;
    public static final int BLANK_MAGIC_CODE = -875286124;
    private final TieredMessageStoreConfig storeConfig;
    private final TieredFlatFile flatFile;

    public TieredCommitLog(TieredFileAllocator fileQueueFactory, String filePath) {
        this.storeConfig = fileQueueFactory.getStoreConfig();
        this.flatFile = fileQueueFactory.createFlatFileForCommitLog(filePath);
    }

    @VisibleForTesting
    public TieredFlatFile getFlatFile() {
        return this.flatFile;
    }

    public long getMinOffset() {
        return this.flatFile.getMinOffset();
    }

    public long getCommitOffset() {
        return this.flatFile.getCommitOffset();
    }

    public long getDispatchCommitOffset() {
        return this.flatFile.getDispatchCommitOffset();
    }

    public long getMaxOffset() {
        return this.flatFile.getMaxOffset();
    }

    public long getBeginTimestamp() {
        TieredFileSegment firstIndexFile = this.flatFile.getFileByIndex(0);
        if (firstIndexFile == null) {
            return -1L;
        }
        long beginTimestamp = firstIndexFile.getMinTimestamp();
        return beginTimestamp != Long.MAX_VALUE ? beginTimestamp : -1L;
    }

    public long getEndTimestamp() {
        return this.flatFile.getFileToWrite().getMaxTimestamp();
    }

    public AppendResult append(ByteBuffer byteBuf) {
        return this.flatFile.append(byteBuf, MessageBufferUtil.getStoreTimeStamp(byteBuf));
    }

    public AppendResult append(ByteBuffer byteBuf, boolean commit) {
        return this.flatFile.append(byteBuf, MessageBufferUtil.getStoreTimeStamp(byteBuf), commit);
    }

    public CompletableFuture<ByteBuffer> readAsync(long offset, int length) {
        return this.flatFile.readAsync(offset, length);
    }

    public void commit(boolean sync) {
        this.flatFile.commit(sync);
    }

    public void cleanExpiredFile(long expireTimestamp) {
        this.flatFile.cleanExpiredFile(expireTimestamp);
    }

    public void destroyExpiredFile() {
        this.flatFile.destroyExpiredFile();
        if (this.flatFile.getFileSegmentCount() == 0) {
            return;
        }
        TieredFileSegment fileSegment = this.flatFile.getFileToWrite();
        try {
            if (System.currentTimeMillis() - fileSegment.getMaxTimestamp() > TimeUnit.HOURS.toMillis(this.storeConfig.getCommitLogRollingInterval()) && fileSegment.getAppendPosition() > (long)this.storeConfig.getCommitLogRollingMinimumSize()) {
                this.flatFile.rollingNewFile();
            }
        }
        catch (Exception e) {
            log.error("Rolling to next file failed", (Throwable)e);
        }
    }

    public void destroy() {
        this.flatFile.destroy();
    }
}

