/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.future.FutureTaskExt;
import org.apache.rocketmq.controller.BrokerHeartbeatManager;
import org.apache.rocketmq.controller.BrokerHousekeepingService;
import org.apache.rocketmq.controller.Controller;
import org.apache.rocketmq.controller.elect.impl.DefaultElectPolicy;
import org.apache.rocketmq.controller.impl.DLedgerController;
import org.apache.rocketmq.controller.impl.heartbeat.DefaultBrokerHeartbeatManager;
import org.apache.rocketmq.controller.processor.ControllerRequestProcessor;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.Configuration;
import org.apache.rocketmq.remoting.RemotingClient;
import org.apache.rocketmq.remoting.RemotingServer;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyRemotingClient;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.body.BrokerMemberGroup;
import org.apache.rocketmq.remoting.protocol.body.RoleChangeNotifyEntry;
import org.apache.rocketmq.remoting.protocol.body.SyncStateSet;
import org.apache.rocketmq.remoting.protocol.header.NotifyBrokerRoleChangedRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoResponseHeader;

public class ControllerManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqController");
    private final ControllerConfig controllerConfig;
    private final NettyServerConfig nettyServerConfig;
    private final NettyClientConfig nettyClientConfig;
    private final BrokerHousekeepingService brokerHousekeepingService;
    private final Configuration configuration;
    private final RemotingClient remotingClient;
    private Controller controller;
    private BrokerHeartbeatManager heartbeatManager;
    private ExecutorService controllerRequestExecutor;
    private BlockingQueue<Runnable> controllerRequestThreadPoolQueue;
    private NotifyService notifyService;

    public ControllerManager(ControllerConfig controllerConfig, NettyServerConfig nettyServerConfig, NettyClientConfig nettyClientConfig) {
        this.controllerConfig = controllerConfig;
        this.nettyServerConfig = nettyServerConfig;
        this.nettyClientConfig = nettyClientConfig;
        this.brokerHousekeepingService = new BrokerHousekeepingService(this);
        this.configuration = new Configuration(log, new Object[]{this.controllerConfig, this.nettyServerConfig});
        this.configuration.setStorePathFromConfig((Object)this.controllerConfig, "configStorePath");
        this.remotingClient = new NettyRemotingClient(nettyClientConfig);
        this.heartbeatManager = new DefaultBrokerHeartbeatManager(this.controllerConfig);
        this.notifyService = new NotifyService();
    }

    public boolean initialize() {
        this.controllerRequestThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.controllerConfig.getControllerRequestThreadPoolQueueCapacity());
        this.controllerRequestExecutor = new ThreadPoolExecutor(this.controllerConfig.getControllerThreadPoolNums(), this.controllerConfig.getControllerThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.controllerRequestThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("ControllerRequestExecutorThread_")){

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
                return new FutureTaskExt(runnable, value);
            }
        };
        this.notifyService.initialize();
        if (StringUtils.isEmpty((CharSequence)this.controllerConfig.getControllerDLegerPeers())) {
            throw new IllegalArgumentException("Attribute value controllerDLegerPeers of ControllerConfig is null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)this.controllerConfig.getControllerDLegerSelfId())) {
            throw new IllegalArgumentException("Attribute value controllerDLegerSelfId of ControllerConfig is null or empty");
        }
        this.controller = new DLedgerController(this.controllerConfig, this.heartbeatManager::isBrokerActive, this.nettyServerConfig, this.nettyClientConfig, this.brokerHousekeepingService, new DefaultElectPolicy(this.heartbeatManager::isBrokerActive, this.heartbeatManager::getBrokerLiveInfo));
        this.heartbeatManager.initialize();
        this.heartbeatManager.registerBrokerLifecycleListener(this::onBrokerInactive);
        this.controller.registerBrokerLifecycleListener(this::onBrokerInactive);
        this.registerProcessor();
        return true;
    }

    private void onBrokerInactive(String clusterName, String brokerName, Long brokerId) {
        if (this.controller.isLeaderState()) {
            if (brokerId == null) {
                this.triggerElectMaster(brokerName);
                return;
            }
            CompletableFuture<RemotingCommand> replicaInfoFuture = this.controller.getReplicaInfo(new GetReplicaInfoRequestHeader(brokerName));
            replicaInfoFuture.whenCompleteAsync((replicaInfoResponse, err) -> {
                if (err != null || replicaInfoResponse == null) {
                    log.error("Failed to get replica-info for broker-set: {} when OnBrokerInactive", (Object)brokerName, err);
                    return;
                }
                GetReplicaInfoResponseHeader replicaInfoResponseHeader = (GetReplicaInfoResponseHeader)replicaInfoResponse.readCustomHeader();
                if (!brokerId.equals(replicaInfoResponseHeader.getMasterBrokerId())) {
                    log.warn("The broker with brokerId: {} in broker-set: {} has been inactive", (Object)brokerId, (Object)brokerName);
                    return;
                }
                this.triggerElectMaster(brokerName);
            });
        } else {
            log.warn("The broker with brokerId: {} in broker-set: {} has been inactive", (Object)brokerId, (Object)brokerName);
        }
    }

    private void triggerElectMaster(String brokerName) {
        CompletableFuture<RemotingCommand> electMasterFuture = this.controller.electMaster(ElectMasterRequestHeader.ofControllerTrigger((String)brokerName));
        electMasterFuture.whenCompleteAsync((electMasterResponse, err) -> {
            if (err != null || electMasterResponse == null) {
                log.error("Failed to trigger elect-master in broker-set: {}", (Object)brokerName, err);
                return;
            }
            if (electMasterResponse.getCode() == 0) {
                log.info("Elect a new master in broker-set: {} done, result: {}", (Object)brokerName, electMasterResponse);
                if (this.controllerConfig.isNotifyBrokerRoleChanged()) {
                    this.notifyBrokerRoleChanged(RoleChangeNotifyEntry.convert((RemotingCommand)electMasterResponse));
                }
            }
        });
    }

    public void notifyBrokerRoleChanged(RoleChangeNotifyEntry entry) {
        BrokerMemberGroup memberGroup = entry.getBrokerMemberGroup();
        if (memberGroup != null) {
            Long masterBrokerId = entry.getMasterBrokerId();
            String clusterName = memberGroup.getCluster();
            String brokerName = memberGroup.getBrokerName();
            if (masterBrokerId == null) {
                log.warn("Notify broker role change failed, because member group is not null but the new master brokerId is empty, entry:{}", (Object)entry);
                return;
            }
            Map brokerAddrs = memberGroup.getBrokerAddrs();
            brokerAddrs.entrySet().stream().filter(x -> this.heartbeatManager.isBrokerActive(clusterName, brokerName, (Long)x.getKey())).forEach(x -> this.notifyService.notifyBroker((String)x.getValue(), entry));
        }
    }

    public void doNotifyBrokerRoleChanged(String brokerAddr, RoleChangeNotifyEntry entry) {
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{brokerAddr})) {
            log.info("Try notify broker {} that role changed, RoleChangeNotifyEntry:{}", (Object)brokerAddr, (Object)entry);
            NotifyBrokerRoleChangedRequestHeader requestHeader = new NotifyBrokerRoleChangedRequestHeader(entry.getMasterAddress(), entry.getMasterBrokerId(), Integer.valueOf(entry.getMasterEpoch()), Integer.valueOf(entry.getSyncStateSetEpoch()));
            RemotingCommand request = RemotingCommand.createRequestCommand((int)1008, (CommandCustomHeader)requestHeader);
            request.setBody(new SyncStateSet(entry.getSyncStateSet(), entry.getSyncStateSetEpoch()).encode());
            try {
                this.remotingClient.invokeOneway(brokerAddr, request, 3000L);
            }
            catch (Exception e) {
                log.error("Failed to notify broker {} that role changed", (Object)brokerAddr, (Object)e);
            }
        }
    }

    public void registerProcessor() {
        ControllerRequestProcessor controllerRequestProcessor = new ControllerRequestProcessor(this);
        RemotingServer controllerRemotingServer = this.controller.getRemotingServer();
        assert (controllerRemotingServer != null);
        controllerRemotingServer.registerProcessor(1001, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1002, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1003, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1004, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1005, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1006, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(904, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1009, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1010, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1011, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1012, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1013, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
    }

    public void start() {
        this.heartbeatManager.start();
        this.controller.startup();
        this.remotingClient.start();
    }

    public void shutdown() {
        this.heartbeatManager.shutdown();
        this.controllerRequestExecutor.shutdown();
        this.notifyService.shutdown();
        this.controller.shutdown();
        this.remotingClient.shutdown();
    }

    public BrokerHeartbeatManager getHeartbeatManager() {
        return this.heartbeatManager;
    }

    public ControllerConfig getControllerConfig() {
        return this.controllerConfig;
    }

    public Controller getController() {
        return this.controller;
    }

    public NettyServerConfig getNettyServerConfig() {
        return this.nettyServerConfig;
    }

    public NettyClientConfig getNettyClientConfig() {
        return this.nettyClientConfig;
    }

    public BrokerHousekeepingService getBrokerHousekeepingService() {
        return this.brokerHousekeepingService;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    class NotifyService {
        private ExecutorService executorService;
        private Map<String, NotifyTask> currentNotifyFutures;

        public void initialize() {
            this.executorService = Executors.newFixedThreadPool(3, (ThreadFactory)new ThreadFactoryImpl("ControllerManager_NotifyService_"));
            this.currentNotifyFutures = new ConcurrentHashMap<String, NotifyTask>();
        }

        public void notifyBroker(String brokerAddress, RoleChangeNotifyEntry entry) {
            Future oldFuture;
            int masterEpoch = entry.getMasterEpoch();
            NotifyTask oldTask = this.currentNotifyFutures.get(brokerAddress);
            if (oldTask != null && masterEpoch > oldTask.getMasterEpoch() && (oldFuture = oldTask.getFuture()) != null && !oldFuture.isDone()) {
                oldFuture.cancel(true);
            }
            NotifyTask task = new NotifyTask(masterEpoch, null);
            Runnable runnable = () -> {
                ControllerManager.this.doNotifyBrokerRoleChanged(brokerAddress, entry);
                this.currentNotifyFutures.remove(brokerAddress, (Object)task);
            };
            this.currentNotifyFutures.put(brokerAddress, task);
            Future<?> future = this.executorService.submit(runnable);
            task.setFuture(future);
        }

        public void shutdown() {
            if (!this.executorService.isShutdown()) {
                this.executorService.shutdownNow();
            }
        }

        class NotifyTask
        extends Pair<Integer, Future> {
            public NotifyTask(Integer masterEpoch, Future future) {
                super((Object)masterEpoch, (Object)future);
            }

            public Integer getMasterEpoch() {
                return (Integer)super.getObject1();
            }

            public Future getFuture() {
                return (Future)super.getObject2();
            }

            public void setFuture(Future future) {
                super.setObject2((Object)future);
            }

            public int hashCode() {
                return Objects.hashCode(super.getObject1());
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof NotifyTask)) {
                    return false;
                }
                NotifyTask task = (NotifyTask)((Object)obj);
                return ((Integer)super.getObject1()).equals(task.getObject1());
            }
        }
    }
}

