/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.common;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.ThreadFactoryImpl;

public class TieredStoreExecutor {
    private static final int QUEUE_CAPACITY = 10000;
    private static final BlockingQueue<Runnable> DISPATCH_THREAD_POOL_QUEUE = new LinkedBlockingQueue<Runnable>(10000);
    public static final ExecutorService DISPATCH_EXECUTOR = new ThreadPoolExecutor(Math.max(2, Runtime.getRuntime().availableProcessors()), Math.max(16, Runtime.getRuntime().availableProcessors() * 4), 60000L, TimeUnit.MILLISECONDS, DISPATCH_THREAD_POOL_QUEUE, (ThreadFactory)new ThreadFactoryImpl("TieredCommonExecutor_"));
    public static final ScheduledExecutorService COMMON_SCHEDULED_EXECUTOR = new ScheduledThreadPoolExecutor(Math.max(4, Runtime.getRuntime().availableProcessors()), (ThreadFactory)new ThreadFactoryImpl("TieredCommonScheduledExecutor_"));
    public static final ScheduledExecutorService COMMIT_EXECUTOR = new ScheduledThreadPoolExecutor(Math.max(16, Runtime.getRuntime().availableProcessors() * 4), (ThreadFactory)new ThreadFactoryImpl("TieredCommitExecutor_"));
    public static final ScheduledExecutorService CLEAN_EXPIRED_FILE_EXECUTOR = new ScheduledThreadPoolExecutor(Math.max(4, Runtime.getRuntime().availableProcessors()), (ThreadFactory)new ThreadFactoryImpl("TieredCleanExpiredFileExecutor_"));
    private static final BlockingQueue<Runnable> FETCH_DATA_THREAD_POOL_QUEUE = new LinkedBlockingQueue<Runnable>(10000);
    public static final ExecutorService FETCH_DATA_EXECUTOR = new ThreadPoolExecutor(Math.max(16, Runtime.getRuntime().availableProcessors() * 4), Math.max(64, Runtime.getRuntime().availableProcessors() * 8), 60000L, TimeUnit.MILLISECONDS, FETCH_DATA_THREAD_POOL_QUEUE, (ThreadFactory)new ThreadFactoryImpl("TieredFetchDataExecutor_"));
    private static final BlockingQueue<Runnable> COMPACT_INDEX_FILE_THREAD_POOL_QUEUE = new LinkedBlockingQueue<Runnable>(10000);
    public static final ExecutorService COMPACT_INDEX_FILE_EXECUTOR = new ThreadPoolExecutor(1, 1, 60000L, TimeUnit.MILLISECONDS, COMPACT_INDEX_FILE_THREAD_POOL_QUEUE, (ThreadFactory)new ThreadFactoryImpl("TieredCompactIndexFileExecutor_"));

    public static void shutdown() {
        DISPATCH_EXECUTOR.shutdown();
        COMMON_SCHEDULED_EXECUTOR.shutdown();
        COMMIT_EXECUTOR.shutdown();
        CLEAN_EXPIRED_FILE_EXECUTOR.shutdown();
        FETCH_DATA_EXECUTOR.shutdown();
        COMPACT_INDEX_FILE_EXECUTOR.shutdown();
    }
}

