/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl.event;

import org.apache.commons.lang3.SerializationException;
import org.apache.rocketmq.common.utils.FastJsonSerializer;
import org.apache.rocketmq.controller.impl.event.AlterSyncStateSetEvent;
import org.apache.rocketmq.controller.impl.event.ApplyBrokerIdEvent;
import org.apache.rocketmq.controller.impl.event.CleanBrokerDataEvent;
import org.apache.rocketmq.controller.impl.event.ElectMasterEvent;
import org.apache.rocketmq.controller.impl.event.EventMessage;
import org.apache.rocketmq.controller.impl.event.EventType;

public class EventSerializer {
    private final FastJsonSerializer serializer = new FastJsonSerializer();

    private void putShort(byte[] memory, int index, int value) {
        memory[index] = (byte)(value >>> 8);
        memory[index + 1] = (byte)value;
    }

    private short getShort(byte[] memory, int index) {
        return (short)(memory[index] << 8 | memory[index + 1] & 0xFF);
    }

    public byte[] serialize(EventMessage message) throws SerializationException {
        short eventType = message.getEventType().getId();
        byte[] data = this.serializer.serialize((Object)message);
        if (data != null && data.length > 0) {
            byte[] result = new byte[2 + data.length];
            this.putShort(result, 0, eventType);
            System.arraycopy(data, 0, result, 2, data.length);
            return result;
        }
        return null;
    }

    public EventMessage deserialize(byte[] bytes) throws SerializationException {
        if (bytes.length < 2) {
            return null;
        }
        short eventId = this.getShort(bytes, 0);
        if (eventId > 0) {
            byte[] data = new byte[bytes.length - 2];
            System.arraycopy(bytes, 2, data, 0, data.length);
            EventType eventType = EventType.from(eventId);
            if (eventType != null) {
                switch (eventType) {
                    case ALTER_SYNC_STATE_SET_EVENT: {
                        return (EventMessage)this.serializer.deserialize(data, AlterSyncStateSetEvent.class);
                    }
                    case APPLY_BROKER_ID_EVENT: {
                        return (EventMessage)this.serializer.deserialize(data, ApplyBrokerIdEvent.class);
                    }
                    case ELECT_MASTER_EVENT: {
                        return (EventMessage)this.serializer.deserialize(data, ElectMasterEvent.class);
                    }
                    case CLEAN_BROKER_DATA_EVENT: {
                        return (EventMessage)this.serializer.deserialize(data, CleanBrokerDataEvent.class);
                    }
                }
            }
        }
        return null;
    }
}

