/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.longpolling.NotificationRequest;
import org.apache.rocketmq.common.AbstractBrokerRunnable;
import org.apache.rocketmq.common.BrokerIdentity;
import org.apache.rocketmq.common.KeyBuilder;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.protocol.header.NotificationRequestHeader;
import org.apache.rocketmq.common.protocol.header.NotificationResponseHeader;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.RequestTask;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class NotificationProcessor
implements NettyRequestProcessor {
    private static final InternalLogger POP_LOGGER = InternalLoggerFactory.getLogger((String)"RocketmqPop");
    private final BrokerController brokerController;
    private Random random = new Random(System.currentTimeMillis());
    private static final String BORN_TIME = "bornTime";
    private ConcurrentLinkedHashMap<String, ArrayBlockingQueue<NotificationRequest>> pollingMap = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(100000L).build();
    private Thread checkNotificationPollingThread;

    public NotificationProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.checkNotificationPollingThread = new Thread((Runnable)new AbstractBrokerRunnable((BrokerIdentity)brokerController.getBrokerConfig()){

            public void run2() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Thread.sleep(2000L);
                        Collection pops = NotificationProcessor.this.pollingMap.values();
                        block4: for (ArrayBlockingQueue popQ : pops) {
                            NotificationRequest tmPopRequest = (NotificationRequest)popQ.peek();
                            while (tmPopRequest != null && tmPopRequest.isTimeout() && (tmPopRequest = (NotificationRequest)popQ.poll()) != null) {
                                if (!tmPopRequest.isTimeout()) {
                                    POP_LOGGER.info("not timeout , but wakeUp Notification in advance: {}", (Object)tmPopRequest);
                                    NotificationProcessor.this.wakeUp(tmPopRequest, false);
                                    continue block4;
                                }
                                POP_LOGGER.info("timeout , wakeUp Notification : {}", (Object)tmPopRequest);
                                NotificationProcessor.this.wakeUp(tmPopRequest, false);
                                tmPopRequest = (NotificationRequest)popQ.peek();
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    catch (Exception e) {
                        POP_LOGGER.error("checkNotificationPolling error", (Throwable)e);
                    }
                }
            }
        });
        this.checkNotificationPollingThread.setDaemon(true);
        this.checkNotificationPollingThread.setName("checkNotificationPolling");
        this.checkNotificationPollingThread.start();
    }

    public void shutdown() {
        this.checkNotificationPollingThread.interrupt();
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        request.addExtField(BORN_TIME, String.valueOf(System.currentTimeMillis()));
        return this.processRequest(ctx.channel(), request);
    }

    public boolean rejectRequest() {
        return false;
    }

    public void notifyMessageArriving(String topic, int queueId) {
        ArrayList c;
        ArrayBlockingQueue remotingCommands = (ArrayBlockingQueue)this.pollingMap.get((Object)KeyBuilder.buildPollingNotificationKey((String)topic, (int)-1));
        if (remotingCommands != null) {
            c = new ArrayList();
            remotingCommands.drainTo(c);
            for (NotificationRequest notificationRequest : c) {
                POP_LOGGER.info("new msg arrive , wakeUp : {}", (Object)notificationRequest);
                this.wakeUp(notificationRequest, true);
            }
        }
        if ((remotingCommands = (ArrayBlockingQueue)this.pollingMap.get((Object)KeyBuilder.buildPollingNotificationKey((String)topic, (int)queueId))) != null) {
            c = new ArrayList();
            remotingCommands.drainTo(c);
            for (NotificationRequest notificationRequest : c) {
                POP_LOGGER.info("new msg arrive , wakeUp : {}", (Object)notificationRequest);
                this.wakeUp(notificationRequest, true);
            }
        }
    }

    private void wakeUp(final NotificationRequest request, final boolean hasMsg) {
        if (request == null || !request.complete()) {
            return;
        }
        if (!request.getChannel().isActive()) {
            return;
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                final RemotingCommand response = NotificationProcessor.this.responseNotification(request.getChannel(), hasMsg);
                if (response != null) {
                    response.setOpaque(request.getRemotingCommand().getOpaque());
                    response.markResponseType();
                    try {
                        request.getChannel().writeAndFlush((Object)response).addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (!future.isSuccess()) {
                                    POP_LOGGER.error("ProcessRequestWrapper response to {} failed", (Object)future.channel().remoteAddress(), (Object)future.cause());
                                    POP_LOGGER.error(request.toString());
                                    POP_LOGGER.error(response.toString());
                                }
                            }
                        });
                    }
                    catch (Throwable e) {
                        POP_LOGGER.error("ProcessRequestWrapper process request over, but response failed", e);
                        POP_LOGGER.error(request.toString());
                        POP_LOGGER.error(response.toString());
                    }
                }
            }
        };
        this.brokerController.getPullMessageExecutor().submit((Runnable)new RequestTask(run, request.getChannel(), request.getRemotingCommand()));
    }

    public RemotingCommand responseNotification(Channel channel, boolean hasMsg) {
        RemotingCommand response = RemotingCommand.createResponseCommand(NotificationResponseHeader.class);
        NotificationResponseHeader responseHeader = (NotificationResponseHeader)response.readCustomHeader();
        responseHeader.setHasMsg(hasMsg);
        response.setCode(0);
        return response;
    }

    private RemotingCommand processRequest(Channel channel, RemotingCommand request) throws RemotingCommandException {
        TopicConfig retryTopicConfig;
        boolean needRetry;
        RemotingCommand response = RemotingCommand.createResponseCommand(NotificationResponseHeader.class);
        NotificationResponseHeader responseHeader = (NotificationResponseHeader)response.readCustomHeader();
        NotificationRequestHeader requestHeader = (NotificationRequestHeader)request.decodeCommandCustomHeader(NotificationRequestHeader.class);
        response.setOpaque(request.getOpaque());
        if (!PermName.isReadable((int)this.brokerController.getBrokerConfig().getBrokerPermission())) {
            response.setCode(16);
            response.setRemark(String.format("the broker[%s] peeking message is forbidden", this.brokerController.getBrokerConfig().getBrokerIP1()));
            return response;
        }
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
        if (null == topicConfig) {
            POP_LOGGER.error("The topic {} not exist, consumer: {} ", (Object)requestHeader.getTopic(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
            response.setCode(17);
            response.setRemark(String.format("topic[%s] not exist, apply first please! %s", requestHeader.getTopic(), FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/")));
            return response;
        }
        if (!PermName.isReadable((int)topicConfig.getPerm())) {
            response.setCode(16);
            response.setRemark("the topic[" + requestHeader.getTopic() + "] peeking message is forbidden");
            return response;
        }
        if (requestHeader.getQueueId() >= topicConfig.getReadQueueNums()) {
            String errorInfo = String.format("queueId[%d] is illegal, topic:[%s] topicConfig.readQueueNums:[%d] consumer:[%s]", requestHeader.getQueueId(), requestHeader.getTopic(), topicConfig.getReadQueueNums(), channel.remoteAddress());
            POP_LOGGER.warn(errorInfo);
            response.setCode(1);
            response.setRemark(errorInfo);
            return response;
        }
        SubscriptionGroupConfig subscriptionGroupConfig = this.brokerController.getSubscriptionGroupManager().findSubscriptionGroupConfig(requestHeader.getConsumerGroup());
        if (null == subscriptionGroupConfig) {
            response.setCode(26);
            response.setRemark(String.format("subscription group [%s] does not exist, %s", requestHeader.getConsumerGroup(), FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/")));
            return response;
        }
        if (!subscriptionGroupConfig.isConsumeEnable()) {
            response.setCode(16);
            response.setRemark("subscription group no permission, " + requestHeader.getConsumerGroup());
            return response;
        }
        int randomQ = this.random.nextInt(100);
        boolean hasMsg = false;
        boolean bl = needRetry = randomQ % 5 == 0;
        if (needRetry && (retryTopicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(KeyBuilder.buildPopRetryTopic((String)requestHeader.getTopic(), (String)requestHeader.getConsumerGroup()))) != null) {
            for (int i = 0; i < retryTopicConfig.getReadQueueNums(); ++i) {
                int queueId = (randomQ + i) % retryTopicConfig.getReadQueueNums();
                hasMsg = this.hasMsgFromQueue(true, requestHeader, queueId);
            }
        }
        if (!hasMsg && requestHeader.getQueueId() < 0) {
            int queueId;
            for (int i = 0; i < topicConfig.getReadQueueNums() && !(hasMsg = this.hasMsgFromQueue(false, requestHeader, queueId = (randomQ + i) % topicConfig.getReadQueueNums())); ++i) {
            }
        } else {
            int queueId = requestHeader.getQueueId();
            hasMsg = this.hasMsgFromQueue(false, requestHeader, queueId);
        }
        if (!hasMsg && this.polling(channel, request, requestHeader)) {
            return null;
        }
        response.setCode(0);
        responseHeader.setHasMsg(hasMsg);
        return response;
    }

    private boolean hasMsgFromQueue(boolean isRetry, NotificationRequestHeader requestHeader, int queueId) {
        String topic = isRetry ? KeyBuilder.buildPopRetryTopic((String)requestHeader.getTopic(), (String)requestHeader.getConsumerGroup()) : requestHeader.getTopic();
        long offset = this.getPopOffset(topic, requestHeader.getConsumerGroup(), queueId);
        long restNum = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId) - offset;
        return restNum > 0L;
    }

    private long getPopOffset(String topic, String cid, int queueId) {
        long bufferOffset;
        long offset = this.brokerController.getConsumerOffsetManager().queryOffset(cid, topic, queueId);
        if (offset < 0L) {
            offset = this.brokerController.getMessageStore().getMinOffsetInQueue(topic, queueId);
        }
        if ((bufferOffset = this.brokerController.getPopMessageProcessor().getPopBufferMergeService().getLatestOffset(topic, cid, queueId)) < 0L) {
            return offset;
        }
        return bufferOffset > offset ? bufferOffset : offset;
    }

    private boolean polling(Channel channel, RemotingCommand remotingCommand, NotificationRequestHeader requestHeader) {
        if (requestHeader.getPollTime() <= 0L) {
            return false;
        }
        long expired = requestHeader.getBornTime() + requestHeader.getPollTime();
        NotificationRequest request = new NotificationRequest(remotingCommand, channel, expired);
        boolean result = false;
        if (!request.isTimeout()) {
            String key = KeyBuilder.buildPollingNotificationKey((String)requestHeader.getTopic(), (int)requestHeader.getQueueId());
            ArrayBlockingQueue<NotificationRequest> queue = (ArrayBlockingQueue<NotificationRequest>)this.pollingMap.get((Object)key);
            if (queue == null) {
                queue = new ArrayBlockingQueue<NotificationRequest>(this.brokerController.getBrokerConfig().getPopPollingSize());
                this.pollingMap.put((Object)key, queue);
                result = queue.offer(request);
            } else {
                result = queue.offer(request);
            }
        }
        POP_LOGGER.info("polling {}, result {}", (Object)remotingCommand, (Object)result);
        return result;
    }
}

