/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker;

import io.openmessaging.storage.dledger.DLedgerLeaderElector;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.AccessValidator;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.broker.BrokerPreOnlineService;
import org.apache.rocketmq.broker.ShutdownHook;
import org.apache.rocketmq.broker.client.ClientHousekeepingService;
import org.apache.rocketmq.broker.client.ConsumerIdsChangeListener;
import org.apache.rocketmq.broker.client.ConsumerManager;
import org.apache.rocketmq.broker.client.DefaultConsumerIdsChangeListener;
import org.apache.rocketmq.broker.client.ProducerManager;
import org.apache.rocketmq.broker.client.net.Broker2Client;
import org.apache.rocketmq.broker.client.rebalance.RebalanceLockManager;
import org.apache.rocketmq.broker.controller.ReplicasManager;
import org.apache.rocketmq.broker.dledger.DLedgerRoleChangeHandler;
import org.apache.rocketmq.broker.failover.EscapeBridge;
import org.apache.rocketmq.broker.filter.CommitLogDispatcherCalcBitMap;
import org.apache.rocketmq.broker.filter.ConsumerFilterManager;
import org.apache.rocketmq.broker.filtersrv.FilterServerManager;
import org.apache.rocketmq.broker.latency.BrokerFastFailure;
import org.apache.rocketmq.broker.latency.BrokerFixedThreadPoolExecutor;
import org.apache.rocketmq.broker.longpolling.LmqPullRequestHoldService;
import org.apache.rocketmq.broker.longpolling.NotifyMessageArrivingListener;
import org.apache.rocketmq.broker.longpolling.PullRequestHoldService;
import org.apache.rocketmq.broker.mqtrace.ConsumeMessageHook;
import org.apache.rocketmq.broker.mqtrace.SendMessageHook;
import org.apache.rocketmq.broker.offset.ConsumerOffsetManager;
import org.apache.rocketmq.broker.offset.ConsumerOrderInfoManager;
import org.apache.rocketmq.broker.offset.LmqConsumerOffsetManager;
import org.apache.rocketmq.broker.out.BrokerOuterAPI;
import org.apache.rocketmq.broker.plugin.BrokerAttachedPlugin;
import org.apache.rocketmq.broker.plugin.MessageStoreFactory;
import org.apache.rocketmq.broker.plugin.MessageStorePluginContext;
import org.apache.rocketmq.broker.processor.AckMessageProcessor;
import org.apache.rocketmq.broker.processor.AdminBrokerProcessor;
import org.apache.rocketmq.broker.processor.ChangeInvisibleTimeProcessor;
import org.apache.rocketmq.broker.processor.ClientManageProcessor;
import org.apache.rocketmq.broker.processor.ConsumerManageProcessor;
import org.apache.rocketmq.broker.processor.EndTransactionProcessor;
import org.apache.rocketmq.broker.processor.NotificationProcessor;
import org.apache.rocketmq.broker.processor.PeekMessageProcessor;
import org.apache.rocketmq.broker.processor.PollingInfoProcessor;
import org.apache.rocketmq.broker.processor.PopMessageProcessor;
import org.apache.rocketmq.broker.processor.PullMessageProcessor;
import org.apache.rocketmq.broker.processor.QueryAssignmentProcessor;
import org.apache.rocketmq.broker.processor.QueryMessageProcessor;
import org.apache.rocketmq.broker.processor.ReplyMessageProcessor;
import org.apache.rocketmq.broker.processor.SendMessageProcessor;
import org.apache.rocketmq.broker.schedule.ScheduleMessageService;
import org.apache.rocketmq.broker.slave.SlaveSynchronize;
import org.apache.rocketmq.broker.subscription.LmqSubscriptionGroupManager;
import org.apache.rocketmq.broker.subscription.SubscriptionGroupManager;
import org.apache.rocketmq.broker.topic.LmqTopicConfigManager;
import org.apache.rocketmq.broker.topic.TopicConfigManager;
import org.apache.rocketmq.broker.topic.TopicQueueMappingCleanService;
import org.apache.rocketmq.broker.topic.TopicQueueMappingManager;
import org.apache.rocketmq.broker.topic.TopicRouteInfoManager;
import org.apache.rocketmq.broker.transaction.AbstractTransactionalMessageCheckListener;
import org.apache.rocketmq.broker.transaction.TransactionalMessageCheckService;
import org.apache.rocketmq.broker.transaction.TransactionalMessageService;
import org.apache.rocketmq.broker.transaction.queue.DefaultTransactionalMessageCheckListener;
import org.apache.rocketmq.broker.transaction.queue.TransactionalMessageBridge;
import org.apache.rocketmq.broker.transaction.queue.TransactionalMessageServiceImpl;
import org.apache.rocketmq.broker.util.HookUtils;
import org.apache.rocketmq.common.AbstractBrokerRunnable;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.BrokerIdentity;
import org.apache.rocketmq.common.BrokerSyncInfo;
import org.apache.rocketmq.common.Configuration;
import org.apache.rocketmq.common.DataVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.namesrv.RegisterBrokerResult;
import org.apache.rocketmq.common.protocol.NamespaceUtil;
import org.apache.rocketmq.common.protocol.body.BrokerMemberGroup;
import org.apache.rocketmq.common.protocol.body.TopicConfigAndMappingSerializeWrapper;
import org.apache.rocketmq.common.protocol.body.TopicConfigSerializeWrapper;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingDetail;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingInfo;
import org.apache.rocketmq.common.stats.MomentStatsItem;
import org.apache.rocketmq.common.utils.ServiceProvider;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.ChannelEventListener;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.RemotingServer;
import org.apache.rocketmq.remoting.common.TlsMode;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyRemotingServer;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.netty.RequestTask;
import org.apache.rocketmq.remoting.netty.TlsSystemConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.srvutil.FileWatchService;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.MessageArrivingListener;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.dledger.DLedgerCommitLog;
import org.apache.rocketmq.store.hook.PutMessageHook;
import org.apache.rocketmq.store.hook.SendMessageBackHook;
import org.apache.rocketmq.store.stats.BrokerStats;
import org.apache.rocketmq.store.stats.BrokerStatsManager;
import org.apache.rocketmq.store.stats.LmqBrokerStatsManager;
import org.apache.rocketmq.store.timer.TimerCheckpoint;
import org.apache.rocketmq.store.timer.TimerMessageStore;
import org.apache.rocketmq.store.timer.TimerMetrics;

public class BrokerController {
    protected static final InternalLogger LOG = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private static final InternalLogger LOG_PROTECTION = InternalLoggerFactory.getLogger((String)"RocketmqProtection");
    private static final InternalLogger LOG_WATER_MARK = InternalLoggerFactory.getLogger((String)"RocketmqWaterMark");
    protected static final int HA_ADDRESS_MIN_LENGTH = 6;
    protected final BrokerConfig brokerConfig;
    private final NettyServerConfig nettyServerConfig;
    private final NettyClientConfig nettyClientConfig;
    protected final MessageStoreConfig messageStoreConfig;
    protected final ConsumerOffsetManager consumerOffsetManager;
    protected final ConsumerManager consumerManager;
    protected final ConsumerFilterManager consumerFilterManager;
    protected final ConsumerOrderInfoManager consumerOrderInfoManager;
    protected final ProducerManager producerManager;
    protected final ScheduleMessageService scheduleMessageService;
    protected final ClientHousekeepingService clientHousekeepingService;
    protected final PullMessageProcessor pullMessageProcessor;
    protected final PeekMessageProcessor peekMessageProcessor;
    protected final PopMessageProcessor popMessageProcessor;
    protected final AckMessageProcessor ackMessageProcessor;
    protected final ChangeInvisibleTimeProcessor changeInvisibleTimeProcessor;
    protected final NotificationProcessor notificationProcessor;
    protected final PollingInfoProcessor pollingInfoProcessor;
    protected final QueryAssignmentProcessor queryAssignmentProcessor;
    protected final ClientManageProcessor clientManageProcessor;
    protected final SendMessageProcessor sendMessageProcessor;
    protected final ReplyMessageProcessor replyMessageProcessor;
    protected final PullRequestHoldService pullRequestHoldService;
    protected final MessageArrivingListener messageArrivingListener;
    protected final Broker2Client broker2Client;
    protected final SubscriptionGroupManager subscriptionGroupManager;
    protected final ConsumerIdsChangeListener consumerIdsChangeListener;
    protected final EndTransactionProcessor endTransactionProcessor;
    private final RebalanceLockManager rebalanceLockManager = new RebalanceLockManager();
    private final TopicRouteInfoManager topicRouteInfoManager;
    protected BrokerOuterAPI brokerOuterAPI;
    protected ScheduledExecutorService scheduledExecutorService;
    protected ScheduledExecutorService syncBrokerMemberGroupExecutorService;
    protected ScheduledExecutorService brokerHeartbeatExecutorService;
    protected final SlaveSynchronize slaveSynchronize;
    protected final BlockingQueue<Runnable> sendThreadPoolQueue;
    protected final BlockingQueue<Runnable> putThreadPoolQueue;
    protected final BlockingQueue<Runnable> ackThreadPoolQueue;
    protected final BlockingQueue<Runnable> pullThreadPoolQueue;
    protected final BlockingQueue<Runnable> litePullThreadPoolQueue;
    protected final BlockingQueue<Runnable> replyThreadPoolQueue;
    protected final BlockingQueue<Runnable> queryThreadPoolQueue;
    protected final BlockingQueue<Runnable> clientManagerThreadPoolQueue;
    protected final BlockingQueue<Runnable> heartbeatThreadPoolQueue;
    protected final BlockingQueue<Runnable> consumerManagerThreadPoolQueue;
    protected final BlockingQueue<Runnable> endTransactionThreadPoolQueue;
    protected final BlockingQueue<Runnable> adminBrokerThreadPoolQueue;
    protected final BlockingQueue<Runnable> loadBalanceThreadPoolQueue;
    protected final FilterServerManager filterServerManager;
    protected final BrokerStatsManager brokerStatsManager;
    protected final List<SendMessageHook> sendMessageHookList = new ArrayList<SendMessageHook>();
    protected final List<ConsumeMessageHook> consumeMessageHookList = new ArrayList<ConsumeMessageHook>();
    protected MessageStore messageStore;
    protected RemotingServer remotingServer;
    protected CountDownLatch remotingServerStartLatch;
    protected RemotingServer fastRemotingServer;
    protected TopicConfigManager topicConfigManager;
    protected TopicQueueMappingManager topicQueueMappingManager;
    protected ExecutorService sendMessageExecutor;
    protected ExecutorService pullMessageExecutor;
    protected ExecutorService litePullMessageExecutor;
    protected ExecutorService putMessageFutureExecutor;
    protected ExecutorService ackMessageExecutor;
    protected ExecutorService replyMessageExecutor;
    protected ExecutorService queryMessageExecutor;
    protected ExecutorService adminBrokerExecutor;
    protected ExecutorService clientManageExecutor;
    protected ExecutorService heartbeatExecutor;
    protected ExecutorService consumerManageExecutor;
    protected ExecutorService loadBalanceExecutor;
    protected ExecutorService endTransactionExecutor;
    protected boolean updateMasterHAServerAddrPeriodically = false;
    private BrokerStats brokerStats;
    private InetSocketAddress storeHost;
    private TimerMessageStore timerMessageStore;
    private TimerCheckpoint timerCheckpoint;
    protected BrokerFastFailure brokerFastFailure;
    private Configuration configuration;
    protected TopicQueueMappingCleanService topicQueueMappingCleanService;
    protected FileWatchService fileWatchService;
    protected TransactionalMessageCheckService transactionalMessageCheckService;
    protected TransactionalMessageService transactionalMessageService;
    protected AbstractTransactionalMessageCheckListener transactionalMessageCheckListener;
    protected Map<Class, AccessValidator> accessValidatorMap = new HashMap<Class, AccessValidator>();
    protected volatile boolean shutdown = false;
    protected ShutdownHook shutdownHook;
    private volatile boolean isScheduleServiceStart = false;
    private volatile boolean isTransactionCheckServiceStart = false;
    protected volatile BrokerMemberGroup brokerMemberGroup;
    protected EscapeBridge escapeBridge;
    protected List<BrokerAttachedPlugin> brokerAttachedPlugins = new ArrayList<BrokerAttachedPlugin>();
    protected volatile long shouldStartTime;
    private BrokerPreOnlineService brokerPreOnlineService;
    protected volatile boolean isIsolated = false;
    protected volatile long minBrokerIdInGroup = 0L;
    protected volatile String minBrokerAddrInGroup = null;
    private final Lock lock = new ReentrantLock();
    protected final List<ScheduledFuture<?>> scheduledFutures = new ArrayList();
    protected ReplicasManager replicasManager;
    private long lastSyncTimeMs = System.currentTimeMillis();

    public BrokerController(BrokerConfig brokerConfig, NettyServerConfig nettyServerConfig, NettyClientConfig nettyClientConfig, MessageStoreConfig messageStoreConfig, ShutdownHook shutdownHook) {
        this(brokerConfig, nettyServerConfig, nettyClientConfig, messageStoreConfig);
        this.shutdownHook = shutdownHook;
    }

    public BrokerController(BrokerConfig brokerConfig, MessageStoreConfig messageStoreConfig) {
        this(brokerConfig, null, null, messageStoreConfig);
    }

    public BrokerController(BrokerConfig brokerConfig, NettyServerConfig nettyServerConfig, NettyClientConfig nettyClientConfig, MessageStoreConfig messageStoreConfig) {
        this.brokerConfig = brokerConfig;
        this.nettyServerConfig = nettyServerConfig;
        this.nettyClientConfig = nettyClientConfig;
        this.messageStoreConfig = messageStoreConfig;
        this.setStoreHost(new InetSocketAddress(this.getBrokerConfig().getBrokerIP1(), this.getListenPort()));
        this.brokerStatsManager = messageStoreConfig.isEnableLmq() ? new LmqBrokerStatsManager(this.brokerConfig.getBrokerClusterName(), this.brokerConfig.isEnableDetailStat()) : new BrokerStatsManager(this.brokerConfig.getBrokerClusterName(), this.brokerConfig.isEnableDetailStat());
        this.consumerOffsetManager = messageStoreConfig.isEnableLmq() ? new LmqConsumerOffsetManager(this) : new ConsumerOffsetManager(this);
        this.topicConfigManager = messageStoreConfig.isEnableLmq() ? new LmqTopicConfigManager(this) : new TopicConfigManager(this);
        this.topicQueueMappingManager = new TopicQueueMappingManager(this);
        this.pullMessageProcessor = new PullMessageProcessor(this);
        this.peekMessageProcessor = new PeekMessageProcessor(this);
        this.pullRequestHoldService = messageStoreConfig.isEnableLmq() ? new LmqPullRequestHoldService(this) : new PullRequestHoldService(this);
        this.popMessageProcessor = new PopMessageProcessor(this);
        this.notificationProcessor = new NotificationProcessor(this);
        this.pollingInfoProcessor = new PollingInfoProcessor(this);
        this.ackMessageProcessor = new AckMessageProcessor(this);
        this.changeInvisibleTimeProcessor = new ChangeInvisibleTimeProcessor(this);
        this.sendMessageProcessor = new SendMessageProcessor(this);
        this.replyMessageProcessor = new ReplyMessageProcessor(this);
        this.messageArrivingListener = new NotifyMessageArrivingListener(this.pullRequestHoldService, this.popMessageProcessor, this.notificationProcessor);
        this.consumerIdsChangeListener = new DefaultConsumerIdsChangeListener(this);
        this.consumerManager = new ConsumerManager(this.consumerIdsChangeListener, this.brokerStatsManager);
        this.producerManager = new ProducerManager(this.brokerStatsManager);
        this.consumerFilterManager = new ConsumerFilterManager(this);
        this.consumerOrderInfoManager = new ConsumerOrderInfoManager(this);
        this.clientHousekeepingService = new ClientHousekeepingService(this);
        this.broker2Client = new Broker2Client(this);
        this.subscriptionGroupManager = messageStoreConfig.isEnableLmq() ? new LmqSubscriptionGroupManager(this) : new SubscriptionGroupManager(this);
        this.scheduleMessageService = new ScheduleMessageService(this);
        if (nettyClientConfig != null) {
            this.brokerOuterAPI = new BrokerOuterAPI(nettyClientConfig);
        }
        this.filterServerManager = new FilterServerManager(this);
        this.queryAssignmentProcessor = new QueryAssignmentProcessor(this);
        this.clientManageProcessor = new ClientManageProcessor(this);
        this.slaveSynchronize = new SlaveSynchronize(this);
        this.endTransactionProcessor = new EndTransactionProcessor(this);
        this.sendThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getSendThreadPoolQueueCapacity());
        this.putThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getPutThreadPoolQueueCapacity());
        this.pullThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getPullThreadPoolQueueCapacity());
        this.litePullThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getLitePullThreadPoolQueueCapacity());
        this.ackThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getAckThreadPoolQueueCapacity());
        this.replyThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getReplyThreadPoolQueueCapacity());
        this.queryThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getQueryThreadPoolQueueCapacity());
        this.clientManagerThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getClientManagerThreadPoolQueueCapacity());
        this.consumerManagerThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getConsumerManagerThreadPoolQueueCapacity());
        this.heartbeatThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getHeartbeatThreadPoolQueueCapacity());
        this.endTransactionThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getEndTransactionPoolQueueCapacity());
        this.adminBrokerThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getAdminBrokerThreadPoolQueueCapacity());
        this.loadBalanceThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getLoadBalanceThreadPoolQueueCapacity());
        this.brokerFastFailure = new BrokerFastFailure(this);
        String brokerConfigPath = brokerConfig.getBrokerConfigPath() != null && !brokerConfig.getBrokerConfigPath().isEmpty() ? brokerConfig.getBrokerConfigPath() : FilenameUtils.concat((String)FilenameUtils.getFullPathNoEndSeparator((String)BrokerPathConfigHelper.getBrokerConfigPath()), (String)(this.brokerConfig.getCanonicalName() + ".properties"));
        this.configuration = new Configuration(LOG, brokerConfigPath, new Object[]{this.brokerConfig, this.nettyServerConfig, this.nettyClientConfig, this.messageStoreConfig});
        this.brokerStatsManager.setProduerStateGetter(new BrokerStatsManager.StateGetter(){

            public boolean online(String instanceId, String group, String topic) {
                if (BrokerController.this.getTopicConfigManager().getTopicConfigTable().containsKey(NamespaceUtil.wrapNamespace((String)instanceId, (String)topic))) {
                    return BrokerController.this.getProducerManager().groupOnline(NamespaceUtil.wrapNamespace((String)instanceId, (String)group));
                }
                return BrokerController.this.getProducerManager().groupOnline(group);
            }
        });
        this.brokerStatsManager.setConsumerStateGetter(new BrokerStatsManager.StateGetter(){

            public boolean online(String instanceId, String group, String topic) {
                String topicFullName = NamespaceUtil.wrapNamespace((String)instanceId, (String)topic);
                if (BrokerController.this.getTopicConfigManager().getTopicConfigTable().containsKey(topicFullName)) {
                    return BrokerController.this.getConsumerManager().findSubscriptionData(NamespaceUtil.wrapNamespace((String)instanceId, (String)group), topicFullName) != null;
                }
                return BrokerController.this.getConsumerManager().findSubscriptionData(group, topic) != null;
            }
        });
        this.brokerMemberGroup = new BrokerMemberGroup(this.brokerConfig.getBrokerClusterName(), this.brokerConfig.getBrokerName());
        this.brokerMemberGroup.getBrokerAddrs().put(this.brokerConfig.getBrokerId(), this.getBrokerAddr());
        this.escapeBridge = new EscapeBridge(this);
        this.topicRouteInfoManager = new TopicRouteInfoManager(this);
        if (this.brokerConfig.isEnableSlaveActingMaster() && !this.brokerConfig.isSkipPreOnline()) {
            this.brokerPreOnlineService = new BrokerPreOnlineService(this);
        }
    }

    public BrokerConfig getBrokerConfig() {
        return this.brokerConfig;
    }

    public NettyServerConfig getNettyServerConfig() {
        return this.nettyServerConfig;
    }

    public NettyClientConfig getNettyClientConfig() {
        return this.nettyClientConfig;
    }

    public BlockingQueue<Runnable> getPullThreadPoolQueue() {
        return this.pullThreadPoolQueue;
    }

    public BlockingQueue<Runnable> getQueryThreadPoolQueue() {
        return this.queryThreadPoolQueue;
    }

    protected void initializeRemotingServer() throws CloneNotSupportedException {
        this.remotingServer = new NettyRemotingServer(this.nettyServerConfig, (ChannelEventListener)this.clientHousekeepingService);
        NettyServerConfig fastConfig = (NettyServerConfig)this.nettyServerConfig.clone();
        int listeningPort = this.nettyServerConfig.getListenPort() - 2;
        if (listeningPort < 0) {
            listeningPort = 0;
        }
        fastConfig.setListenPort(listeningPort);
        this.fastRemotingServer = new NettyRemotingServer(fastConfig, (ChannelEventListener)this.clientHousekeepingService);
    }

    protected void initializeResources() {
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ThreadFactoryImpl("BrokerControllerScheduledThread", true, this.getBrokerIdentity()));
        this.sendMessageExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getSendMessageThreadPoolNums(), this.brokerConfig.getSendMessageThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.sendThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("SendMessageThread_", this.getBrokerIdentity()));
        this.pullMessageExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getPullMessageThreadPoolNums(), this.brokerConfig.getPullMessageThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.pullThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("PullMessageThread_", this.getBrokerIdentity()));
        this.litePullMessageExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getLitePullMessageThreadPoolNums(), this.brokerConfig.getLitePullMessageThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.litePullThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("LitePullMessageThread_", this.getBrokerIdentity()));
        this.putMessageFutureExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getPutMessageFutureThreadPoolNums(), this.brokerConfig.getPutMessageFutureThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.putThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("SendMessageThread_", this.getBrokerIdentity()));
        this.ackMessageExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getAckMessageThreadPoolNums(), this.brokerConfig.getAckMessageThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.ackThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("AckMessageThread_", this.getBrokerIdentity()));
        this.queryMessageExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getQueryMessageThreadPoolNums(), this.brokerConfig.getQueryMessageThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.queryThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("QueryMessageThread_", this.getBrokerIdentity()));
        this.adminBrokerExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getAdminBrokerThreadPoolNums(), this.brokerConfig.getAdminBrokerThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.adminBrokerThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("AdminBrokerThread_", this.getBrokerIdentity()));
        this.clientManageExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getClientManageThreadPoolNums(), this.brokerConfig.getClientManageThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.clientManagerThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("ClientManageThread_", this.getBrokerIdentity()));
        this.heartbeatExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getHeartbeatThreadPoolNums(), this.brokerConfig.getHeartbeatThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.heartbeatThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("HeartbeatThread_", true, this.getBrokerIdentity()));
        this.consumerManageExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getConsumerManageThreadPoolNums(), this.brokerConfig.getConsumerManageThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.consumerManagerThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("ConsumerManageThread_", true, this.getBrokerIdentity()));
        this.replyMessageExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getProcessReplyMessageThreadPoolNums(), this.brokerConfig.getProcessReplyMessageThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.replyThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("ProcessReplyMessageThread_", this.getBrokerIdentity()));
        this.endTransactionExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getEndTransactionThreadPoolNums(), this.brokerConfig.getEndTransactionThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.endTransactionThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("EndTransactionThread_", this.getBrokerIdentity()));
        this.loadBalanceExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getLoadBalanceProcessorThreadPoolNums(), this.brokerConfig.getLoadBalanceProcessorThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.loadBalanceThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("LoadBalanceProcessorThread_", this.getBrokerIdentity()));
        this.syncBrokerMemberGroupExecutorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ThreadFactoryImpl("BrokerControllerSyncBrokerScheduledThread", this.getBrokerIdentity()));
        this.brokerHeartbeatExecutorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ThreadFactoryImpl("rokerControllerHeartbeatScheduledThread", this.getBrokerIdentity()));
        this.topicQueueMappingCleanService = new TopicQueueMappingCleanService(this);
    }

    protected void initializeBrokerScheduledTasks() {
        long initialDelay = UtilAll.computeNextMorningTimeMillis() - System.currentTimeMillis();
        long period = TimeUnit.DAYS.toMillis(1L);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    BrokerController.this.getBrokerStats().record();
                }
                catch (Throwable e) {
                    LOG.error("BrokerController: failed to record broker stats", e);
                }
            }
        }, initialDelay, period, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    BrokerController.this.consumerOffsetManager.persist();
                }
                catch (Throwable e) {
                    LOG.error("BrokerController: failed to persist config file of consumerOffset", e);
                }
            }
        }, 10000L, this.brokerConfig.getFlushConsumerOffsetInterval(), TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    BrokerController.this.consumerFilterManager.persist();
                    BrokerController.this.consumerOrderInfoManager.persist();
                }
                catch (Throwable e) {
                    LOG.error("BrokerController: failed to persist config file of consumerFilter or consumerOrderInfo", e);
                }
            }
        }, 10000L, 10000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    BrokerController.this.protectBroker();
                }
                catch (Throwable e) {
                    LOG.error("BrokerController: failed to protectBroker", e);
                }
            }
        }, 3L, 3L, TimeUnit.MINUTES);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    BrokerController.this.printWaterMark();
                }
                catch (Throwable e) {
                    LOG.error("BrokerController: failed to print broker watermark", e);
                }
            }
        }, 10L, 1L, TimeUnit.SECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("Dispatch task fall behind commit log {}bytes", (Object)BrokerController.this.getMessageStore().dispatchBehindBytes());
                }
                catch (Throwable e) {
                    LOG.error("Failed to print dispatchBehindBytes", e);
                }
            }
        }, 10000L, 60000L, TimeUnit.MILLISECONDS);
        if (!(this.messageStoreConfig.isEnableDLegerCommitLog() || this.messageStoreConfig.isDuplicationEnable() || this.brokerConfig.isEnableControllerMode())) {
            if (BrokerRole.SLAVE == this.messageStoreConfig.getBrokerRole()) {
                if (this.messageStoreConfig.getHaMasterAddress() != null && this.messageStoreConfig.getHaMasterAddress().length() >= 6) {
                    this.messageStore.updateHaMasterAddress(this.messageStoreConfig.getHaMasterAddress());
                    this.updateMasterHAServerAddrPeriodically = false;
                } else {
                    this.updateMasterHAServerAddrPeriodically = true;
                }
                this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (System.currentTimeMillis() - BrokerController.this.lastSyncTimeMs > 60000L) {
                                BrokerController.this.getSlaveSynchronize().syncAll();
                                BrokerController.this.lastSyncTimeMs = System.currentTimeMillis();
                            }
                            BrokerController.this.getSlaveSynchronize().syncTimerCheckPoint();
                        }
                        catch (Throwable e) {
                            LOG.error("Failed to sync all config for slave.", e);
                        }
                    }
                }, 10000L, 3000L, TimeUnit.MILLISECONDS);
            } else {
                this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BrokerController.this.printMasterAndSlaveDiff();
                        }
                        catch (Throwable e) {
                            LOG.error("Failed to print diff of master and slave.", e);
                        }
                    }
                }, 10000L, 60000L, TimeUnit.MILLISECONDS);
            }
        }
        if (this.brokerConfig.isEnableControllerMode()) {
            this.updateMasterHAServerAddrPeriodically = true;
        }
    }

    protected void initializeScheduledTasks() {
        this.initializeBrokerScheduledTasks();
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    BrokerController.this.brokerOuterAPI.refreshMetadata();
                }
                catch (Exception e) {
                    LOG.error("ScheduledTask refresh metadata exception", (Throwable)e);
                }
            }
        }, 10L, 5L, TimeUnit.SECONDS);
        if (this.brokerConfig.getNamesrvAddr() != null) {
            this.brokerOuterAPI.updateNameServerAddressList(this.brokerConfig.getNamesrvAddr());
            LOG.info("Set user specified name server address: {}", (Object)this.brokerConfig.getNamesrvAddr());
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        BrokerController.this.brokerOuterAPI.updateNameServerAddressList(BrokerController.this.brokerConfig.getNamesrvAddr());
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to update nameServer address list", e);
                    }
                }
            }, 10000L, 120000L, TimeUnit.MILLISECONDS);
        } else if (this.brokerConfig.isFetchNamesrvAddrByAddressServer()) {
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        BrokerController.this.brokerOuterAPI.fetchNameServerAddr();
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to fetch nameServer address", e);
                    }
                }
            }, 10000L, 120000L, TimeUnit.MILLISECONDS);
        }
    }

    public boolean initialize() throws CloneNotSupportedException {
        boolean result = this.topicConfigManager.load();
        result = result && this.topicQueueMappingManager.load();
        result = result && this.consumerOffsetManager.load();
        result = result && this.subscriptionGroupManager.load();
        result = result && this.consumerFilterManager.load();
        boolean bl = result = result && this.consumerOrderInfoManager.load();
        if (result) {
            try {
                DefaultMessageStore defaultMessageStore = new DefaultMessageStore(this.messageStoreConfig, this.brokerStatsManager, this.messageArrivingListener, this.brokerConfig);
                defaultMessageStore.setTopicConfigTable(this.topicConfigManager.getTopicConfigTable());
                if (this.messageStoreConfig.isEnableDLegerCommitLog()) {
                    DLedgerRoleChangeHandler roleChangeHandler = new DLedgerRoleChangeHandler(this, defaultMessageStore);
                    ((DLedgerCommitLog)defaultMessageStore.getCommitLog()).getdLedgerServer().getdLedgerLeaderElector().addRoleChangeHandler((DLedgerLeaderElector.RoleChangeHandler)roleChangeHandler);
                }
                this.brokerStats = new BrokerStats((MessageStore)defaultMessageStore);
                MessageStorePluginContext context = new MessageStorePluginContext(this, this.messageStoreConfig, this.brokerStatsManager, this.messageArrivingListener);
                this.messageStore = MessageStoreFactory.build(context, (MessageStore)defaultMessageStore);
                this.messageStore.getDispatcherList().addFirst(new CommitLogDispatcherCalcBitMap(this.brokerConfig, this.consumerFilterManager));
                if (this.brokerConfig.isEnableControllerMode()) {
                    this.replicasManager = new ReplicasManager(this);
                }
                if (this.messageStoreConfig.isTimerWheelEnable()) {
                    this.timerCheckpoint = new TimerCheckpoint(BrokerPathConfigHelper.getTimerCheckPath(this.messageStoreConfig.getStorePathRootDir()));
                    TimerMetrics timerMetrics = new TimerMetrics(BrokerPathConfigHelper.getTimerMetricsPath(this.messageStoreConfig.getStorePathRootDir()));
                    this.timerMessageStore = new TimerMessageStore(this.messageStore, this.messageStoreConfig, this.timerCheckpoint, timerMetrics, this.brokerStatsManager);
                    this.timerMessageStore.registerEscapeBridgeHook(msg -> this.escapeBridge.putMessage((MessageExtBrokerInner)msg));
                    this.messageStore.setTimerMessageStore(this.timerMessageStore);
                }
            }
            catch (IOException e) {
                result = false;
                LOG.error("BrokerController#initialize: unexpected error occurs", (Throwable)e);
            }
        }
        if (this.messageStore != null) {
            this.registerMessageStoreHook();
        }
        boolean bl2 = result = result && this.messageStore.load();
        if (this.messageStoreConfig.isTimerWheelEnable()) {
            result = result && this.timerMessageStore.load();
        }
        result = result && this.scheduleMessageService.load();
        for (BrokerAttachedPlugin brokerAttachedPlugin : this.brokerAttachedPlugins) {
            if (brokerAttachedPlugin == null) continue;
            result = result && brokerAttachedPlugin.load();
        }
        if (result) {
            this.initializeRemotingServer();
            this.initializeResources();
            this.registerProcessor();
            this.initializeScheduledTasks();
            this.initialTransaction();
            this.initialAcl();
            this.initialRpcHooks();
            if (TlsSystemConfig.tlsMode != TlsMode.DISABLED) {
                try {
                    this.fileWatchService = new FileWatchService(new String[]{TlsSystemConfig.tlsServerCertPath, TlsSystemConfig.tlsServerKeyPath, TlsSystemConfig.tlsServerTrustCertPath}, new FileWatchService.Listener(){
                        boolean certChanged;
                        boolean keyChanged = false;

                        public void onChanged(String path) {
                            if (path.equals(TlsSystemConfig.tlsServerTrustCertPath)) {
                                LOG.info("The trust certificate changed, reload the ssl context");
                                this.reloadServerSslContext();
                            }
                            if (path.equals(TlsSystemConfig.tlsServerCertPath)) {
                                this.certChanged = true;
                            }
                            if (path.equals(TlsSystemConfig.tlsServerKeyPath)) {
                                this.keyChanged = true;
                            }
                            if (this.certChanged && this.keyChanged) {
                                LOG.info("The certificate and private key changed, reload the ssl context");
                                this.keyChanged = false;
                                this.certChanged = false;
                                this.reloadServerSslContext();
                            }
                        }

                        private void reloadServerSslContext() {
                            ((NettyRemotingServer)BrokerController.this.remotingServer).loadSslContext();
                            ((NettyRemotingServer)BrokerController.this.fastRemotingServer).loadSslContext();
                        }
                    });
                }
                catch (Exception e) {
                    result = false;
                    LOG.warn("FileWatchService created error, can't load the certificate dynamically");
                }
            }
        }
        return result;
    }

    public void registerMessageStoreHook() {
        List putMessageHookList = this.messageStore.getPutMessageHookList();
        putMessageHookList.add(new PutMessageHook(){

            public String hookName() {
                return "checkBeforePutMessage";
            }

            public PutMessageResult executeBeforePutMessage(MessageExt msg) {
                return HookUtils.checkBeforePutMessage(BrokerController.this, msg);
            }
        });
        putMessageHookList.add(new PutMessageHook(){

            public String hookName() {
                return "innerBatchChecker";
            }

            public PutMessageResult executeBeforePutMessage(MessageExt msg) {
                if (msg instanceof MessageExtBrokerInner) {
                    return HookUtils.checkInnerBatch(BrokerController.this, msg);
                }
                return null;
            }
        });
        putMessageHookList.add(new PutMessageHook(){

            public String hookName() {
                return "handleScheduleMessage";
            }

            public PutMessageResult executeBeforePutMessage(MessageExt msg) {
                if (msg instanceof MessageExtBrokerInner) {
                    return HookUtils.handleScheduleMessage(BrokerController.this, (MessageExtBrokerInner)msg);
                }
                return null;
            }
        });
        SendMessageBackHook sendMessageBackHook = new SendMessageBackHook(){

            public boolean executeSendMessageBack(List<MessageExt> msgList, String brokerName, String brokerAddr) {
                return HookUtils.sendMessageBack(BrokerController.this, msgList, brokerName, brokerAddr);
            }
        };
        if (this.messageStore != null) {
            this.messageStore.setSendMessageBackHook(sendMessageBackHook);
        }
    }

    private void initialTransaction() {
        this.transactionalMessageService = (TransactionalMessageService)ServiceProvider.loadClass((String)"META-INF/service/org.apache.rocketmq.broker.transaction.TransactionalMessageService", TransactionalMessageService.class);
        if (null == this.transactionalMessageService) {
            this.transactionalMessageService = new TransactionalMessageServiceImpl(new TransactionalMessageBridge(this, this.getMessageStore()));
            LOG.warn("Load default transaction message hook service: {}", (Object)TransactionalMessageServiceImpl.class.getSimpleName());
        }
        this.transactionalMessageCheckListener = (AbstractTransactionalMessageCheckListener)ServiceProvider.loadClass((String)"META-INF/service/org.apache.rocketmq.broker.transaction.AbstractTransactionalMessageCheckListener", AbstractTransactionalMessageCheckListener.class);
        if (null == this.transactionalMessageCheckListener) {
            this.transactionalMessageCheckListener = new DefaultTransactionalMessageCheckListener();
            LOG.warn("Load default discard message hook service: {}", (Object)DefaultTransactionalMessageCheckListener.class.getSimpleName());
        }
        this.transactionalMessageCheckListener.setBrokerController(this);
        this.transactionalMessageCheckService = new TransactionalMessageCheckService(this);
    }

    private void initialAcl() {
        if (!this.brokerConfig.isAclEnable()) {
            LOG.info("The broker dose not enable acl");
            return;
        }
        List accessValidators = ServiceProvider.load((String)"META-INF/service/org.apache.rocketmq.acl.AccessValidator", AccessValidator.class);
        if (accessValidators.isEmpty()) {
            LOG.info("The broker dose not load the AccessValidator");
            return;
        }
        Iterator iterator = accessValidators.iterator();
        while (iterator.hasNext()) {
            AccessValidator accessValidator;
            final AccessValidator validator = accessValidator = (AccessValidator)iterator.next();
            this.accessValidatorMap.put(validator.getClass(), validator);
            this.registerServerRPCHook(new RPCHook(){

                public void doBeforeRequest(String remoteAddr, RemotingCommand request) {
                    validator.validate(validator.parse(request, remoteAddr));
                }

                public void doAfterResponse(String remoteAddr, RemotingCommand request, RemotingCommand response) {
                }
            });
        }
    }

    private void initialRpcHooks() {
        List rpcHooks = ServiceProvider.load((String)"META-INF/service/org.apache.rocketmq.remoting.RPCHook", RPCHook.class);
        if (rpcHooks == null || rpcHooks.isEmpty()) {
            return;
        }
        for (RPCHook rpcHook : rpcHooks) {
            this.registerServerRPCHook(rpcHook);
        }
    }

    public void registerProcessor() {
        this.sendMessageProcessor.registerSendMessageHook(this.sendMessageHookList);
        this.sendMessageProcessor.registerConsumeMessageHook(this.consumeMessageHookList);
        this.remotingServer.registerProcessor(10, (NettyRequestProcessor)this.sendMessageProcessor, this.sendMessageExecutor);
        this.remotingServer.registerProcessor(310, (NettyRequestProcessor)this.sendMessageProcessor, this.sendMessageExecutor);
        this.remotingServer.registerProcessor(320, (NettyRequestProcessor)this.sendMessageProcessor, this.sendMessageExecutor);
        this.remotingServer.registerProcessor(36, (NettyRequestProcessor)this.sendMessageProcessor, this.sendMessageExecutor);
        this.fastRemotingServer.registerProcessor(10, (NettyRequestProcessor)this.sendMessageProcessor, this.sendMessageExecutor);
        this.fastRemotingServer.registerProcessor(310, (NettyRequestProcessor)this.sendMessageProcessor, this.sendMessageExecutor);
        this.fastRemotingServer.registerProcessor(320, (NettyRequestProcessor)this.sendMessageProcessor, this.sendMessageExecutor);
        this.fastRemotingServer.registerProcessor(36, (NettyRequestProcessor)this.sendMessageProcessor, this.sendMessageExecutor);
        this.remotingServer.registerProcessor(11, (NettyRequestProcessor)this.pullMessageProcessor, this.pullMessageExecutor);
        this.remotingServer.registerProcessor(361, (NettyRequestProcessor)this.pullMessageProcessor, this.litePullMessageExecutor);
        this.pullMessageProcessor.registerConsumeMessageHook(this.consumeMessageHookList);
        this.remotingServer.registerProcessor(200052, (NettyRequestProcessor)this.peekMessageProcessor, this.pullMessageExecutor);
        this.remotingServer.registerProcessor(200050, (NettyRequestProcessor)this.popMessageProcessor, this.pullMessageExecutor);
        this.remotingServer.registerProcessor(200051, (NettyRequestProcessor)this.ackMessageProcessor, this.ackMessageExecutor);
        this.fastRemotingServer.registerProcessor(200051, (NettyRequestProcessor)this.ackMessageProcessor, this.ackMessageExecutor);
        this.remotingServer.registerProcessor(200053, (NettyRequestProcessor)this.changeInvisibleTimeProcessor, this.ackMessageExecutor);
        this.fastRemotingServer.registerProcessor(200053, (NettyRequestProcessor)this.changeInvisibleTimeProcessor, this.ackMessageExecutor);
        this.remotingServer.registerProcessor(200054, (NettyRequestProcessor)this.notificationProcessor, this.pullMessageExecutor);
        this.remotingServer.registerProcessor(200055, (NettyRequestProcessor)this.pollingInfoProcessor, this.pullMessageExecutor);
        this.replyMessageProcessor.registerSendMessageHook(this.sendMessageHookList);
        this.remotingServer.registerProcessor(324, (NettyRequestProcessor)this.replyMessageProcessor, this.replyMessageExecutor);
        this.remotingServer.registerProcessor(325, (NettyRequestProcessor)this.replyMessageProcessor, this.replyMessageExecutor);
        this.fastRemotingServer.registerProcessor(324, (NettyRequestProcessor)this.replyMessageProcessor, this.replyMessageExecutor);
        this.fastRemotingServer.registerProcessor(325, (NettyRequestProcessor)this.replyMessageProcessor, this.replyMessageExecutor);
        QueryMessageProcessor queryProcessor = new QueryMessageProcessor(this);
        this.remotingServer.registerProcessor(12, (NettyRequestProcessor)queryProcessor, this.queryMessageExecutor);
        this.remotingServer.registerProcessor(33, (NettyRequestProcessor)queryProcessor, this.queryMessageExecutor);
        this.fastRemotingServer.registerProcessor(12, (NettyRequestProcessor)queryProcessor, this.queryMessageExecutor);
        this.fastRemotingServer.registerProcessor(33, (NettyRequestProcessor)queryProcessor, this.queryMessageExecutor);
        this.remotingServer.registerProcessor(34, (NettyRequestProcessor)this.clientManageProcessor, this.heartbeatExecutor);
        this.remotingServer.registerProcessor(35, (NettyRequestProcessor)this.clientManageProcessor, this.clientManageExecutor);
        this.remotingServer.registerProcessor(46, (NettyRequestProcessor)this.clientManageProcessor, this.clientManageExecutor);
        this.fastRemotingServer.registerProcessor(34, (NettyRequestProcessor)this.clientManageProcessor, this.heartbeatExecutor);
        this.fastRemotingServer.registerProcessor(35, (NettyRequestProcessor)this.clientManageProcessor, this.clientManageExecutor);
        this.fastRemotingServer.registerProcessor(46, (NettyRequestProcessor)this.clientManageProcessor, this.clientManageExecutor);
        ConsumerManageProcessor consumerManageProcessor = new ConsumerManageProcessor(this);
        this.remotingServer.registerProcessor(38, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.remotingServer.registerProcessor(15, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.remotingServer.registerProcessor(14, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.fastRemotingServer.registerProcessor(38, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.fastRemotingServer.registerProcessor(15, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.fastRemotingServer.registerProcessor(14, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.remotingServer.registerProcessor(400, (NettyRequestProcessor)this.queryAssignmentProcessor, this.loadBalanceExecutor);
        this.fastRemotingServer.registerProcessor(400, (NettyRequestProcessor)this.queryAssignmentProcessor, this.loadBalanceExecutor);
        this.remotingServer.registerProcessor(401, (NettyRequestProcessor)this.queryAssignmentProcessor, this.loadBalanceExecutor);
        this.fastRemotingServer.registerProcessor(401, (NettyRequestProcessor)this.queryAssignmentProcessor, this.loadBalanceExecutor);
        this.remotingServer.registerProcessor(37, (NettyRequestProcessor)this.endTransactionProcessor, this.endTransactionExecutor);
        this.fastRemotingServer.registerProcessor(37, (NettyRequestProcessor)this.endTransactionProcessor, this.endTransactionExecutor);
        AdminBrokerProcessor adminProcessor = new AdminBrokerProcessor(this);
        this.remotingServer.registerDefaultProcessor((NettyRequestProcessor)adminProcessor, this.adminBrokerExecutor);
        this.fastRemotingServer.registerDefaultProcessor((NettyRequestProcessor)adminProcessor, this.adminBrokerExecutor);
    }

    public BrokerStats getBrokerStats() {
        return this.brokerStats;
    }

    public void setBrokerStats(BrokerStats brokerStats) {
        this.brokerStats = brokerStats;
    }

    public void protectBroker() {
        if (this.brokerConfig.isDisableConsumeIfConsumerReadSlowly()) {
            for (Map.Entry next : this.brokerStatsManager.getMomentStatsItemSetFallSize().getStatsItemTable().entrySet()) {
                long fallBehindBytes = ((MomentStatsItem)next.getValue()).getValue().get();
                if (fallBehindBytes <= this.brokerConfig.getConsumerFallbehindThreshold()) continue;
                String[] split = ((MomentStatsItem)next.getValue()).getStatsKey().split("@");
                String group = split[2];
                LOG_PROTECTION.info("[PROTECT_BROKER] the consumer[{}] consume slowly, {} bytes, disable it", (Object)group, (Object)fallBehindBytes);
                this.subscriptionGroupManager.disableConsume(group);
            }
        }
    }

    public long headSlowTimeMills(BlockingQueue<Runnable> q) {
        long slowTimeMills = 0L;
        Runnable peek = (Runnable)q.peek();
        if (peek != null) {
            RequestTask rt = BrokerFastFailure.castRunnable(peek);
            long l = slowTimeMills = rt == null ? 0L : this.messageStore.now() - rt.getCreateTimestamp();
        }
        if (slowTimeMills < 0L) {
            slowTimeMills = 0L;
        }
        return slowTimeMills;
    }

    public long headSlowTimeMills4SendThreadPoolQueue() {
        return this.headSlowTimeMills(this.sendThreadPoolQueue);
    }

    public long headSlowTimeMills4PullThreadPoolQueue() {
        return this.headSlowTimeMills(this.pullThreadPoolQueue);
    }

    public long headSlowTimeMills4LitePullThreadPoolQueue() {
        return this.headSlowTimeMills(this.litePullThreadPoolQueue);
    }

    public long headSlowTimeMills4QueryThreadPoolQueue() {
        return this.headSlowTimeMills(this.queryThreadPoolQueue);
    }

    public void printWaterMark() {
        LOG_WATER_MARK.info("[WATERMARK] Send Queue Size: {} SlowTimeMills: {}", (Object)this.sendThreadPoolQueue.size(), (Object)this.headSlowTimeMills4SendThreadPoolQueue());
        LOG_WATER_MARK.info("[WATERMARK] Pull Queue Size: {} SlowTimeMills: {}", (Object)this.pullThreadPoolQueue.size(), (Object)this.headSlowTimeMills4PullThreadPoolQueue());
        LOG_WATER_MARK.info("[WATERMARK] Query Queue Size: {} SlowTimeMills: {}", (Object)this.queryThreadPoolQueue.size(), (Object)this.headSlowTimeMills4QueryThreadPoolQueue());
        LOG_WATER_MARK.info("[WATERMARK] Lite Pull Queue Size: {} SlowTimeMills: {}", (Object)this.litePullThreadPoolQueue.size(), (Object)this.headSlowTimeMills4LitePullThreadPoolQueue());
        LOG_WATER_MARK.info("[WATERMARK] Transaction Queue Size: {} SlowTimeMills: {}", (Object)this.endTransactionThreadPoolQueue.size(), (Object)this.headSlowTimeMills(this.endTransactionThreadPoolQueue));
        LOG_WATER_MARK.info("[WATERMARK] ClientManager Queue Size: {} SlowTimeMills: {}", (Object)this.clientManagerThreadPoolQueue.size(), (Object)this.headSlowTimeMills(this.clientManagerThreadPoolQueue));
        LOG_WATER_MARK.info("[WATERMARK] Heartbeat Queue Size: {} SlowTimeMills: {}", (Object)this.heartbeatThreadPoolQueue.size(), (Object)this.headSlowTimeMills(this.heartbeatThreadPoolQueue));
        LOG_WATER_MARK.info("[WATERMARK] Ack Queue Size: {} SlowTimeMills: {}", (Object)this.ackThreadPoolQueue.size(), (Object)this.headSlowTimeMills(this.ackThreadPoolQueue));
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public void setMessageStore(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    protected void printMasterAndSlaveDiff() {
        if (this.messageStore.getHaService() != null && this.messageStore.getHaService().getConnectionCount().get() > 0) {
            long diff = this.messageStore.slaveFallBehindMuch();
            LOG.info("CommitLog: slave fall behind master {}bytes", (Object)diff);
        }
    }

    public Broker2Client getBroker2Client() {
        return this.broker2Client;
    }

    public ConsumerManager getConsumerManager() {
        return this.consumerManager;
    }

    public ConsumerFilterManager getConsumerFilterManager() {
        return this.consumerFilterManager;
    }

    public ConsumerOrderInfoManager getConsumerOrderInfoManager() {
        return this.consumerOrderInfoManager;
    }

    public ConsumerOffsetManager getConsumerOffsetManager() {
        return this.consumerOffsetManager;
    }

    public MessageStoreConfig getMessageStoreConfig() {
        return this.messageStoreConfig;
    }

    public ProducerManager getProducerManager() {
        return this.producerManager;
    }

    public void setFastRemotingServer(RemotingServer fastRemotingServer) {
        this.fastRemotingServer = fastRemotingServer;
    }

    public RemotingServer getFastRemotingServer() {
        return this.fastRemotingServer;
    }

    public PullMessageProcessor getPullMessageProcessor() {
        return this.pullMessageProcessor;
    }

    public PullRequestHoldService getPullRequestHoldService() {
        return this.pullRequestHoldService;
    }

    public SubscriptionGroupManager getSubscriptionGroupManager() {
        return this.subscriptionGroupManager;
    }

    public PopMessageProcessor getPopMessageProcessor() {
        return this.popMessageProcessor;
    }

    public TimerMessageStore getTimerMessageStore() {
        return this.timerMessageStore;
    }

    public void setTimerMessageStore(TimerMessageStore timerMessageStore) {
        this.timerMessageStore = timerMessageStore;
    }

    public AckMessageProcessor getAckMessageProcessor() {
        return this.ackMessageProcessor;
    }

    public ChangeInvisibleTimeProcessor getChangeInvisibleTimeProcessor() {
        return this.changeInvisibleTimeProcessor;
    }

    protected void shutdownBasicService() {
        this.shutdown = true;
        this.unregisterBrokerAll();
        if (this.shutdownHook != null) {
            this.shutdownHook.beforeShutdown(this);
        }
        if (this.remotingServer != null) {
            this.remotingServer.shutdown();
        }
        if (this.fastRemotingServer != null) {
            this.fastRemotingServer.shutdown();
        }
        if (this.brokerStatsManager != null) {
            this.brokerStatsManager.shutdown();
        }
        if (this.clientHousekeepingService != null) {
            this.clientHousekeepingService.shutdown();
        }
        if (this.pullRequestHoldService != null) {
            this.pullRequestHoldService.shutdown();
        }
        this.popMessageProcessor.getPopLongPollingService().shutdown();
        this.popMessageProcessor.getQueueLockManager().shutdown();
        this.popMessageProcessor.getPopBufferMergeService().shutdown();
        this.ackMessageProcessor.shutdownPopReviveService();
        if (this.notificationProcessor != null) {
            this.notificationProcessor.shutdown();
        }
        if (this.consumerIdsChangeListener != null) {
            this.consumerIdsChangeListener.shutdown();
        }
        if (this.topicQueueMappingCleanService != null) {
            this.topicQueueMappingCleanService.shutdown();
        }
        if (this.timerMessageStore != null) {
            this.timerMessageStore.shutdown();
        }
        if (this.fileWatchService != null) {
            this.fileWatchService.shutdown();
        }
        if (this.messageStore != null) {
            this.messageStore.shutdown();
        }
        if (this.replicasManager != null) {
            this.replicasManager.shutdown();
        }
        this.shutdownScheduledExecutorService(this.scheduledExecutorService);
        if (this.sendMessageExecutor != null) {
            this.sendMessageExecutor.shutdown();
        }
        if (this.litePullMessageExecutor != null) {
            this.litePullMessageExecutor.shutdown();
        }
        if (this.pullMessageExecutor != null) {
            this.pullMessageExecutor.shutdown();
        }
        if (this.replyMessageExecutor != null) {
            this.replyMessageExecutor.shutdown();
        }
        if (this.putMessageFutureExecutor != null) {
            this.putMessageFutureExecutor.shutdown();
        }
        if (this.ackMessageExecutor != null) {
            this.ackMessageExecutor.shutdown();
        }
        if (this.adminBrokerExecutor != null) {
            this.adminBrokerExecutor.shutdown();
        }
        this.consumerOffsetManager.persist();
        if (this.filterServerManager != null) {
            this.filterServerManager.shutdown();
        }
        if (this.brokerFastFailure != null) {
            this.brokerFastFailure.shutdown();
        }
        if (this.consumerFilterManager != null) {
            this.consumerFilterManager.persist();
        }
        if (this.consumerOrderInfoManager != null) {
            this.consumerOrderInfoManager.persist();
        }
        if (this.scheduleMessageService != null) {
            this.scheduleMessageService.persist();
            this.scheduleMessageService.shutdown();
        }
        if (this.clientManageExecutor != null) {
            this.clientManageExecutor.shutdown();
        }
        if (this.queryMessageExecutor != null) {
            this.queryMessageExecutor.shutdown();
        }
        if (this.heartbeatExecutor != null) {
            this.heartbeatExecutor.shutdown();
        }
        if (this.consumerManageExecutor != null) {
            this.consumerManageExecutor.shutdown();
        }
        if (this.fileWatchService != null) {
            this.fileWatchService.shutdown();
        }
        if (this.transactionalMessageCheckService != null) {
            this.transactionalMessageCheckService.shutdown(false);
        }
        if (this.endTransactionExecutor != null) {
            this.endTransactionExecutor.shutdown();
        }
        if (this.escapeBridge != null) {
            this.escapeBridge.shutdown();
        }
        if (this.topicRouteInfoManager != null) {
            this.topicRouteInfoManager.shutdown();
        }
        if (this.brokerPreOnlineService != null && !this.brokerPreOnlineService.isStopped()) {
            this.brokerPreOnlineService.shutdown();
        }
        this.shutdownScheduledExecutorService(this.syncBrokerMemberGroupExecutorService);
        this.shutdownScheduledExecutorService(this.brokerHeartbeatExecutorService);
        this.topicConfigManager.persist();
        this.subscriptionGroupManager.persist();
        for (BrokerAttachedPlugin brokerAttachedPlugin : this.brokerAttachedPlugins) {
            if (brokerAttachedPlugin == null) continue;
            brokerAttachedPlugin.shutdown();
        }
    }

    public void shutdown() {
        this.shutdownBasicService();
        for (ScheduledFuture<?> scheduledFuture : this.scheduledFutures) {
            scheduledFuture.cancel(true);
        }
        if (this.brokerOuterAPI != null) {
            this.brokerOuterAPI.shutdown();
        }
    }

    protected void shutdownScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        if (scheduledExecutorService == null) {
            return;
        }
        scheduledExecutorService.shutdown();
        try {
            scheduledExecutorService.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void unregisterBrokerAll() {
        this.brokerOuterAPI.unregisterBrokerAll(this.brokerConfig.getBrokerClusterName(), this.getBrokerAddr(), this.brokerConfig.getBrokerName(), this.brokerConfig.getBrokerId());
    }

    public String getBrokerAddr() {
        return this.brokerConfig.getBrokerIP1() + ":" + this.nettyServerConfig.getListenPort();
    }

    protected void startBasicService() throws Exception {
        if (this.messageStore != null) {
            this.messageStore.start();
        }
        if (this.timerMessageStore != null) {
            this.timerMessageStore.start();
        }
        if (this.replicasManager != null) {
            this.replicasManager.start();
        }
        if (this.remotingServerStartLatch != null) {
            this.remotingServerStartLatch.await();
        }
        if (this.remotingServer != null) {
            this.remotingServer.start();
            if (null != this.nettyServerConfig && 0 == this.nettyServerConfig.getListenPort()) {
                this.nettyServerConfig.setListenPort(this.remotingServer.localListenPort());
            }
        }
        if (this.fastRemotingServer != null) {
            this.fastRemotingServer.start();
        }
        this.storeHost = new InetSocketAddress(this.getBrokerConfig().getBrokerIP1(), this.getNettyServerConfig().getListenPort());
        for (BrokerAttachedPlugin brokerAttachedPlugin : this.brokerAttachedPlugins) {
            if (brokerAttachedPlugin == null) continue;
            brokerAttachedPlugin.start();
        }
        if (this.popMessageProcessor != null) {
            this.popMessageProcessor.getPopLongPollingService().start();
            this.popMessageProcessor.getPopBufferMergeService().start();
            this.popMessageProcessor.getQueueLockManager().start();
        }
        if (this.ackMessageProcessor != null) {
            this.ackMessageProcessor.startPopReviveService();
        }
        if (this.topicQueueMappingCleanService != null) {
            this.topicQueueMappingCleanService.start();
        }
        if (this.fileWatchService != null) {
            this.fileWatchService.start();
        }
        if (this.pullRequestHoldService != null) {
            this.pullRequestHoldService.start();
        }
        if (this.clientHousekeepingService != null) {
            this.clientHousekeepingService.start();
        }
        if (this.filterServerManager != null) {
            this.filterServerManager.start();
        }
        if (this.brokerStatsManager != null) {
            this.brokerStatsManager.start();
        }
        if (this.brokerFastFailure != null) {
            this.brokerFastFailure.start();
        }
        if (this.escapeBridge != null) {
            this.escapeBridge.start();
        }
        if (this.topicRouteInfoManager != null) {
            this.topicRouteInfoManager.start();
        }
        if (this.brokerPreOnlineService != null) {
            this.brokerPreOnlineService.start();
        }
        this.topicConfigManager.initStateVersion();
    }

    public void start() throws Exception {
        this.shouldStartTime = System.currentTimeMillis() + (long)this.messageStoreConfig.getDisappearTimeAfterStart();
        if (this.messageStoreConfig.getTotalReplicas() > 1 && this.brokerConfig.isEnableSlaveActingMaster() || this.brokerConfig.isEnableControllerMode()) {
            this.isIsolated = true;
        }
        if (this.brokerOuterAPI != null) {
            this.brokerOuterAPI.start();
        }
        this.startBasicService();
        if (!(this.isIsolated || this.messageStoreConfig.isEnableDLegerCommitLog() || this.messageStoreConfig.isDuplicationEnable())) {
            this.changeSpecialServiceStatus(this.brokerConfig.getBrokerId() == 0L);
            this.registerBrokerAll(true, false, true);
        }
        this.scheduledFutures.add(this.scheduledExecutorService.scheduleAtFixedRate((Runnable)new AbstractBrokerRunnable(this.getBrokerIdentity()){

            public void run2() {
                try {
                    if (System.currentTimeMillis() < BrokerController.this.shouldStartTime) {
                        LOG.info("Register to namesrv after {}", (Object)BrokerController.this.shouldStartTime);
                        return;
                    }
                    if (BrokerController.this.isIsolated) {
                        LOG.info("Skip register for broker is isolated");
                        return;
                    }
                    BrokerController.this.registerBrokerAll(true, false, BrokerController.this.brokerConfig.isForceRegister());
                }
                catch (Throwable e) {
                    LOG.error("registerBrokerAll Exception", e);
                }
            }
        }, 10000L, Math.max(10000, Math.min(this.brokerConfig.getRegisterNameServerPeriod(), 60000)), TimeUnit.MILLISECONDS));
        if (this.brokerConfig.isEnableSlaveActingMaster()) {
            this.scheduleSendHeartbeat();
            this.scheduledFutures.add(this.syncBrokerMemberGroupExecutorService.scheduleAtFixedRate((Runnable)new AbstractBrokerRunnable(this.getBrokerIdentity()){

                public void run2() {
                    try {
                        BrokerController.this.syncBrokerMemberGroup();
                    }
                    catch (Throwable e) {
                        LOG.error("sync BrokerMemberGroup error. ", e);
                    }
                }
            }, 1000L, this.brokerConfig.getSyncBrokerMemberGroupPeriod(), TimeUnit.MILLISECONDS));
        }
        if (this.brokerConfig.isEnableControllerMode()) {
            this.scheduleSendHeartbeat();
        }
        if (this.brokerConfig.isSkipPreOnline()) {
            this.startServiceWithoutCondition();
        }
    }

    protected void scheduleSendHeartbeat() {
        this.scheduledFutures.add(this.brokerHeartbeatExecutorService.scheduleAtFixedRate((Runnable)new AbstractBrokerRunnable(this.getBrokerIdentity()){

            public void run2() {
                if (BrokerController.this.isIsolated) {
                    return;
                }
                try {
                    BrokerController.this.sendHeartbeat();
                }
                catch (Exception e) {
                    LOG.error("sendHeartbeat Exception", (Throwable)e);
                }
            }
        }, 1000L, this.brokerConfig.getBrokerHeartbeatInterval(), TimeUnit.MILLISECONDS));
    }

    public synchronized void registerIncrementBrokerData(TopicConfig topicConfig, DataVersion dataVersion) {
        this.registerIncrementBrokerData(Collections.singletonList(topicConfig), dataVersion);
    }

    public synchronized void registerIncrementBrokerData(List<TopicConfig> topicConfigList, DataVersion dataVersion) {
        if (topicConfigList == null || topicConfigList.isEmpty()) {
            return;
        }
        TopicConfigAndMappingSerializeWrapper topicConfigSerializeWrapper = new TopicConfigAndMappingSerializeWrapper();
        topicConfigSerializeWrapper.setDataVersion(dataVersion);
        ConcurrentMap topicConfigTable = topicConfigList.stream().map(topicConfig -> {
            TopicConfig registerTopicConfig = !PermName.isWriteable((int)this.getBrokerConfig().getBrokerPermission()) || !PermName.isReadable((int)this.getBrokerConfig().getBrokerPermission()) ? new TopicConfig(topicConfig.getTopicName(), topicConfig.getReadQueueNums(), topicConfig.getWriteQueueNums(), this.brokerConfig.getBrokerPermission(), topicConfig.getTopicSysFlag()) : new TopicConfig(topicConfig);
            return registerTopicConfig;
        }).collect(Collectors.toConcurrentMap(TopicConfig::getTopicName, Function.identity()));
        topicConfigSerializeWrapper.setTopicConfigTable(topicConfigTable);
        Map<String, TopicQueueMappingInfo> topicQueueMappingInfoMap = topicConfigList.stream().map(TopicConfig::getTopicName).map(topicName -> Optional.ofNullable(this.topicQueueMappingManager.getTopicQueueMapping((String)topicName)).map(info -> new AbstractMap.SimpleImmutableEntry<String, TopicQueueMappingInfo>((String)topicName, TopicQueueMappingDetail.cloneAsMappingInfo((TopicQueueMappingDetail)info))).orElse(null)).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!topicQueueMappingInfoMap.isEmpty()) {
            topicConfigSerializeWrapper.setTopicQueueMappingInfoMap(topicQueueMappingInfoMap);
        }
        this.doRegisterBrokerAll(true, false, (TopicConfigSerializeWrapper)topicConfigSerializeWrapper);
    }

    public synchronized void registerBrokerAll(boolean checkOrderConfig, boolean oneway, boolean forceRegister) {
        TopicConfigAndMappingSerializeWrapper topicConfigWrapper = new TopicConfigAndMappingSerializeWrapper();
        topicConfigWrapper.setDataVersion(this.getTopicConfigManager().getDataVersion());
        topicConfigWrapper.setTopicConfigTable(this.getTopicConfigManager().getTopicConfigTable());
        topicConfigWrapper.setTopicQueueMappingInfoMap(this.getTopicQueueMappingManager().getTopicQueueMappingTable().entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry(entry.getKey(), TopicQueueMappingDetail.cloneAsMappingInfo((TopicQueueMappingDetail)((TopicQueueMappingDetail)entry.getValue())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        if (!PermName.isWriteable((int)this.getBrokerConfig().getBrokerPermission()) || !PermName.isReadable((int)this.getBrokerConfig().getBrokerPermission())) {
            ConcurrentHashMap<String, TopicConfig> topicConfigTable = new ConcurrentHashMap<String, TopicConfig>();
            for (TopicConfig topicConfig : topicConfigWrapper.getTopicConfigTable().values()) {
                TopicConfig tmp = new TopicConfig(topicConfig.getTopicName(), topicConfig.getReadQueueNums(), topicConfig.getWriteQueueNums(), topicConfig.getPerm() & this.brokerConfig.getBrokerPermission(), topicConfig.getTopicSysFlag());
                topicConfigTable.put(topicConfig.getTopicName(), tmp);
            }
            topicConfigWrapper.setTopicConfigTable(topicConfigTable);
        }
        if (forceRegister || this.needRegister(this.brokerConfig.getBrokerClusterName(), this.getBrokerAddr(), this.brokerConfig.getBrokerName(), this.brokerConfig.getBrokerId(), this.brokerConfig.getRegisterBrokerTimeoutMills(), this.brokerConfig.isInBrokerContainer())) {
            this.doRegisterBrokerAll(checkOrderConfig, oneway, (TopicConfigSerializeWrapper)topicConfigWrapper);
        }
    }

    protected void doRegisterBrokerAll(boolean checkOrderConfig, boolean oneway, TopicConfigSerializeWrapper topicConfigWrapper) {
        if (this.shutdown) {
            LOG.info("BrokerController#doResterBrokerAll: broker has shutdown, no need to register any more.");
            return;
        }
        List<RegisterBrokerResult> registerBrokerResultList = this.brokerOuterAPI.registerBrokerAll(this.brokerConfig.getBrokerClusterName(), this.getBrokerAddr(), this.brokerConfig.getBrokerName(), this.brokerConfig.getBrokerId(), this.getHAServerAddr(), topicConfigWrapper, this.filterServerManager.buildNewFilterServerList(), oneway, this.brokerConfig.getRegisterBrokerTimeoutMills(), this.brokerConfig.isEnableSlaveActingMaster(), this.brokerConfig.isCompressedRegister(), this.brokerConfig.isEnableSlaveActingMaster() ? Long.valueOf(this.brokerConfig.getBrokerNotActiveTimeoutMillis()) : null, this.getBrokerIdentity());
        this.handleRegisterBrokerResult(registerBrokerResultList, checkOrderConfig);
    }

    protected void sendHeartbeat() {
        if (this.brokerConfig.isEnableControllerMode()) {
            List<String> controllerAddresses = this.replicasManager.getControllerAddresses();
            for (String controllerAddress : controllerAddresses) {
                if (!StringUtils.isNotEmpty((CharSequence)controllerAddress)) continue;
                this.brokerOuterAPI.sendHeartbeatToController(controllerAddress, this.brokerConfig.getBrokerClusterName(), this.getBrokerAddr(), this.brokerConfig.getBrokerName(), this.brokerConfig.getBrokerId(), this.brokerConfig.getSendHeartbeatTimeoutMillis(), this.brokerConfig.isInBrokerContainer(), this.replicasManager.getLastEpoch(), this.messageStore.getMaxPhyOffset(), this.replicasManager.getConfirmOffset());
            }
        }
        if (this.brokerConfig.isEnableSlaveActingMaster()) {
            if (this.brokerConfig.isCompatibleWithOldNameSrv()) {
                this.brokerOuterAPI.sendHeartbeatViaDataVersion(this.brokerConfig.getBrokerClusterName(), this.getBrokerAddr(), this.brokerConfig.getBrokerName(), this.brokerConfig.getBrokerId(), this.brokerConfig.getSendHeartbeatTimeoutMillis(), this.getTopicConfigManager().getDataVersion(), this.brokerConfig.isInBrokerContainer());
            } else {
                this.brokerOuterAPI.sendHeartbeat(this.brokerConfig.getBrokerClusterName(), this.getBrokerAddr(), this.brokerConfig.getBrokerName(), this.brokerConfig.getBrokerId(), this.brokerConfig.getSendHeartbeatTimeoutMillis(), this.brokerConfig.isInBrokerContainer());
            }
        }
    }

    protected void syncBrokerMemberGroup() {
        try {
            this.brokerMemberGroup = this.getBrokerOuterAPI().syncBrokerMemberGroup(this.brokerConfig.getBrokerClusterName(), this.brokerConfig.getBrokerName(), this.brokerConfig.isCompatibleWithOldNameSrv());
        }
        catch (Exception e) {
            LOG.error("syncBrokerMemberGroup from namesrv failed, ", (Throwable)e);
            return;
        }
        if (this.brokerMemberGroup == null || this.brokerMemberGroup.getBrokerAddrs().size() == 0) {
            LOG.warn("Couldn't find any broker member from namesrv in {}/{}", (Object)this.brokerConfig.getBrokerClusterName(), (Object)this.brokerConfig.getBrokerName());
            return;
        }
        this.messageStore.setAliveReplicaNumInGroup(this.calcAliveBrokerNumInGroup(this.brokerMemberGroup.getBrokerAddrs()));
        if (!this.isIsolated) {
            long minBrokerId = this.brokerMemberGroup.minimumBrokerId();
            this.updateMinBroker(minBrokerId, (String)this.brokerMemberGroup.getBrokerAddrs().get(minBrokerId));
        }
    }

    private int calcAliveBrokerNumInGroup(Map<Long, String> brokerAddrTable) {
        if (brokerAddrTable.containsKey(this.brokerConfig.getBrokerId())) {
            return brokerAddrTable.size();
        }
        return brokerAddrTable.size() + 1;
    }

    protected void handleRegisterBrokerResult(List<RegisterBrokerResult> registerBrokerResultList, boolean checkOrderConfig) {
        for (RegisterBrokerResult registerBrokerResult : registerBrokerResultList) {
            if (registerBrokerResult == null) continue;
            if (this.updateMasterHAServerAddrPeriodically && registerBrokerResult.getHaServerAddr() != null) {
                this.messageStore.updateHaMasterAddress(registerBrokerResult.getHaServerAddr());
            }
            this.slaveSynchronize.setMasterAddr(registerBrokerResult.getMasterAddr());
            if (!checkOrderConfig) break;
            this.getTopicConfigManager().updateOrderTopicConfig(registerBrokerResult.getKvTable());
            break;
        }
    }

    private boolean needRegister(String clusterName, String brokerAddr, String brokerName, long brokerId, int timeoutMills, boolean isInBrokerContainer) {
        TopicConfigSerializeWrapper topicConfigWrapper = this.getTopicConfigManager().buildTopicConfigSerializeWrapper();
        List<Boolean> changeList = this.brokerOuterAPI.needRegister(clusterName, brokerAddr, brokerName, brokerId, topicConfigWrapper, timeoutMills, isInBrokerContainer);
        boolean needRegister = false;
        for (Boolean changed : changeList) {
            if (!changed.booleanValue()) continue;
            needRegister = true;
            break;
        }
        return needRegister;
    }

    public void startService(long minBrokerId, String minBrokerAddr) {
        LOG.info("{} start service, min broker id is {}, min broker addr: {}", new Object[]{this.brokerConfig.getCanonicalName(), minBrokerId, minBrokerAddr});
        this.minBrokerIdInGroup = minBrokerId;
        this.minBrokerAddrInGroup = minBrokerAddr;
        this.changeSpecialServiceStatus(this.brokerConfig.getBrokerId() == minBrokerId);
        this.registerBrokerAll(true, false, this.brokerConfig.isForceRegister());
        this.isIsolated = false;
    }

    public void startServiceWithoutCondition() {
        LOG.info("{} start service", (Object)this.brokerConfig.getCanonicalName());
        this.changeSpecialServiceStatus(this.brokerConfig.getBrokerId() == 0L);
        this.registerBrokerAll(true, false, this.brokerConfig.isForceRegister());
        this.isIsolated = false;
    }

    public void stopService() {
        LOG.info("{} stop service", (Object)this.getBrokerConfig().getCanonicalName());
        this.isIsolated = true;
        this.changeSpecialServiceStatus(false);
    }

    public boolean isSpecialServiceRunning() {
        if (this.isScheduleServiceStart() && this.isTransactionCheckServiceStart()) {
            return true;
        }
        return this.ackMessageProcessor != null && this.ackMessageProcessor.isPopReviveServiceRunning();
    }

    private void onMasterOffline() {
        String masterAddr = this.slaveSynchronize.getMasterAddr();
        if (masterAddr != null) {
            this.brokerOuterAPI.getRemotingClient().closeChannels(Arrays.asList(masterAddr, MixAll.brokerVIPChannel((boolean)true, (String)masterAddr)));
        }
        this.slaveSynchronize.setMasterAddr(null);
        this.messageStore.updateHaMasterAddress(null);
    }

    private void onMasterOnline(String masterAddr, String masterHaAddr) {
        boolean needSyncMasterFlushOffset;
        boolean bl = needSyncMasterFlushOffset = this.messageStore.getMasterFlushedOffset() == 0L && this.messageStoreConfig.isSyncMasterFlushOffsetWhenStartup();
        if (masterHaAddr == null || needSyncMasterFlushOffset) {
            try {
                BrokerSyncInfo brokerSyncInfo = this.brokerOuterAPI.retrieveBrokerHaInfo(masterAddr);
                if (needSyncMasterFlushOffset) {
                    LOG.info("Set master flush offset in slave to {}", (Object)brokerSyncInfo.getMasterFlushOffset());
                    this.messageStore.setMasterFlushedOffset(brokerSyncInfo.getMasterFlushOffset());
                }
                if (masterHaAddr == null) {
                    this.messageStore.updateHaMasterAddress(brokerSyncInfo.getMasterHaAddress());
                    this.messageStore.updateMasterAddress(brokerSyncInfo.getMasterAddress());
                }
            }
            catch (Exception e) {
                LOG.error("retrieve master ha info exception, {}", (Throwable)e);
            }
        }
        if (masterHaAddr != null) {
            this.messageStore.updateHaMasterAddress(masterHaAddr);
        }
        this.messageStore.wakeupHAClient();
    }

    private void onMinBrokerChange(long minBrokerId, String minBrokerAddr, String offlineBrokerAddr, String masterHaAddr) {
        LOG.info("Min broker changed, old: {}-{}, new {}-{}", new Object[]{this.minBrokerIdInGroup, this.minBrokerAddrInGroup, minBrokerId, minBrokerAddr});
        this.minBrokerIdInGroup = minBrokerId;
        this.minBrokerAddrInGroup = minBrokerAddr;
        this.changeSpecialServiceStatus(this.brokerConfig.getBrokerId() == this.minBrokerIdInGroup);
        if (offlineBrokerAddr != null && offlineBrokerAddr.equals(this.slaveSynchronize.getMasterAddr())) {
            this.onMasterOffline();
        }
        if (minBrokerId == 0L && minBrokerAddr != null) {
            this.onMasterOnline(minBrokerAddr, masterHaAddr);
        }
        if (this.minBrokerIdInGroup == 0L) {
            this.pullRequestHoldService.notifyMasterOnline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMinBroker(long minBrokerId, String minBrokerAddr) {
        if (this.brokerConfig.isEnableSlaveActingMaster() && this.brokerConfig.getBrokerId() != 0L && this.lock.tryLock()) {
            try {
                if (minBrokerId != this.minBrokerIdInGroup) {
                    String offlineBrokerAddr = null;
                    if (minBrokerId > this.minBrokerIdInGroup) {
                        offlineBrokerAddr = this.minBrokerAddrInGroup;
                    }
                    this.onMinBrokerChange(minBrokerId, minBrokerAddr, offlineBrokerAddr, null);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMinBroker(long minBrokerId, String minBrokerAddr, String offlineBrokerAddr, String masterHaAddr) {
        block7: {
            if (this.brokerConfig.isEnableSlaveActingMaster() && this.brokerConfig.getBrokerId() != 0L) {
                try {
                    if (!this.lock.tryLock(3000L, TimeUnit.MILLISECONDS)) break block7;
                    try {
                        if (minBrokerId != this.minBrokerIdInGroup) {
                            this.onMinBrokerChange(minBrokerId, minBrokerAddr, offlineBrokerAddr, masterHaAddr);
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                catch (InterruptedException e) {
                    LOG.error("Update min broker error, {}", (Throwable)e);
                }
            }
        }
    }

    public void changeSpecialServiceStatus(boolean shouldStart) {
        for (BrokerAttachedPlugin brokerAttachedPlugin : this.brokerAttachedPlugins) {
            if (brokerAttachedPlugin == null) continue;
            brokerAttachedPlugin.statusChanged(shouldStart);
        }
        this.changeScheduleServiceStatus(shouldStart);
        this.changeTransactionCheckServiceStatus(shouldStart);
        if (this.ackMessageProcessor != null) {
            LOG.info("Set PopReviveService Status to {}", (Object)shouldStart);
            this.ackMessageProcessor.setPopReviveServiceStatus(shouldStart);
        }
    }

    private synchronized void changeTransactionCheckServiceStatus(boolean shouldStart) {
        if (this.isTransactionCheckServiceStart != shouldStart) {
            LOG.info("TransactionCheckService status changed to {}", (Object)shouldStart);
            if (shouldStart) {
                this.transactionalMessageCheckService.start();
            } else {
                this.transactionalMessageCheckService.shutdown(true);
            }
            this.isTransactionCheckServiceStart = shouldStart;
        }
    }

    public synchronized void changeScheduleServiceStatus(boolean shouldStart) {
        if (this.isScheduleServiceStart != shouldStart) {
            LOG.info("ScheduleServiceStatus changed to {}", (Object)shouldStart);
            if (shouldStart) {
                this.scheduleMessageService.start();
            } else {
                this.scheduleMessageService.stop();
            }
            this.isScheduleServiceStart = shouldStart;
            if (this.timerMessageStore != null) {
                this.timerMessageStore.setShouldRunningDequeue(shouldStart);
            }
        }
    }

    public MessageStore getMessageStoreByBrokerName(String brokerName) {
        if (this.brokerConfig.getBrokerName().equals(brokerName)) {
            return this.getMessageStore();
        }
        return null;
    }

    public BrokerIdentity getBrokerIdentity() {
        if (this.messageStoreConfig.isEnableDLegerCommitLog()) {
            return new BrokerIdentity(this.brokerConfig.getBrokerClusterName(), this.brokerConfig.getBrokerName(), (long)Integer.parseInt(this.messageStoreConfig.getdLegerSelfId().substring(1)), this.brokerConfig.isInBrokerContainer());
        }
        return new BrokerIdentity(this.brokerConfig.getBrokerClusterName(), this.brokerConfig.getBrokerName(), this.brokerConfig.getBrokerId(), this.brokerConfig.isInBrokerContainer());
    }

    public TopicConfigManager getTopicConfigManager() {
        return this.topicConfigManager;
    }

    public void setTopicConfigManager(TopicConfigManager topicConfigManager) {
        this.topicConfigManager = topicConfigManager;
    }

    public TopicQueueMappingManager getTopicQueueMappingManager() {
        return this.topicQueueMappingManager;
    }

    public String getHAServerAddr() {
        return this.brokerConfig.getBrokerIP2() + ":" + this.messageStoreConfig.getHaListenPort();
    }

    public RebalanceLockManager getRebalanceLockManager() {
        return this.rebalanceLockManager;
    }

    public SlaveSynchronize getSlaveSynchronize() {
        return this.slaveSynchronize;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public ExecutorService getPullMessageExecutor() {
        return this.pullMessageExecutor;
    }

    public ExecutorService getPutMessageFutureExecutor() {
        return this.putMessageFutureExecutor;
    }

    public void setPullMessageExecutor(ExecutorService pullMessageExecutor) {
        this.pullMessageExecutor = pullMessageExecutor;
    }

    public BlockingQueue<Runnable> getSendThreadPoolQueue() {
        return this.sendThreadPoolQueue;
    }

    public BlockingQueue<Runnable> getAckThreadPoolQueue() {
        return this.ackThreadPoolQueue;
    }

    public FilterServerManager getFilterServerManager() {
        return this.filterServerManager;
    }

    public BrokerStatsManager getBrokerStatsManager() {
        return this.brokerStatsManager;
    }

    public List<SendMessageHook> getSendMessageHookList() {
        return this.sendMessageHookList;
    }

    public void registerSendMessageHook(SendMessageHook hook) {
        this.sendMessageHookList.add(hook);
        LOG.info("register SendMessageHook Hook, {}", (Object)hook.hookName());
    }

    public List<ConsumeMessageHook> getConsumeMessageHookList() {
        return this.consumeMessageHookList;
    }

    public void registerConsumeMessageHook(ConsumeMessageHook hook) {
        this.consumeMessageHookList.add(hook);
        LOG.info("register ConsumeMessageHook Hook, {}", (Object)hook.hookName());
    }

    public void registerServerRPCHook(RPCHook rpcHook) {
        this.getRemotingServer().registerRPCHook(rpcHook);
        this.fastRemotingServer.registerRPCHook(rpcHook);
    }

    public RemotingServer getRemotingServer() {
        return this.remotingServer;
    }

    public void setRemotingServer(RemotingServer remotingServer) {
        this.remotingServer = remotingServer;
    }

    public CountDownLatch getRemotingServerStartLatch() {
        return this.remotingServerStartLatch;
    }

    public void setRemotingServerStartLatch(CountDownLatch remotingServerStartLatch) {
        this.remotingServerStartLatch = remotingServerStartLatch;
    }

    public void registerClientRPCHook(RPCHook rpcHook) {
        this.getBrokerOuterAPI().registerRPCHook(rpcHook);
    }

    public BrokerOuterAPI getBrokerOuterAPI() {
        return this.brokerOuterAPI;
    }

    public InetSocketAddress getStoreHost() {
        return this.storeHost;
    }

    public void setStoreHost(InetSocketAddress storeHost) {
        this.storeHost = storeHost;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public BlockingQueue<Runnable> getHeartbeatThreadPoolQueue() {
        return this.heartbeatThreadPoolQueue;
    }

    public TransactionalMessageCheckService getTransactionalMessageCheckService() {
        return this.transactionalMessageCheckService;
    }

    public void setTransactionalMessageCheckService(TransactionalMessageCheckService transactionalMessageCheckService) {
        this.transactionalMessageCheckService = transactionalMessageCheckService;
    }

    public TransactionalMessageService getTransactionalMessageService() {
        return this.transactionalMessageService;
    }

    public void setTransactionalMessageService(TransactionalMessageService transactionalMessageService) {
        this.transactionalMessageService = transactionalMessageService;
    }

    public AbstractTransactionalMessageCheckListener getTransactionalMessageCheckListener() {
        return this.transactionalMessageCheckListener;
    }

    public void setTransactionalMessageCheckListener(AbstractTransactionalMessageCheckListener transactionalMessageCheckListener) {
        this.transactionalMessageCheckListener = transactionalMessageCheckListener;
    }

    public BlockingQueue<Runnable> getEndTransactionThreadPoolQueue() {
        return this.endTransactionThreadPoolQueue;
    }

    public Map<Class, AccessValidator> getAccessValidatorMap() {
        return this.accessValidatorMap;
    }

    public ExecutorService getSendMessageExecutor() {
        return this.sendMessageExecutor;
    }

    public SendMessageProcessor getSendMessageProcessor() {
        return this.sendMessageProcessor;
    }

    public QueryAssignmentProcessor getQueryAssignmentProcessor() {
        return this.queryAssignmentProcessor;
    }

    public TopicQueueMappingCleanService getTopicQueueMappingCleanService() {
        return this.topicQueueMappingCleanService;
    }

    public ExecutorService getAdminBrokerExecutor() {
        return this.adminBrokerExecutor;
    }

    public BlockingQueue<Runnable> getLitePullThreadPoolQueue() {
        return this.litePullThreadPoolQueue;
    }

    public ShutdownHook getShutdownHook() {
        return this.shutdownHook;
    }

    public void setShutdownHook(ShutdownHook shutdownHook) {
        this.shutdownHook = shutdownHook;
    }

    public long getMinBrokerIdInGroup() {
        return this.brokerConfig.getBrokerId();
    }

    public BrokerController peekMasterBroker() {
        return this.brokerConfig.getBrokerId() == 0L ? this : null;
    }

    public BrokerMemberGroup getBrokerMemberGroup() {
        return this.brokerMemberGroup;
    }

    public int getListenPort() {
        return this.nettyServerConfig.getListenPort();
    }

    public List<BrokerAttachedPlugin> getBrokerAttachedPlugins() {
        return this.brokerAttachedPlugins;
    }

    public EscapeBridge getEscapeBridge() {
        return this.escapeBridge;
    }

    public long getShouldStartTime() {
        return this.shouldStartTime;
    }

    public BrokerPreOnlineService getBrokerPreOnlineService() {
        return this.brokerPreOnlineService;
    }

    public EndTransactionProcessor getEndTransactionProcessor() {
        return this.endTransactionProcessor;
    }

    public boolean isScheduleServiceStart() {
        return this.isScheduleServiceStart;
    }

    public boolean isTransactionCheckServiceStart() {
        return this.isTransactionCheckServiceStart;
    }

    public ScheduleMessageService getScheduleMessageService() {
        return this.scheduleMessageService;
    }

    public ReplicasManager getReplicasManager() {
        return this.replicasManager;
    }

    public void setIsolated(boolean isolated) {
        this.isIsolated = isolated;
    }

    public boolean isIsolated() {
        return this.isIsolated;
    }

    public TimerCheckpoint getTimerCheckpoint() {
        return this.timerCheckpoint;
    }

    public TopicRouteInfoManager getTopicRouteInfoManager() {
        return this.topicRouteInfoManager;
    }
}

