/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.util;

import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.logging.InternalLogger;

public class PerfCounter {
    private long last = System.currentTimeMillis();
    private float lastTps = 0.0f;
    private final ThreadLocal<AtomicLong> lastTickMs = new ThreadLocal<AtomicLong>(){

        @Override
        protected AtomicLong initialValue() {
            return new AtomicLong(System.currentTimeMillis());
        }
    };
    private final InternalLogger logger;
    private String prefix = "DEFAULT";
    private final AtomicInteger[] count;
    private final AtomicLong allCount;
    private final int maxNumPerCount;
    private final int maxTimeMsPerCount;

    public float getLastTps() {
        if (System.currentTimeMillis() - this.last <= (long)(this.maxTimeMsPerCount + 3000)) {
            return this.lastTps;
        }
        return 0.0f;
    }

    public PerfCounter() {
        this(5001, null, null, 1000000, 10000);
    }

    public PerfCounter(int slots, InternalLogger logger, String prefix, int maxNumPerCount, int maxTimeMsPerCount) {
        if (slots < 3000) {
            throw new RuntimeException("slots must bigger than 3000, but:%s" + slots);
        }
        this.count = new AtomicInteger[slots];
        this.allCount = new AtomicLong(0L);
        this.logger = logger;
        if (prefix != null) {
            this.prefix = prefix;
        }
        this.maxNumPerCount = maxNumPerCount;
        this.maxTimeMsPerCount = maxTimeMsPerCount;
        this.reset();
    }

    public void flow(long cost) {
        this.flow(cost, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flow(long cost, int num) {
        if (cost < 0L) {
            return;
        }
        this.allCount.addAndGet(num);
        this.count[this.getIndex(cost)].addAndGet(num);
        if (this.allCount.get() >= (long)this.maxNumPerCount || System.currentTimeMillis() - this.last >= (long)this.maxTimeMsPerCount) {
            AtomicLong atomicLong = this.allCount;
            synchronized (atomicLong) {
                if (this.allCount.get() < (long)this.maxNumPerCount && System.currentTimeMillis() - this.last < (long)this.maxTimeMsPerCount) {
                    return;
                }
                this.print();
                this.reset();
            }
        }
    }

    public void print() {
        int min = this.getMin();
        int max = this.getMax();
        int tp50 = this.getTPValue(0.5f);
        int tp80 = this.getTPValue(0.8f);
        int tp90 = this.getTPValue(0.9f);
        int tp99 = this.getTPValue(0.99f);
        int tp999 = this.getTPValue(0.999f);
        long count0t1 = this.getCount(0, 1);
        long count2t5 = this.getCount(2, 5);
        long count6t10 = this.getCount(6, 10);
        long count11t50 = this.getCount(11, 50);
        long count51t100 = this.getCount(51, 100);
        long count101t500 = this.getCount(101, 500);
        long count501t999 = this.getCount(501, 999);
        long count1000t = this.getCount(1000, 100000000);
        long elapsed = System.currentTimeMillis() - this.last;
        this.lastTps = ((float)this.allCount.get() + 0.1f) * 1000.0f / (float)elapsed;
        String str = String.format("PERF_COUNTER_%s[%s] num:%d cost:%d tps:%.4f min:%d max:%d tp50:%d tp80:%d tp90:%d tp99:%d tp999:%d 0_1:%d 2_5:%d 6_10:%d 11_50:%d 51_100:%d 101_500:%d 501_999:%d 1000_:%d", this.prefix, new Timestamp(System.currentTimeMillis()), this.allCount.get(), elapsed, Float.valueOf(this.lastTps), min, max, tp50, tp80, tp90, tp99, tp999, count0t1, count2t5, count6t10, count11t50, count51t100, count101t500, count501t999, count1000t);
        if (this.logger != null) {
            this.logger.info(str);
        }
    }

    private int getIndex(long cost) {
        if (cost < 1000L) {
            return (int)cost;
        }
        if (cost >= 1000L && cost < 11000L) {
            int units = (int)((cost - 1000L) / 10L);
            return 1000 + units;
        }
        int units = (int)((cost - 1000L - 10000L) / 100L);
        if ((units = 2000 + units) >= this.count.length) {
            units = this.count.length - 1;
        }
        return units;
    }

    private int convert(int index) {
        if (index < 1000) {
            return index;
        }
        if (index >= 1000 && index < 2000) {
            return (index - 1000) * 10 + 1000;
        }
        return (index - 2000) * 100 + 10000 + 1000;
    }

    public float getRate(int from, int to) {
        long tmp = this.getCount(from, to);
        return ((float)tmp + 0.0f) * 100.0f / (float)(this.allCount.get() + 1L);
    }

    public long getCount(int from, int to) {
        from = this.getIndex(from);
        to = this.getIndex(to);
        long tmp = 0L;
        for (int i = from; i <= to && i < this.count.length; ++i) {
            tmp += (long)this.count[i].get();
        }
        return tmp;
    }

    public int getTPValue(float ratio) {
        if (ratio <= 0.0f || ratio >= 1.0f) {
            ratio = 0.99f;
        }
        long num = (long)((float)this.allCount.get() * (1.0f - ratio));
        int tmp = 0;
        for (int i = this.count.length - 1; i > 0; --i) {
            if ((long)(tmp += this.count[i].get()) <= num) continue;
            return this.convert(i);
        }
        return 0;
    }

    public int getMin() {
        for (int i = 0; i < this.count.length; ++i) {
            if (this.count[i].get() <= 0) continue;
            return this.convert(i);
        }
        return 0;
    }

    public int getMax() {
        for (int i = this.count.length - 1; i > 0; --i) {
            if (this.count[i].get() <= 0) continue;
            return this.convert(i);
        }
        return 99999999;
    }

    public void reset() {
        for (int i = 0; i < this.count.length; ++i) {
            if (this.count[i] == null) {
                this.count[i] = new AtomicInteger(0);
                continue;
            }
            this.count[i].set(0);
        }
        this.allCount.set(0L);
        this.last = System.currentTimeMillis();
    }

    public void startTick() {
        this.lastTickMs.get().set(System.currentTimeMillis());
    }

    public void endTick() {
        this.flow(System.currentTimeMillis() - this.lastTickMs.get().get());
    }

    public static class Ticks
    extends ServiceThread {
        private final InternalLogger logger;
        private final Map<String, PerfCounter> perfs = new ConcurrentHashMap<String, PerfCounter>();
        private final Map<String, AtomicLong> keyFreqs = new ConcurrentHashMap<String, AtomicLong>();
        private final PerfCounter defaultPerf;
        private final AtomicLong defaultTime = new AtomicLong(System.currentTimeMillis());
        private final int maxKeyNumPerf;
        private final int maxKeyNumDebug;
        private final int maxNumPerCount;
        private final int maxTimeMsPerCount;

        public Ticks() {
            this(null, 1000000, 10000, 20000, 100000);
        }

        public Ticks(InternalLogger logger) {
            this(logger, 1000000, 10000, 20000, 100000);
        }

        public String getServiceName() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public Ticks(InternalLogger logger, int maxNumPerCount, int maxTimeMsPerCount, int maxKeyNumPerf, int maxKeyNumDebug) {
            this.logger = logger;
            this.maxNumPerCount = maxNumPerCount;
            this.maxTimeMsPerCount = maxTimeMsPerCount;
            this.maxKeyNumPerf = maxKeyNumPerf;
            this.maxKeyNumDebug = maxKeyNumDebug;
            this.defaultPerf = new PerfCounter(3001, logger, null, maxNumPerCount, maxTimeMsPerCount);
        }

        private PerfCounter makeSureExists(String key) {
            if (this.perfs.get(key) == null) {
                if (this.perfs.size() >= this.maxKeyNumPerf + 100) {
                    return this.defaultPerf;
                }
                this.perfs.put(key, new PerfCounter(3001, this.logger, key, this.maxNumPerCount, this.maxTimeMsPerCount));
            }
            return this.perfs.getOrDefault(key, this.defaultPerf);
        }

        public void startTick(String key) {
            try {
                this.makeSureExists(key).startTick();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void endTick(String key) {
            try {
                this.makeSureExists(key).endTick();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void flowOnce(String key, int cost) {
            try {
                this.makeSureExists(key).flow(cost);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public PerfCounter getCounter(String key) {
            try {
                return this.makeSureExists(key);
            }
            catch (Throwable ignored) {
                return this.defaultPerf;
            }
        }

        private AtomicLong makeSureDebugKeyExists(String key) {
            AtomicLong lastTimeMs = this.keyFreqs.get(key);
            if (null == lastTimeMs) {
                if (this.keyFreqs.size() >= this.maxKeyNumDebug + 100) {
                    return this.defaultTime;
                }
                lastTimeMs = new AtomicLong(0L);
                this.keyFreqs.put(key, lastTimeMs);
            }
            return this.keyFreqs.getOrDefault(key, this.defaultTime);
        }

        public boolean shouldDebugKeyAndTimeMs(String key, int intervalMs) {
            try {
                AtomicLong lastTimeMs = this.makeSureDebugKeyExists(key);
                if (System.currentTimeMillis() - lastTimeMs.get() > (long)intervalMs) {
                    lastTimeMs.set(System.currentTimeMillis());
                    return true;
                }
                return false;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        public void run() {
            this.logger.info("{} get started", (Object)this.getServiceName());
            while (!this.isStopped()) {
                try {
                    Object value;
                    Map.Entry<String, Object> entry;
                    long maxLiveTimeMs = this.maxTimeMsPerCount * 2 + 1000;
                    this.waitForRunning(maxLiveTimeMs);
                    if (this.perfs.size() >= this.maxKeyNumPerf || this.keyFreqs.size() >= this.maxKeyNumDebug) {
                        this.logger.warn("The key is full {}-{} {}-{}", new Object[]{this.perfs.size(), this.maxKeyNumPerf, this.keyFreqs.size(), this.maxKeyNumDebug});
                    }
                    Iterator<Map.Entry<String, Object>> it = this.perfs.entrySet().iterator();
                    while (it.hasNext()) {
                        entry = it.next();
                        value = entry.getValue();
                        if (System.currentTimeMillis() - ((PerfCounter)value).last <= maxLiveTimeMs) continue;
                        it.remove();
                    }
                    it = this.keyFreqs.entrySet().iterator();
                    while (it.hasNext()) {
                        entry = it.next();
                        value = (AtomicLong)entry.getValue();
                        if (System.currentTimeMillis() - ((AtomicLong)value).get() <= maxLiveTimeMs) continue;
                        it.remove();
                    }
                }
                catch (Exception e) {
                    this.logger.error("{} get unknown errror", (Object)this.getServiceName(), (Object)e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Throwable throwable) {}
                }
            }
            this.logger.info("{} get stopped", (Object)this.getServiceName());
        }
    }
}

