/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.export;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.protocol.body.BrokerStatsData;
import org.apache.rocketmq.common.protocol.body.ClusterInfo;
import org.apache.rocketmq.common.protocol.body.Connection;
import org.apache.rocketmq.common.protocol.body.ConsumerConnection;
import org.apache.rocketmq.common.protocol.body.KVTable;
import org.apache.rocketmq.common.protocol.body.SubscriptionGroupWrapper;
import org.apache.rocketmq.common.protocol.body.TopicConfigSerializeWrapper;
import org.apache.rocketmq.common.protocol.route.BrokerData;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;
import org.apache.rocketmq.tools.command.stats.StatsAllSubCommand;

public class ExportMetricsCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "exportMetrics";
    }

    @Override
    public String commandDesc() {
        return "Export metrics";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("c", "clusterName", true, "choose a cluster to export");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("f", "filePath", true, "export metrics.json path | default /tmp/rocketmq/export");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            String clusterName = commandLine.getOptionValue('c').trim();
            String filePath = !commandLine.hasOption('f') ? "/tmp/rocketmq/export" : commandLine.getOptionValue('f').trim();
            defaultMQAdminExt.start();
            HashMap evaluateReportMap = new HashMap();
            HashMap<String, Double> totalTpsMap = new HashMap<String, Double>();
            HashMap<String, Long> totalOneDayNumMap = new HashMap<String, Long>();
            this.initTotalMap(totalTpsMap, totalOneDayNumMap);
            ClusterInfo clusterInfoSerializeWrapper = defaultMQAdminExt.examineBrokerClusterInfo();
            Set brokerNameSet = (Set)clusterInfoSerializeWrapper.getClusterAddrTable().get(clusterName);
            for (String brokerName : brokerNameSet) {
                BrokerData brokerData = (BrokerData)clusterInfoSerializeWrapper.getBrokerAddrTable().get(brokerName);
                if (brokerData == null) continue;
                String addr = (String)brokerData.getBrokerAddrs().get(0L);
                KVTable kvTable = defaultMQAdminExt.fetchBrokerRuntimeStats(addr);
                Properties properties = defaultMQAdminExt.getBrokerConfig(addr);
                SubscriptionGroupWrapper subscriptionGroupWrapper = defaultMQAdminExt.getUserSubscriptionGroup(addr, 10000L);
                HashMap<String, Map<String, Object>> brokerInfo = new HashMap<String, Map<String, Object>>();
                brokerInfo.put("runtimeEnv", this.getRuntimeEnv(kvTable, properties));
                brokerInfo.put("runtimeQuota", this.getRuntimeQuota(kvTable, defaultMQAdminExt, addr, totalTpsMap, totalOneDayNumMap, subscriptionGroupWrapper));
                brokerInfo.put("runtimeVersion", this.getRuntimeVersion(defaultMQAdminExt, subscriptionGroupWrapper));
                evaluateReportMap.put(brokerName, brokerInfo);
            }
            String path = filePath + "/metrics.json";
            HashMap<String, HashMap<String, Number>> totalData = new HashMap<String, HashMap<String, Number>>();
            totalData.put("totalTps", totalTpsMap);
            totalData.put("totalOneDayNum", totalOneDayNumMap);
            HashMap<String, HashMap<String, HashMap<Object, Object>>> result = new HashMap<String, HashMap<String, HashMap<Object, Object>>>();
            result.put("evaluateReport", evaluateReportMap);
            result.put("totalData", totalData);
            MixAll.string2FileNotSafe((String)JSON.toJSONString(result, (boolean)true), (String)path);
            System.out.printf("export %s success", path);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }

    private Map<String, Object> getRuntimeVersion(DefaultMQAdminExt defaultMQAdminExt, SubscriptionGroupWrapper subscriptionGroupWrapper) {
        HashMap<String, Object> runtimeVersionMap = new HashMap<String, Object>();
        HashSet<String> clientInfoSet = new HashSet<String>();
        for (Map.Entry entry : subscriptionGroupWrapper.getSubscriptionGroupTable().entrySet()) {
            try {
                ConsumerConnection cc = defaultMQAdminExt.examineConsumerConnectionInfo(((SubscriptionGroupConfig)entry.getValue()).getGroupName());
                for (Connection conn : cc.getConnectionSet()) {
                    String clientInfo = conn.getLanguage() + "%" + MQVersion.getVersionDesc((int)conn.getVersion());
                    clientInfoSet.add(clientInfo);
                }
            }
            catch (Exception e) {
            }
        }
        runtimeVersionMap.put("rocketmqVersion", MQVersion.getVersionDesc((int)MQVersion.CURRENT_VERSION));
        runtimeVersionMap.put("clientInfo", clientInfoSet);
        return runtimeVersionMap;
    }

    private Map<String, Object> getRuntimeEnv(KVTable kvTable, Properties properties) {
        HashMap<String, Object> runtimeEnvMap = new HashMap<String, Object>();
        runtimeEnvMap.put("cpuNum", properties.getProperty("clientCallbackExecutorThreads"));
        runtimeEnvMap.put("totalMemKBytes", kvTable.getTable().get("totalMemKBytes"));
        return runtimeEnvMap;
    }

    private Map<String, Object> getRuntimeQuota(KVTable kvTable, DefaultMQAdminExt defaultMQAdminExt, String brokerAddr, Map<String, Double> totalTpsMap, Map<String, Long> totalOneDayNumMap, SubscriptionGroupWrapper subscriptionGroupWrapper) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        String[] outTpss;
        TopicConfigSerializeWrapper topicConfigSerializeWrapper = defaultMQAdminExt.getUserTopicConfig(brokerAddr, false, 10000L);
        BrokerStatsData transStatsData = null;
        try {
            transStatsData = defaultMQAdminExt.viewBrokerStatsData(brokerAddr, "TOPIC_PUT_NUMS", "RMQ_SYS_TRANS_HALF_TOPIC");
        }
        catch (MQClientException mQClientException) {
            // empty catch block
        }
        BrokerStatsData scheduleStatsData = null;
        try {
            scheduleStatsData = defaultMQAdminExt.viewBrokerStatsData(brokerAddr, "TOPIC_PUT_NUMS", "SCHEDULE_TOPIC_XXXX");
        }
        catch (MQClientException mQClientException) {
            // empty catch block
        }
        HashMap<String, Object> runtimeQuotaMap = new HashMap<String, Object>();
        HashMap diskRatioMap = new HashMap();
        diskRatioMap.put("commitLogDiskRatio", kvTable.getTable().get("commitLogDiskRatio"));
        diskRatioMap.put("consumeQueueDiskRatio", kvTable.getTable().get("consumeQueueDiskRatio"));
        runtimeQuotaMap.put("diskRatio", diskRatioMap);
        HashMap<String, Double> tpsMap = new HashMap<String, Double>();
        double normalInTps = 0.0;
        double normalOutTps = 0.0;
        String putTps = (String)kvTable.getTable().get("putTps");
        String getTransferredTps = (String)kvTable.getTable().get("getTransferredTps");
        String[] inTpss = putTps.split(" ");
        if (inTpss.length > 0) {
            normalInTps = Double.parseDouble(inTpss[0]);
        }
        if ((outTpss = getTransferredTps.split(" ")).length > 0) {
            normalOutTps = Double.parseDouble(outTpss[0]);
        }
        double transInTps = null != transStatsData ? transStatsData.getStatsMinute().getTps() : 0.0;
        double scheduleInTps = null != scheduleStatsData ? scheduleStatsData.getStatsMinute().getTps() : 0.0;
        long transOneDayInNum = null != transStatsData ? StatsAllSubCommand.compute24HourSum(transStatsData) : 0L;
        long scheduleOneDayInNum = null != scheduleStatsData ? StatsAllSubCommand.compute24HourSum(scheduleStatsData) : 0L;
        tpsMap.put("normalInTps", normalInTps);
        tpsMap.put("normalOutTps", normalOutTps);
        tpsMap.put("transInTps", transInTps);
        tpsMap.put("scheduleInTps", scheduleInTps);
        runtimeQuotaMap.put("tps", tpsMap);
        HashMap<String, Long> oneDayNumMap = new HashMap<String, Long>();
        long normalOneDayInNum = Long.parseLong((String)kvTable.getTable().get("msgPutTotalTodayMorning")) - Long.parseLong((String)kvTable.getTable().get("msgPutTotalYesterdayMorning"));
        long normalOneDayOutNum = Long.parseLong((String)kvTable.getTable().get("msgGetTotalTodayMorning")) - Long.parseLong((String)kvTable.getTable().get("msgGetTotalYesterdayMorning"));
        oneDayNumMap.put("normalOneDayInNum", normalOneDayInNum);
        oneDayNumMap.put("normalOneDayOutNum", normalOneDayOutNum);
        oneDayNumMap.put("transOneDayInNum", transOneDayInNum);
        oneDayNumMap.put("scheduleOneDayInNum", scheduleOneDayInNum);
        runtimeQuotaMap.put("oneDayNum", oneDayNumMap);
        totalTpsMap.put("totalNormalInTps", totalTpsMap.get("totalNormalInTps") + normalInTps);
        totalTpsMap.put("totalNormalOutTps", totalTpsMap.get("totalNormalOutTps") + normalOutTps);
        totalTpsMap.put("totalTransInTps", totalTpsMap.get("totalTransInTps") + transInTps);
        totalTpsMap.put("totalScheduleInTps", totalTpsMap.get("totalScheduleInTps") + scheduleInTps);
        totalOneDayNumMap.put("normalOneDayInNum", totalOneDayNumMap.get("normalOneDayInNum") + normalOneDayInNum);
        totalOneDayNumMap.put("normalOneDayOutNum", totalOneDayNumMap.get("normalOneDayOutNum") + normalOneDayOutNum);
        totalOneDayNumMap.put("transOneDayInNum", totalOneDayNumMap.get("transOneDayInNum") + transOneDayInNum);
        totalOneDayNumMap.put("scheduleOneDayInNum", totalOneDayNumMap.get("scheduleOneDayInNum") + scheduleOneDayInNum);
        runtimeQuotaMap.put("messageAverageSize", kvTable.getTable().get("putMessageAverageSize"));
        runtimeQuotaMap.put("topicSize", topicConfigSerializeWrapper.getTopicConfigTable().size());
        runtimeQuotaMap.put("groupSize", subscriptionGroupWrapper.getSubscriptionGroupTable().size());
        return runtimeQuotaMap;
    }

    private void initTotalMap(Map<String, Double> totalTpsMap, Map<String, Long> totalOneDayNumMap) {
        totalTpsMap.put("totalNormalInTps", 0.0);
        totalTpsMap.put("totalNormalOutTps", 0.0);
        totalTpsMap.put("totalTransInTps", 0.0);
        totalTpsMap.put("totalScheduleInTps", 0.0);
        totalOneDayNumMap.put("normalOneDayInNum", 0L);
        totalOneDayNumMap.put("normalOneDayOutNum", 0L);
        totalOneDayNumMap.put("transOneDayInNum", 0L);
        totalOneDayNumMap.put("scheduleOneDayInNum", 0L);
    }
}

