/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.net.URI;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.jms.Connection;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.CommonConnection;
import org.apache.qpid.client.ConnectAttemptListener;
import org.apache.qpid.client.ConnectionExtension;
import org.apache.qpid.client.ExtensibleConnectionURL;
import org.apache.qpid.jms.ConnectionURL;

public abstract class AbstractConnectionFactory {
    private final Map<ConnectionExtension, BiFunction<Connection, URI, Object>> _extensions = new EnumMap<ConnectionExtension, BiFunction<Connection, URI, Object>>(ConnectionExtension.class);
    private volatile ConnectAttemptListener _connectAttemptListener;

    public void setExtension(String extensionName, BiFunction<Connection, URI, Object> extension) {
        ConnectionExtension connectionExtension = ConnectionExtension.fromString(extensionName);
        if (extension == null) {
            this._extensions.remove((Object)connectionExtension);
        } else {
            this._extensions.put(connectionExtension, extension);
        }
    }

    public void setConnectAttemptListener(ConnectAttemptListener connectAttemptListener) {
        this._connectAttemptListener = connectAttemptListener;
    }

    protected CommonConnection newConnectionInstance(ConnectionURL connectionDetails) throws QpidException {
        return this.newAMQConnectionInstance(connectionDetails);
    }

    protected Map<ConnectionExtension, BiFunction<Connection, URI, Object>> getExtensions() {
        return new EnumMap<ConnectionExtension, BiFunction<Connection, URI, Object>>(this._extensions);
    }

    final AMQConnection newAMQConnectionInstance(ConnectionURL connectionDetails) throws QpidException {
        Map<ConnectionExtension, BiFunction<Connection, URI, Object>> extensions = this.getExtensions();
        ConnectionURL connectionURL = extensions.isEmpty() ? connectionDetails : new ExtensibleConnectionURL(connectionDetails, extensions);
        AMQConnection connection = new AMQConnection(connectionURL, this._connectAttemptListener);
        if (connectionURL instanceof ExtensibleConnectionURL) {
            ((ExtensibleConnectionURL)connectionURL).setConnectionSupplier(() -> connection);
        }
        return connection;
    }
}

