/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.EncodingUtils;
import org.apache.qpid.server.protocol.v0_8.FieldTable;
import org.apache.qpid.server.protocol.v0_8.transport.AMQFrame;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQVersionAwareProtocolSession;
import org.apache.qpid.server.transport.ByteBufferSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQMethodBodyImpl
implements AMQMethodBody {
    private static final Logger LOGGER = LoggerFactory.getLogger(AMQMethodBodyImpl.class);
    public static final byte TYPE = 1;

    @Override
    public byte getFrameType() {
        return 1;
    }

    protected abstract int getBodySize();

    @Override
    public AMQFrame generateFrame(int channelId) {
        return new AMQFrame(channelId, this);
    }

    @Override
    public void handle(int channelId, AMQVersionAwareProtocolSession session) throws QpidException {
        session.methodFrameReceived(channelId, this);
    }

    @Override
    public int getSize() {
        return 4 + this.getBodySize();
    }

    @Override
    public long writePayload(ByteBufferSender sender) {
        int size = this.getSize();
        try (QpidByteBuffer buf = QpidByteBuffer.allocate((boolean)sender.isDirectBufferPreferred(), (int)size);){
            buf.putUnsignedShort(this.getClazz());
            buf.putUnsignedShort(this.getMethod());
            this.writeMethodPayload(buf);
            buf.flip();
            sender.send(buf);
        }
        return size;
    }

    protected abstract void writeMethodPayload(QpidByteBuffer var1);

    protected int getSizeOf(AMQShortString string) {
        return EncodingUtils.encodedShortStringLength(string);
    }

    protected void writeByte(QpidByteBuffer buffer, byte b) {
        buffer.put(b);
    }

    protected void writeAMQShortString(QpidByteBuffer buffer, AMQShortString string) {
        EncodingUtils.writeShortStringBytes(buffer, string);
    }

    protected void writeInt(QpidByteBuffer buffer, int i) {
        buffer.putInt(i);
    }

    protected int getSizeOf(FieldTable table) {
        return EncodingUtils.encodedFieldTableLength(table);
    }

    protected void writeFieldTable(QpidByteBuffer buffer, FieldTable table) {
        EncodingUtils.writeFieldTableBytes(buffer, table);
    }

    protected void writeLong(QpidByteBuffer buffer, long l) {
        buffer.putLong(l);
    }

    protected int getSizeOf(byte[] response) {
        return response == null ? 4 : response.length + 4;
    }

    protected void writeBytes(QpidByteBuffer buffer, byte[] data) {
        EncodingUtils.writeBytes(buffer, data);
    }

    protected void writeShort(QpidByteBuffer buffer, short s) {
        buffer.putShort(s);
    }

    protected void writeBitfield(QpidByteBuffer buffer, byte bitfield0) {
        buffer.put(bitfield0);
    }

    protected void writeUnsignedShort(QpidByteBuffer buffer, int s) {
        buffer.putUnsignedShort(s);
    }

    protected void writeUnsignedInteger(QpidByteBuffer buffer, long i) {
        buffer.putUnsignedInt(i);
    }

    protected void writeUnsignedByte(QpidByteBuffer buffer, short unsignedByte) {
        buffer.putUnsignedByte(unsignedByte);
    }
}

