/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ContentFilterElementResult extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 606;
  }

  // Properties.
  protected final StatusCode statusCode;
  protected final List<StatusCode> operandStatusCodes;
  protected final List<DiagnosticInfo> operandDiagnosticInfos;

  public ContentFilterElementResult(
      StatusCode statusCode,
      List<StatusCode> operandStatusCodes,
      List<DiagnosticInfo> operandDiagnosticInfos) {
    super();
    this.statusCode = statusCode;
    this.operandStatusCodes = operandStatusCodes;
    this.operandDiagnosticInfos = operandDiagnosticInfos;
  }

  public StatusCode getStatusCode() {
    return statusCode;
  }

  public List<StatusCode> getOperandStatusCodes() {
    return operandStatusCodes;
  }

  public List<DiagnosticInfo> getOperandDiagnosticInfos() {
    return operandDiagnosticInfos;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ContentFilterElementResult");

    // Simple Field (statusCode)
    writeSimpleField("statusCode", statusCode, writeComplex(writeBuffer));

    // Implicit Field (noOfOperandStatusCodes) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfOperandStatusCodes =
        (int) ((((getOperandStatusCodes()) == (null)) ? -(1) : COUNT(getOperandStatusCodes())));
    writeImplicitField(
        "noOfOperandStatusCodes", noOfOperandStatusCodes, writeSignedInt(writeBuffer, 32));

    // Array Field (operandStatusCodes)
    writeComplexTypeArrayField("operandStatusCodes", operandStatusCodes, writeBuffer);

    // Implicit Field (noOfOperandDiagnosticInfos) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfOperandDiagnosticInfos =
        (int)
            ((((getOperandDiagnosticInfos()) == (null))
                ? -(1)
                : COUNT(getOperandDiagnosticInfos())));
    writeImplicitField(
        "noOfOperandDiagnosticInfos", noOfOperandDiagnosticInfos, writeSignedInt(writeBuffer, 32));

    // Array Field (operandDiagnosticInfos)
    writeComplexTypeArrayField("operandDiagnosticInfos", operandDiagnosticInfos, writeBuffer);

    writeBuffer.popContext("ContentFilterElementResult");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ContentFilterElementResult _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (statusCode)
    lengthInBits += statusCode.getLengthInBits();

    // Implicit Field (noOfOperandStatusCodes)
    lengthInBits += 32;

    // Array field
    if (operandStatusCodes != null) {
      int i = 0;
      for (StatusCode element : operandStatusCodes) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= operandStatusCodes.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfOperandDiagnosticInfos)
    lengthInBits += 32;

    // Array field
    if (operandDiagnosticInfos != null) {
      int i = 0;
      for (DiagnosticInfo element : operandDiagnosticInfos) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= operandDiagnosticInfos.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("ContentFilterElementResult");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    StatusCode statusCode =
        readSimpleField(
            "statusCode", readComplex(() -> StatusCode.staticParse(readBuffer), readBuffer));

    int noOfOperandStatusCodes =
        readImplicitField("noOfOperandStatusCodes", readSignedInt(readBuffer, 32));

    List<StatusCode> operandStatusCodes =
        readCountArrayField(
            "operandStatusCodes",
            readComplex(() -> StatusCode.staticParse(readBuffer), readBuffer),
            noOfOperandStatusCodes);

    int noOfOperandDiagnosticInfos =
        readImplicitField("noOfOperandDiagnosticInfos", readSignedInt(readBuffer, 32));

    List<DiagnosticInfo> operandDiagnosticInfos =
        readCountArrayField(
            "operandDiagnosticInfos",
            readComplex(() -> DiagnosticInfo.staticParse(readBuffer), readBuffer),
            noOfOperandDiagnosticInfos);

    readBuffer.closeContext("ContentFilterElementResult");
    // Create the instance
    return new ContentFilterElementResultBuilderImpl(
        statusCode, operandStatusCodes, operandDiagnosticInfos);
  }

  public static class ContentFilterElementResultBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final StatusCode statusCode;
    private final List<StatusCode> operandStatusCodes;
    private final List<DiagnosticInfo> operandDiagnosticInfos;

    public ContentFilterElementResultBuilderImpl(
        StatusCode statusCode,
        List<StatusCode> operandStatusCodes,
        List<DiagnosticInfo> operandDiagnosticInfos) {
      this.statusCode = statusCode;
      this.operandStatusCodes = operandStatusCodes;
      this.operandDiagnosticInfos = operandDiagnosticInfos;
    }

    public ContentFilterElementResult build() {
      ContentFilterElementResult contentFilterElementResult =
          new ContentFilterElementResult(statusCode, operandStatusCodes, operandDiagnosticInfos);
      return contentFilterElementResult;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ContentFilterElementResult)) {
      return false;
    }
    ContentFilterElementResult that = (ContentFilterElementResult) o;
    return (getStatusCode() == that.getStatusCode())
        && (getOperandStatusCodes() == that.getOperandStatusCodes())
        && (getOperandDiagnosticInfos() == that.getOperandDiagnosticInfos())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getStatusCode(), getOperandStatusCodes(), getOperandDiagnosticInfos());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
