/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class RegulatingStepCommand implements Message {

  // Properties.
  protected final QualifierOfCommand qoc;
  protected final byte rcs;

  public RegulatingStepCommand(QualifierOfCommand qoc, byte rcs) {
    super();
    this.qoc = qoc;
    this.rcs = rcs;
  }

  public QualifierOfCommand getQoc() {
    return qoc;
  }

  public byte getRcs() {
    return rcs;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("RegulatingStepCommand");

    // Simple Field (qoc)
    writeSimpleField(
        "qoc", qoc, writeComplex(writeBuffer), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (rcs)
    writeSimpleField(
        "rcs",
        rcs,
        writeUnsignedByte(writeBuffer, 2),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    writeBuffer.popContext("RegulatingStepCommand");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    RegulatingStepCommand _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (qoc)
    lengthInBits += qoc.getLengthInBits();

    // Simple field (rcs)
    lengthInBits += 2;

    return lengthInBits;
  }

  public static RegulatingStepCommand staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("RegulatingStepCommand");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    QualifierOfCommand qoc =
        readSimpleField(
            "qoc",
            readComplex(() -> QualifierOfCommand.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    byte rcs =
        readSimpleField(
            "rcs",
            readUnsignedByte(readBuffer, 2),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    readBuffer.closeContext("RegulatingStepCommand");
    // Create the instance
    RegulatingStepCommand _regulatingStepCommand;
    _regulatingStepCommand = new RegulatingStepCommand(qoc, rcs);
    return _regulatingStepCommand;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof RegulatingStepCommand)) {
      return false;
    }
    RegulatingStepCommand that = (RegulatingStepCommand) o;
    return (getQoc() == that.getQoc()) && (getRcs() == that.getRcs()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getQoc(), getRcs());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
