/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class EipConstants implements Message {

  // Constant values.
  public static final Integer EIPUDPDISCOVERYDEFAULTPORT = 44818;
  public static final Integer EIPTCPDEFAULTPORT = 44818;

  public EipConstants() {
    super();
  }

  public int getEipUdpDiscoveryDefaultPort() {
    return EIPUDPDISCOVERYDEFAULTPORT;
  }

  public int getEipTcpDefaultPort() {
    return EIPTCPDEFAULTPORT;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("EipConstants");

    // Const Field (eipUdpDiscoveryDefaultPort)
    writeConstField(
        "eipUdpDiscoveryDefaultPort",
        EIPUDPDISCOVERYDEFAULTPORT,
        writeUnsignedInt(writeBuffer, 16));

    // Const Field (eipTcpDefaultPort)
    writeConstField("eipTcpDefaultPort", EIPTCPDEFAULTPORT, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("EipConstants");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    EipConstants _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (eipUdpDiscoveryDefaultPort)
    lengthInBits += 16;

    // Const Field (eipTcpDefaultPort)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static EipConstants staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("EipConstants");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int eipUdpDiscoveryDefaultPort =
        readConstField(
            "eipUdpDiscoveryDefaultPort",
            readUnsignedInt(readBuffer, 16),
            EipConstants.EIPUDPDISCOVERYDEFAULTPORT);

    int eipTcpDefaultPort =
        readConstField(
            "eipTcpDefaultPort", readUnsignedInt(readBuffer, 16), EipConstants.EIPTCPDEFAULTPORT);

    readBuffer.closeContext("EipConstants");
    // Create the instance
    EipConstants _eipConstants;
    _eipConstants = new EipConstants();
    return _eipConstants;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof EipConstants)) {
      return false;
    }
    EipConstants that = (EipConstants) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
