/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetServiceAckGetEventInformation extends BACnetServiceAck implements Message {

  // Accessors for discriminator values.
  public BACnetConfirmedServiceChoice getServiceChoice() {
    return BACnetConfirmedServiceChoice.GET_EVENT_INFORMATION;
  }

  // Properties.
  protected final BACnetEventSummariesList listOfEventSummaries;
  protected final BACnetContextTagBoolean moreEvents;

  // Arguments.
  protected final Long serviceAckLength;

  public BACnetServiceAckGetEventInformation(
      BACnetEventSummariesList listOfEventSummaries,
      BACnetContextTagBoolean moreEvents,
      Long serviceAckLength) {
    super(serviceAckLength);
    this.listOfEventSummaries = listOfEventSummaries;
    this.moreEvents = moreEvents;
    this.serviceAckLength = serviceAckLength;
  }

  public BACnetEventSummariesList getListOfEventSummaries() {
    return listOfEventSummaries;
  }

  public BACnetContextTagBoolean getMoreEvents() {
    return moreEvents;
  }

  @Override
  protected void serializeBACnetServiceAckChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetServiceAckGetEventInformation");

    // Simple Field (listOfEventSummaries)
    writeSimpleField("listOfEventSummaries", listOfEventSummaries, writeComplex(writeBuffer));

    // Simple Field (moreEvents)
    writeSimpleField("moreEvents", moreEvents, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetServiceAckGetEventInformation");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetServiceAckGetEventInformation _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (listOfEventSummaries)
    lengthInBits += listOfEventSummaries.getLengthInBits();

    // Simple field (moreEvents)
    lengthInBits += moreEvents.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetServiceAckBuilder staticParseBACnetServiceAckBuilder(
      ReadBuffer readBuffer, Long serviceAckLength) throws ParseException {
    readBuffer.pullContext("BACnetServiceAckGetEventInformation");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetEventSummariesList listOfEventSummaries =
        readSimpleField(
            "listOfEventSummaries",
            readComplex(
                () -> BACnetEventSummariesList.staticParse(readBuffer, (short) (0)), readBuffer));

    BACnetContextTagBoolean moreEvents =
        readSimpleField(
            "moreEvents",
            readComplex(
                () ->
                    (BACnetContextTagBoolean)
                        BACnetContextTag.staticParse(
                            readBuffer, (short) (1), (BACnetDataType) (BACnetDataType.BOOLEAN)),
                readBuffer));

    readBuffer.closeContext("BACnetServiceAckGetEventInformation");
    // Create the instance
    return new BACnetServiceAckGetEventInformationBuilderImpl(
        listOfEventSummaries, moreEvents, serviceAckLength);
  }

  public static class BACnetServiceAckGetEventInformationBuilderImpl
      implements BACnetServiceAck.BACnetServiceAckBuilder {
    private final BACnetEventSummariesList listOfEventSummaries;
    private final BACnetContextTagBoolean moreEvents;
    private final Long serviceAckLength;

    public BACnetServiceAckGetEventInformationBuilderImpl(
        BACnetEventSummariesList listOfEventSummaries,
        BACnetContextTagBoolean moreEvents,
        Long serviceAckLength) {
      this.listOfEventSummaries = listOfEventSummaries;
      this.moreEvents = moreEvents;
      this.serviceAckLength = serviceAckLength;
    }

    public BACnetServiceAckGetEventInformation build(Long serviceAckLength) {

      BACnetServiceAckGetEventInformation bACnetServiceAckGetEventInformation =
          new BACnetServiceAckGetEventInformation(
              listOfEventSummaries, moreEvents, serviceAckLength);
      return bACnetServiceAckGetEventInformation;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetServiceAckGetEventInformation)) {
      return false;
    }
    BACnetServiceAckGetEventInformation that = (BACnetServiceAckGetEventInformation) o;
    return (getListOfEventSummaries() == that.getListOfEventSummaries())
        && (getMoreEvents() == that.getMoreEvents())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getListOfEventSummaries(), getMoreEvents());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
