/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesMethod is an enum
type OpcuaNodeIdServicesMethod int32

type IOpcuaNodeIdServicesMethod interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesMethod_ProgramStateMachineType_Start                                                                                                                            OpcuaNodeIdServicesMethod = 2426
	OpcuaNodeIdServicesMethod_ProgramStateMachineType_Suspend                                                                                                                          OpcuaNodeIdServicesMethod = 2427
	OpcuaNodeIdServicesMethod_ProgramStateMachineType_Resume                                                                                                                           OpcuaNodeIdServicesMethod = 2428
	OpcuaNodeIdServicesMethod_ProgramStateMachineType_Halt                                                                                                                             OpcuaNodeIdServicesMethod = 2429
	OpcuaNodeIdServicesMethod_ProgramStateMachineType_Reset                                                                                                                            OpcuaNodeIdServicesMethod = 2430
	OpcuaNodeIdServicesMethod_ShelvedStateMachineType_Unshelve                                                                                                                         OpcuaNodeIdServicesMethod = 2947
	OpcuaNodeIdServicesMethod_ShelvedStateMachineType_OneShotShelve                                                                                                                    OpcuaNodeIdServicesMethod = 2948
	OpcuaNodeIdServicesMethod_ShelvedStateMachineType_TimedShelve                                                                                                                      OpcuaNodeIdServicesMethod = 2949
	OpcuaNodeIdServicesMethod_AddCommentMethodType                                                                                                                                     OpcuaNodeIdServicesMethod = 3863
	OpcuaNodeIdServicesMethod_ConditionType_ConditionRefresh                                                                                                                           OpcuaNodeIdServicesMethod = 3875
	OpcuaNodeIdServicesMethod_TimedShelveMethodType                                                                                                                                    OpcuaNodeIdServicesMethod = 6102
	OpcuaNodeIdServicesMethod_ConditionRefreshMethodType                                                                                                                               OpcuaNodeIdServicesMethod = 9007
	OpcuaNodeIdServicesMethod_ConditionType_Enable                                                                                                                                     OpcuaNodeIdServicesMethod = 9027
	OpcuaNodeIdServicesMethod_ConditionType_Disable                                                                                                                                    OpcuaNodeIdServicesMethod = 9028
	OpcuaNodeIdServicesMethod_ConditionType_AddComment                                                                                                                                 OpcuaNodeIdServicesMethod = 9029
	OpcuaNodeIdServicesMethod_DialogResponseMethodType                                                                                                                                 OpcuaNodeIdServicesMethod = 9031
	OpcuaNodeIdServicesMethod_DialogConditionType_Respond                                                                                                                              OpcuaNodeIdServicesMethod = 9069
	OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Acknowledge                                                                                                                 OpcuaNodeIdServicesMethod = 9111
	OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Confirm                                                                                                                     OpcuaNodeIdServicesMethod = 9113
	OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_Unshelve                                                                                                                OpcuaNodeIdServicesMethod = 9211
	OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_OneShotShelve                                                                                                           OpcuaNodeIdServicesMethod = 9212
	OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_TimedShelve                                                                                                             OpcuaNodeIdServicesMethod = 9213
	OpcuaNodeIdServicesMethod_ServerType_GetMonitoredItems                                                                                                                             OpcuaNodeIdServicesMethod = 11489
	OpcuaNodeIdServicesMethod_Server_GetMonitoredItems                                                                                                                                 OpcuaNodeIdServicesMethod = 11492
	OpcuaNodeIdServicesMethod_GetMonitoredItemsMethodType                                                                                                                              OpcuaNodeIdServicesMethod = 11495
	OpcuaNodeIdServicesMethod_FileType_Open                                                                                                                                            OpcuaNodeIdServicesMethod = 11580
	OpcuaNodeIdServicesMethod_FileType_Close                                                                                                                                           OpcuaNodeIdServicesMethod = 11583
	OpcuaNodeIdServicesMethod_FileType_Read                                                                                                                                            OpcuaNodeIdServicesMethod = 11585
	OpcuaNodeIdServicesMethod_FileType_Write                                                                                                                                           OpcuaNodeIdServicesMethod = 11588
	OpcuaNodeIdServicesMethod_FileType_GetPosition                                                                                                                                     OpcuaNodeIdServicesMethod = 11590
	OpcuaNodeIdServicesMethod_FileType_SetPosition                                                                                                                                     OpcuaNodeIdServicesMethod = 11593
	OpcuaNodeIdServicesMethod_AddressSpaceFileType_ExportNamespace                                                                                                                     OpcuaNodeIdServicesMethod = 11615
	OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Open                                                                                                                 OpcuaNodeIdServicesMethod = 11629
	OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Close                                                                                                                OpcuaNodeIdServicesMethod = 11632
	OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Read                                                                                                                 OpcuaNodeIdServicesMethod = 11634
	OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Write                                                                                                                OpcuaNodeIdServicesMethod = 11637
	OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_GetPosition                                                                                                          OpcuaNodeIdServicesMethod = 11639
	OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_SetPosition                                                                                                          OpcuaNodeIdServicesMethod = 11642
	OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_ExportNamespace                                                                                                      OpcuaNodeIdServicesMethod = 11644
	OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open                                                                                        OpcuaNodeIdServicesMethod = 11659
	OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close                                                                                       OpcuaNodeIdServicesMethod = 11662
	OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read                                                                                        OpcuaNodeIdServicesMethod = 11664
	OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write                                                                                       OpcuaNodeIdServicesMethod = 11667
	OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition                                                                                 OpcuaNodeIdServicesMethod = 11669
	OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition                                                                                 OpcuaNodeIdServicesMethod = 11672
	OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_ExportNamespace                                                                             OpcuaNodeIdServicesMethod = 11674
	OpcuaNodeIdServicesMethod_OpenMethodType                                                                                                                                           OpcuaNodeIdServicesMethod = 11738
	OpcuaNodeIdServicesMethod_CloseMethodType                                                                                                                                          OpcuaNodeIdServicesMethod = 11741
	OpcuaNodeIdServicesMethod_ReadMethodType                                                                                                                                           OpcuaNodeIdServicesMethod = 11743
	OpcuaNodeIdServicesMethod_WriteMethodType                                                                                                                                          OpcuaNodeIdServicesMethod = 11746
	OpcuaNodeIdServicesMethod_GetPositionMethodType                                                                                                                                    OpcuaNodeIdServicesMethod = 11748
	OpcuaNodeIdServicesMethod_SetPositionMethodType                                                                                                                                    OpcuaNodeIdServicesMethod = 11751
	OpcuaNodeIdServicesMethod_OpenWithMasksMethodType                                                                                                                                  OpcuaNodeIdServicesMethod = 12513
	OpcuaNodeIdServicesMethod_CloseAndUpdateMethodType                                                                                                                                 OpcuaNodeIdServicesMethod = 12516
	OpcuaNodeIdServicesMethod_AddCertificateMethodType                                                                                                                                 OpcuaNodeIdServicesMethod = 12518
	OpcuaNodeIdServicesMethod_RemoveCertificateMethodType                                                                                                                              OpcuaNodeIdServicesMethod = 12520
	OpcuaNodeIdServicesMethod_TrustListType_OpenWithMasks                                                                                                                              OpcuaNodeIdServicesMethod = 12543
	OpcuaNodeIdServicesMethod_TrustListType_CloseAndUpdate                                                                                                                             OpcuaNodeIdServicesMethod = 12546
	OpcuaNodeIdServicesMethod_TrustListType_AddCertificate                                                                                                                             OpcuaNodeIdServicesMethod = 12548
	OpcuaNodeIdServicesMethod_TrustListType_RemoveCertificate                                                                                                                          OpcuaNodeIdServicesMethod = 12550
	OpcuaNodeIdServicesMethod_UpdateCertificateMethodType                                                                                                                              OpcuaNodeIdServicesMethod = 12578
	OpcuaNodeIdServicesMethod_ServerConfigurationType_UpdateCertificate                                                                                                                OpcuaNodeIdServicesMethod = 12616
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open                                                                             OpcuaNodeIdServicesMethod = 12647
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close                                                                            OpcuaNodeIdServicesMethod = 12650
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read                                                                             OpcuaNodeIdServicesMethod = 12652
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write                                                                            OpcuaNodeIdServicesMethod = 12655
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition                                                                      OpcuaNodeIdServicesMethod = 12657
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition                                                                      OpcuaNodeIdServicesMethod = 12660
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks                                                                    OpcuaNodeIdServicesMethod = 12663
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate                                                                   OpcuaNodeIdServicesMethod = 12666
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate                                                                   OpcuaNodeIdServicesMethod = 12668
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate                                                                OpcuaNodeIdServicesMethod = 12670
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CreateSigningRequest                                                                                                             OpcuaNodeIdServicesMethod = 12731
	OpcuaNodeIdServicesMethod_ServerConfigurationType_ApplyChanges                                                                                                                     OpcuaNodeIdServicesMethod = 12734
	OpcuaNodeIdServicesMethod_ServerConfiguration_CreateSigningRequest                                                                                                                 OpcuaNodeIdServicesMethod = 12737
	OpcuaNodeIdServicesMethod_ServerConfiguration_ApplyChanges                                                                                                                         OpcuaNodeIdServicesMethod = 12740
	OpcuaNodeIdServicesMethod_CreateSigningRequestMethodType                                                                                                                           OpcuaNodeIdServicesMethod = 12741
	OpcuaNodeIdServicesMethod_ServerType_SetSubscriptionDurable                                                                                                                        OpcuaNodeIdServicesMethod = 12746
	OpcuaNodeIdServicesMethod_Server_SetSubscriptionDurable                                                                                                                            OpcuaNodeIdServicesMethod = 12749
	OpcuaNodeIdServicesMethod_SetSubscriptionDurableMethodType                                                                                                                         OpcuaNodeIdServicesMethod = 12752
	OpcuaNodeIdServicesMethod_GetRejectedListMethodType                                                                                                                                OpcuaNodeIdServicesMethod = 12773
	OpcuaNodeIdServicesMethod_ServerConfigurationType_GetRejectedList                                                                                                                  OpcuaNodeIdServicesMethod = 12775
	OpcuaNodeIdServicesMethod_ServerConfiguration_GetRejectedList                                                                                                                      OpcuaNodeIdServicesMethod = 12777
	OpcuaNodeIdServicesMethod_ServerType_ResendData                                                                                                                                    OpcuaNodeIdServicesMethod = 12871
	OpcuaNodeIdServicesMethod_Server_ResendData                                                                                                                                        OpcuaNodeIdServicesMethod = 12873
	OpcuaNodeIdServicesMethod_ResendDataMethodType                                                                                                                                     OpcuaNodeIdServicesMethod = 12875
	OpcuaNodeIdServicesMethod_ServerType_RequestServerStateChange                                                                                                                      OpcuaNodeIdServicesMethod = 12883
	OpcuaNodeIdServicesMethod_Server_RequestServerStateChange                                                                                                                          OpcuaNodeIdServicesMethod = 12886
	OpcuaNodeIdServicesMethod_RequestServerStateChangeMethodType                                                                                                                       OpcuaNodeIdServicesMethod = 12888
	OpcuaNodeIdServicesMethod_ConditionType_ConditionRefresh2                                                                                                                          OpcuaNodeIdServicesMethod = 12912
	OpcuaNodeIdServicesMethod_ConditionRefresh2MethodType                                                                                                                              OpcuaNodeIdServicesMethod = 12914
	OpcuaNodeIdServicesMethod_CreateDirectoryMethodType                                                                                                                                OpcuaNodeIdServicesMethod = 13342
	OpcuaNodeIdServicesMethod_CreateFileMethodType                                                                                                                                     OpcuaNodeIdServicesMethod = 13345
	OpcuaNodeIdServicesMethod_DeleteFileMethodType                                                                                                                                     OpcuaNodeIdServicesMethod = 13348
	OpcuaNodeIdServicesMethod_MoveOrCopyMethodType                                                                                                                                     OpcuaNodeIdServicesMethod = 13350
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory                                                                                          OpcuaNodeIdServicesMethod = 13355
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile                                                                                               OpcuaNodeIdServicesMethod = 13358
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy                                                                                               OpcuaNodeIdServicesMethod = 13363
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Open                                                                                                              OpcuaNodeIdServicesMethod = 13372
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Close                                                                                                             OpcuaNodeIdServicesMethod = 13375
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Read                                                                                                              OpcuaNodeIdServicesMethod = 13377
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Write                                                                                                             OpcuaNodeIdServicesMethod = 13380
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_GetPosition                                                                                                       OpcuaNodeIdServicesMethod = 13382
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_SetPosition                                                                                                       OpcuaNodeIdServicesMethod = 13385
	OpcuaNodeIdServicesMethod_FileDirectoryType_CreateDirectory                                                                                                                        OpcuaNodeIdServicesMethod = 13387
	OpcuaNodeIdServicesMethod_FileDirectoryType_CreateFile                                                                                                                             OpcuaNodeIdServicesMethod = 13390
	OpcuaNodeIdServicesMethod_FileDirectoryType_DeleteFileSystemObject                                                                                                                 OpcuaNodeIdServicesMethod = 13393
	OpcuaNodeIdServicesMethod_FileDirectoryType_MoveOrCopy                                                                                                                             OpcuaNodeIdServicesMethod = 13395
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Open                                                                                                                      OpcuaNodeIdServicesMethod = 13605
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Close                                                                                                                     OpcuaNodeIdServicesMethod = 13608
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Read                                                                                                                      OpcuaNodeIdServicesMethod = 13610
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Write                                                                                                                     OpcuaNodeIdServicesMethod = 13613
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_GetPosition                                                                                                               OpcuaNodeIdServicesMethod = 13615
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_SetPosition                                                                                                               OpcuaNodeIdServicesMethod = 13618
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_OpenWithMasks                                                                                                             OpcuaNodeIdServicesMethod = 13621
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_CloseAndUpdate                                                                                                            OpcuaNodeIdServicesMethod = 13624
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_AddCertificate                                                                                                            OpcuaNodeIdServicesMethod = 13627
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_RemoveCertificate                                                                                                         OpcuaNodeIdServicesMethod = 13629
	OpcuaNodeIdServicesMethod_ServerConfiguration_UpdateCertificate                                                                                                                    OpcuaNodeIdServicesMethod = 13737
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open                                                                                        OpcuaNodeIdServicesMethod = 13821
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close                                                                                       OpcuaNodeIdServicesMethod = 13824
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read                                                                                        OpcuaNodeIdServicesMethod = 13826
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write                                                                                       OpcuaNodeIdServicesMethod = 13829
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition                                                                                 OpcuaNodeIdServicesMethod = 13831
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition                                                                                 OpcuaNodeIdServicesMethod = 13834
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks                                                                               OpcuaNodeIdServicesMethod = 13837
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate                                                                              OpcuaNodeIdServicesMethod = 13840
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate                                                                              OpcuaNodeIdServicesMethod = 13843
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate                                                                           OpcuaNodeIdServicesMethod = 13845
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open                                                                                              OpcuaNodeIdServicesMethod = 13855
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close                                                                                             OpcuaNodeIdServicesMethod = 13858
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read                                                                                              OpcuaNodeIdServicesMethod = 13860
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write                                                                                             OpcuaNodeIdServicesMethod = 13863
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition                                                                                       OpcuaNodeIdServicesMethod = 13865
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition                                                                                       OpcuaNodeIdServicesMethod = 13868
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks                                                                                     OpcuaNodeIdServicesMethod = 13871
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate                                                                                    OpcuaNodeIdServicesMethod = 13874
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate                                                                                    OpcuaNodeIdServicesMethod = 13877
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate                                                                                 OpcuaNodeIdServicesMethod = 13879
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open                                                                                          OpcuaNodeIdServicesMethod = 13889
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close                                                                                         OpcuaNodeIdServicesMethod = 13892
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read                                                                                          OpcuaNodeIdServicesMethod = 13894
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write                                                                                         OpcuaNodeIdServicesMethod = 13897
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition                                                                                   OpcuaNodeIdServicesMethod = 13899
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition                                                                                   OpcuaNodeIdServicesMethod = 13902
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks                                                                                 OpcuaNodeIdServicesMethod = 13905
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate                                                                                OpcuaNodeIdServicesMethod = 13908
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate                                                                                OpcuaNodeIdServicesMethod = 13911
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate                                                                             OpcuaNodeIdServicesMethod = 13913
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open                                                                                    OpcuaNodeIdServicesMethod = 13923
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close                                                                                   OpcuaNodeIdServicesMethod = 13926
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read                                                                                    OpcuaNodeIdServicesMethod = 13928
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write                                                                                   OpcuaNodeIdServicesMethod = 13931
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition                                                                             OpcuaNodeIdServicesMethod = 13933
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition                                                                             OpcuaNodeIdServicesMethod = 13936
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks                                                                           OpcuaNodeIdServicesMethod = 13939
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate                                                                          OpcuaNodeIdServicesMethod = 13942
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate                                                                          OpcuaNodeIdServicesMethod = 13945
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate                                                                       OpcuaNodeIdServicesMethod = 13947
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open                                                                         OpcuaNodeIdServicesMethod = 13958
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close                                                                        OpcuaNodeIdServicesMethod = 13961
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read                                                                         OpcuaNodeIdServicesMethod = 13963
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write                                                                        OpcuaNodeIdServicesMethod = 13966
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition                                                                  OpcuaNodeIdServicesMethod = 13968
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition                                                                  OpcuaNodeIdServicesMethod = 13971
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks                                                                OpcuaNodeIdServicesMethod = 13974
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate                                                               OpcuaNodeIdServicesMethod = 13977
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate                                                               OpcuaNodeIdServicesMethod = 13980
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate                                                            OpcuaNodeIdServicesMethod = 13982
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open                                                                               OpcuaNodeIdServicesMethod = 13992
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close                                                                              OpcuaNodeIdServicesMethod = 13995
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read                                                                               OpcuaNodeIdServicesMethod = 13997
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write                                                                              OpcuaNodeIdServicesMethod = 14000
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition                                                                        OpcuaNodeIdServicesMethod = 14002
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition                                                                        OpcuaNodeIdServicesMethod = 14005
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks                                                                      OpcuaNodeIdServicesMethod = 14008
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate                                                                     OpcuaNodeIdServicesMethod = 14011
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate                                                                     OpcuaNodeIdServicesMethod = 14014
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate                                                                  OpcuaNodeIdServicesMethod = 14016
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open                                                                           OpcuaNodeIdServicesMethod = 14026
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close                                                                          OpcuaNodeIdServicesMethod = 14029
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read                                                                           OpcuaNodeIdServicesMethod = 14031
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write                                                                          OpcuaNodeIdServicesMethod = 14034
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition                                                                    OpcuaNodeIdServicesMethod = 14036
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition                                                                    OpcuaNodeIdServicesMethod = 14039
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks                                                                  OpcuaNodeIdServicesMethod = 14042
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate                                                                 OpcuaNodeIdServicesMethod = 14045
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate                                                                 OpcuaNodeIdServicesMethod = 14048
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate                                                              OpcuaNodeIdServicesMethod = 14050
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open                                                                                   OpcuaNodeIdServicesMethod = 14095
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close                                                                                  OpcuaNodeIdServicesMethod = 14098
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read                                                                                   OpcuaNodeIdServicesMethod = 14100
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write                                                                                  OpcuaNodeIdServicesMethod = 14103
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition                                                                            OpcuaNodeIdServicesMethod = 14105
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition                                                                            OpcuaNodeIdServicesMethod = 14108
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks                                                                          OpcuaNodeIdServicesMethod = 14111
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate                                                                         OpcuaNodeIdServicesMethod = 14114
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate                                                                         OpcuaNodeIdServicesMethod = 14117
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate                                                                      OpcuaNodeIdServicesMethod = 14119
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open                                                                               OpcuaNodeIdServicesMethod = 14129
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close                                                                              OpcuaNodeIdServicesMethod = 14132
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read                                                                               OpcuaNodeIdServicesMethod = 14134
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write                                                                              OpcuaNodeIdServicesMethod = 14137
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition                                                                        OpcuaNodeIdServicesMethod = 14139
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition                                                                        OpcuaNodeIdServicesMethod = 14142
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks                                                                      OpcuaNodeIdServicesMethod = 14145
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate                                                                     OpcuaNodeIdServicesMethod = 14148
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate                                                                     OpcuaNodeIdServicesMethod = 14151
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate                                                                  OpcuaNodeIdServicesMethod = 14153
	OpcuaNodeIdServicesMethod_RemoveConnectionMethodType                                                                                                                               OpcuaNodeIdServicesMethod = 14183
	OpcuaNodeIdServicesMethod_PubSubConnectionType_RemoveGroup                                                                                                                         OpcuaNodeIdServicesMethod = 14225
	OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Status_Enable                                                                                            OpcuaNodeIdServicesMethod = 14421
	OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Status_Disable                                                                                           OpcuaNodeIdServicesMethod = 14422
	OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup                                                                                              OpcuaNodeIdServicesMethod = 14424
	OpcuaNodeIdServicesMethod_PublishSubscribeType_RemoveConnection                                                                                                                    OpcuaNodeIdServicesMethod = 14432
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems                                                                                             OpcuaNodeIdServicesMethod = 14435
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedEvents                                                                                                OpcuaNodeIdServicesMethod = 14438
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet                                                                                            OpcuaNodeIdServicesMethod = 14441
	OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems                                                                                    OpcuaNodeIdServicesMethod = 14479
	OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents                                                                                       OpcuaNodeIdServicesMethod = 14482
	OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet                                                                                   OpcuaNodeIdServicesMethod = 14485
	OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedDataItems                                                                                                                  OpcuaNodeIdServicesMethod = 14493
	OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedEvents                                                                                                                     OpcuaNodeIdServicesMethod = 14496
	OpcuaNodeIdServicesMethod_DataSetFolderType_RemovePublishedDataSet                                                                                                                 OpcuaNodeIdServicesMethod = 14499
	OpcuaNodeIdServicesMethod_AddPublishedDataItemsMethodType                                                                                                                          OpcuaNodeIdServicesMethod = 14501
	OpcuaNodeIdServicesMethod_AddPublishedEventsMethodType                                                                                                                             OpcuaNodeIdServicesMethod = 14504
	OpcuaNodeIdServicesMethod_RemovePublishedDataSetMethodType                                                                                                                         OpcuaNodeIdServicesMethod = 14507
	OpcuaNodeIdServicesMethod_PublishedDataItemsType_AddVariables                                                                                                                      OpcuaNodeIdServicesMethod = 14555
	OpcuaNodeIdServicesMethod_PublishedDataItemsType_RemoveVariables                                                                                                                   OpcuaNodeIdServicesMethod = 14558
	OpcuaNodeIdServicesMethod_PublishedDataItemsAddVariablesMethodType                                                                                                                 OpcuaNodeIdServicesMethod = 14564
	OpcuaNodeIdServicesMethod_PublishedDataItemsRemoveVariablesMethodType                                                                                                              OpcuaNodeIdServicesMethod = 14567
	OpcuaNodeIdServicesMethod_PubSubConnectionType_Status_Enable                                                                                                                       OpcuaNodeIdServicesMethod = 14602
	OpcuaNodeIdServicesMethod_PubSubConnectionType_Status_Disable                                                                                                                      OpcuaNodeIdServicesMethod = 14603
	OpcuaNodeIdServicesMethod_PubSubConnectionTypeRemoveGroupMethodType                                                                                                                OpcuaNodeIdServicesMethod = 14604
	OpcuaNodeIdServicesMethod_PubSubGroupTypeRemoveWriterMethodType                                                                                                                    OpcuaNodeIdServicesMethod = 14623
	OpcuaNodeIdServicesMethod_PubSubGroupTypeRemoveReaderMethodType                                                                                                                    OpcuaNodeIdServicesMethod = 14625
	OpcuaNodeIdServicesMethod_PubSubStatusType_Enable                                                                                                                                  OpcuaNodeIdServicesMethod = 14645
	OpcuaNodeIdServicesMethod_PubSubStatusType_Disable                                                                                                                                 OpcuaNodeIdServicesMethod = 14646
	OpcuaNodeIdServicesMethod_PublishedEventsType_ModifyFieldSelection                                                                                                                 OpcuaNodeIdServicesMethod = 15052
	OpcuaNodeIdServicesMethod_PublishedEventsTypeModifyFieldSelectionMethodType                                                                                                        OpcuaNodeIdServicesMethod = 15054
	OpcuaNodeIdServicesMethod_TargetVariablesType_AddTargetVariables                                                                                                                   OpcuaNodeIdServicesMethod = 15115
	OpcuaNodeIdServicesMethod_TargetVariablesType_RemoveTargetVariables                                                                                                                OpcuaNodeIdServicesMethod = 15118
	OpcuaNodeIdServicesMethod_TargetVariablesTypeAddTargetVariablesMethodType                                                                                                          OpcuaNodeIdServicesMethod = 15121
	OpcuaNodeIdServicesMethod_TargetVariablesTypeRemoveTargetVariablesMethodType                                                                                                       OpcuaNodeIdServicesMethod = 15124
	OpcuaNodeIdServicesMethod_PublishSubscribe_GetSecurityKeys                                                                                                                         OpcuaNodeIdServicesMethod = 15215
	OpcuaNodeIdServicesMethod_GetSecurityKeysMethodType                                                                                                                                OpcuaNodeIdServicesMethod = 15218
	OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Status_Enable                                                                                         OpcuaNodeIdServicesMethod = 15225
	OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Status_Disable                                                                                        OpcuaNodeIdServicesMethod = 15226
	OpcuaNodeIdServicesMethod_CreateCredentialMethodType                                                                                                                               OpcuaNodeIdServicesMethod = 15248
	OpcuaNodeIdServicesMethod_PubSubGroupType_Status_Enable                                                                                                                            OpcuaNodeIdServicesMethod = 15267
	OpcuaNodeIdServicesMethod_PubSubGroupType_Status_Disable                                                                                                                           OpcuaNodeIdServicesMethod = 15268
	OpcuaNodeIdServicesMethod_DataSetWriterType_Status_Enable                                                                                                                          OpcuaNodeIdServicesMethod = 15301
	OpcuaNodeIdServicesMethod_DataSetWriterType_Status_Disable                                                                                                                         OpcuaNodeIdServicesMethod = 15302
	OpcuaNodeIdServicesMethod_DataSetReaderType_Status_Enable                                                                                                                          OpcuaNodeIdServicesMethod = 15309
	OpcuaNodeIdServicesMethod_DataSetReaderType_Status_Disable                                                                                                                         OpcuaNodeIdServicesMethod = 15310
	OpcuaNodeIdServicesMethod_PublishSubscribe_GetSecurityGroup                                                                                                                        OpcuaNodeIdServicesMethod = 15440
	OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_AddSecurityGroup                                                                                                         OpcuaNodeIdServicesMethod = 15444
	OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_RemoveSecurityGroup                                                                                                      OpcuaNodeIdServicesMethod = 15447
	OpcuaNodeIdServicesMethod_GetSecurityGroupMethodType                                                                                                                               OpcuaNodeIdServicesMethod = 15449
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup                                                                             OpcuaNodeIdServicesMethod = 15454
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup                                                                          OpcuaNodeIdServicesMethod = 15457
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_AddSecurityGroup                                                                                                                 OpcuaNodeIdServicesMethod = 15461
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_RemoveSecurityGroup                                                                                                              OpcuaNodeIdServicesMethod = 15464
	OpcuaNodeIdServicesMethod_AddSecurityGroupMethodType                                                                                                                               OpcuaNodeIdServicesMethod = 15466
	OpcuaNodeIdServicesMethod_RemoveSecurityGroupMethodType                                                                                                                            OpcuaNodeIdServicesMethod = 15469
	OpcuaNodeIdServicesMethod_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField                                                                     OpcuaNodeIdServicesMethod = 15474
	OpcuaNodeIdServicesMethod_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField                                                                  OpcuaNodeIdServicesMethod = 15477
	OpcuaNodeIdServicesMethod_PublishedDataSetType_ExtensionFields_AddExtensionField                                                                                                   OpcuaNodeIdServicesMethod = 15482
	OpcuaNodeIdServicesMethod_PublishedDataSetType_ExtensionFields_RemoveExtensionField                                                                                                OpcuaNodeIdServicesMethod = 15485
	OpcuaNodeIdServicesMethod_ExtensionFieldsType_AddExtensionField                                                                                                                    OpcuaNodeIdServicesMethod = 15491
	OpcuaNodeIdServicesMethod_ExtensionFieldsType_RemoveExtensionField                                                                                                                 OpcuaNodeIdServicesMethod = 15494
	OpcuaNodeIdServicesMethod_AddExtensionFieldMethodType                                                                                                                              OpcuaNodeIdServicesMethod = 15496
	OpcuaNodeIdServicesMethod_RemoveExtensionFieldMethodType                                                                                                                           OpcuaNodeIdServicesMethod = 15499
	OpcuaNodeIdServicesMethod_ConfigurationFileType_CloseAndUpdate                                                                                                                     OpcuaNodeIdServicesMethod = 15505
	OpcuaNodeIdServicesMethod_ConfigurationFileType_ConfirmUpdate                                                                                                                      OpcuaNodeIdServicesMethod = 15508
	OpcuaNodeIdServicesMethod_ConfigurationFileCloseAndUpdateMethodType                                                                                                                OpcuaNodeIdServicesMethod = 15513
	OpcuaNodeIdServicesMethod_ConfigurationFileConfirmUpdateMethodType                                                                                                                 OpcuaNodeIdServicesMethod = 15516
	OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_Open                                                                                                           OpcuaNodeIdServicesMethod = 15572
	OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_Close                                                                                                          OpcuaNodeIdServicesMethod = 15575
	OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddIdentity                                                                                                             OpcuaNodeIdServicesMethod = 15612
	OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveIdentity                                                                                                          OpcuaNodeIdServicesMethod = 15614
	OpcuaNodeIdServicesMethod_RoleType_AddIdentity                                                                                                                                     OpcuaNodeIdServicesMethod = 15624
	OpcuaNodeIdServicesMethod_RoleType_RemoveIdentity                                                                                                                                  OpcuaNodeIdServicesMethod = 15626
	OpcuaNodeIdServicesMethod_AddIdentityMethodType                                                                                                                                    OpcuaNodeIdServicesMethod = 15636
	OpcuaNodeIdServicesMethod_RemoveIdentityMethodType                                                                                                                                 OpcuaNodeIdServicesMethod = 15638
	OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddIdentity                                                                                                                      OpcuaNodeIdServicesMethod = 15648
	OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveIdentity                                                                                                                   OpcuaNodeIdServicesMethod = 15650
	OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddIdentity                                                                                                              OpcuaNodeIdServicesMethod = 15660
	OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveIdentity                                                                                                           OpcuaNodeIdServicesMethod = 15662
	OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddIdentity                                                                                                                       OpcuaNodeIdServicesMethod = 15672
	OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveIdentity                                                                                                                    OpcuaNodeIdServicesMethod = 15674
	OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddIdentity                                                                                                                       OpcuaNodeIdServicesMethod = 15684
	OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveIdentity                                                                                                                    OpcuaNodeIdServicesMethod = 15686
	OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddIdentity                                                                                                                     OpcuaNodeIdServicesMethod = 15696
	OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveIdentity                                                                                                                  OpcuaNodeIdServicesMethod = 15698
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddIdentity                                                                                                                  OpcuaNodeIdServicesMethod = 15708
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveIdentity                                                                                                               OpcuaNodeIdServicesMethod = 15710
	OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddIdentity                                                                                                                 OpcuaNodeIdServicesMethod = 15720
	OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveIdentity                                                                                                              OpcuaNodeIdServicesMethod = 15722
	OpcuaNodeIdServicesMethod_TemporaryFileTransferType_GenerateFileForRead                                                                                                            OpcuaNodeIdServicesMethod = 15746
	OpcuaNodeIdServicesMethod_TemporaryFileTransferType_GenerateFileForWrite                                                                                                           OpcuaNodeIdServicesMethod = 15749
	OpcuaNodeIdServicesMethod_TemporaryFileTransferType_CloseAndCommit                                                                                                                 OpcuaNodeIdServicesMethod = 15751
	OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_Read                                                                                                           OpcuaNodeIdServicesMethod = 15791
	OpcuaNodeIdServicesMethod_TemporaryFileTransferType_TransferState_Placeholder_Reset                                                                                                OpcuaNodeIdServicesMethod = 15794
	OpcuaNodeIdServicesMethod_GenerateFileForReadMethodType                                                                                                                            OpcuaNodeIdServicesMethod = 15795
	OpcuaNodeIdServicesMethod_GenerateFileForWriteMethodType                                                                                                                           OpcuaNodeIdServicesMethod = 15798
	OpcuaNodeIdServicesMethod_CloseAndCommitMethodType                                                                                                                                 OpcuaNodeIdServicesMethod = 15800
	OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_Write                                                                                                          OpcuaNodeIdServicesMethod = 15805
	OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_GetPosition                                                                                                    OpcuaNodeIdServicesMethod = 15807
	OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_SetPosition                                                                                                    OpcuaNodeIdServicesMethod = 15810
	OpcuaNodeIdServicesMethod_FileTransferStateMachineType_Reset                                                                                                                       OpcuaNodeIdServicesMethod = 15843
	OpcuaNodeIdServicesMethod_PublishSubscribeType_Status_Enable                                                                                                                       OpcuaNodeIdServicesMethod = 15846
	OpcuaNodeIdServicesMethod_PublishSubscribeType_Status_Disable                                                                                                                      OpcuaNodeIdServicesMethod = 15847
	OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_CloseAndUpdate                                                                                                 OpcuaNodeIdServicesMethod = 15849
	OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_ConfirmUpdate                                                                                                  OpcuaNodeIdServicesMethod = 15863
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_GetSecurityKeys                                                                                                                     OpcuaNodeIdServicesMethod = 15907
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_GetSecurityGroup                                                                                                                    OpcuaNodeIdServicesMethod = 15910
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup                                                                                                     OpcuaNodeIdServicesMethod = 15914
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup                                                                                                  OpcuaNodeIdServicesMethod = 15917
	OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Open                                                                                                                OpcuaNodeIdServicesMethod = 15971
	OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Close                                                                                                               OpcuaNodeIdServicesMethod = 15974
	OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Read                                                                                                                OpcuaNodeIdServicesMethod = 15976
	OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Write                                                                                                               OpcuaNodeIdServicesMethod = 15979
	OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_GetPosition                                                                                                         OpcuaNodeIdServicesMethod = 15981
	OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_SetPosition                                                                                                         OpcuaNodeIdServicesMethod = 15984
	OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_ExportNamespace                                                                                                     OpcuaNodeIdServicesMethod = 15986
	OpcuaNodeIdServicesMethod_RoleSetType_AddRole                                                                                                                                      OpcuaNodeIdServicesMethod = 15997
	OpcuaNodeIdServicesMethod_RoleSetType_RemoveRole                                                                                                                                   OpcuaNodeIdServicesMethod = 16000
	OpcuaNodeIdServicesMethod_AddRoleMethodType                                                                                                                                        OpcuaNodeIdServicesMethod = 16002
	OpcuaNodeIdServicesMethod_RemoveRoleMethodType                                                                                                                                     OpcuaNodeIdServicesMethod = 16005
	OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_Open                                                                                                               OpcuaNodeIdServicesMethod = 16013
	OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddIdentity                                                                                                                       OpcuaNodeIdServicesMethod = 16041
	OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveIdentity                                                                                                                    OpcuaNodeIdServicesMethod = 16043
	OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_Close                                                                                                              OpcuaNodeIdServicesMethod = 16060
	OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_Read                                                                                                               OpcuaNodeIdServicesMethod = 16074
	OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_Write                                                                                                              OpcuaNodeIdServicesMethod = 16101
	OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_GetPosition                                                                                                        OpcuaNodeIdServicesMethod = 16103
	OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_SetPosition                                                                                                        OpcuaNodeIdServicesMethod = 16124
	OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddApplication                                                                                                          OpcuaNodeIdServicesMethod = 16165
	OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveApplication                                                                                                       OpcuaNodeIdServicesMethod = 16167
	OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddEndpoint                                                                                                             OpcuaNodeIdServicesMethod = 16169
	OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveEndpoint                                                                                                          OpcuaNodeIdServicesMethod = 16171
	OpcuaNodeIdServicesMethod_RoleType_AddApplication                                                                                                                                  OpcuaNodeIdServicesMethod = 16176
	OpcuaNodeIdServicesMethod_RoleType_RemoveApplication                                                                                                                               OpcuaNodeIdServicesMethod = 16178
	OpcuaNodeIdServicesMethod_RoleType_AddEndpoint                                                                                                                                     OpcuaNodeIdServicesMethod = 16180
	OpcuaNodeIdServicesMethod_RoleType_RemoveEndpoint                                                                                                                                  OpcuaNodeIdServicesMethod = 16182
	OpcuaNodeIdServicesMethod_AddApplicationMethodType                                                                                                                                 OpcuaNodeIdServicesMethod = 16184
	OpcuaNodeIdServicesMethod_RemoveApplicationMethodType                                                                                                                              OpcuaNodeIdServicesMethod = 16186
	OpcuaNodeIdServicesMethod_AddEndpointMethodType                                                                                                                                    OpcuaNodeIdServicesMethod = 16188
	OpcuaNodeIdServicesMethod_RemoveEndpointMethodType                                                                                                                                 OpcuaNodeIdServicesMethod = 16190
	OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddApplication                                                                                                                   OpcuaNodeIdServicesMethod = 16195
	OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveApplication                                                                                                                OpcuaNodeIdServicesMethod = 16197
	OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddEndpoint                                                                                                                      OpcuaNodeIdServicesMethod = 16199
	OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveEndpoint                                                                                                                   OpcuaNodeIdServicesMethod = 16201
	OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddApplication                                                                                                           OpcuaNodeIdServicesMethod = 16206
	OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveApplication                                                                                                        OpcuaNodeIdServicesMethod = 16208
	OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddEndpoint                                                                                                              OpcuaNodeIdServicesMethod = 16210
	OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveEndpoint                                                                                                           OpcuaNodeIdServicesMethod = 16212
	OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddApplication                                                                                                                    OpcuaNodeIdServicesMethod = 16217
	OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveApplication                                                                                                                 OpcuaNodeIdServicesMethod = 16219
	OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddEndpoint                                                                                                                       OpcuaNodeIdServicesMethod = 16221
	OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveEndpoint                                                                                                                    OpcuaNodeIdServicesMethod = 16223
	OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddApplication                                                                                                                    OpcuaNodeIdServicesMethod = 16228
	OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveApplication                                                                                                                 OpcuaNodeIdServicesMethod = 16230
	OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddEndpoint                                                                                                                       OpcuaNodeIdServicesMethod = 16232
	OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveEndpoint                                                                                                                    OpcuaNodeIdServicesMethod = 16234
	OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddApplication                                                                                                                    OpcuaNodeIdServicesMethod = 16239
	OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveApplication                                                                                                                 OpcuaNodeIdServicesMethod = 16241
	OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddEndpoint                                                                                                                       OpcuaNodeIdServicesMethod = 16243
	OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveEndpoint                                                                                                                    OpcuaNodeIdServicesMethod = 16245
	OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddApplication                                                                                                                  OpcuaNodeIdServicesMethod = 16250
	OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveApplication                                                                                                               OpcuaNodeIdServicesMethod = 16252
	OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddEndpoint                                                                                                                     OpcuaNodeIdServicesMethod = 16254
	OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveEndpoint                                                                                                                  OpcuaNodeIdServicesMethod = 16256
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddApplication                                                                                                               OpcuaNodeIdServicesMethod = 16261
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveApplication                                                                                                            OpcuaNodeIdServicesMethod = 16263
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddEndpoint                                                                                                                  OpcuaNodeIdServicesMethod = 16265
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveEndpoint                                                                                                               OpcuaNodeIdServicesMethod = 16267
	OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddApplication                                                                                                              OpcuaNodeIdServicesMethod = 16272
	OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveApplication                                                                                                           OpcuaNodeIdServicesMethod = 16274
	OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddEndpoint                                                                                                                 OpcuaNodeIdServicesMethod = 16276
	OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveEndpoint                                                                                                              OpcuaNodeIdServicesMethod = 16278
	OpcuaNodeIdServicesMethod_ServerType_ServerCapabilities_RoleSet_AddRole                                                                                                            OpcuaNodeIdServicesMethod = 16290
	OpcuaNodeIdServicesMethod_ServerType_ServerCapabilities_RoleSet_RemoveRole                                                                                                         OpcuaNodeIdServicesMethod = 16293
	OpcuaNodeIdServicesMethod_ServerCapabilitiesType_RoleSet_AddRole                                                                                                                   OpcuaNodeIdServicesMethod = 16296
	OpcuaNodeIdServicesMethod_ServerCapabilitiesType_RoleSet_RemoveRole                                                                                                                OpcuaNodeIdServicesMethod = 16299
	OpcuaNodeIdServicesMethod_Server_ServerCapabilities_RoleSet_AddRole                                                                                                                OpcuaNodeIdServicesMethod = 16301
	OpcuaNodeIdServicesMethod_Server_ServerCapabilities_RoleSet_RemoveRole                                                                                                             OpcuaNodeIdServicesMethod = 16304
	OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_CloseAndUpdate                                                                                                     OpcuaNodeIdServicesMethod = 16317
	OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_ConfirmUpdate                                                                                                      OpcuaNodeIdServicesMethod = 16320
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open                                                                               OpcuaNodeIdServicesMethod = 16332
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Close                                                                              OpcuaNodeIdServicesMethod = 16335
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read                                                                               OpcuaNodeIdServicesMethod = 16337
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Write                                                                              OpcuaNodeIdServicesMethod = 16340
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition                                                                        OpcuaNodeIdServicesMethod = 16342
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SetPosition                                                                        OpcuaNodeIdServicesMethod = 16345
	OpcuaNodeIdServicesMethod_FileSystem_CreateDirectory                                                                                                                               OpcuaNodeIdServicesMethod = 16348
	OpcuaNodeIdServicesMethod_FileSystem_CreateFile                                                                                                                                    OpcuaNodeIdServicesMethod = 16351
	OpcuaNodeIdServicesMethod_FileSystem_DeleteFileSystemObject                                                                                                                        OpcuaNodeIdServicesMethod = 16354
	OpcuaNodeIdServicesMethod_FileSystem_MoveOrCopy                                                                                                                                    OpcuaNodeIdServicesMethod = 16356
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate                                                                     OpcuaNodeIdServicesMethod = 16368
	OpcuaNodeIdServicesMethod_AlarmConditionType_Silence                                                                                                                               OpcuaNodeIdServicesMethod = 16402
	OpcuaNodeIdServicesMethod_AlarmConditionType_Suppress                                                                                                                              OpcuaNodeIdServicesMethod = 16403
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Disable                                                                                                OpcuaNodeIdServicesMethod = 16439
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Enable                                                                                                 OpcuaNodeIdServicesMethod = 16440
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment                                                                                             OpcuaNodeIdServicesMethod = 16441
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge                                                                                            OpcuaNodeIdServicesMethod = 16461
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm                                                                                                OpcuaNodeIdServicesMethod = 16463
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve                                                                                 OpcuaNodeIdServicesMethod = 16515
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve                                                                            OpcuaNodeIdServicesMethod = 16516
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve                                                                              OpcuaNodeIdServicesMethod = 16517
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ConfirmUpdate                                                                      OpcuaNodeIdServicesMethod = 16523
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Silence                                                                                                OpcuaNodeIdServicesMethod = 16533
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress                                                                                               OpcuaNodeIdServicesMethod = 16534
	OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup                                                                                           OpcuaNodeIdServicesMethod = 16535
	OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup                                                                                           OpcuaNodeIdServicesMethod = 16560
	OpcuaNodeIdServicesMethod_PublishSubscribeType_AddConnection                                                                                                                       OpcuaNodeIdServicesMethod = 16598
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate                                                                                     OpcuaNodeIdServicesMethod = 16601
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate                                                                                        OpcuaNodeIdServicesMethod = 16639
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddDataSetFolder                                                                                                  OpcuaNodeIdServicesMethod = 16651
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder                                                                                               OpcuaNodeIdServicesMethod = 16680
	OpcuaNodeIdServicesMethod_AddConnectionMethodType                                                                                                                                  OpcuaNodeIdServicesMethod = 16691
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open                                  OpcuaNodeIdServicesMethod = 16717
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close                                 OpcuaNodeIdServicesMethod = 16724
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read                                  OpcuaNodeIdServicesMethod = 16726
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write                                 OpcuaNodeIdServicesMethod = 16729
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition                           OpcuaNodeIdServicesMethod = 16732
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition                           OpcuaNodeIdServicesMethod = 16735
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks                         OpcuaNodeIdServicesMethod = 16741
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate                        OpcuaNodeIdServicesMethod = 16744
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate                        OpcuaNodeIdServicesMethod = 16747
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate                     OpcuaNodeIdServicesMethod = 16749
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList                                 OpcuaNodeIdServicesMethod = 16752
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable                      OpcuaNodeIdServicesMethod = 16790
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable                       OpcuaNodeIdServicesMethod = 16791
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment                   OpcuaNodeIdServicesMethod = 16792
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge                  OpcuaNodeIdServicesMethod = 16812
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm                      OpcuaNodeIdServicesMethod = 16814
	OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate                                                                            OpcuaNodeIdServicesMethod = 16842
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve    OpcuaNodeIdServicesMethod = 16864
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2   OpcuaNodeIdServicesMethod = 16866
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve       OpcuaNodeIdServicesMethod = 16868
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2      OpcuaNodeIdServicesMethod = 16869
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve  OpcuaNodeIdServicesMethod = 16871
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2 OpcuaNodeIdServicesMethod = 16872
	OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate                                                                               OpcuaNodeIdServicesMethod = 16881
	OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder                                                                                         OpcuaNodeIdServicesMethod = 16884
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence                      OpcuaNodeIdServicesMethod = 16911
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress                     OpcuaNodeIdServicesMethod = 16912
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2                    OpcuaNodeIdServicesMethod = 16913
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress                   OpcuaNodeIdServicesMethod = 16915
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2                  OpcuaNodeIdServicesMethod = 16916
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService            OpcuaNodeIdServicesMethod = 16918
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2           OpcuaNodeIdServicesMethod = 16919
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService               OpcuaNodeIdServicesMethod = 16921
	OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder                                                                                      OpcuaNodeIdServicesMethod = 16923
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2              OpcuaNodeIdServicesMethod = 16926
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset                        OpcuaNodeIdServicesMethod = 16928
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2                       OpcuaNodeIdServicesMethod = 16929
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships          OpcuaNodeIdServicesMethod = 16931
	OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedDataItemsTemplate                                                                                                          OpcuaNodeIdServicesMethod = 16935
	OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedEventsTemplate                                                                                                             OpcuaNodeIdServicesMethod = 16960
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable                      OpcuaNodeIdServicesMethod = 16977
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable                       OpcuaNodeIdServicesMethod = 16978
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment                   OpcuaNodeIdServicesMethod = 16979
	OpcuaNodeIdServicesMethod_DataSetFolderType_AddDataSetFolder                                                                                                                       OpcuaNodeIdServicesMethod = 16994
	OpcuaNodeIdServicesMethod_DataSetFolderType_RemoveDataSetFolder                                                                                                                    OpcuaNodeIdServicesMethod = 16997
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge                  OpcuaNodeIdServicesMethod = 17003
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm                      OpcuaNodeIdServicesMethod = 17005
	OpcuaNodeIdServicesMethod_AddPublishedDataItemsTemplateMethodType                                                                                                                  OpcuaNodeIdServicesMethod = 17030
	OpcuaNodeIdServicesMethod_AddPublishedEventsTemplateMethodType                                                                                                                     OpcuaNodeIdServicesMethod = 17033
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve    OpcuaNodeIdServicesMethod = 17056
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2   OpcuaNodeIdServicesMethod = 17058
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve       OpcuaNodeIdServicesMethod = 17060
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2      OpcuaNodeIdServicesMethod = 17061
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve  OpcuaNodeIdServicesMethod = 17063
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2 OpcuaNodeIdServicesMethod = 17064
	OpcuaNodeIdServicesMethod_AddDataSetFolderMethodType                                                                                                                               OpcuaNodeIdServicesMethod = 17067
	OpcuaNodeIdServicesMethod_RemoveDataSetFolderMethodType                                                                                                                            OpcuaNodeIdServicesMethod = 17079
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence                      OpcuaNodeIdServicesMethod = 17103
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress                     OpcuaNodeIdServicesMethod = 17104
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2                    OpcuaNodeIdServicesMethod = 17105
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress                   OpcuaNodeIdServicesMethod = 17107
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2                  OpcuaNodeIdServicesMethod = 17108
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService            OpcuaNodeIdServicesMethod = 17110
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2           OpcuaNodeIdServicesMethod = 17111
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService               OpcuaNodeIdServicesMethod = 17113
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2              OpcuaNodeIdServicesMethod = 17114
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset                        OpcuaNodeIdServicesMethod = 17116
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2                       OpcuaNodeIdServicesMethod = 17117
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships          OpcuaNodeIdServicesMethod = 17119
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open                                        OpcuaNodeIdServicesMethod = 17134
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close                                       OpcuaNodeIdServicesMethod = 17137
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read                                        OpcuaNodeIdServicesMethod = 17139
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write                                       OpcuaNodeIdServicesMethod = 17142
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition                                 OpcuaNodeIdServicesMethod = 17144
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition                                 OpcuaNodeIdServicesMethod = 17147
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks                               OpcuaNodeIdServicesMethod = 17153
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate                              OpcuaNodeIdServicesMethod = 17156
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate                              OpcuaNodeIdServicesMethod = 17159
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate                           OpcuaNodeIdServicesMethod = 17161
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList                                       OpcuaNodeIdServicesMethod = 17164
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable                            OpcuaNodeIdServicesMethod = 17199
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable                             OpcuaNodeIdServicesMethod = 17200
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment                         OpcuaNodeIdServicesMethod = 17205
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge                        OpcuaNodeIdServicesMethod = 17237
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm                            OpcuaNodeIdServicesMethod = 17239
	OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter                                                                                        OpcuaNodeIdServicesMethod = 17293
	OpcuaNodeIdServicesMethod_PublishSubscribeType_SetSecurityKeys                                                                                                                     OpcuaNodeIdServicesMethod = 17296
	OpcuaNodeIdServicesMethod_SetSecurityKeysMethodType                                                                                                                                OpcuaNodeIdServicesMethod = 17298
	OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Status_Enable                                                                                           OpcuaNodeIdServicesMethod = 17316
	OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Status_Disable                                                                                          OpcuaNodeIdServicesMethod = 17317
	OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter                                                                                     OpcuaNodeIdServicesMethod = 17323
	OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Status_Enable                                                                                           OpcuaNodeIdServicesMethod = 17331
	OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Status_Disable                                                                                          OpcuaNodeIdServicesMethod = 17332
	OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader                                                                                     OpcuaNodeIdServicesMethod = 17333
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve          OpcuaNodeIdServicesMethod = 17340
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2         OpcuaNodeIdServicesMethod = 17342
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve             OpcuaNodeIdServicesMethod = 17344
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2            OpcuaNodeIdServicesMethod = 17345
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve        OpcuaNodeIdServicesMethod = 17347
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2       OpcuaNodeIdServicesMethod = 17348
	OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader                                                                                        OpcuaNodeIdServicesMethod = 17355
	OpcuaNodeIdServicesMethod_PublishSubscribe_SetSecurityKeys                                                                                                                         OpcuaNodeIdServicesMethod = 17364
	OpcuaNodeIdServicesMethod_PublishSubscribe_AddConnection                                                                                                                           OpcuaNodeIdServicesMethod = 17366
	OpcuaNodeIdServicesMethod_PublishSubscribe_RemoveConnection                                                                                                                        OpcuaNodeIdServicesMethod = 17369
	OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedDataItems                                                                                                 OpcuaNodeIdServicesMethod = 17372
	OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedEvents                                                                                                    OpcuaNodeIdServicesMethod = 17375
	OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate                                                                                         OpcuaNodeIdServicesMethod = 17378
	OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate                                                                                            OpcuaNodeIdServicesMethod = 17381
	OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_RemovePublishedDataSet                                                                                                OpcuaNodeIdServicesMethod = 17384
	OpcuaNodeIdServicesMethod_DataSetReaderType_CreateTargetVariables                                                                                                                  OpcuaNodeIdServicesMethod = 17386
	OpcuaNodeIdServicesMethod_DataSetReaderType_CreateDataSetMirror                                                                                                                    OpcuaNodeIdServicesMethod = 17389
	OpcuaNodeIdServicesMethod_DataSetReaderTypeCreateTargetVariablesMethodType                                                                                                         OpcuaNodeIdServicesMethod = 17392
	OpcuaNodeIdServicesMethod_DataSetReaderTypeCreateDataSetMirrorMethodType                                                                                                           OpcuaNodeIdServicesMethod = 17395
	OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddDataSetFolder                                                                                                      OpcuaNodeIdServicesMethod = 17398
	OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_RemoveDataSetFolder                                                                                                   OpcuaNodeIdServicesMethod = 17403
	OpcuaNodeIdServicesMethod_PublishSubscribe_Status_Enable                                                                                                                           OpcuaNodeIdServicesMethod = 17407
	OpcuaNodeIdServicesMethod_PublishSubscribe_Status_Disable                                                                                                                          OpcuaNodeIdServicesMethod = 17408
	OpcuaNodeIdServicesMethod_PublishSubscribe_Diagnostics_Reset                                                                                                                       OpcuaNodeIdServicesMethod = 17421
	OpcuaNodeIdServicesMethod_PubSubConnectionType_AddWriterGroup                                                                                                                      OpcuaNodeIdServicesMethod = 17427
	OpcuaNodeIdServicesMethod_PubSubConnectionType_AddReaderGroup                                                                                                                      OpcuaNodeIdServicesMethod = 17465
	OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_GetEncryptingKey                                                                            OpcuaNodeIdServicesMethod = 17516
	OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_UpdateCredential                                                                            OpcuaNodeIdServicesMethod = 17519
	OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_DeleteCredential                                                                            OpcuaNodeIdServicesMethod = 17521
	OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_CreateCredential                                                                                                    OpcuaNodeIdServicesMethod = 17522
	OpcuaNodeIdServicesMethod_KeyCredentialConfiguration_CreateCredential                                                                                                              OpcuaNodeIdServicesMethod = 17528
	OpcuaNodeIdServicesMethod_GetEncryptingKeyMethodType                                                                                                                               OpcuaNodeIdServicesMethod = 17531
	OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_GetEncryptingKey                                                                                                          OpcuaNodeIdServicesMethod = 17534
	OpcuaNodeIdServicesMethod_PubSubConnectionTypeAddWriterGroupMethodType                                                                                                             OpcuaNodeIdServicesMethod = 17561
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence                            OpcuaNodeIdServicesMethod = 17572
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress                           OpcuaNodeIdServicesMethod = 17573
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2                          OpcuaNodeIdServicesMethod = 17574
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress                         OpcuaNodeIdServicesMethod = 17586
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2                        OpcuaNodeIdServicesMethod = 17587
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService                  OpcuaNodeIdServicesMethod = 17596
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2                 OpcuaNodeIdServicesMethod = 17599
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService                     OpcuaNodeIdServicesMethod = 17616
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2                    OpcuaNodeIdServicesMethod = 17617
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset                              OpcuaNodeIdServicesMethod = 17619
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2                             OpcuaNodeIdServicesMethod = 17620
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships                OpcuaNodeIdServicesMethod = 17622
	OpcuaNodeIdServicesMethod_PubSubConnectionAddReaderGroupGroupMethodType                                                                                                            OpcuaNodeIdServicesMethod = 17630
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable                            OpcuaNodeIdServicesMethod = 17678
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable                             OpcuaNodeIdServicesMethod = 17679
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment                         OpcuaNodeIdServicesMethod = 17680
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge                        OpcuaNodeIdServicesMethod = 17700
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm                            OpcuaNodeIdServicesMethod = 17702
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject                                                                                   OpcuaNodeIdServicesMethod = 17718
	OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Status_Enable                                                                                              OpcuaNodeIdServicesMethod = 17751
	OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Status_Disable                                                                                             OpcuaNodeIdServicesMethod = 17752
	OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Reset                                                                                          OpcuaNodeIdServicesMethod = 17765
	OpcuaNodeIdServicesMethod_WriterGroupType_Diagnostics_Reset                                                                                                                        OpcuaNodeIdServicesMethod = 17824
	OpcuaNodeIdServicesMethod_AlarmConditionType_Unsuppress                                                                                                                            OpcuaNodeIdServicesMethod = 17868
	OpcuaNodeIdServicesMethod_AlarmConditionType_RemoveFromService                                                                                                                     OpcuaNodeIdServicesMethod = 17869
	OpcuaNodeIdServicesMethod_AlarmConditionType_PlaceInService                                                                                                                        OpcuaNodeIdServicesMethod = 17870
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress                                                                                             OpcuaNodeIdServicesMethod = 17875
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService                                                                                      OpcuaNodeIdServicesMethod = 17876
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService                                                                                         OpcuaNodeIdServicesMethod = 17877
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve          OpcuaNodeIdServicesMethod = 17917
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2         OpcuaNodeIdServicesMethod = 17919
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve             OpcuaNodeIdServicesMethod = 17922
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2            OpcuaNodeIdServicesMethod = 17923
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve        OpcuaNodeIdServicesMethod = 17925
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2       OpcuaNodeIdServicesMethod = 17926
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence                            OpcuaNodeIdServicesMethod = 17965
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress                           OpcuaNodeIdServicesMethod = 17966
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2                          OpcuaNodeIdServicesMethod = 17967
	OpcuaNodeIdServicesMethod_WriterGroupType_AddDataSetWriter                                                                                                                         OpcuaNodeIdServicesMethod = 17969
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress                         OpcuaNodeIdServicesMethod = 17970
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2                        OpcuaNodeIdServicesMethod = 17971
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService                  OpcuaNodeIdServicesMethod = 17973
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2                 OpcuaNodeIdServicesMethod = 17974
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService                     OpcuaNodeIdServicesMethod = 17977
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2                    OpcuaNodeIdServicesMethod = 17978
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset                              OpcuaNodeIdServicesMethod = 17980
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2                             OpcuaNodeIdServicesMethod = 17981
	OpcuaNodeIdServicesMethod_WriterGroupType_RemoveDataSetWriter                                                                                                                      OpcuaNodeIdServicesMethod = 17992
	OpcuaNodeIdServicesMethod_PubSubGroupTypeAddWriterMethodType                                                                                                                       OpcuaNodeIdServicesMethod = 17994
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships                OpcuaNodeIdServicesMethod = 18000
	OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_UpdateCredential                                                                                                          OpcuaNodeIdServicesMethod = 18006
	OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_DeleteCredential                                                                                                          OpcuaNodeIdServicesMethod = 18008
	OpcuaNodeIdServicesMethod_KeyCredentialUpdateMethodType                                                                                                                            OpcuaNodeIdServicesMethod = 18009
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open                                    OpcuaNodeIdServicesMethod = 18024
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close                                   OpcuaNodeIdServicesMethod = 18027
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read                                    OpcuaNodeIdServicesMethod = 18031
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write                                   OpcuaNodeIdServicesMethod = 18034
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition                             OpcuaNodeIdServicesMethod = 18036
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition                             OpcuaNodeIdServicesMethod = 18039
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks                           OpcuaNodeIdServicesMethod = 18045
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate                          OpcuaNodeIdServicesMethod = 18049
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate                          OpcuaNodeIdServicesMethod = 18052
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate                       OpcuaNodeIdServicesMethod = 18054
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList                                   OpcuaNodeIdServicesMethod = 18057
	OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Status_Enable                                                                                              OpcuaNodeIdServicesMethod = 18090
	OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Status_Disable                                                                                             OpcuaNodeIdServicesMethod = 18091
	OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Reset                                                                                          OpcuaNodeIdServicesMethod = 18104
	OpcuaNodeIdServicesMethod_AlarmConditionType_Reset                                                                                                                                 OpcuaNodeIdServicesMethod = 18199
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Reset                                                                                                  OpcuaNodeIdServicesMethod = 18212
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable                        OpcuaNodeIdServicesMethod = 18225
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable                         OpcuaNodeIdServicesMethod = 18226
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment                     OpcuaNodeIdServicesMethod = 18227
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge                    OpcuaNodeIdServicesMethod = 18247
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm                        OpcuaNodeIdServicesMethod = 18249
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve      OpcuaNodeIdServicesMethod = 18294
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2     OpcuaNodeIdServicesMethod = 18296
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve         OpcuaNodeIdServicesMethod = 18298
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2        OpcuaNodeIdServicesMethod = 18299
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve    OpcuaNodeIdServicesMethod = 18301
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2   OpcuaNodeIdServicesMethod = 18302
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence                        OpcuaNodeIdServicesMethod = 18335
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress                       OpcuaNodeIdServicesMethod = 18336
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2                      OpcuaNodeIdServicesMethod = 18337
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress                     OpcuaNodeIdServicesMethod = 18339
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2                    OpcuaNodeIdServicesMethod = 18340
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService              OpcuaNodeIdServicesMethod = 18342
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2             OpcuaNodeIdServicesMethod = 18343
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService                 OpcuaNodeIdServicesMethod = 18345
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2                OpcuaNodeIdServicesMethod = 18346
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset                          OpcuaNodeIdServicesMethod = 18349
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2                         OpcuaNodeIdServicesMethod = 18350
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships            OpcuaNodeIdServicesMethod = 18352
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable                        OpcuaNodeIdServicesMethod = 18392
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable                         OpcuaNodeIdServicesMethod = 18393
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment                     OpcuaNodeIdServicesMethod = 18394
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge                    OpcuaNodeIdServicesMethod = 18414
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm                        OpcuaNodeIdServicesMethod = 18416
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve      OpcuaNodeIdServicesMethod = 18461
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2     OpcuaNodeIdServicesMethod = 18463
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve         OpcuaNodeIdServicesMethod = 18465
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2        OpcuaNodeIdServicesMethod = 18466
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve    OpcuaNodeIdServicesMethod = 18468
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2   OpcuaNodeIdServicesMethod = 18469
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence                        OpcuaNodeIdServicesMethod = 18503
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress                       OpcuaNodeIdServicesMethod = 18504
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2                      OpcuaNodeIdServicesMethod = 18505
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress                     OpcuaNodeIdServicesMethod = 18507
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2                    OpcuaNodeIdServicesMethod = 18508
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService              OpcuaNodeIdServicesMethod = 18510
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2             OpcuaNodeIdServicesMethod = 18511
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService                 OpcuaNodeIdServicesMethod = 18513
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2                OpcuaNodeIdServicesMethod = 18514
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset                          OpcuaNodeIdServicesMethod = 18516
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2                         OpcuaNodeIdServicesMethod = 18517
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships            OpcuaNodeIdServicesMethod = 18519
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_UpdateCertificate                                                                         OpcuaNodeIdServicesMethod = 18533
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_GetCertificates                                                                           OpcuaNodeIdServicesMethod = 18536
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ApplyChanges                                                                              OpcuaNodeIdServicesMethod = 18539
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CancelChanges                                                                             OpcuaNodeIdServicesMethod = 18540
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CreateSigningRequest                                                                      OpcuaNodeIdServicesMethod = 18541
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_GetRejectedList                                                                           OpcuaNodeIdServicesMethod = 18544
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ResetToServerDefaults                                                                     OpcuaNodeIdServicesMethod = 18546
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Open                                                                    OpcuaNodeIdServicesMethod = 18562
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Close                                                                   OpcuaNodeIdServicesMethod = 18565
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Read                                                                    OpcuaNodeIdServicesMethod = 18567
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Write                                                                   OpcuaNodeIdServicesMethod = 18570
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_GetPosition                                                             OpcuaNodeIdServicesMethod = 18572
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_SetPosition                                                             OpcuaNodeIdServicesMethod = 18575
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate                                                          OpcuaNodeIdServicesMethod = 18581
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_ConfirmUpdate                                                           OpcuaNodeIdServicesMethod = 18584
	OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_AddIdentity                                                                                                             OpcuaNodeIdServicesMethod = 18632
	OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_RemoveIdentity                                                                                                          OpcuaNodeIdServicesMethod = 18634
	OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_AddApplication                                                                                                          OpcuaNodeIdServicesMethod = 18636
	OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_RemoveApplication                                                                                                       OpcuaNodeIdServicesMethod = 18638
	OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_AddEndpoint                                                                                                             OpcuaNodeIdServicesMethod = 18640
	OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_RemoveEndpoint                                                                                                          OpcuaNodeIdServicesMethod = 18642
	OpcuaNodeIdServicesMethod_AlarmMetricsType_Reset                                                                                                                                   OpcuaNodeIdServicesMethod = 18666
	OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Reset                                                                                        OpcuaNodeIdServicesMethod = 18679
	OpcuaNodeIdServicesMethod_PublishSubscribeType_Diagnostics_Reset                                                                                                                   OpcuaNodeIdServicesMethod = 18727
	OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Reset                                                                                     OpcuaNodeIdServicesMethod = 18883
	OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Reset                                                                                       OpcuaNodeIdServicesMethod = 19119
	OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Reset                                                                                       OpcuaNodeIdServicesMethod = 19188
	OpcuaNodeIdServicesMethod_PubSubConnectionType_Diagnostics_Reset                                                                                                                   OpcuaNodeIdServicesMethod = 19253
	OpcuaNodeIdServicesMethod_CreateSelfSignedCertificateMethodType                                                                                                                    OpcuaNodeIdServicesMethod = 19327
	OpcuaNodeIdServicesMethod_DeleteCertificateMethodType                                                                                                                              OpcuaNodeIdServicesMethod = 19330
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CreateSelfSignedCertificate                                                               OpcuaNodeIdServicesMethod = 19332
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_DeleteCertificate                                                                         OpcuaNodeIdServicesMethod = 19335
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CreateSelfSignedCertificate                                                                                                      OpcuaNodeIdServicesMethod = 19337
	OpcuaNodeIdServicesMethod_ServerConfigurationType_DeleteCertificate                                                                                                                OpcuaNodeIdServicesMethod = 19340
	OpcuaNodeIdServicesMethod_ServerConfiguration_CreateSelfSignedCertificate                                                                                                          OpcuaNodeIdServicesMethod = 19342
	OpcuaNodeIdServicesMethod_ServerConfiguration_DeleteCertificate                                                                                                                    OpcuaNodeIdServicesMethod = 19345
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate                                                                          OpcuaNodeIdServicesMethod = 19347
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_DeleteCertificate                                                                                    OpcuaNodeIdServicesMethod = 19350
	OpcuaNodeIdServicesMethod_LogObjectType_GetRecords                                                                                                                                 OpcuaNodeIdServicesMethod = 19353
	OpcuaNodeIdServicesMethod_GetRecordsMethodType                                                                                                                                     OpcuaNodeIdServicesMethod = 19358
	OpcuaNodeIdServicesMethod_ServerLog_GetRecords                                                                                                                                     OpcuaNodeIdServicesMethod = 19373
	OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_KeyCredentials_CreateCredential                                                           OpcuaNodeIdServicesMethod = 19410
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_KeyCredentials_CreateCredential                                                                                             OpcuaNodeIdServicesMethod = 19424
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Disable                                                                                                          OpcuaNodeIdServicesMethod = 19483
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Enable                                                                                                           OpcuaNodeIdServicesMethod = 19484
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_AddComment                                                                                                       OpcuaNodeIdServicesMethod = 19485
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Acknowledge                                                                                                      OpcuaNodeIdServicesMethod = 19505
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Confirm                                                                                                          OpcuaNodeIdServicesMethod = 19507
	OpcuaNodeIdServicesMethod_DataSetWriterType_Diagnostics_Reset                                                                                                                      OpcuaNodeIdServicesMethod = 19562
	OpcuaNodeIdServicesMethod_DataSetReaderType_Diagnostics_Reset                                                                                                                      OpcuaNodeIdServicesMethod = 19621
	OpcuaNodeIdServicesMethod_PubSubDiagnosticsType_Reset                                                                                                                              OpcuaNodeIdServicesMethod = 19689
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential                                                                      OpcuaNodeIdServicesMethod = 19740
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve                                                                                        OpcuaNodeIdServicesMethod = 20097
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve                                                                                           OpcuaNodeIdServicesMethod = 20099
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve                                                                                      OpcuaNodeIdServicesMethod = 20100
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Silence                                                                                                          OpcuaNodeIdServicesMethod = 20132
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Suppress                                                                                                         OpcuaNodeIdServicesMethod = 20133
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Unsuppress                                                                                                       OpcuaNodeIdServicesMethod = 20134
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_RemoveFromService                                                                                                OpcuaNodeIdServicesMethod = 20135
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_PlaceInService                                                                                                   OpcuaNodeIdServicesMethod = 20136
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Reset                                                                                                            OpcuaNodeIdServicesMethod = 20137
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Disable                                                                                                          OpcuaNodeIdServicesMethod = 20176
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Enable                                                                                                           OpcuaNodeIdServicesMethod = 20177
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_AddComment                                                                                                       OpcuaNodeIdServicesMethod = 20178
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Acknowledge                                                                                                      OpcuaNodeIdServicesMethod = 20198
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Confirm                                                                                                          OpcuaNodeIdServicesMethod = 20200
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve                                                                                        OpcuaNodeIdServicesMethod = 20245
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve                                                                                           OpcuaNodeIdServicesMethod = 20247
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve                                                                                      OpcuaNodeIdServicesMethod = 20248
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Silence                                                                                                          OpcuaNodeIdServicesMethod = 20280
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Suppress                                                                                                         OpcuaNodeIdServicesMethod = 20281
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Unsuppress                                                                                                       OpcuaNodeIdServicesMethod = 20282
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_RemoveFromService                                                                                                OpcuaNodeIdServicesMethod = 20283
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_PlaceInService                                                                                                   OpcuaNodeIdServicesMethod = 20284
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Reset                                                                                                            OpcuaNodeIdServicesMethod = 20285
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Disable                                                                            OpcuaNodeIdServicesMethod = 20324
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Enable                                                                             OpcuaNodeIdServicesMethod = 20325
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment                                                                         OpcuaNodeIdServicesMethod = 20326
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge                                                                        OpcuaNodeIdServicesMethod = 20346
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm                                                                            OpcuaNodeIdServicesMethod = 20348
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve                                                          OpcuaNodeIdServicesMethod = 20393
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve                                                             OpcuaNodeIdServicesMethod = 20395
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve                                                        OpcuaNodeIdServicesMethod = 20396
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Silence                                                                            OpcuaNodeIdServicesMethod = 20430
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress                                                                           OpcuaNodeIdServicesMethod = 20431
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress                                                                         OpcuaNodeIdServicesMethod = 20432
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService                                                                  OpcuaNodeIdServicesMethod = 20433
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService                                                                     OpcuaNodeIdServicesMethod = 20434
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset                                                                              OpcuaNodeIdServicesMethod = 20435
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Disable                                                                            OpcuaNodeIdServicesMethod = 20474
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Enable                                                                             OpcuaNodeIdServicesMethod = 20475
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment                                                                         OpcuaNodeIdServicesMethod = 20476
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge                                                                        OpcuaNodeIdServicesMethod = 20496
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm                                                                            OpcuaNodeIdServicesMethod = 20498
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                                          OpcuaNodeIdServicesMethod = 20543
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve                                                             OpcuaNodeIdServicesMethod = 20545
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                                                        OpcuaNodeIdServicesMethod = 20546
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Silence                                                                            OpcuaNodeIdServicesMethod = 20578
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress                                                                           OpcuaNodeIdServicesMethod = 20579
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress                                                                         OpcuaNodeIdServicesMethod = 20580
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService                                                                  OpcuaNodeIdServicesMethod = 20581
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService                                                                     OpcuaNodeIdServicesMethod = 20582
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset                                                                              OpcuaNodeIdServicesMethod = 20583
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Disable                                                                                  OpcuaNodeIdServicesMethod = 20622
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Enable                                                                                   OpcuaNodeIdServicesMethod = 20623
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment                                                                               OpcuaNodeIdServicesMethod = 20624
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge                                                                              OpcuaNodeIdServicesMethod = 20644
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm                                                                                  OpcuaNodeIdServicesMethod = 20646
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve                                                                OpcuaNodeIdServicesMethod = 20691
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve                                                                   OpcuaNodeIdServicesMethod = 20693
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve                                                              OpcuaNodeIdServicesMethod = 20694
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Silence                                                                                  OpcuaNodeIdServicesMethod = 20726
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress                                                                                 OpcuaNodeIdServicesMethod = 20727
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress                                                                               OpcuaNodeIdServicesMethod = 20728
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService                                                                        OpcuaNodeIdServicesMethod = 20729
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService                                                                           OpcuaNodeIdServicesMethod = 20730
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset                                                                                    OpcuaNodeIdServicesMethod = 20731
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Disable                                                                                  OpcuaNodeIdServicesMethod = 20770
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Enable                                                                                   OpcuaNodeIdServicesMethod = 20771
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment                                                                               OpcuaNodeIdServicesMethod = 20772
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge                                                                              OpcuaNodeIdServicesMethod = 20792
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm                                                                                  OpcuaNodeIdServicesMethod = 20794
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                                                OpcuaNodeIdServicesMethod = 20839
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve                                                                   OpcuaNodeIdServicesMethod = 20841
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                                                              OpcuaNodeIdServicesMethod = 20842
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Silence                                                                                  OpcuaNodeIdServicesMethod = 20874
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress                                                                                 OpcuaNodeIdServicesMethod = 20875
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress                                                                               OpcuaNodeIdServicesMethod = 20876
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService                                                                        OpcuaNodeIdServicesMethod = 20877
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService                                                                           OpcuaNodeIdServicesMethod = 20878
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset                                                                                    OpcuaNodeIdServicesMethod = 20879
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Disable                                                                              OpcuaNodeIdServicesMethod = 20918
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Enable                                                                               OpcuaNodeIdServicesMethod = 20919
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment                                                                           OpcuaNodeIdServicesMethod = 20920
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge                                                                          OpcuaNodeIdServicesMethod = 20940
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Confirm                                                                              OpcuaNodeIdServicesMethod = 20942
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve                                                            OpcuaNodeIdServicesMethod = 20987
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve                                                               OpcuaNodeIdServicesMethod = 20989
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve                                                          OpcuaNodeIdServicesMethod = 20990
	OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables                                                                                      OpcuaNodeIdServicesMethod = 21009
	OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror                                                                                        OpcuaNodeIdServicesMethod = 21012
	OpcuaNodeIdServicesMethod_ReaderGroupType_Diagnostics_Reset                                                                                                                        OpcuaNodeIdServicesMethod = 21027
	OpcuaNodeIdServicesMethod_ReaderGroupType_AddDataSetReader                                                                                                                         OpcuaNodeIdServicesMethod = 21082
	OpcuaNodeIdServicesMethod_ReaderGroupType_RemoveDataSetReader                                                                                                                      OpcuaNodeIdServicesMethod = 21085
	OpcuaNodeIdServicesMethod_PubSubGroupTypeAddReaderMethodType                                                                                                                       OpcuaNodeIdServicesMethod = 21087
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Silence                                                                              OpcuaNodeIdServicesMethod = 21225
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress                                                                             OpcuaNodeIdServicesMethod = 21226
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress                                                                           OpcuaNodeIdServicesMethod = 21227
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService                                                                    OpcuaNodeIdServicesMethod = 21228
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService                                                                       OpcuaNodeIdServicesMethod = 21229
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset                                                                                OpcuaNodeIdServicesMethod = 21230
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Disable                                                                              OpcuaNodeIdServicesMethod = 21269
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Enable                                                                               OpcuaNodeIdServicesMethod = 21270
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment                                                                           OpcuaNodeIdServicesMethod = 21271
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge                                                                          OpcuaNodeIdServicesMethod = 21291
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Confirm                                                                              OpcuaNodeIdServicesMethod = 21293
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                                            OpcuaNodeIdServicesMethod = 21338
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve                                                               OpcuaNodeIdServicesMethod = 21340
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                                                          OpcuaNodeIdServicesMethod = 21341
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Silence                                                                              OpcuaNodeIdServicesMethod = 21373
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress                                                                             OpcuaNodeIdServicesMethod = 21374
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress                                                                           OpcuaNodeIdServicesMethod = 21375
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService                                                                    OpcuaNodeIdServicesMethod = 21376
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService                                                                       OpcuaNodeIdServicesMethod = 21377
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset                                                                                OpcuaNodeIdServicesMethod = 21378
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Disable                                                                        OpcuaNodeIdServicesMethod = 21417
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Enable                                                                         OpcuaNodeIdServicesMethod = 21418
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment                                                                     OpcuaNodeIdServicesMethod = 21419
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge                                                                    OpcuaNodeIdServicesMethod = 21439
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Confirm                                                                        OpcuaNodeIdServicesMethod = 21441
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve                                                      OpcuaNodeIdServicesMethod = 21486
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve                                                         OpcuaNodeIdServicesMethod = 21488
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve                                                    OpcuaNodeIdServicesMethod = 21489
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Silence                                                                        OpcuaNodeIdServicesMethod = 21521
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress                                                                       OpcuaNodeIdServicesMethod = 21522
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress                                                                     OpcuaNodeIdServicesMethod = 21523
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService                                                              OpcuaNodeIdServicesMethod = 21524
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService                                                                 OpcuaNodeIdServicesMethod = 21525
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset                                                                          OpcuaNodeIdServicesMethod = 21526
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Disable                                                                        OpcuaNodeIdServicesMethod = 21565
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Enable                                                                         OpcuaNodeIdServicesMethod = 21566
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment                                                                     OpcuaNodeIdServicesMethod = 21567
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge                                                                    OpcuaNodeIdServicesMethod = 21587
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Confirm                                                                        OpcuaNodeIdServicesMethod = 21589
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve                                                      OpcuaNodeIdServicesMethod = 21634
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve                                                         OpcuaNodeIdServicesMethod = 21636
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve                                                    OpcuaNodeIdServicesMethod = 21637
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Silence                                                                        OpcuaNodeIdServicesMethod = 21669
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress                                                                       OpcuaNodeIdServicesMethod = 21670
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress                                                                     OpcuaNodeIdServicesMethod = 21671
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService                                                              OpcuaNodeIdServicesMethod = 21672
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService                                                                 OpcuaNodeIdServicesMethod = 21673
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset                                                                          OpcuaNodeIdServicesMethod = 21674
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable                                                             OpcuaNodeIdServicesMethod = 21713
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable                                                              OpcuaNodeIdServicesMethod = 21714
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment                                                          OpcuaNodeIdServicesMethod = 21715
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge                                                         OpcuaNodeIdServicesMethod = 21735
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm                                                             OpcuaNodeIdServicesMethod = 21737
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve                                           OpcuaNodeIdServicesMethod = 21782
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve                                              OpcuaNodeIdServicesMethod = 21784
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve                                         OpcuaNodeIdServicesMethod = 21785
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence                                                             OpcuaNodeIdServicesMethod = 21817
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress                                                            OpcuaNodeIdServicesMethod = 21818
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress                                                          OpcuaNodeIdServicesMethod = 21819
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService                                                   OpcuaNodeIdServicesMethod = 21820
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService                                                      OpcuaNodeIdServicesMethod = 21821
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset                                                               OpcuaNodeIdServicesMethod = 21822
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable                                                             OpcuaNodeIdServicesMethod = 21861
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable                                                              OpcuaNodeIdServicesMethod = 21862
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment                                                          OpcuaNodeIdServicesMethod = 21863
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge                                                         OpcuaNodeIdServicesMethod = 21883
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm                                                             OpcuaNodeIdServicesMethod = 21885
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                           OpcuaNodeIdServicesMethod = 21930
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve                                              OpcuaNodeIdServicesMethod = 21932
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                                         OpcuaNodeIdServicesMethod = 21933
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence                                                             OpcuaNodeIdServicesMethod = 21965
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress                                                            OpcuaNodeIdServicesMethod = 21966
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress                                                          OpcuaNodeIdServicesMethod = 21967
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService                                                   OpcuaNodeIdServicesMethod = 21968
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService                                                      OpcuaNodeIdServicesMethod = 21969
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset                                                               OpcuaNodeIdServicesMethod = 21970
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable                                                                   OpcuaNodeIdServicesMethod = 22009
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable                                                                    OpcuaNodeIdServicesMethod = 22010
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment                                                                OpcuaNodeIdServicesMethod = 22011
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge                                                               OpcuaNodeIdServicesMethod = 22031
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm                                                                   OpcuaNodeIdServicesMethod = 22033
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve                                                 OpcuaNodeIdServicesMethod = 22078
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve                                                    OpcuaNodeIdServicesMethod = 22080
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve                                               OpcuaNodeIdServicesMethod = 22081
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence                                                                   OpcuaNodeIdServicesMethod = 22113
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress                                                                  OpcuaNodeIdServicesMethod = 22114
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress                                                                OpcuaNodeIdServicesMethod = 22115
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService                                                         OpcuaNodeIdServicesMethod = 22116
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService                                                            OpcuaNodeIdServicesMethod = 22117
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset                                                                     OpcuaNodeIdServicesMethod = 22118
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable                                                                   OpcuaNodeIdServicesMethod = 22157
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable                                                                    OpcuaNodeIdServicesMethod = 22158
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment                                                                OpcuaNodeIdServicesMethod = 22159
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge                                                               OpcuaNodeIdServicesMethod = 22179
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm                                                                   OpcuaNodeIdServicesMethod = 22181
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                                 OpcuaNodeIdServicesMethod = 22226
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve                                                    OpcuaNodeIdServicesMethod = 22228
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                                               OpcuaNodeIdServicesMethod = 22229
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence                                                                   OpcuaNodeIdServicesMethod = 22261
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress                                                                  OpcuaNodeIdServicesMethod = 22262
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress                                                                OpcuaNodeIdServicesMethod = 22263
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService                                                         OpcuaNodeIdServicesMethod = 22264
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService                                                            OpcuaNodeIdServicesMethod = 22265
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset                                                                     OpcuaNodeIdServicesMethod = 22266
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable                                                               OpcuaNodeIdServicesMethod = 22305
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable                                                                OpcuaNodeIdServicesMethod = 22306
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment                                                            OpcuaNodeIdServicesMethod = 22307
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge                                                           OpcuaNodeIdServicesMethod = 22327
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm                                                               OpcuaNodeIdServicesMethod = 22329
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve                                             OpcuaNodeIdServicesMethod = 22374
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve                                                OpcuaNodeIdServicesMethod = 22376
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve                                           OpcuaNodeIdServicesMethod = 22377
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence                                                               OpcuaNodeIdServicesMethod = 22409
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress                                                              OpcuaNodeIdServicesMethod = 22410
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress                                                            OpcuaNodeIdServicesMethod = 22411
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService                                                     OpcuaNodeIdServicesMethod = 22412
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService                                                        OpcuaNodeIdServicesMethod = 22413
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset                                                                 OpcuaNodeIdServicesMethod = 22414
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable                                                               OpcuaNodeIdServicesMethod = 22453
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable                                                                OpcuaNodeIdServicesMethod = 22454
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment                                                            OpcuaNodeIdServicesMethod = 22455
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge                                                           OpcuaNodeIdServicesMethod = 22475
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm                                                               OpcuaNodeIdServicesMethod = 22477
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                             OpcuaNodeIdServicesMethod = 22522
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve                                                OpcuaNodeIdServicesMethod = 22524
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                                           OpcuaNodeIdServicesMethod = 22525
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence                                                               OpcuaNodeIdServicesMethod = 22557
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress                                                              OpcuaNodeIdServicesMethod = 22558
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress                                                            OpcuaNodeIdServicesMethod = 22559
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService                                                     OpcuaNodeIdServicesMethod = 22560
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService                                                        OpcuaNodeIdServicesMethod = 22561
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset                                                                 OpcuaNodeIdServicesMethod = 22562
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable                                                                 OpcuaNodeIdServicesMethod = 22601
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable                                                                  OpcuaNodeIdServicesMethod = 22602
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment                                                              OpcuaNodeIdServicesMethod = 22603
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge                                                             OpcuaNodeIdServicesMethod = 22623
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm                                                                 OpcuaNodeIdServicesMethod = 22625
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve                                               OpcuaNodeIdServicesMethod = 22670
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve                                                  OpcuaNodeIdServicesMethod = 22672
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve                                             OpcuaNodeIdServicesMethod = 22673
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence                                                                 OpcuaNodeIdServicesMethod = 22705
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress                                                                OpcuaNodeIdServicesMethod = 22706
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress                                                              OpcuaNodeIdServicesMethod = 22707
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService                                                       OpcuaNodeIdServicesMethod = 22708
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService                                                          OpcuaNodeIdServicesMethod = 22709
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset                                                                   OpcuaNodeIdServicesMethod = 22710
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable                                                                 OpcuaNodeIdServicesMethod = 22749
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable                                                                  OpcuaNodeIdServicesMethod = 22750
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment                                                              OpcuaNodeIdServicesMethod = 22751
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge                                                             OpcuaNodeIdServicesMethod = 22771
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm                                                                 OpcuaNodeIdServicesMethod = 22773
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                               OpcuaNodeIdServicesMethod = 22818
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve                                                  OpcuaNodeIdServicesMethod = 22820
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                                             OpcuaNodeIdServicesMethod = 22821
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence                                                                 OpcuaNodeIdServicesMethod = 22853
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress                                                                OpcuaNodeIdServicesMethod = 22854
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress                                                              OpcuaNodeIdServicesMethod = 22855
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService                                                       OpcuaNodeIdServicesMethod = 22856
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService                                                          OpcuaNodeIdServicesMethod = 22857
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset                                                                   OpcuaNodeIdServicesMethod = 22858
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable                                                                       OpcuaNodeIdServicesMethod = 22897
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable                                                                        OpcuaNodeIdServicesMethod = 22898
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment                                                                    OpcuaNodeIdServicesMethod = 22899
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge                                                                   OpcuaNodeIdServicesMethod = 22919
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm                                                                       OpcuaNodeIdServicesMethod = 22921
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve                                                     OpcuaNodeIdServicesMethod = 22966
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve                                                        OpcuaNodeIdServicesMethod = 22968
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve                                                   OpcuaNodeIdServicesMethod = 22969
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence                                                                       OpcuaNodeIdServicesMethod = 23001
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress                                                                      OpcuaNodeIdServicesMethod = 23002
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress                                                                    OpcuaNodeIdServicesMethod = 23003
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService                                                             OpcuaNodeIdServicesMethod = 23004
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService                                                                OpcuaNodeIdServicesMethod = 23005
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset                                                                         OpcuaNodeIdServicesMethod = 23006
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable                                                                       OpcuaNodeIdServicesMethod = 23045
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable                                                                        OpcuaNodeIdServicesMethod = 23046
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment                                                                    OpcuaNodeIdServicesMethod = 23047
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge                                                                   OpcuaNodeIdServicesMethod = 23067
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm                                                                       OpcuaNodeIdServicesMethod = 23069
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                                     OpcuaNodeIdServicesMethod = 23114
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve                                                        OpcuaNodeIdServicesMethod = 23116
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                                                   OpcuaNodeIdServicesMethod = 23117
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence                                                                       OpcuaNodeIdServicesMethod = 23149
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress                                                                      OpcuaNodeIdServicesMethod = 23150
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress                                                                    OpcuaNodeIdServicesMethod = 23151
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService                                                             OpcuaNodeIdServicesMethod = 23152
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService                                                                OpcuaNodeIdServicesMethod = 23153
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset                                                                         OpcuaNodeIdServicesMethod = 23154
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable                                                                   OpcuaNodeIdServicesMethod = 23193
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable                                                                    OpcuaNodeIdServicesMethod = 23194
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment                                                                OpcuaNodeIdServicesMethod = 23195
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge                                                               OpcuaNodeIdServicesMethod = 23215
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm                                                                   OpcuaNodeIdServicesMethod = 23217
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve                                                 OpcuaNodeIdServicesMethod = 23262
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve                                                    OpcuaNodeIdServicesMethod = 23264
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve                                               OpcuaNodeIdServicesMethod = 23265
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence                                                                   OpcuaNodeIdServicesMethod = 23297
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress                                                                  OpcuaNodeIdServicesMethod = 23298
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress                                                                OpcuaNodeIdServicesMethod = 23299
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService                                                         OpcuaNodeIdServicesMethod = 23300
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService                                                            OpcuaNodeIdServicesMethod = 23301
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset                                                                     OpcuaNodeIdServicesMethod = 23302
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable                                                                   OpcuaNodeIdServicesMethod = 23341
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable                                                                    OpcuaNodeIdServicesMethod = 23342
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment                                                                OpcuaNodeIdServicesMethod = 23343
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge                                                               OpcuaNodeIdServicesMethod = 23363
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm                                                                   OpcuaNodeIdServicesMethod = 23365
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                                 OpcuaNodeIdServicesMethod = 23410
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve                                                    OpcuaNodeIdServicesMethod = 23412
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                                               OpcuaNodeIdServicesMethod = 23413
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence                                                                   OpcuaNodeIdServicesMethod = 23445
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress                                                                  OpcuaNodeIdServicesMethod = 23446
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress                                                                OpcuaNodeIdServicesMethod = 23447
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService                                                         OpcuaNodeIdServicesMethod = 23448
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService                                                            OpcuaNodeIdServicesMethod = 23449
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset                                                                     OpcuaNodeIdServicesMethod = 23450
	OpcuaNodeIdServicesMethod_AliasNameCategoryType_SubAliasNameCategories_Placeholder_FindAlias                                                                                       OpcuaNodeIdServicesMethod = 23459
	OpcuaNodeIdServicesMethod_AliasNameCategoryType_FindAlias                                                                                                                          OpcuaNodeIdServicesMethod = 23462
	OpcuaNodeIdServicesMethod_FindAliasMethodType                                                                                                                                      OpcuaNodeIdServicesMethod = 23465
	OpcuaNodeIdServicesMethod_Aliases_FindAlias                                                                                                                                        OpcuaNodeIdServicesMethod = 23476
	OpcuaNodeIdServicesMethod_TagVariables_FindAlias                                                                                                                                   OpcuaNodeIdServicesMethod = 23485
	OpcuaNodeIdServicesMethod_Topics_FindAlias                                                                                                                                         OpcuaNodeIdServicesMethod = 23494
	OpcuaNodeIdServicesMethod_CertificateGroupType_GetRejectedList                                                                                                                     OpcuaNodeIdServicesMethod = 23526
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_GetRejectedList                                                                                       OpcuaNodeIdServicesMethod = 23529
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_GetRejectedList                                                                                             OpcuaNodeIdServicesMethod = 23531
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_GetRejectedList                                                                                         OpcuaNodeIdServicesMethod = 23533
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_GetRejectedList                                                                                   OpcuaNodeIdServicesMethod = 23535
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList                                                                        OpcuaNodeIdServicesMethod = 23544
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList                                                                              OpcuaNodeIdServicesMethod = 23546
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList                                                                          OpcuaNodeIdServicesMethod = 23548
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_GetRejectedList                                                                            OpcuaNodeIdServicesMethod = 23550
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_GetRejectedList                                                                                  OpcuaNodeIdServicesMethod = 23552
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_GetRejectedList                                                                              OpcuaNodeIdServicesMethod = 23554
	OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder                                                                                                 OpcuaNodeIdServicesMethod = 23637
	OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder                                                                                              OpcuaNodeIdServicesMethod = 23640
	OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_AddDataSetFolder                                                                                                     OpcuaNodeIdServicesMethod = 23673
	OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder                                                                                                  OpcuaNodeIdServicesMethod = 23676
	OpcuaNodeIdServicesMethod_GetConnectionMethodType                                                                                                                                  OpcuaNodeIdServicesMethod = 23726
	OpcuaNodeIdServicesMethod_ModifyConnectionMethodType                                                                                                                               OpcuaNodeIdServicesMethod = 23729
	OpcuaNodeIdServicesMethod_GetWriterGroupMethodType                                                                                                                                 OpcuaNodeIdServicesMethod = 23745
	OpcuaNodeIdServicesMethod_ModifyWriterGroupMethodType                                                                                                                              OpcuaNodeIdServicesMethod = 23748
	OpcuaNodeIdServicesMethod_GetReaderGroupMethodType                                                                                                                                 OpcuaNodeIdServicesMethod = 23767
	OpcuaNodeIdServicesMethod_ModifyReaderGroupMethodType                                                                                                                              OpcuaNodeIdServicesMethod = 23770
	OpcuaNodeIdServicesMethod_GetDataSetWriterMethodType                                                                                                                               OpcuaNodeIdServicesMethod = 23779
	OpcuaNodeIdServicesMethod_ModifyDataSetWriterMethodType                                                                                                                            OpcuaNodeIdServicesMethod = 23781
	OpcuaNodeIdServicesMethod_GetDataSetReaderMethodType                                                                                                                               OpcuaNodeIdServicesMethod = 23790
	OpcuaNodeIdServicesMethod_ModifyDataSetReaderMethodType                                                                                                                            OpcuaNodeIdServicesMethod = 23792
	OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddSubscribedDataSet                                                                 OpcuaNodeIdServicesMethod = 23797
	OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveSubscribedDataSet                                                              OpcuaNodeIdServicesMethod = 23800
	OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddDataSetFolder                                                                     OpcuaNodeIdServicesMethod = 23802
	OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveDataSetFolder                                                                  OpcuaNodeIdServicesMethod = 23805
	OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_AddSubscribedDataSet                                                                                                         OpcuaNodeIdServicesMethod = 23811
	OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_RemoveSubscribedDataSet                                                                                                      OpcuaNodeIdServicesMethod = 23814
	OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_AddDataSetFolder                                                                                                             OpcuaNodeIdServicesMethod = 23816
	OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_RemoveDataSetFolder                                                                                                          OpcuaNodeIdServicesMethod = 23819
	OpcuaNodeIdServicesMethod_AddSubscribedDataSetMethodType                                                                                                                           OpcuaNodeIdServicesMethod = 23821
	OpcuaNodeIdServicesMethod_RemoveSubscribedDataSetMethodType                                                                                                                        OpcuaNodeIdServicesMethod = 23824
	OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet                                                                                             OpcuaNodeIdServicesMethod = 24004
	OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet                                                                                          OpcuaNodeIdServicesMethod = 24007
	OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet                                                                                                 OpcuaNodeIdServicesMethod = 24010
	OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet                                                                                              OpcuaNodeIdServicesMethod = 24013
	OpcuaNodeIdServicesMethod_UserManagementType_AddUser                                                                                                                               OpcuaNodeIdServicesMethod = 24269
	OpcuaNodeIdServicesMethod_UserManagementType_ModifyUser                                                                                                                            OpcuaNodeIdServicesMethod = 24271
	OpcuaNodeIdServicesMethod_UserManagementType_RemoveUser                                                                                                                            OpcuaNodeIdServicesMethod = 24273
	OpcuaNodeIdServicesMethod_UserManagementType_ChangePassword                                                                                                                        OpcuaNodeIdServicesMethod = 24275
	OpcuaNodeIdServicesMethod_AddUserMethodType                                                                                                                                        OpcuaNodeIdServicesMethod = 24282
	OpcuaNodeIdServicesMethod_ModifyUserMethodType                                                                                                                                     OpcuaNodeIdServicesMethod = 24284
	OpcuaNodeIdServicesMethod_RemoveUserMethodType                                                                                                                                     OpcuaNodeIdServicesMethod = 24286
	OpcuaNodeIdServicesMethod_ChangePasswordMethodType                                                                                                                                 OpcuaNodeIdServicesMethod = 24288
	OpcuaNodeIdServicesMethod_UserManagement_AddUser                                                                                                                                   OpcuaNodeIdServicesMethod = 24304
	OpcuaNodeIdServicesMethod_UserManagement_ModifyUser                                                                                                                                OpcuaNodeIdServicesMethod = 24306
	OpcuaNodeIdServicesMethod_UserManagement_RemoveUser                                                                                                                                OpcuaNodeIdServicesMethod = 24308
	OpcuaNodeIdServicesMethod_UserManagement_ChangePassword                                                                                                                            OpcuaNodeIdServicesMethod = 24310
	OpcuaNodeIdServicesMethod_DialogConditionType_Respond2                                                                                                                             OpcuaNodeIdServicesMethod = 24312
	OpcuaNodeIdServicesMethod_DialogResponse2MethodType                                                                                                                                OpcuaNodeIdServicesMethod = 24314
	OpcuaNodeIdServicesMethod_AlarmConditionType_Suppress2                                                                                                                             OpcuaNodeIdServicesMethod = 24316
	OpcuaNodeIdServicesMethod_AlarmConditionType_Unsuppress2                                                                                                                           OpcuaNodeIdServicesMethod = 24318
	OpcuaNodeIdServicesMethod_AlarmConditionType_RemoveFromService2                                                                                                                    OpcuaNodeIdServicesMethod = 24320
	OpcuaNodeIdServicesMethod_AlarmConditionType_PlaceInService2                                                                                                                       OpcuaNodeIdServicesMethod = 24322
	OpcuaNodeIdServicesMethod_AlarmConditionType_Reset2                                                                                                                                OpcuaNodeIdServicesMethod = 24324
	OpcuaNodeIdServicesMethod_WithCommentMethodType                                                                                                                                    OpcuaNodeIdServicesMethod = 24326
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress2                                                                                              OpcuaNodeIdServicesMethod = 24328
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress2                                                                                            OpcuaNodeIdServicesMethod = 24330
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2                                                                                     OpcuaNodeIdServicesMethod = 24332
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService2                                                                                        OpcuaNodeIdServicesMethod = 24334
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Reset2                                                                                                 OpcuaNodeIdServicesMethod = 24336
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Suppress2                                                                                                        OpcuaNodeIdServicesMethod = 24518
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Unsuppress2                                                                                                      OpcuaNodeIdServicesMethod = 24520
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_RemoveFromService2                                                                                               OpcuaNodeIdServicesMethod = 24522
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_PlaceInService2                                                                                                  OpcuaNodeIdServicesMethod = 24524
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Reset2                                                                                                           OpcuaNodeIdServicesMethod = 24526
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Suppress2                                                                                                        OpcuaNodeIdServicesMethod = 24528
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Unsuppress2                                                                                                      OpcuaNodeIdServicesMethod = 24530
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_RemoveFromService2                                                                                               OpcuaNodeIdServicesMethod = 24532
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_PlaceInService2                                                                                                  OpcuaNodeIdServicesMethod = 24534
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Reset2                                                                                                           OpcuaNodeIdServicesMethod = 24536
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress2                                                                          OpcuaNodeIdServicesMethod = 24538
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress2                                                                        OpcuaNodeIdServicesMethod = 24540
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService2                                                                 OpcuaNodeIdServicesMethod = 24542
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService2                                                                    OpcuaNodeIdServicesMethod = 24544
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset2                                                                             OpcuaNodeIdServicesMethod = 24546
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress2                                                                          OpcuaNodeIdServicesMethod = 24548
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2                                                                        OpcuaNodeIdServicesMethod = 24550
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2                                                                 OpcuaNodeIdServicesMethod = 24552
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2                                                                    OpcuaNodeIdServicesMethod = 24554
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset2                                                                             OpcuaNodeIdServicesMethod = 24556
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress2                                                                                OpcuaNodeIdServicesMethod = 24558
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress2                                                                              OpcuaNodeIdServicesMethod = 24560
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService2                                                                       OpcuaNodeIdServicesMethod = 24562
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService2                                                                          OpcuaNodeIdServicesMethod = 24564
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset2                                                                                   OpcuaNodeIdServicesMethod = 24566
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress2                                                                                OpcuaNodeIdServicesMethod = 24568
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2                                                                              OpcuaNodeIdServicesMethod = 24570
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2                                                                       OpcuaNodeIdServicesMethod = 24572
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2                                                                          OpcuaNodeIdServicesMethod = 24574
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset2                                                                                   OpcuaNodeIdServicesMethod = 24576
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress2                                                                            OpcuaNodeIdServicesMethod = 24578
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress2                                                                          OpcuaNodeIdServicesMethod = 24580
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2                                                                   OpcuaNodeIdServicesMethod = 24582
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService2                                                                      OpcuaNodeIdServicesMethod = 24584
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset2                                                                               OpcuaNodeIdServicesMethod = 24586
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2                                                                            OpcuaNodeIdServicesMethod = 24588
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2                                                                          OpcuaNodeIdServicesMethod = 24590
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2                                                                   OpcuaNodeIdServicesMethod = 24592
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2                                                                      OpcuaNodeIdServicesMethod = 24594
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset2                                                                               OpcuaNodeIdServicesMethod = 24596
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress2                                                                      OpcuaNodeIdServicesMethod = 24598
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress2                                                                    OpcuaNodeIdServicesMethod = 24600
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService2                                                             OpcuaNodeIdServicesMethod = 24602
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService2                                                                OpcuaNodeIdServicesMethod = 24604
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset2                                                                         OpcuaNodeIdServicesMethod = 24606
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress2                                                                      OpcuaNodeIdServicesMethod = 24608
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress2                                                                    OpcuaNodeIdServicesMethod = 24610
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService2                                                             OpcuaNodeIdServicesMethod = 24612
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService2                                                                OpcuaNodeIdServicesMethod = 24614
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset2                                                                         OpcuaNodeIdServicesMethod = 24616
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2                                                           OpcuaNodeIdServicesMethod = 24618
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2                                                         OpcuaNodeIdServicesMethod = 24620
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2                                                  OpcuaNodeIdServicesMethod = 24622
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2                                                     OpcuaNodeIdServicesMethod = 24624
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2                                                              OpcuaNodeIdServicesMethod = 24626
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2                                                           OpcuaNodeIdServicesMethod = 24628
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2                                                         OpcuaNodeIdServicesMethod = 24630
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2                                                  OpcuaNodeIdServicesMethod = 24632
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2                                                     OpcuaNodeIdServicesMethod = 24634
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2                                                              OpcuaNodeIdServicesMethod = 24636
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2                                                                 OpcuaNodeIdServicesMethod = 24638
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2                                                               OpcuaNodeIdServicesMethod = 24640
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2                                                        OpcuaNodeIdServicesMethod = 24642
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2                                                           OpcuaNodeIdServicesMethod = 24644
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2                                                                    OpcuaNodeIdServicesMethod = 24646
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2                                                                 OpcuaNodeIdServicesMethod = 24648
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2                                                               OpcuaNodeIdServicesMethod = 24650
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2                                                        OpcuaNodeIdServicesMethod = 24652
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2                                                           OpcuaNodeIdServicesMethod = 24654
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2                                                                    OpcuaNodeIdServicesMethod = 24656
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2                                                             OpcuaNodeIdServicesMethod = 24658
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2                                                           OpcuaNodeIdServicesMethod = 24660
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2                                                    OpcuaNodeIdServicesMethod = 24662
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2                                                       OpcuaNodeIdServicesMethod = 24664
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2                                                                OpcuaNodeIdServicesMethod = 24666
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2                                                             OpcuaNodeIdServicesMethod = 24668
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2                                                           OpcuaNodeIdServicesMethod = 24670
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2                                                    OpcuaNodeIdServicesMethod = 24672
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2                                                       OpcuaNodeIdServicesMethod = 24674
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2                                                                OpcuaNodeIdServicesMethod = 24676
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2                                                               OpcuaNodeIdServicesMethod = 24678
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2                                                             OpcuaNodeIdServicesMethod = 24680
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2                                                      OpcuaNodeIdServicesMethod = 24682
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2                                                         OpcuaNodeIdServicesMethod = 24684
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2                                                                  OpcuaNodeIdServicesMethod = 24686
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2                                                               OpcuaNodeIdServicesMethod = 24688
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2                                                             OpcuaNodeIdServicesMethod = 24690
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2                                                      OpcuaNodeIdServicesMethod = 24692
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2                                                         OpcuaNodeIdServicesMethod = 24694
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2                                                                  OpcuaNodeIdServicesMethod = 24696
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2                                                                     OpcuaNodeIdServicesMethod = 24698
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2                                                                   OpcuaNodeIdServicesMethod = 24700
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2                                                            OpcuaNodeIdServicesMethod = 24702
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2                                                               OpcuaNodeIdServicesMethod = 24704
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2                                                                        OpcuaNodeIdServicesMethod = 24706
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2                                                                     OpcuaNodeIdServicesMethod = 24708
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2                                                                   OpcuaNodeIdServicesMethod = 24710
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2                                                            OpcuaNodeIdServicesMethod = 24712
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2                                                               OpcuaNodeIdServicesMethod = 24714
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2                                                                        OpcuaNodeIdServicesMethod = 24716
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2                                                                 OpcuaNodeIdServicesMethod = 24718
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2                                                               OpcuaNodeIdServicesMethod = 24720
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2                                                        OpcuaNodeIdServicesMethod = 24722
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2                                                           OpcuaNodeIdServicesMethod = 24724
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2                                                                    OpcuaNodeIdServicesMethod = 24726
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2                                                                 OpcuaNodeIdServicesMethod = 24728
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2                                                               OpcuaNodeIdServicesMethod = 24730
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2                                                        OpcuaNodeIdServicesMethod = 24732
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2                                                           OpcuaNodeIdServicesMethod = 24734
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2                                                                    OpcuaNodeIdServicesMethod = 24736
	OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_TimedShelve2                                                                                                            OpcuaNodeIdServicesMethod = 24738
	OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_Unshelve2                                                                                                               OpcuaNodeIdServicesMethod = 24740
	OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_OneShotShelve2                                                                                                          OpcuaNodeIdServicesMethod = 24742
	OpcuaNodeIdServicesMethod_AlarmConditionType_GetGroupMemberships                                                                                                                   OpcuaNodeIdServicesMethod = 24744
	OpcuaNodeIdServicesMethod_GetGroupMembershipsMethodType                                                                                                                            OpcuaNodeIdServicesMethod = 24746
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2                                                                             OpcuaNodeIdServicesMethod = 24748
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2                                                                                OpcuaNodeIdServicesMethod = 24750
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2                                                                           OpcuaNodeIdServicesMethod = 24752
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships                                                                                    OpcuaNodeIdServicesMethod = 24754
	OpcuaNodeIdServicesMethod_ShelvedStateMachineType_TimedShelve2                                                                                                                     OpcuaNodeIdServicesMethod = 24756
	OpcuaNodeIdServicesMethod_ShelvedStateMachineType_Unshelve2                                                                                                                        OpcuaNodeIdServicesMethod = 24758
	OpcuaNodeIdServicesMethod_ShelvedStateMachineType_OneShotShelve2                                                                                                                   OpcuaNodeIdServicesMethod = 24760
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve2                                                                                       OpcuaNodeIdServicesMethod = 24978
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve2                                                                                          OpcuaNodeIdServicesMethod = 24980
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve2                                                                                     OpcuaNodeIdServicesMethod = 24982
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_GetGroupMemberships                                                                                              OpcuaNodeIdServicesMethod = 24984
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve2                                                                                       OpcuaNodeIdServicesMethod = 24986
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve2                                                                                          OpcuaNodeIdServicesMethod = 24988
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve2                                                                                     OpcuaNodeIdServicesMethod = 24990
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_GetGroupMemberships                                                                                              OpcuaNodeIdServicesMethod = 24992
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2                                                         OpcuaNodeIdServicesMethod = 24994
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2                                                            OpcuaNodeIdServicesMethod = 24996
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2                                                       OpcuaNodeIdServicesMethod = 24998
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships                                                                OpcuaNodeIdServicesMethod = 25000
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                                         OpcuaNodeIdServicesMethod = 25002
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                                            OpcuaNodeIdServicesMethod = 25004
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                                                       OpcuaNodeIdServicesMethod = 25006
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships                                                                OpcuaNodeIdServicesMethod = 25008
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2                                                               OpcuaNodeIdServicesMethod = 25010
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2                                                                  OpcuaNodeIdServicesMethod = 25012
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2                                                             OpcuaNodeIdServicesMethod = 25014
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships                                                                      OpcuaNodeIdServicesMethod = 25016
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                                               OpcuaNodeIdServicesMethod = 25018
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                                                  OpcuaNodeIdServicesMethod = 25020
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                                                             OpcuaNodeIdServicesMethod = 25022
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships                                                                      OpcuaNodeIdServicesMethod = 25024
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2                                                           OpcuaNodeIdServicesMethod = 25026
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2                                                              OpcuaNodeIdServicesMethod = 25028
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2                                                         OpcuaNodeIdServicesMethod = 25030
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships                                                                  OpcuaNodeIdServicesMethod = 25032
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                                           OpcuaNodeIdServicesMethod = 25034
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                                              OpcuaNodeIdServicesMethod = 25036
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                                                         OpcuaNodeIdServicesMethod = 25038
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships                                                                  OpcuaNodeIdServicesMethod = 25040
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve2                                                     OpcuaNodeIdServicesMethod = 25042
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve2                                                        OpcuaNodeIdServicesMethod = 25044
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve2                                                   OpcuaNodeIdServicesMethod = 25046
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_GetGroupMemberships                                                            OpcuaNodeIdServicesMethod = 25048
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve2                                                     OpcuaNodeIdServicesMethod = 25050
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve2                                                        OpcuaNodeIdServicesMethod = 25052
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve2                                                   OpcuaNodeIdServicesMethod = 25054
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_GetGroupMemberships                                                            OpcuaNodeIdServicesMethod = 25056
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2                                          OpcuaNodeIdServicesMethod = 25058
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2                                             OpcuaNodeIdServicesMethod = 25060
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2                                        OpcuaNodeIdServicesMethod = 25062
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships                                                 OpcuaNodeIdServicesMethod = 25064
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                          OpcuaNodeIdServicesMethod = 25066
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                             OpcuaNodeIdServicesMethod = 25068
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                                        OpcuaNodeIdServicesMethod = 25070
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships                                                 OpcuaNodeIdServicesMethod = 25072
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2                                                OpcuaNodeIdServicesMethod = 25074
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2                                                   OpcuaNodeIdServicesMethod = 25076
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2                                              OpcuaNodeIdServicesMethod = 25078
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships                                                       OpcuaNodeIdServicesMethod = 25080
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                                OpcuaNodeIdServicesMethod = 25082
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                                   OpcuaNodeIdServicesMethod = 25084
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                                              OpcuaNodeIdServicesMethod = 25086
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships                                                       OpcuaNodeIdServicesMethod = 25088
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2                                            OpcuaNodeIdServicesMethod = 25090
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2                                               OpcuaNodeIdServicesMethod = 25092
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2                                          OpcuaNodeIdServicesMethod = 25094
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships                                                   OpcuaNodeIdServicesMethod = 25096
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                            OpcuaNodeIdServicesMethod = 25098
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                               OpcuaNodeIdServicesMethod = 25100
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                                          OpcuaNodeIdServicesMethod = 25102
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships                                                   OpcuaNodeIdServicesMethod = 25104
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2                                              OpcuaNodeIdServicesMethod = 25106
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2                                                 OpcuaNodeIdServicesMethod = 25108
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2                                            OpcuaNodeIdServicesMethod = 25110
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships                                                     OpcuaNodeIdServicesMethod = 25112
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                              OpcuaNodeIdServicesMethod = 25114
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                                 OpcuaNodeIdServicesMethod = 25116
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                                            OpcuaNodeIdServicesMethod = 25118
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships                                                     OpcuaNodeIdServicesMethod = 25120
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2                                                    OpcuaNodeIdServicesMethod = 25122
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2                                                       OpcuaNodeIdServicesMethod = 25124
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2                                                  OpcuaNodeIdServicesMethod = 25126
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships                                                           OpcuaNodeIdServicesMethod = 25128
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                                    OpcuaNodeIdServicesMethod = 25130
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                                       OpcuaNodeIdServicesMethod = 25132
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                                                  OpcuaNodeIdServicesMethod = 25134
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships                                                           OpcuaNodeIdServicesMethod = 25136
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2                                                OpcuaNodeIdServicesMethod = 25138
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2                                                   OpcuaNodeIdServicesMethod = 25140
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2                                              OpcuaNodeIdServicesMethod = 25142
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships                                                       OpcuaNodeIdServicesMethod = 25144
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                                OpcuaNodeIdServicesMethod = 25146
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                                   OpcuaNodeIdServicesMethod = 25148
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                                              OpcuaNodeIdServicesMethod = 25150
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships                                                       OpcuaNodeIdServicesMethod = 25152
	OpcuaNodeIdServicesMethod_TimedShelve2MethodType                                                                                                                                   OpcuaNodeIdServicesMethod = 25157
	OpcuaNodeIdServicesMethod_PriorityMappingTableType_AddPriorityMappingEntry                                                                                                         OpcuaNodeIdServicesMethod = 25229
	OpcuaNodeIdServicesMethod_PriorityMappingTableType_DeletePriorityMappingEntry                                                                                                      OpcuaNodeIdServicesMethod = 25231
	OpcuaNodeIdServicesMethod_AddPriorityMappingEntryMethodType                                                                                                                        OpcuaNodeIdServicesMethod = 25233
	OpcuaNodeIdServicesMethod_DeletePriorityMappingEntryMethodType                                                                                                                     OpcuaNodeIdServicesMethod = 25235
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder                                                                                               OpcuaNodeIdServicesMethod = 25271
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder                                                                                            OpcuaNodeIdServicesMethod = 25274
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_AddPushTarget                                                                                                        OpcuaNodeIdServicesMethod = 25278
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_RemovePushTarget                                                                                                     OpcuaNodeIdServicesMethod = 25281
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder                                                                                                  OpcuaNodeIdServicesMethod = 25283
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder                                                                                               OpcuaNodeIdServicesMethod = 25286
	OpcuaNodeIdServicesMethod_AddSecurityGroupFolderMethodType                                                                                                                         OpcuaNodeIdServicesMethod = 25288
	OpcuaNodeIdServicesMethod_RemoveSecurityGroupFolderMethodType                                                                                                                      OpcuaNodeIdServicesMethod = 25291
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder                                                                       OpcuaNodeIdServicesMethod = 25293
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder                                                                    OpcuaNodeIdServicesMethod = 25296
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_AddSecurityGroupFolder                                                                                                           OpcuaNodeIdServicesMethod = 25312
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_RemoveSecurityGroupFolder                                                                                                        OpcuaNodeIdServicesMethod = 25315
	OpcuaNodeIdServicesMethod_ConnectSecurityGroupsMethodType                                                                                                                          OpcuaNodeIdServicesMethod = 25331
	OpcuaNodeIdServicesMethod_DisconnectSecurityGroupsMethodType                                                                                                                       OpcuaNodeIdServicesMethod = 25334
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget                                                                             OpcuaNodeIdServicesMethod = 25348
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget                                                                          OpcuaNodeIdServicesMethod = 25351
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder                                                                       OpcuaNodeIdServicesMethod = 25353
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder                                                                    OpcuaNodeIdServicesMethod = 25356
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_AddPushTarget                                                                                                              OpcuaNodeIdServicesMethod = 25366
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_RemovePushTarget                                                                                                           OpcuaNodeIdServicesMethod = 25369
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_AddPushTargetFolder                                                                                                        OpcuaNodeIdServicesMethod = 25371
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_RemovePushTargetFolder                                                                                                     OpcuaNodeIdServicesMethod = 25374
	OpcuaNodeIdServicesMethod_AddPushTargetMethodType                                                                                                                                  OpcuaNodeIdServicesMethod = 25376
	OpcuaNodeIdServicesMethod_RemovePushTargetMethodType                                                                                                                               OpcuaNodeIdServicesMethod = 25379
	OpcuaNodeIdServicesMethod_AddPushTargetFolderMethodType                                                                                                                            OpcuaNodeIdServicesMethod = 25381
	OpcuaNodeIdServicesMethod_RemovePushTargetFolderMethodType                                                                                                                         OpcuaNodeIdServicesMethod = 25384
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Open                                                                                                            OpcuaNodeIdServicesMethod = 25411
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Close                                                                                                           OpcuaNodeIdServicesMethod = 25414
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Read                                                                                                            OpcuaNodeIdServicesMethod = 25416
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Write                                                                                                           OpcuaNodeIdServicesMethod = 25419
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_GetPosition                                                                                                     OpcuaNodeIdServicesMethod = 25421
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_SetPosition                                                                                                     OpcuaNodeIdServicesMethod = 25424
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_ReserveIds                                                                                                      OpcuaNodeIdServicesMethod = 25426
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate                                                                                                  OpcuaNodeIdServicesMethod = 25429
	OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder                                                                                                   OpcuaNodeIdServicesMethod = 25434
	OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder                                                                                                OpcuaNodeIdServicesMethod = 25437
	OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_AddPushTarget                                                                                                            OpcuaNodeIdServicesMethod = 25441
	OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_RemovePushTarget                                                                                                         OpcuaNodeIdServicesMethod = 25444
	OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_AddPushTargetFolder                                                                                                      OpcuaNodeIdServicesMethod = 25446
	OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_RemovePushTargetFolder                                                                                                   OpcuaNodeIdServicesMethod = 25449
	OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Open                                                                                                                OpcuaNodeIdServicesMethod = 25459
	OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Close                                                                                                               OpcuaNodeIdServicesMethod = 25462
	OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Read                                                                                                                OpcuaNodeIdServicesMethod = 25464
	OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Write                                                                                                               OpcuaNodeIdServicesMethod = 25467
	OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_GetPosition                                                                                                         OpcuaNodeIdServicesMethod = 25469
	OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_SetPosition                                                                                                         OpcuaNodeIdServicesMethod = 25472
	OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_ReserveIds                                                                                                          OpcuaNodeIdServicesMethod = 25474
	OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_CloseAndUpdate                                                                                                      OpcuaNodeIdServicesMethod = 25477
	OpcuaNodeIdServicesMethod_PubSubConfigurationType_ReserveIds                                                                                                                       OpcuaNodeIdServicesMethod = 25505
	OpcuaNodeIdServicesMethod_PubSubConfigurationType_CloseAndUpdate                                                                                                                   OpcuaNodeIdServicesMethod = 25508
	OpcuaNodeIdServicesMethod_PubSubConfigurationTypeReserveIdsMethodType                                                                                                              OpcuaNodeIdServicesMethod = 25511
	OpcuaNodeIdServicesMethod_PubSubConfigurationTypeCloseAndUpdateMethodType                                                                                                          OpcuaNodeIdServicesMethod = 25514
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddIdentity                                                                                                         OpcuaNodeIdServicesMethod = 25572
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity                                                                                                      OpcuaNodeIdServicesMethod = 25574
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddApplication                                                                                                      OpcuaNodeIdServicesMethod = 25576
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveApplication                                                                                                   OpcuaNodeIdServicesMethod = 25578
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddEndpoint                                                                                                         OpcuaNodeIdServicesMethod = 25580
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint                                                                                                      OpcuaNodeIdServicesMethod = 25582
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddIdentity                                                                                                          OpcuaNodeIdServicesMethod = 25591
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveIdentity                                                                                                       OpcuaNodeIdServicesMethod = 25593
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddApplication                                                                                                       OpcuaNodeIdServicesMethod = 25595
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveApplication                                                                                                    OpcuaNodeIdServicesMethod = 25597
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddEndpoint                                                                                                          OpcuaNodeIdServicesMethod = 25599
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveEndpoint                                                                                                       OpcuaNodeIdServicesMethod = 25601
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddIdentity                                                                                                        OpcuaNodeIdServicesMethod = 25610
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveIdentity                                                                                                     OpcuaNodeIdServicesMethod = 25612
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddApplication                                                                                                     OpcuaNodeIdServicesMethod = 25614
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveApplication                                                                                                  OpcuaNodeIdServicesMethod = 25616
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddEndpoint                                                                                                        OpcuaNodeIdServicesMethod = 25618
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint                                                                                                     OpcuaNodeIdServicesMethod = 25620
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupName_Placeholder_InvalidateKeys                                                                                     OpcuaNodeIdServicesMethod = 25622
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupName_Placeholder_ForceKeyRotation                                                                                   OpcuaNodeIdServicesMethod = 25623
	OpcuaNodeIdServicesMethod_SecurityGroupType_InvalidateKeys                                                                                                                         OpcuaNodeIdServicesMethod = 25624
	OpcuaNodeIdServicesMethod_SecurityGroupType_ForceKeyRotation                                                                                                                       OpcuaNodeIdServicesMethod = 25625
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_InvalidateKeys                                                                                     OpcuaNodeIdServicesMethod = 25632
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_ForceKeyRotation                                                                                   OpcuaNodeIdServicesMethod = 25633
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_ConnectSecurityGroups                                                                                                            OpcuaNodeIdServicesMethod = 25641
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_DisconnectSecurityGroups                                                                                                         OpcuaNodeIdServicesMethod = 25644
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_TriggerKeyUpdate                                                                                                                 OpcuaNodeIdServicesMethod = 25647
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups                                                                           OpcuaNodeIdServicesMethod = 25655
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups                                                                        OpcuaNodeIdServicesMethod = 25658
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_TriggerKeyUpdate                                                                                OpcuaNodeIdServicesMethod = 25661
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CancelChanges                                                                                                                    OpcuaNodeIdServicesMethod = 25698
	OpcuaNodeIdServicesMethod_ServerConfigurationType_ResetToServerDefaults                                                                                                            OpcuaNodeIdServicesMethod = 25699
	OpcuaNodeIdServicesMethod_ServerConfiguration_CancelChanges                                                                                                                        OpcuaNodeIdServicesMethod = 25708
	OpcuaNodeIdServicesMethod_ServerConfiguration_ResetToServerDefaults                                                                                                                OpcuaNodeIdServicesMethod = 25709
	OpcuaNodeIdServicesMethod_RequestTicketsMethodType                                                                                                                                 OpcuaNodeIdServicesMethod = 25727
	OpcuaNodeIdServicesMethod_SetRegistrarEndpointsMethodType                                                                                                                          OpcuaNodeIdServicesMethod = 25729
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_RequestTickets                                                                                                                   OpcuaNodeIdServicesMethod = 26873
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_SetRegistrarEndpoints                                                                                                            OpcuaNodeIdServicesMethod = 26875
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open                                             OpcuaNodeIdServicesMethod = 26889
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close                                            OpcuaNodeIdServicesMethod = 26892
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read                                             OpcuaNodeIdServicesMethod = 26894
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write                                            OpcuaNodeIdServicesMethod = 26897
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition                                      OpcuaNodeIdServicesMethod = 26899
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition                                      OpcuaNodeIdServicesMethod = 26902
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks                                    OpcuaNodeIdServicesMethod = 26907
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate                                   OpcuaNodeIdServicesMethod = 26910
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate                                   OpcuaNodeIdServicesMethod = 26913
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate                                OpcuaNodeIdServicesMethod = 26915
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList                                            OpcuaNodeIdServicesMethod = 26919
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable                                 OpcuaNodeIdServicesMethod = 26954
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable                                  OpcuaNodeIdServicesMethod = 26955
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment                              OpcuaNodeIdServicesMethod = 26956
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge                             OpcuaNodeIdServicesMethod = 26976
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm                                 OpcuaNodeIdServicesMethod = 26978
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve               OpcuaNodeIdServicesMethod = 27023
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2              OpcuaNodeIdServicesMethod = 27025
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve                  OpcuaNodeIdServicesMethod = 27027
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2                 OpcuaNodeIdServicesMethod = 27028
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve             OpcuaNodeIdServicesMethod = 27030
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2            OpcuaNodeIdServicesMethod = 27031
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence                                 OpcuaNodeIdServicesMethod = 27064
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress                                OpcuaNodeIdServicesMethod = 27065
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2                               OpcuaNodeIdServicesMethod = 27066
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress                              OpcuaNodeIdServicesMethod = 27068
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2                             OpcuaNodeIdServicesMethod = 27069
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService                       OpcuaNodeIdServicesMethod = 27071
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2                      OpcuaNodeIdServicesMethod = 27072
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService                          OpcuaNodeIdServicesMethod = 27074
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2                         OpcuaNodeIdServicesMethod = 27075
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset                                   OpcuaNodeIdServicesMethod = 27077
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2                                  OpcuaNodeIdServicesMethod = 27078
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships                     OpcuaNodeIdServicesMethod = 27080
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable                                 OpcuaNodeIdServicesMethod = 27120
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable                                  OpcuaNodeIdServicesMethod = 27121
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment                              OpcuaNodeIdServicesMethod = 27122
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge                             OpcuaNodeIdServicesMethod = 27142
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm                                 OpcuaNodeIdServicesMethod = 27144
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve               OpcuaNodeIdServicesMethod = 27189
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2              OpcuaNodeIdServicesMethod = 27191
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve                  OpcuaNodeIdServicesMethod = 27193
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2                 OpcuaNodeIdServicesMethod = 27194
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve             OpcuaNodeIdServicesMethod = 27196
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2            OpcuaNodeIdServicesMethod = 27197
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence                                 OpcuaNodeIdServicesMethod = 27230
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress                                OpcuaNodeIdServicesMethod = 27231
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2                               OpcuaNodeIdServicesMethod = 27232
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress                              OpcuaNodeIdServicesMethod = 27234
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2                             OpcuaNodeIdServicesMethod = 27235
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService                       OpcuaNodeIdServicesMethod = 27237
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2                      OpcuaNodeIdServicesMethod = 27238
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService                          OpcuaNodeIdServicesMethod = 27240
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2                         OpcuaNodeIdServicesMethod = 27241
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset                                   OpcuaNodeIdServicesMethod = 27243
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2                                  OpcuaNodeIdServicesMethod = 27244
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships                     OpcuaNodeIdServicesMethod = 27246
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open                                                   OpcuaNodeIdServicesMethod = 27261
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close                                                  OpcuaNodeIdServicesMethod = 27264
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read                                                   OpcuaNodeIdServicesMethod = 27266
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write                                                  OpcuaNodeIdServicesMethod = 27269
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition                                            OpcuaNodeIdServicesMethod = 27271
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition                                            OpcuaNodeIdServicesMethod = 27274
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks                                          OpcuaNodeIdServicesMethod = 27279
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate                                         OpcuaNodeIdServicesMethod = 27282
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate                                         OpcuaNodeIdServicesMethod = 27285
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate                                      OpcuaNodeIdServicesMethod = 27287
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList                                                  OpcuaNodeIdServicesMethod = 27291
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable                                       OpcuaNodeIdServicesMethod = 27326
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable                                        OpcuaNodeIdServicesMethod = 27327
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment                                    OpcuaNodeIdServicesMethod = 27328
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge                                   OpcuaNodeIdServicesMethod = 27348
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm                                       OpcuaNodeIdServicesMethod = 27350
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve                     OpcuaNodeIdServicesMethod = 27395
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2                    OpcuaNodeIdServicesMethod = 27397
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve                        OpcuaNodeIdServicesMethod = 27399
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2                       OpcuaNodeIdServicesMethod = 27400
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve                   OpcuaNodeIdServicesMethod = 27402
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2                  OpcuaNodeIdServicesMethod = 27403
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence                                       OpcuaNodeIdServicesMethod = 27436
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress                                      OpcuaNodeIdServicesMethod = 27437
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2                                     OpcuaNodeIdServicesMethod = 27438
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress                                    OpcuaNodeIdServicesMethod = 27440
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2                                   OpcuaNodeIdServicesMethod = 27441
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService                             OpcuaNodeIdServicesMethod = 27443
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2                            OpcuaNodeIdServicesMethod = 27444
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService                                OpcuaNodeIdServicesMethod = 27446
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2                               OpcuaNodeIdServicesMethod = 27447
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset                                         OpcuaNodeIdServicesMethod = 27449
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2                                        OpcuaNodeIdServicesMethod = 27450
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships                           OpcuaNodeIdServicesMethod = 27452
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable                                       OpcuaNodeIdServicesMethod = 27492
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable                                        OpcuaNodeIdServicesMethod = 27493
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment                                    OpcuaNodeIdServicesMethod = 27494
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge                                   OpcuaNodeIdServicesMethod = 27514
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm                                       OpcuaNodeIdServicesMethod = 27516
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve                     OpcuaNodeIdServicesMethod = 27561
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                    OpcuaNodeIdServicesMethod = 27563
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve                        OpcuaNodeIdServicesMethod = 27565
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2                       OpcuaNodeIdServicesMethod = 27566
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                   OpcuaNodeIdServicesMethod = 27568
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                  OpcuaNodeIdServicesMethod = 27569
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence                                       OpcuaNodeIdServicesMethod = 27602
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress                                      OpcuaNodeIdServicesMethod = 27603
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2                                     OpcuaNodeIdServicesMethod = 27604
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress                                    OpcuaNodeIdServicesMethod = 27606
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2                                   OpcuaNodeIdServicesMethod = 27607
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService                             OpcuaNodeIdServicesMethod = 27609
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2                            OpcuaNodeIdServicesMethod = 27610
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService                                OpcuaNodeIdServicesMethod = 27612
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2                               OpcuaNodeIdServicesMethod = 27613
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset                                         OpcuaNodeIdServicesMethod = 27615
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2                                        OpcuaNodeIdServicesMethod = 27616
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships                           OpcuaNodeIdServicesMethod = 27618
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open                                               OpcuaNodeIdServicesMethod = 27633
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close                                              OpcuaNodeIdServicesMethod = 27636
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read                                               OpcuaNodeIdServicesMethod = 27638
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write                                              OpcuaNodeIdServicesMethod = 27641
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition                                        OpcuaNodeIdServicesMethod = 27643
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition                                        OpcuaNodeIdServicesMethod = 27646
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks                                      OpcuaNodeIdServicesMethod = 27651
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate                                     OpcuaNodeIdServicesMethod = 27654
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate                                     OpcuaNodeIdServicesMethod = 27657
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate                                  OpcuaNodeIdServicesMethod = 27659
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList                                              OpcuaNodeIdServicesMethod = 27663
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable                                   OpcuaNodeIdServicesMethod = 27698
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable                                    OpcuaNodeIdServicesMethod = 27699
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment                                OpcuaNodeIdServicesMethod = 27700
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge                               OpcuaNodeIdServicesMethod = 27720
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm                                   OpcuaNodeIdServicesMethod = 27722
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve                 OpcuaNodeIdServicesMethod = 27767
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2                OpcuaNodeIdServicesMethod = 27769
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve                    OpcuaNodeIdServicesMethod = 27771
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2                   OpcuaNodeIdServicesMethod = 27772
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve               OpcuaNodeIdServicesMethod = 27774
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2              OpcuaNodeIdServicesMethod = 27775
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence                                   OpcuaNodeIdServicesMethod = 27808
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress                                  OpcuaNodeIdServicesMethod = 27809
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2                                 OpcuaNodeIdServicesMethod = 27810
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress                                OpcuaNodeIdServicesMethod = 27812
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2                               OpcuaNodeIdServicesMethod = 27813
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService                         OpcuaNodeIdServicesMethod = 27815
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2                        OpcuaNodeIdServicesMethod = 27816
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService                            OpcuaNodeIdServicesMethod = 27818
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2                           OpcuaNodeIdServicesMethod = 27819
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset                                     OpcuaNodeIdServicesMethod = 27821
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2                                    OpcuaNodeIdServicesMethod = 27822
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships                       OpcuaNodeIdServicesMethod = 27824
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable                                   OpcuaNodeIdServicesMethod = 27864
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable                                    OpcuaNodeIdServicesMethod = 27865
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment                                OpcuaNodeIdServicesMethod = 27866
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge                               OpcuaNodeIdServicesMethod = 27886
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm                                   OpcuaNodeIdServicesMethod = 27888
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve                 OpcuaNodeIdServicesMethod = 27933
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                OpcuaNodeIdServicesMethod = 27935
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve                    OpcuaNodeIdServicesMethod = 27937
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2                   OpcuaNodeIdServicesMethod = 27938
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve               OpcuaNodeIdServicesMethod = 27940
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2              OpcuaNodeIdServicesMethod = 27941
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence                                   OpcuaNodeIdServicesMethod = 27974
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress                                  OpcuaNodeIdServicesMethod = 27975
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2                                 OpcuaNodeIdServicesMethod = 27976
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress                                OpcuaNodeIdServicesMethod = 27978
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2                               OpcuaNodeIdServicesMethod = 27979
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService                         OpcuaNodeIdServicesMethod = 27981
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2                        OpcuaNodeIdServicesMethod = 27982
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService                            OpcuaNodeIdServicesMethod = 27984
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2                           OpcuaNodeIdServicesMethod = 27985
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset                                     OpcuaNodeIdServicesMethod = 27987
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2                                    OpcuaNodeIdServicesMethod = 27988
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships                       OpcuaNodeIdServicesMethod = 27990
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate                                                                                    OpcuaNodeIdServicesMethod = 28005
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ApplyChanges                                                                                         OpcuaNodeIdServicesMethod = 28008
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CancelChanges                                                                                        OpcuaNodeIdServicesMethod = 28009
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest                                                                                 OpcuaNodeIdServicesMethod = 28010
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_GetRejectedList                                                                                      OpcuaNodeIdServicesMethod = 28013
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ResetToServerDefaults                                                                                OpcuaNodeIdServicesMethod = 28015
	OpcuaNodeIdServicesMethod_ProvisionableDevice_RequestTickets                                                                                                                       OpcuaNodeIdServicesMethod = 29880
	OpcuaNodeIdServicesMethod_ProvisionableDevice_SetRegistrarEndpoints                                                                                                                OpcuaNodeIdServicesMethod = 29882
	OpcuaNodeIdServicesMethod_GetCertificatesMethodType                                                                                                                                OpcuaNodeIdServicesMethod = 32282
	OpcuaNodeIdServicesMethod_ServerConfigurationType_GetCertificates                                                                                                                  OpcuaNodeIdServicesMethod = 32296
	OpcuaNodeIdServicesMethod_ServerConfiguration_GetCertificates                                                                                                                      OpcuaNodeIdServicesMethod = 32333
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates                                                                                      OpcuaNodeIdServicesMethod = 32359
	OpcuaNodeIdServicesMethod_NonTransparentBackupRedundancyType_Failover                                                                                                              OpcuaNodeIdServicesMethod = 32416
)

var OpcuaNodeIdServicesMethodValues []OpcuaNodeIdServicesMethod

func init() {
	_ = errors.New
	OpcuaNodeIdServicesMethodValues = []OpcuaNodeIdServicesMethod{
		OpcuaNodeIdServicesMethod_ProgramStateMachineType_Start,
		OpcuaNodeIdServicesMethod_ProgramStateMachineType_Suspend,
		OpcuaNodeIdServicesMethod_ProgramStateMachineType_Resume,
		OpcuaNodeIdServicesMethod_ProgramStateMachineType_Halt,
		OpcuaNodeIdServicesMethod_ProgramStateMachineType_Reset,
		OpcuaNodeIdServicesMethod_ShelvedStateMachineType_Unshelve,
		OpcuaNodeIdServicesMethod_ShelvedStateMachineType_OneShotShelve,
		OpcuaNodeIdServicesMethod_ShelvedStateMachineType_TimedShelve,
		OpcuaNodeIdServicesMethod_AddCommentMethodType,
		OpcuaNodeIdServicesMethod_ConditionType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_TimedShelveMethodType,
		OpcuaNodeIdServicesMethod_ConditionRefreshMethodType,
		OpcuaNodeIdServicesMethod_ConditionType_Enable,
		OpcuaNodeIdServicesMethod_ConditionType_Disable,
		OpcuaNodeIdServicesMethod_ConditionType_AddComment,
		OpcuaNodeIdServicesMethod_DialogResponseMethodType,
		OpcuaNodeIdServicesMethod_DialogConditionType_Respond,
		OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Acknowledge,
		OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Confirm,
		OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerType_GetMonitoredItems,
		OpcuaNodeIdServicesMethod_Server_GetMonitoredItems,
		OpcuaNodeIdServicesMethod_GetMonitoredItemsMethodType,
		OpcuaNodeIdServicesMethod_FileType_Open,
		OpcuaNodeIdServicesMethod_FileType_Close,
		OpcuaNodeIdServicesMethod_FileType_Read,
		OpcuaNodeIdServicesMethod_FileType_Write,
		OpcuaNodeIdServicesMethod_FileType_GetPosition,
		OpcuaNodeIdServicesMethod_FileType_SetPosition,
		OpcuaNodeIdServicesMethod_AddressSpaceFileType_ExportNamespace,
		OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Open,
		OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Close,
		OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Read,
		OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Write,
		OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_GetPosition,
		OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_SetPosition,
		OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_ExportNamespace,
		OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open,
		OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close,
		OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read,
		OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write,
		OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition,
		OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition,
		OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_ExportNamespace,
		OpcuaNodeIdServicesMethod_OpenMethodType,
		OpcuaNodeIdServicesMethod_CloseMethodType,
		OpcuaNodeIdServicesMethod_ReadMethodType,
		OpcuaNodeIdServicesMethod_WriteMethodType,
		OpcuaNodeIdServicesMethod_GetPositionMethodType,
		OpcuaNodeIdServicesMethod_SetPositionMethodType,
		OpcuaNodeIdServicesMethod_OpenWithMasksMethodType,
		OpcuaNodeIdServicesMethod_CloseAndUpdateMethodType,
		OpcuaNodeIdServicesMethod_AddCertificateMethodType,
		OpcuaNodeIdServicesMethod_RemoveCertificateMethodType,
		OpcuaNodeIdServicesMethod_TrustListType_OpenWithMasks,
		OpcuaNodeIdServicesMethod_TrustListType_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_TrustListType_AddCertificate,
		OpcuaNodeIdServicesMethod_TrustListType_RemoveCertificate,
		OpcuaNodeIdServicesMethod_UpdateCertificateMethodType,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_UpdateCertificate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CreateSigningRequest,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_ApplyChanges,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CreateSigningRequest,
		OpcuaNodeIdServicesMethod_ServerConfiguration_ApplyChanges,
		OpcuaNodeIdServicesMethod_CreateSigningRequestMethodType,
		OpcuaNodeIdServicesMethod_ServerType_SetSubscriptionDurable,
		OpcuaNodeIdServicesMethod_Server_SetSubscriptionDurable,
		OpcuaNodeIdServicesMethod_SetSubscriptionDurableMethodType,
		OpcuaNodeIdServicesMethod_GetRejectedListMethodType,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_GetRejectedList,
		OpcuaNodeIdServicesMethod_ServerConfiguration_GetRejectedList,
		OpcuaNodeIdServicesMethod_ServerType_ResendData,
		OpcuaNodeIdServicesMethod_Server_ResendData,
		OpcuaNodeIdServicesMethod_ResendDataMethodType,
		OpcuaNodeIdServicesMethod_ServerType_RequestServerStateChange,
		OpcuaNodeIdServicesMethod_Server_RequestServerStateChange,
		OpcuaNodeIdServicesMethod_RequestServerStateChangeMethodType,
		OpcuaNodeIdServicesMethod_ConditionType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_ConditionRefresh2MethodType,
		OpcuaNodeIdServicesMethod_CreateDirectoryMethodType,
		OpcuaNodeIdServicesMethod_CreateFileMethodType,
		OpcuaNodeIdServicesMethod_DeleteFileMethodType,
		OpcuaNodeIdServicesMethod_MoveOrCopyMethodType,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Open,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Close,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Read,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Write,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_GetPosition,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_SetPosition,
		OpcuaNodeIdServicesMethod_FileDirectoryType_CreateDirectory,
		OpcuaNodeIdServicesMethod_FileDirectoryType_CreateFile,
		OpcuaNodeIdServicesMethod_FileDirectoryType_DeleteFileSystemObject,
		OpcuaNodeIdServicesMethod_FileDirectoryType_MoveOrCopy,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Open,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Close,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Read,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Write,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_UpdateCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_RemoveConnectionMethodType,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_RemoveGroup,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Status_Enable,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Status_Disable,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_RemoveConnection,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedEvents,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet,
		OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems,
		OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents,
		OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet,
		OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedDataItems,
		OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedEvents,
		OpcuaNodeIdServicesMethod_DataSetFolderType_RemovePublishedDataSet,
		OpcuaNodeIdServicesMethod_AddPublishedDataItemsMethodType,
		OpcuaNodeIdServicesMethod_AddPublishedEventsMethodType,
		OpcuaNodeIdServicesMethod_RemovePublishedDataSetMethodType,
		OpcuaNodeIdServicesMethod_PublishedDataItemsType_AddVariables,
		OpcuaNodeIdServicesMethod_PublishedDataItemsType_RemoveVariables,
		OpcuaNodeIdServicesMethod_PublishedDataItemsAddVariablesMethodType,
		OpcuaNodeIdServicesMethod_PublishedDataItemsRemoveVariablesMethodType,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_Status_Enable,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_Status_Disable,
		OpcuaNodeIdServicesMethod_PubSubConnectionTypeRemoveGroupMethodType,
		OpcuaNodeIdServicesMethod_PubSubGroupTypeRemoveWriterMethodType,
		OpcuaNodeIdServicesMethod_PubSubGroupTypeRemoveReaderMethodType,
		OpcuaNodeIdServicesMethod_PubSubStatusType_Enable,
		OpcuaNodeIdServicesMethod_PubSubStatusType_Disable,
		OpcuaNodeIdServicesMethod_PublishedEventsType_ModifyFieldSelection,
		OpcuaNodeIdServicesMethod_PublishedEventsTypeModifyFieldSelectionMethodType,
		OpcuaNodeIdServicesMethod_TargetVariablesType_AddTargetVariables,
		OpcuaNodeIdServicesMethod_TargetVariablesType_RemoveTargetVariables,
		OpcuaNodeIdServicesMethod_TargetVariablesTypeAddTargetVariablesMethodType,
		OpcuaNodeIdServicesMethod_TargetVariablesTypeRemoveTargetVariablesMethodType,
		OpcuaNodeIdServicesMethod_PublishSubscribe_GetSecurityKeys,
		OpcuaNodeIdServicesMethod_GetSecurityKeysMethodType,
		OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Status_Enable,
		OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Status_Disable,
		OpcuaNodeIdServicesMethod_CreateCredentialMethodType,
		OpcuaNodeIdServicesMethod_PubSubGroupType_Status_Enable,
		OpcuaNodeIdServicesMethod_PubSubGroupType_Status_Disable,
		OpcuaNodeIdServicesMethod_DataSetWriterType_Status_Enable,
		OpcuaNodeIdServicesMethod_DataSetWriterType_Status_Disable,
		OpcuaNodeIdServicesMethod_DataSetReaderType_Status_Enable,
		OpcuaNodeIdServicesMethod_DataSetReaderType_Status_Disable,
		OpcuaNodeIdServicesMethod_PublishSubscribe_GetSecurityGroup,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_AddSecurityGroup,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_RemoveSecurityGroup,
		OpcuaNodeIdServicesMethod_GetSecurityGroupMethodType,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_AddSecurityGroup,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_RemoveSecurityGroup,
		OpcuaNodeIdServicesMethod_AddSecurityGroupMethodType,
		OpcuaNodeIdServicesMethod_RemoveSecurityGroupMethodType,
		OpcuaNodeIdServicesMethod_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField,
		OpcuaNodeIdServicesMethod_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField,
		OpcuaNodeIdServicesMethod_PublishedDataSetType_ExtensionFields_AddExtensionField,
		OpcuaNodeIdServicesMethod_PublishedDataSetType_ExtensionFields_RemoveExtensionField,
		OpcuaNodeIdServicesMethod_ExtensionFieldsType_AddExtensionField,
		OpcuaNodeIdServicesMethod_ExtensionFieldsType_RemoveExtensionField,
		OpcuaNodeIdServicesMethod_AddExtensionFieldMethodType,
		OpcuaNodeIdServicesMethod_RemoveExtensionFieldMethodType,
		OpcuaNodeIdServicesMethod_ConfigurationFileType_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ConfigurationFileType_ConfirmUpdate,
		OpcuaNodeIdServicesMethod_ConfigurationFileCloseAndUpdateMethodType,
		OpcuaNodeIdServicesMethod_ConfigurationFileConfirmUpdateMethodType,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_Open,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_Close,
		OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddIdentity,
		OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveIdentity,
		OpcuaNodeIdServicesMethod_RoleType_AddIdentity,
		OpcuaNodeIdServicesMethod_RoleType_RemoveIdentity,
		OpcuaNodeIdServicesMethod_AddIdentityMethodType,
		OpcuaNodeIdServicesMethod_RemoveIdentityMethodType,
		OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveIdentity,
		OpcuaNodeIdServicesMethod_TemporaryFileTransferType_GenerateFileForRead,
		OpcuaNodeIdServicesMethod_TemporaryFileTransferType_GenerateFileForWrite,
		OpcuaNodeIdServicesMethod_TemporaryFileTransferType_CloseAndCommit,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_Read,
		OpcuaNodeIdServicesMethod_TemporaryFileTransferType_TransferState_Placeholder_Reset,
		OpcuaNodeIdServicesMethod_GenerateFileForReadMethodType,
		OpcuaNodeIdServicesMethod_GenerateFileForWriteMethodType,
		OpcuaNodeIdServicesMethod_CloseAndCommitMethodType,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_Write,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_GetPosition,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_SetPosition,
		OpcuaNodeIdServicesMethod_FileTransferStateMachineType_Reset,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_Status_Enable,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_Status_Disable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_ConfirmUpdate,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_GetSecurityKeys,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_GetSecurityGroup,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup,
		OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Open,
		OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Close,
		OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Read,
		OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Write,
		OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_GetPosition,
		OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_SetPosition,
		OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_ExportNamespace,
		OpcuaNodeIdServicesMethod_RoleSetType_AddRole,
		OpcuaNodeIdServicesMethod_RoleSetType_RemoveRole,
		OpcuaNodeIdServicesMethod_AddRoleMethodType,
		OpcuaNodeIdServicesMethod_RemoveRoleMethodType,
		OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_Open,
		OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveIdentity,
		OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_Close,
		OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_Read,
		OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_Write,
		OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_GetPosition,
		OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_SetPosition,
		OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddApplication,
		OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveApplication,
		OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddEndpoint,
		OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_RoleType_AddApplication,
		OpcuaNodeIdServicesMethod_RoleType_RemoveApplication,
		OpcuaNodeIdServicesMethod_RoleType_AddEndpoint,
		OpcuaNodeIdServicesMethod_RoleType_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_AddApplicationMethodType,
		OpcuaNodeIdServicesMethod_RemoveApplicationMethodType,
		OpcuaNodeIdServicesMethod_AddEndpointMethodType,
		OpcuaNodeIdServicesMethod_RemoveEndpointMethodType,
		OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_ServerType_ServerCapabilities_RoleSet_AddRole,
		OpcuaNodeIdServicesMethod_ServerType_ServerCapabilities_RoleSet_RemoveRole,
		OpcuaNodeIdServicesMethod_ServerCapabilitiesType_RoleSet_AddRole,
		OpcuaNodeIdServicesMethod_ServerCapabilitiesType_RoleSet_RemoveRole,
		OpcuaNodeIdServicesMethod_Server_ServerCapabilities_RoleSet_AddRole,
		OpcuaNodeIdServicesMethod_Server_ServerCapabilities_RoleSet_RemoveRole,
		OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_ConfirmUpdate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Close,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Write,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SetPosition,
		OpcuaNodeIdServicesMethod_FileSystem_CreateDirectory,
		OpcuaNodeIdServicesMethod_FileSystem_CreateFile,
		OpcuaNodeIdServicesMethod_FileSystem_DeleteFileSystemObject,
		OpcuaNodeIdServicesMethod_FileSystem_MoveOrCopy,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Silence,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Suppress,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Disable,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Enable,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ConfirmUpdate,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Silence,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_AddConnection,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_AddConnectionMethodType,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate,
		OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedDataItemsTemplate,
		OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedEventsTemplate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_DataSetFolderType_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_DataSetFolderType_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_AddPublishedDataItemsTemplateMethodType,
		OpcuaNodeIdServicesMethod_AddPublishedEventsTemplateMethodType,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_AddDataSetFolderMethodType,
		OpcuaNodeIdServicesMethod_RemoveDataSetFolderMethodType,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_SetSecurityKeys,
		OpcuaNodeIdServicesMethod_SetSecurityKeysMethodType,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Status_Enable,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Status_Disable,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Status_Enable,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Status_Disable,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SetSecurityKeys,
		OpcuaNodeIdServicesMethod_PublishSubscribe_AddConnection,
		OpcuaNodeIdServicesMethod_PublishSubscribe_RemoveConnection,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedDataItems,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedEvents,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_RemovePublishedDataSet,
		OpcuaNodeIdServicesMethod_DataSetReaderType_CreateTargetVariables,
		OpcuaNodeIdServicesMethod_DataSetReaderType_CreateDataSetMirror,
		OpcuaNodeIdServicesMethod_DataSetReaderTypeCreateTargetVariablesMethodType,
		OpcuaNodeIdServicesMethod_DataSetReaderTypeCreateDataSetMirrorMethodType,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribe_Status_Enable,
		OpcuaNodeIdServicesMethod_PublishSubscribe_Status_Disable,
		OpcuaNodeIdServicesMethod_PublishSubscribe_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_AddWriterGroup,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_AddReaderGroup,
		OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_GetEncryptingKey,
		OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_UpdateCredential,
		OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_DeleteCredential,
		OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_CreateCredential,
		OpcuaNodeIdServicesMethod_KeyCredentialConfiguration_CreateCredential,
		OpcuaNodeIdServicesMethod_GetEncryptingKeyMethodType,
		OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_GetEncryptingKey,
		OpcuaNodeIdServicesMethod_PubSubConnectionTypeAddWriterGroupMethodType,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_PubSubConnectionAddReaderGroupGroupMethodType,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject,
		OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Status_Enable,
		OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Status_Disable,
		OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_WriterGroupType_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Unsuppress,
		OpcuaNodeIdServicesMethod_AlarmConditionType_RemoveFromService,
		OpcuaNodeIdServicesMethod_AlarmConditionType_PlaceInService,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_WriterGroupType_AddDataSetWriter,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_WriterGroupType_RemoveDataSetWriter,
		OpcuaNodeIdServicesMethod_PubSubGroupTypeAddWriterMethodType,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_UpdateCredential,
		OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_DeleteCredential,
		OpcuaNodeIdServicesMethod_KeyCredentialUpdateMethodType,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Status_Enable,
		OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Status_Disable,
		OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Reset,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Reset,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_UpdateCertificate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_GetCertificates,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ApplyChanges,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CancelChanges,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CreateSigningRequest,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_GetRejectedList,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ResetToServerDefaults,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Open,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Close,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Read,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Write,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_GetPosition,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_SetPosition,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_ConfirmUpdate,
		OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_AlarmMetricsType_Reset,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_CreateSelfSignedCertificateMethodType,
		OpcuaNodeIdServicesMethod_DeleteCertificateMethodType,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CreateSelfSignedCertificate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_DeleteCertificate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CreateSelfSignedCertificate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_DeleteCertificate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CreateSelfSignedCertificate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_DeleteCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_DeleteCertificate,
		OpcuaNodeIdServicesMethod_LogObjectType_GetRecords,
		OpcuaNodeIdServicesMethod_GetRecordsMethodType,
		OpcuaNodeIdServicesMethod_ServerLog_GetRecords,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_KeyCredentials_CreateCredential,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_KeyCredentials_CreateCredential,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_DataSetWriterType_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_DataSetReaderType_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_PubSubDiagnosticsType_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables,
		OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror,
		OpcuaNodeIdServicesMethod_ReaderGroupType_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_ReaderGroupType_AddDataSetReader,
		OpcuaNodeIdServicesMethod_ReaderGroupType_RemoveDataSetReader,
		OpcuaNodeIdServicesMethod_PubSubGroupTypeAddReaderMethodType,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_AliasNameCategoryType_SubAliasNameCategories_Placeholder_FindAlias,
		OpcuaNodeIdServicesMethod_AliasNameCategoryType_FindAlias,
		OpcuaNodeIdServicesMethod_FindAliasMethodType,
		OpcuaNodeIdServicesMethod_Aliases_FindAlias,
		OpcuaNodeIdServicesMethod_TagVariables_FindAlias,
		OpcuaNodeIdServicesMethod_Topics_FindAlias,
		OpcuaNodeIdServicesMethod_CertificateGroupType_GetRejectedList,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_GetRejectedList,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_GetConnectionMethodType,
		OpcuaNodeIdServicesMethod_ModifyConnectionMethodType,
		OpcuaNodeIdServicesMethod_GetWriterGroupMethodType,
		OpcuaNodeIdServicesMethod_ModifyWriterGroupMethodType,
		OpcuaNodeIdServicesMethod_GetReaderGroupMethodType,
		OpcuaNodeIdServicesMethod_ModifyReaderGroupMethodType,
		OpcuaNodeIdServicesMethod_GetDataSetWriterMethodType,
		OpcuaNodeIdServicesMethod_ModifyDataSetWriterMethodType,
		OpcuaNodeIdServicesMethod_GetDataSetReaderMethodType,
		OpcuaNodeIdServicesMethod_ModifyDataSetReaderMethodType,
		OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddSubscribedDataSet,
		OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveSubscribedDataSet,
		OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_AddSubscribedDataSet,
		OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_RemoveSubscribedDataSet,
		OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_AddSubscribedDataSetMethodType,
		OpcuaNodeIdServicesMethod_RemoveSubscribedDataSetMethodType,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet,
		OpcuaNodeIdServicesMethod_UserManagementType_AddUser,
		OpcuaNodeIdServicesMethod_UserManagementType_ModifyUser,
		OpcuaNodeIdServicesMethod_UserManagementType_RemoveUser,
		OpcuaNodeIdServicesMethod_UserManagementType_ChangePassword,
		OpcuaNodeIdServicesMethod_AddUserMethodType,
		OpcuaNodeIdServicesMethod_ModifyUserMethodType,
		OpcuaNodeIdServicesMethod_RemoveUserMethodType,
		OpcuaNodeIdServicesMethod_ChangePasswordMethodType,
		OpcuaNodeIdServicesMethod_UserManagement_AddUser,
		OpcuaNodeIdServicesMethod_UserManagement_ModifyUser,
		OpcuaNodeIdServicesMethod_UserManagement_RemoveUser,
		OpcuaNodeIdServicesMethod_UserManagement_ChangePassword,
		OpcuaNodeIdServicesMethod_DialogConditionType_Respond2,
		OpcuaNodeIdServicesMethod_DialogResponse2MethodType,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Suppress2,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Unsuppress2,
		OpcuaNodeIdServicesMethod_AlarmConditionType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_AlarmConditionType_PlaceInService2,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Reset2,
		OpcuaNodeIdServicesMethod_WithCommentMethodType,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress2,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress2,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService2,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_AlarmConditionType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_GetGroupMembershipsMethodType,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ShelvedStateMachineType_TimedShelve2,
		OpcuaNodeIdServicesMethod_ShelvedStateMachineType_Unshelve2,
		OpcuaNodeIdServicesMethod_ShelvedStateMachineType_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_TimedShelve2MethodType,
		OpcuaNodeIdServicesMethod_PriorityMappingTableType_AddPriorityMappingEntry,
		OpcuaNodeIdServicesMethod_PriorityMappingTableType_DeletePriorityMappingEntry,
		OpcuaNodeIdServicesMethod_AddPriorityMappingEntryMethodType,
		OpcuaNodeIdServicesMethod_DeletePriorityMappingEntryMethodType,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_AddPushTarget,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_RemovePushTarget,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder,
		OpcuaNodeIdServicesMethod_AddSecurityGroupFolderMethodType,
		OpcuaNodeIdServicesMethod_RemoveSecurityGroupFolderMethodType,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_AddSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_RemoveSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_ConnectSecurityGroupsMethodType,
		OpcuaNodeIdServicesMethod_DisconnectSecurityGroupsMethodType,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_AddPushTarget,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_RemovePushTarget,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_AddPushTargetFolder,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_RemovePushTargetFolder,
		OpcuaNodeIdServicesMethod_AddPushTargetMethodType,
		OpcuaNodeIdServicesMethod_RemovePushTargetMethodType,
		OpcuaNodeIdServicesMethod_AddPushTargetFolderMethodType,
		OpcuaNodeIdServicesMethod_RemovePushTargetFolderMethodType,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Open,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Close,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Read,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Write,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_GetPosition,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_SetPosition,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_ReserveIds,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_AddPushTarget,
		OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_RemovePushTarget,
		OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_AddPushTargetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_RemovePushTargetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Open,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Close,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Read,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Write,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_GetPosition,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_SetPosition,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_ReserveIds,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_PubSubConfigurationType_ReserveIds,
		OpcuaNodeIdServicesMethod_PubSubConfigurationType_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_PubSubConfigurationTypeReserveIdsMethodType,
		OpcuaNodeIdServicesMethod_PubSubConfigurationTypeCloseAndUpdateMethodType,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupName_Placeholder_InvalidateKeys,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupName_Placeholder_ForceKeyRotation,
		OpcuaNodeIdServicesMethod_SecurityGroupType_InvalidateKeys,
		OpcuaNodeIdServicesMethod_SecurityGroupType_ForceKeyRotation,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_InvalidateKeys,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_ForceKeyRotation,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_ConnectSecurityGroups,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_DisconnectSecurityGroups,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_TriggerKeyUpdate,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_TriggerKeyUpdate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CancelChanges,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_ResetToServerDefaults,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CancelChanges,
		OpcuaNodeIdServicesMethod_ServerConfiguration_ResetToServerDefaults,
		OpcuaNodeIdServicesMethod_RequestTicketsMethodType,
		OpcuaNodeIdServicesMethod_SetRegistrarEndpointsMethodType,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_RequestTickets,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_SetRegistrarEndpoints,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ApplyChanges,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CancelChanges,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_GetRejectedList,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ResetToServerDefaults,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_RequestTickets,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_SetRegistrarEndpoints,
		OpcuaNodeIdServicesMethod_GetCertificatesMethodType,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_GetCertificates,
		OpcuaNodeIdServicesMethod_ServerConfiguration_GetCertificates,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates,
		OpcuaNodeIdServicesMethod_NonTransparentBackupRedundancyType_Failover,
	}
}

func OpcuaNodeIdServicesMethodByValue(value int32) (enum OpcuaNodeIdServicesMethod, ok bool) {
	switch value {
	case 11489:
		return OpcuaNodeIdServicesMethod_ServerType_GetMonitoredItems, true
	case 11492:
		return OpcuaNodeIdServicesMethod_Server_GetMonitoredItems, true
	case 11495:
		return OpcuaNodeIdServicesMethod_GetMonitoredItemsMethodType, true
	case 11580:
		return OpcuaNodeIdServicesMethod_FileType_Open, true
	case 11583:
		return OpcuaNodeIdServicesMethod_FileType_Close, true
	case 11585:
		return OpcuaNodeIdServicesMethod_FileType_Read, true
	case 11588:
		return OpcuaNodeIdServicesMethod_FileType_Write, true
	case 11590:
		return OpcuaNodeIdServicesMethod_FileType_GetPosition, true
	case 11593:
		return OpcuaNodeIdServicesMethod_FileType_SetPosition, true
	case 11615:
		return OpcuaNodeIdServicesMethod_AddressSpaceFileType_ExportNamespace, true
	case 11629:
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Open, true
	case 11632:
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Close, true
	case 11634:
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Read, true
	case 11637:
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Write, true
	case 11639:
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_GetPosition, true
	case 11642:
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_SetPosition, true
	case 11644:
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_ExportNamespace, true
	case 11659:
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open, true
	case 11662:
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close, true
	case 11664:
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read, true
	case 11667:
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write, true
	case 11669:
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition, true
	case 11672:
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition, true
	case 11674:
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_ExportNamespace, true
	case 11738:
		return OpcuaNodeIdServicesMethod_OpenMethodType, true
	case 11741:
		return OpcuaNodeIdServicesMethod_CloseMethodType, true
	case 11743:
		return OpcuaNodeIdServicesMethod_ReadMethodType, true
	case 11746:
		return OpcuaNodeIdServicesMethod_WriteMethodType, true
	case 11748:
		return OpcuaNodeIdServicesMethod_GetPositionMethodType, true
	case 11751:
		return OpcuaNodeIdServicesMethod_SetPositionMethodType, true
	case 12513:
		return OpcuaNodeIdServicesMethod_OpenWithMasksMethodType, true
	case 12516:
		return OpcuaNodeIdServicesMethod_CloseAndUpdateMethodType, true
	case 12518:
		return OpcuaNodeIdServicesMethod_AddCertificateMethodType, true
	case 12520:
		return OpcuaNodeIdServicesMethod_RemoveCertificateMethodType, true
	case 12543:
		return OpcuaNodeIdServicesMethod_TrustListType_OpenWithMasks, true
	case 12546:
		return OpcuaNodeIdServicesMethod_TrustListType_CloseAndUpdate, true
	case 12548:
		return OpcuaNodeIdServicesMethod_TrustListType_AddCertificate, true
	case 12550:
		return OpcuaNodeIdServicesMethod_TrustListType_RemoveCertificate, true
	case 12578:
		return OpcuaNodeIdServicesMethod_UpdateCertificateMethodType, true
	case 12616:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_UpdateCertificate, true
	case 12647:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open, true
	case 12650:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close, true
	case 12652:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read, true
	case 12655:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write, true
	case 12657:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition, true
	case 12660:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition, true
	case 12663:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks, true
	case 12666:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate, true
	case 12668:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate, true
	case 12670:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate, true
	case 12731:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CreateSigningRequest, true
	case 12734:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ApplyChanges, true
	case 12737:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CreateSigningRequest, true
	case 12740:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ApplyChanges, true
	case 12741:
		return OpcuaNodeIdServicesMethod_CreateSigningRequestMethodType, true
	case 12746:
		return OpcuaNodeIdServicesMethod_ServerType_SetSubscriptionDurable, true
	case 12749:
		return OpcuaNodeIdServicesMethod_Server_SetSubscriptionDurable, true
	case 12752:
		return OpcuaNodeIdServicesMethod_SetSubscriptionDurableMethodType, true
	case 12773:
		return OpcuaNodeIdServicesMethod_GetRejectedListMethodType, true
	case 12775:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_GetRejectedList, true
	case 12777:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_GetRejectedList, true
	case 12871:
		return OpcuaNodeIdServicesMethod_ServerType_ResendData, true
	case 12873:
		return OpcuaNodeIdServicesMethod_Server_ResendData, true
	case 12875:
		return OpcuaNodeIdServicesMethod_ResendDataMethodType, true
	case 12883:
		return OpcuaNodeIdServicesMethod_ServerType_RequestServerStateChange, true
	case 12886:
		return OpcuaNodeIdServicesMethod_Server_RequestServerStateChange, true
	case 12888:
		return OpcuaNodeIdServicesMethod_RequestServerStateChangeMethodType, true
	case 12912:
		return OpcuaNodeIdServicesMethod_ConditionType_ConditionRefresh2, true
	case 12914:
		return OpcuaNodeIdServicesMethod_ConditionRefresh2MethodType, true
	case 13342:
		return OpcuaNodeIdServicesMethod_CreateDirectoryMethodType, true
	case 13345:
		return OpcuaNodeIdServicesMethod_CreateFileMethodType, true
	case 13348:
		return OpcuaNodeIdServicesMethod_DeleteFileMethodType, true
	case 13350:
		return OpcuaNodeIdServicesMethod_MoveOrCopyMethodType, true
	case 13355:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory, true
	case 13358:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile, true
	case 13363:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy, true
	case 13372:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Open, true
	case 13375:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Close, true
	case 13377:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Read, true
	case 13380:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Write, true
	case 13382:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_GetPosition, true
	case 13385:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_SetPosition, true
	case 13387:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_CreateDirectory, true
	case 13390:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_CreateFile, true
	case 13393:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_DeleteFileSystemObject, true
	case 13395:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_MoveOrCopy, true
	case 13605:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Open, true
	case 13608:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Close, true
	case 13610:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Read, true
	case 13613:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Write, true
	case 13615:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_GetPosition, true
	case 13618:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_SetPosition, true
	case 13621:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_OpenWithMasks, true
	case 13624:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_CloseAndUpdate, true
	case 13627:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_AddCertificate, true
	case 13629:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_RemoveCertificate, true
	case 13737:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_UpdateCertificate, true
	case 13821:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open, true
	case 13824:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close, true
	case 13826:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read, true
	case 13829:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write, true
	case 13831:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition, true
	case 13834:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition, true
	case 13837:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks, true
	case 13840:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate, true
	case 13843:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate, true
	case 13845:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate, true
	case 13855:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open, true
	case 13858:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close, true
	case 13860:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read, true
	case 13863:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write, true
	case 13865:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition, true
	case 13868:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition, true
	case 13871:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks, true
	case 13874:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate, true
	case 13877:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate, true
	case 13879:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate, true
	case 13889:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open, true
	case 13892:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close, true
	case 13894:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read, true
	case 13897:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write, true
	case 13899:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition, true
	case 13902:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition, true
	case 13905:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks, true
	case 13908:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate, true
	case 13911:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate, true
	case 13913:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate, true
	case 13923:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open, true
	case 13926:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close, true
	case 13928:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read, true
	case 13931:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write, true
	case 13933:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition, true
	case 13936:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition, true
	case 13939:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks, true
	case 13942:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate, true
	case 13945:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate, true
	case 13947:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate, true
	case 13958:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open, true
	case 13961:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close, true
	case 13963:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read, true
	case 13966:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write, true
	case 13968:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition, true
	case 13971:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition, true
	case 13974:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks, true
	case 13977:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate, true
	case 13980:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate, true
	case 13982:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate, true
	case 13992:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open, true
	case 13995:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close, true
	case 13997:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read, true
	case 14000:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write, true
	case 14002:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition, true
	case 14005:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition, true
	case 14008:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks, true
	case 14011:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate, true
	case 14014:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate, true
	case 14016:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate, true
	case 14026:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open, true
	case 14029:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close, true
	case 14031:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read, true
	case 14034:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write, true
	case 14036:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition, true
	case 14039:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition, true
	case 14042:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks, true
	case 14045:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate, true
	case 14048:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate, true
	case 14050:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate, true
	case 14095:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open, true
	case 14098:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close, true
	case 14100:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read, true
	case 14103:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write, true
	case 14105:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition, true
	case 14108:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition, true
	case 14111:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks, true
	case 14114:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate, true
	case 14117:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate, true
	case 14119:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate, true
	case 14129:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open, true
	case 14132:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close, true
	case 14134:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read, true
	case 14137:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write, true
	case 14139:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition, true
	case 14142:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition, true
	case 14145:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks, true
	case 14148:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate, true
	case 14151:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate, true
	case 14153:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate, true
	case 14183:
		return OpcuaNodeIdServicesMethod_RemoveConnectionMethodType, true
	case 14225:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_RemoveGroup, true
	case 14421:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Status_Enable, true
	case 14422:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Status_Disable, true
	case 14424:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup, true
	case 14432:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_RemoveConnection, true
	case 14435:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems, true
	case 14438:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedEvents, true
	case 14441:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet, true
	case 14479:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems, true
	case 14482:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents, true
	case 14485:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet, true
	case 14493:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedDataItems, true
	case 14496:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedEvents, true
	case 14499:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_RemovePublishedDataSet, true
	case 14501:
		return OpcuaNodeIdServicesMethod_AddPublishedDataItemsMethodType, true
	case 14504:
		return OpcuaNodeIdServicesMethod_AddPublishedEventsMethodType, true
	case 14507:
		return OpcuaNodeIdServicesMethod_RemovePublishedDataSetMethodType, true
	case 14555:
		return OpcuaNodeIdServicesMethod_PublishedDataItemsType_AddVariables, true
	case 14558:
		return OpcuaNodeIdServicesMethod_PublishedDataItemsType_RemoveVariables, true
	case 14564:
		return OpcuaNodeIdServicesMethod_PublishedDataItemsAddVariablesMethodType, true
	case 14567:
		return OpcuaNodeIdServicesMethod_PublishedDataItemsRemoveVariablesMethodType, true
	case 14602:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_Status_Enable, true
	case 14603:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_Status_Disable, true
	case 14604:
		return OpcuaNodeIdServicesMethod_PubSubConnectionTypeRemoveGroupMethodType, true
	case 14623:
		return OpcuaNodeIdServicesMethod_PubSubGroupTypeRemoveWriterMethodType, true
	case 14625:
		return OpcuaNodeIdServicesMethod_PubSubGroupTypeRemoveReaderMethodType, true
	case 14645:
		return OpcuaNodeIdServicesMethod_PubSubStatusType_Enable, true
	case 14646:
		return OpcuaNodeIdServicesMethod_PubSubStatusType_Disable, true
	case 15052:
		return OpcuaNodeIdServicesMethod_PublishedEventsType_ModifyFieldSelection, true
	case 15054:
		return OpcuaNodeIdServicesMethod_PublishedEventsTypeModifyFieldSelectionMethodType, true
	case 15115:
		return OpcuaNodeIdServicesMethod_TargetVariablesType_AddTargetVariables, true
	case 15118:
		return OpcuaNodeIdServicesMethod_TargetVariablesType_RemoveTargetVariables, true
	case 15121:
		return OpcuaNodeIdServicesMethod_TargetVariablesTypeAddTargetVariablesMethodType, true
	case 15124:
		return OpcuaNodeIdServicesMethod_TargetVariablesTypeRemoveTargetVariablesMethodType, true
	case 15215:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_GetSecurityKeys, true
	case 15218:
		return OpcuaNodeIdServicesMethod_GetSecurityKeysMethodType, true
	case 15225:
		return OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Status_Enable, true
	case 15226:
		return OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Status_Disable, true
	case 15248:
		return OpcuaNodeIdServicesMethod_CreateCredentialMethodType, true
	case 15267:
		return OpcuaNodeIdServicesMethod_PubSubGroupType_Status_Enable, true
	case 15268:
		return OpcuaNodeIdServicesMethod_PubSubGroupType_Status_Disable, true
	case 15301:
		return OpcuaNodeIdServicesMethod_DataSetWriterType_Status_Enable, true
	case 15302:
		return OpcuaNodeIdServicesMethod_DataSetWriterType_Status_Disable, true
	case 15309:
		return OpcuaNodeIdServicesMethod_DataSetReaderType_Status_Enable, true
	case 15310:
		return OpcuaNodeIdServicesMethod_DataSetReaderType_Status_Disable, true
	case 15440:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_GetSecurityGroup, true
	case 15444:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_AddSecurityGroup, true
	case 15447:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_RemoveSecurityGroup, true
	case 15449:
		return OpcuaNodeIdServicesMethod_GetSecurityGroupMethodType, true
	case 15454:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup, true
	case 15457:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup, true
	case 15461:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_AddSecurityGroup, true
	case 15464:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_RemoveSecurityGroup, true
	case 15466:
		return OpcuaNodeIdServicesMethod_AddSecurityGroupMethodType, true
	case 15469:
		return OpcuaNodeIdServicesMethod_RemoveSecurityGroupMethodType, true
	case 15474:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField, true
	case 15477:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField, true
	case 15482:
		return OpcuaNodeIdServicesMethod_PublishedDataSetType_ExtensionFields_AddExtensionField, true
	case 15485:
		return OpcuaNodeIdServicesMethod_PublishedDataSetType_ExtensionFields_RemoveExtensionField, true
	case 15491:
		return OpcuaNodeIdServicesMethod_ExtensionFieldsType_AddExtensionField, true
	case 15494:
		return OpcuaNodeIdServicesMethod_ExtensionFieldsType_RemoveExtensionField, true
	case 15496:
		return OpcuaNodeIdServicesMethod_AddExtensionFieldMethodType, true
	case 15499:
		return OpcuaNodeIdServicesMethod_RemoveExtensionFieldMethodType, true
	case 15505:
		return OpcuaNodeIdServicesMethod_ConfigurationFileType_CloseAndUpdate, true
	case 15508:
		return OpcuaNodeIdServicesMethod_ConfigurationFileType_ConfirmUpdate, true
	case 15513:
		return OpcuaNodeIdServicesMethod_ConfigurationFileCloseAndUpdateMethodType, true
	case 15516:
		return OpcuaNodeIdServicesMethod_ConfigurationFileConfirmUpdateMethodType, true
	case 15572:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_Open, true
	case 15575:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_Close, true
	case 15612:
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddIdentity, true
	case 15614:
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveIdentity, true
	case 15624:
		return OpcuaNodeIdServicesMethod_RoleType_AddIdentity, true
	case 15626:
		return OpcuaNodeIdServicesMethod_RoleType_RemoveIdentity, true
	case 15636:
		return OpcuaNodeIdServicesMethod_AddIdentityMethodType, true
	case 15638:
		return OpcuaNodeIdServicesMethod_RemoveIdentityMethodType, true
	case 15648:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddIdentity, true
	case 15650:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveIdentity, true
	case 15660:
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddIdentity, true
	case 15662:
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveIdentity, true
	case 15672:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddIdentity, true
	case 15674:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveIdentity, true
	case 15684:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddIdentity, true
	case 15686:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveIdentity, true
	case 15696:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddIdentity, true
	case 15698:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveIdentity, true
	case 15708:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddIdentity, true
	case 15710:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveIdentity, true
	case 15720:
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddIdentity, true
	case 15722:
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveIdentity, true
	case 15746:
		return OpcuaNodeIdServicesMethod_TemporaryFileTransferType_GenerateFileForRead, true
	case 15749:
		return OpcuaNodeIdServicesMethod_TemporaryFileTransferType_GenerateFileForWrite, true
	case 15751:
		return OpcuaNodeIdServicesMethod_TemporaryFileTransferType_CloseAndCommit, true
	case 15791:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_Read, true
	case 15794:
		return OpcuaNodeIdServicesMethod_TemporaryFileTransferType_TransferState_Placeholder_Reset, true
	case 15795:
		return OpcuaNodeIdServicesMethod_GenerateFileForReadMethodType, true
	case 15798:
		return OpcuaNodeIdServicesMethod_GenerateFileForWriteMethodType, true
	case 15800:
		return OpcuaNodeIdServicesMethod_CloseAndCommitMethodType, true
	case 15805:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_Write, true
	case 15807:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_GetPosition, true
	case 15810:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_SetPosition, true
	case 15843:
		return OpcuaNodeIdServicesMethod_FileTransferStateMachineType_Reset, true
	case 15846:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_Status_Enable, true
	case 15847:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_Status_Disable, true
	case 15849:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_CloseAndUpdate, true
	case 15863:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_ConfirmUpdate, true
	case 15907:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_GetSecurityKeys, true
	case 15910:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_GetSecurityGroup, true
	case 15914:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup, true
	case 15917:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup, true
	case 15971:
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Open, true
	case 15974:
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Close, true
	case 15976:
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Read, true
	case 15979:
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Write, true
	case 15981:
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_GetPosition, true
	case 15984:
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_SetPosition, true
	case 15986:
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_ExportNamespace, true
	case 15997:
		return OpcuaNodeIdServicesMethod_RoleSetType_AddRole, true
	case 16000:
		return OpcuaNodeIdServicesMethod_RoleSetType_RemoveRole, true
	case 16002:
		return OpcuaNodeIdServicesMethod_AddRoleMethodType, true
	case 16005:
		return OpcuaNodeIdServicesMethod_RemoveRoleMethodType, true
	case 16013:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_Open, true
	case 16041:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddIdentity, true
	case 16043:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveIdentity, true
	case 16060:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_Close, true
	case 16074:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_Read, true
	case 16101:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_Write, true
	case 16103:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_GetPosition, true
	case 16124:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_SetPosition, true
	case 16165:
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddApplication, true
	case 16167:
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveApplication, true
	case 16169:
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddEndpoint, true
	case 16171:
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveEndpoint, true
	case 16176:
		return OpcuaNodeIdServicesMethod_RoleType_AddApplication, true
	case 16178:
		return OpcuaNodeIdServicesMethod_RoleType_RemoveApplication, true
	case 16180:
		return OpcuaNodeIdServicesMethod_RoleType_AddEndpoint, true
	case 16182:
		return OpcuaNodeIdServicesMethod_RoleType_RemoveEndpoint, true
	case 16184:
		return OpcuaNodeIdServicesMethod_AddApplicationMethodType, true
	case 16186:
		return OpcuaNodeIdServicesMethod_RemoveApplicationMethodType, true
	case 16188:
		return OpcuaNodeIdServicesMethod_AddEndpointMethodType, true
	case 16190:
		return OpcuaNodeIdServicesMethod_RemoveEndpointMethodType, true
	case 16195:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddApplication, true
	case 16197:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveApplication, true
	case 16199:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddEndpoint, true
	case 16201:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveEndpoint, true
	case 16206:
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddApplication, true
	case 16208:
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveApplication, true
	case 16210:
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddEndpoint, true
	case 16212:
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveEndpoint, true
	case 16217:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddApplication, true
	case 16219:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveApplication, true
	case 16221:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddEndpoint, true
	case 16223:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveEndpoint, true
	case 16228:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddApplication, true
	case 16230:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveApplication, true
	case 16232:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddEndpoint, true
	case 16234:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveEndpoint, true
	case 16239:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddApplication, true
	case 16241:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveApplication, true
	case 16243:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddEndpoint, true
	case 16245:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveEndpoint, true
	case 16250:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddApplication, true
	case 16252:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveApplication, true
	case 16254:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddEndpoint, true
	case 16256:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveEndpoint, true
	case 16261:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddApplication, true
	case 16263:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveApplication, true
	case 16265:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddEndpoint, true
	case 16267:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveEndpoint, true
	case 16272:
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddApplication, true
	case 16274:
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveApplication, true
	case 16276:
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddEndpoint, true
	case 16278:
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveEndpoint, true
	case 16290:
		return OpcuaNodeIdServicesMethod_ServerType_ServerCapabilities_RoleSet_AddRole, true
	case 16293:
		return OpcuaNodeIdServicesMethod_ServerType_ServerCapabilities_RoleSet_RemoveRole, true
	case 16296:
		return OpcuaNodeIdServicesMethod_ServerCapabilitiesType_RoleSet_AddRole, true
	case 16299:
		return OpcuaNodeIdServicesMethod_ServerCapabilitiesType_RoleSet_RemoveRole, true
	case 16301:
		return OpcuaNodeIdServicesMethod_Server_ServerCapabilities_RoleSet_AddRole, true
	case 16304:
		return OpcuaNodeIdServicesMethod_Server_ServerCapabilities_RoleSet_RemoveRole, true
	case 16317:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_CloseAndUpdate, true
	case 16320:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_ConfirmUpdate, true
	case 16332:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open, true
	case 16335:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Close, true
	case 16337:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read, true
	case 16340:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Write, true
	case 16342:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition, true
	case 16345:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SetPosition, true
	case 16348:
		return OpcuaNodeIdServicesMethod_FileSystem_CreateDirectory, true
	case 16351:
		return OpcuaNodeIdServicesMethod_FileSystem_CreateFile, true
	case 16354:
		return OpcuaNodeIdServicesMethod_FileSystem_DeleteFileSystemObject, true
	case 16356:
		return OpcuaNodeIdServicesMethod_FileSystem_MoveOrCopy, true
	case 16368:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate, true
	case 16402:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Silence, true
	case 16403:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Suppress, true
	case 16439:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Disable, true
	case 16440:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Enable, true
	case 16441:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment, true
	case 16461:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge, true
	case 16463:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm, true
	case 16515:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve, true
	case 16516:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve, true
	case 16517:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve, true
	case 16523:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ConfirmUpdate, true
	case 16533:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Silence, true
	case 16534:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress, true
	case 16535:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup, true
	case 16560:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup, true
	case 16598:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_AddConnection, true
	case 16601:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate, true
	case 16639:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate, true
	case 16651:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddDataSetFolder, true
	case 16680:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder, true
	case 16691:
		return OpcuaNodeIdServicesMethod_AddConnectionMethodType, true
	case 16717:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open, true
	case 16724:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close, true
	case 16726:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read, true
	case 16729:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write, true
	case 16732:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition, true
	case 16735:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition, true
	case 16741:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks, true
	case 16744:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate, true
	case 16747:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate, true
	case 16749:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate, true
	case 16752:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList, true
	case 16790:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable, true
	case 16791:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable, true
	case 16792:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment, true
	case 16812:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge, true
	case 16814:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm, true
	case 16842:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate, true
	case 16864:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 16866:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 16868:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 16869:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 16871:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 16872:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 16881:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate, true
	case 16884:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder, true
	case 16911:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence, true
	case 16912:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress, true
	case 16913:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2, true
	case 16915:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress, true
	case 16916:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2, true
	case 16918:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService, true
	case 16919:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2, true
	case 16921:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService, true
	case 16923:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder, true
	case 16926:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2, true
	case 16928:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset, true
	case 16929:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2, true
	case 16931:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships, true
	case 16935:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedDataItemsTemplate, true
	case 16960:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedEventsTemplate, true
	case 16977:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable, true
	case 16978:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable, true
	case 16979:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment, true
	case 16994:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_AddDataSetFolder, true
	case 16997:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_RemoveDataSetFolder, true
	case 17003:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge, true
	case 17005:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm, true
	case 17030:
		return OpcuaNodeIdServicesMethod_AddPublishedDataItemsTemplateMethodType, true
	case 17033:
		return OpcuaNodeIdServicesMethod_AddPublishedEventsTemplateMethodType, true
	case 17056:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 17058:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 17060:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 17061:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 17063:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 17064:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 17067:
		return OpcuaNodeIdServicesMethod_AddDataSetFolderMethodType, true
	case 17079:
		return OpcuaNodeIdServicesMethod_RemoveDataSetFolderMethodType, true
	case 17103:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence, true
	case 17104:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress, true
	case 17105:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2, true
	case 17107:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress, true
	case 17108:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2, true
	case 17110:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService, true
	case 17111:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2, true
	case 17113:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService, true
	case 17114:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2, true
	case 17116:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset, true
	case 17117:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2, true
	case 17119:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 17134:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open, true
	case 17137:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close, true
	case 17139:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read, true
	case 17142:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write, true
	case 17144:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition, true
	case 17147:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition, true
	case 17153:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks, true
	case 17156:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate, true
	case 17159:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate, true
	case 17161:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate, true
	case 17164:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList, true
	case 17199:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable, true
	case 17200:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable, true
	case 17205:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment, true
	case 17237:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge, true
	case 17239:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm, true
	case 17293:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter, true
	case 17296:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SetSecurityKeys, true
	case 17298:
		return OpcuaNodeIdServicesMethod_SetSecurityKeysMethodType, true
	case 17316:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Status_Enable, true
	case 17317:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Status_Disable, true
	case 17323:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter, true
	case 17331:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Status_Enable, true
	case 17332:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Status_Disable, true
	case 17333:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader, true
	case 17340:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 17342:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 17344:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 17345:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 17347:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 17348:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 17355:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader, true
	case 17364:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SetSecurityKeys, true
	case 17366:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_AddConnection, true
	case 17369:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_RemoveConnection, true
	case 17372:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedDataItems, true
	case 17375:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedEvents, true
	case 17378:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate, true
	case 17381:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate, true
	case 17384:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_RemovePublishedDataSet, true
	case 17386:
		return OpcuaNodeIdServicesMethod_DataSetReaderType_CreateTargetVariables, true
	case 17389:
		return OpcuaNodeIdServicesMethod_DataSetReaderType_CreateDataSetMirror, true
	case 17392:
		return OpcuaNodeIdServicesMethod_DataSetReaderTypeCreateTargetVariablesMethodType, true
	case 17395:
		return OpcuaNodeIdServicesMethod_DataSetReaderTypeCreateDataSetMirrorMethodType, true
	case 17398:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddDataSetFolder, true
	case 17403:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_RemoveDataSetFolder, true
	case 17407:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_Status_Enable, true
	case 17408:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_Status_Disable, true
	case 17421:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_Diagnostics_Reset, true
	case 17427:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_AddWriterGroup, true
	case 17465:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_AddReaderGroup, true
	case 17516:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_GetEncryptingKey, true
	case 17519:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_UpdateCredential, true
	case 17521:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_DeleteCredential, true
	case 17522:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_CreateCredential, true
	case 17528:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfiguration_CreateCredential, true
	case 17531:
		return OpcuaNodeIdServicesMethod_GetEncryptingKeyMethodType, true
	case 17534:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_GetEncryptingKey, true
	case 17561:
		return OpcuaNodeIdServicesMethod_PubSubConnectionTypeAddWriterGroupMethodType, true
	case 17572:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence, true
	case 17573:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress, true
	case 17574:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2, true
	case 17586:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress, true
	case 17587:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2, true
	case 17596:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService, true
	case 17599:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2, true
	case 17616:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService, true
	case 17617:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2, true
	case 17619:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset, true
	case 17620:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2, true
	case 17622:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships, true
	case 17630:
		return OpcuaNodeIdServicesMethod_PubSubConnectionAddReaderGroupGroupMethodType, true
	case 17678:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable, true
	case 17679:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable, true
	case 17680:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment, true
	case 17700:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge, true
	case 17702:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm, true
	case 17718:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject, true
	case 17751:
		return OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Status_Enable, true
	case 17752:
		return OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Status_Disable, true
	case 17765:
		return OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Reset, true
	case 17824:
		return OpcuaNodeIdServicesMethod_WriterGroupType_Diagnostics_Reset, true
	case 17868:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Unsuppress, true
	case 17869:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_RemoveFromService, true
	case 17870:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_PlaceInService, true
	case 17875:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress, true
	case 17876:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService, true
	case 17877:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService, true
	case 17917:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 17919:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 17922:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 17923:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 17925:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 17926:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 17965:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence, true
	case 17966:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress, true
	case 17967:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2, true
	case 17969:
		return OpcuaNodeIdServicesMethod_WriterGroupType_AddDataSetWriter, true
	case 17970:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress, true
	case 17971:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2, true
	case 17973:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService, true
	case 17974:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2, true
	case 17977:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService, true
	case 17978:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2, true
	case 17980:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset, true
	case 17981:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2, true
	case 17992:
		return OpcuaNodeIdServicesMethod_WriterGroupType_RemoveDataSetWriter, true
	case 17994:
		return OpcuaNodeIdServicesMethod_PubSubGroupTypeAddWriterMethodType, true
	case 18000:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 18006:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_UpdateCredential, true
	case 18008:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_DeleteCredential, true
	case 18009:
		return OpcuaNodeIdServicesMethod_KeyCredentialUpdateMethodType, true
	case 18024:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open, true
	case 18027:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close, true
	case 18031:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read, true
	case 18034:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write, true
	case 18036:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition, true
	case 18039:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition, true
	case 18045:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks, true
	case 18049:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate, true
	case 18052:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate, true
	case 18054:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate, true
	case 18057:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList, true
	case 18090:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Status_Enable, true
	case 18091:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Status_Disable, true
	case 18104:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Reset, true
	case 18199:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Reset, true
	case 18212:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Reset, true
	case 18225:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable, true
	case 18226:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable, true
	case 18227:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment, true
	case 18247:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge, true
	case 18249:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm, true
	case 18294:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 18296:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 18298:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 18299:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 18301:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 18302:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 18335:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence, true
	case 18336:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress, true
	case 18337:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2, true
	case 18339:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress, true
	case 18340:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2, true
	case 18342:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService, true
	case 18343:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2, true
	case 18345:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService, true
	case 18346:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2, true
	case 18349:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset, true
	case 18350:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2, true
	case 18352:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships, true
	case 18392:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable, true
	case 18393:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable, true
	case 18394:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment, true
	case 18414:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge, true
	case 18416:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm, true
	case 18461:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 18463:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 18465:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 18466:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 18468:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 18469:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 18503:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence, true
	case 18504:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress, true
	case 18505:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2, true
	case 18507:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress, true
	case 18508:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2, true
	case 18510:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService, true
	case 18511:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2, true
	case 18513:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService, true
	case 18514:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2, true
	case 18516:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset, true
	case 18517:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2, true
	case 18519:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 18533:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_UpdateCertificate, true
	case 18536:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_GetCertificates, true
	case 18539:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ApplyChanges, true
	case 18540:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CancelChanges, true
	case 18541:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CreateSigningRequest, true
	case 18544:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_GetRejectedList, true
	case 18546:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ResetToServerDefaults, true
	case 18562:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Open, true
	case 18565:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Close, true
	case 18567:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Read, true
	case 18570:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Write, true
	case 18572:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_GetPosition, true
	case 18575:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_SetPosition, true
	case 18581:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate, true
	case 18584:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_ConfirmUpdate, true
	case 18632:
		return OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_AddIdentity, true
	case 18634:
		return OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_RemoveIdentity, true
	case 18636:
		return OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_AddApplication, true
	case 18638:
		return OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_RemoveApplication, true
	case 18640:
		return OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_AddEndpoint, true
	case 18642:
		return OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_RemoveEndpoint, true
	case 18666:
		return OpcuaNodeIdServicesMethod_AlarmMetricsType_Reset, true
	case 18679:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Reset, true
	case 18727:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_Diagnostics_Reset, true
	case 18883:
		return OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Reset, true
	case 19119:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Reset, true
	case 19188:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Reset, true
	case 19253:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_Diagnostics_Reset, true
	case 19327:
		return OpcuaNodeIdServicesMethod_CreateSelfSignedCertificateMethodType, true
	case 19330:
		return OpcuaNodeIdServicesMethod_DeleteCertificateMethodType, true
	case 19332:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CreateSelfSignedCertificate, true
	case 19335:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_DeleteCertificate, true
	case 19337:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CreateSelfSignedCertificate, true
	case 19340:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_DeleteCertificate, true
	case 19342:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CreateSelfSignedCertificate, true
	case 19345:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_DeleteCertificate, true
	case 19347:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate, true
	case 19350:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_DeleteCertificate, true
	case 19353:
		return OpcuaNodeIdServicesMethod_LogObjectType_GetRecords, true
	case 19358:
		return OpcuaNodeIdServicesMethod_GetRecordsMethodType, true
	case 19373:
		return OpcuaNodeIdServicesMethod_ServerLog_GetRecords, true
	case 19410:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_KeyCredentials_CreateCredential, true
	case 19424:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_KeyCredentials_CreateCredential, true
	case 19483:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Disable, true
	case 19484:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Enable, true
	case 19485:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_AddComment, true
	case 19505:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Acknowledge, true
	case 19507:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Confirm, true
	case 19562:
		return OpcuaNodeIdServicesMethod_DataSetWriterType_Diagnostics_Reset, true
	case 19621:
		return OpcuaNodeIdServicesMethod_DataSetReaderType_Diagnostics_Reset, true
	case 19689:
		return OpcuaNodeIdServicesMethod_PubSubDiagnosticsType_Reset, true
	case 19740:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential, true
	case 20097:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve, true
	case 20099:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve, true
	case 20100:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve, true
	case 20132:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Silence, true
	case 20133:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Suppress, true
	case 20134:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Unsuppress, true
	case 20135:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_RemoveFromService, true
	case 20136:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_PlaceInService, true
	case 20137:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Reset, true
	case 20176:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Disable, true
	case 20177:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Enable, true
	case 20178:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_AddComment, true
	case 20198:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Acknowledge, true
	case 20200:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Confirm, true
	case 20245:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 20247:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 20248:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 20280:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Silence, true
	case 20281:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Suppress, true
	case 20282:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Unsuppress, true
	case 20283:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_RemoveFromService, true
	case 20284:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_PlaceInService, true
	case 20285:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Reset, true
	case 20324:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Disable, true
	case 20325:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Enable, true
	case 20326:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment, true
	case 20346:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge, true
	case 20348:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm, true
	case 20393:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 20395:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 20396:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 20430:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Silence, true
	case 20431:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress, true
	case 20432:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress, true
	case 20433:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService, true
	case 20434:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService, true
	case 20435:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset, true
	case 20474:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Disable, true
	case 20475:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Enable, true
	case 20476:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment, true
	case 20496:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge, true
	case 20498:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm, true
	case 20543:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 20545:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 20546:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 20578:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Silence, true
	case 20579:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress, true
	case 20580:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress, true
	case 20581:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService, true
	case 20582:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService, true
	case 20583:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset, true
	case 20622:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Disable, true
	case 20623:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Enable, true
	case 20624:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment, true
	case 20644:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge, true
	case 20646:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm, true
	case 20691:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 20693:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 20694:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 20726:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Silence, true
	case 20727:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress, true
	case 20728:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress, true
	case 20729:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService, true
	case 20730:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService, true
	case 20731:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset, true
	case 20770:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Disable, true
	case 20771:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Enable, true
	case 20772:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment, true
	case 20792:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge, true
	case 20794:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm, true
	case 20839:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 20841:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 20842:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 20874:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Silence, true
	case 20875:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress, true
	case 20876:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress, true
	case 20877:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService, true
	case 20878:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService, true
	case 20879:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset, true
	case 20918:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Disable, true
	case 20919:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Enable, true
	case 20920:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment, true
	case 20940:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge, true
	case 20942:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Confirm, true
	case 20987:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 20989:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 20990:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 21009:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables, true
	case 21012:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror, true
	case 21027:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_Diagnostics_Reset, true
	case 21082:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_AddDataSetReader, true
	case 21085:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_RemoveDataSetReader, true
	case 21087:
		return OpcuaNodeIdServicesMethod_PubSubGroupTypeAddReaderMethodType, true
	case 21225:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Silence, true
	case 21226:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress, true
	case 21227:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress, true
	case 21228:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService, true
	case 21229:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService, true
	case 21230:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset, true
	case 21269:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Disable, true
	case 21270:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Enable, true
	case 21271:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment, true
	case 21291:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge, true
	case 21293:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Confirm, true
	case 21338:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 21340:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 21341:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 21373:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Silence, true
	case 21374:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress, true
	case 21375:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress, true
	case 21376:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService, true
	case 21377:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService, true
	case 21378:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset, true
	case 21417:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Disable, true
	case 21418:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Enable, true
	case 21419:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment, true
	case 21439:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge, true
	case 21441:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Confirm, true
	case 21486:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve, true
	case 21488:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve, true
	case 21489:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve, true
	case 21521:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Silence, true
	case 21522:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress, true
	case 21523:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress, true
	case 21524:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService, true
	case 21525:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService, true
	case 21526:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset, true
	case 21565:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Disable, true
	case 21566:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Enable, true
	case 21567:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment, true
	case 21587:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge, true
	case 21589:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Confirm, true
	case 21634:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 21636:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 21637:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 21669:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Silence, true
	case 21670:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress, true
	case 21671:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress, true
	case 21672:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService, true
	case 21673:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService, true
	case 21674:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset, true
	case 21713:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable, true
	case 21714:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable, true
	case 21715:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment, true
	case 21735:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge, true
	case 21737:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm, true
	case 21782:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 21784:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 21785:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 21817:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence, true
	case 21818:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress, true
	case 21819:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress, true
	case 21820:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService, true
	case 21821:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService, true
	case 21822:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset, true
	case 21861:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable, true
	case 21862:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable, true
	case 21863:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment, true
	case 21883:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge, true
	case 21885:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm, true
	case 21930:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 21932:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 21933:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 21965:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence, true
	case 21966:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress, true
	case 21967:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress, true
	case 21968:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService, true
	case 21969:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService, true
	case 21970:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset, true
	case 22009:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable, true
	case 22010:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable, true
	case 22011:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment, true
	case 22031:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge, true
	case 22033:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm, true
	case 22078:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 22080:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 22081:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 22113:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence, true
	case 22114:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress, true
	case 22115:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress, true
	case 22116:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService, true
	case 22117:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService, true
	case 22118:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset, true
	case 22157:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable, true
	case 22158:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable, true
	case 22159:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment, true
	case 22179:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge, true
	case 22181:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm, true
	case 22226:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 22228:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 22229:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 22261:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence, true
	case 22262:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress, true
	case 22263:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress, true
	case 22264:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService, true
	case 22265:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService, true
	case 22266:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset, true
	case 22305:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable, true
	case 22306:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable, true
	case 22307:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment, true
	case 22327:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge, true
	case 22329:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm, true
	case 22374:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 22376:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 22377:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 22409:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence, true
	case 22410:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress, true
	case 22411:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress, true
	case 22412:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService, true
	case 22413:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService, true
	case 22414:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset, true
	case 22453:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable, true
	case 22454:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable, true
	case 22455:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment, true
	case 22475:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge, true
	case 22477:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm, true
	case 22522:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 22524:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 22525:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 22557:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence, true
	case 22558:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress, true
	case 22559:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress, true
	case 22560:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService, true
	case 22561:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService, true
	case 22562:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset, true
	case 22601:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable, true
	case 22602:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable, true
	case 22603:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment, true
	case 22623:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge, true
	case 22625:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm, true
	case 22670:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 22672:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 22673:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 22705:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence, true
	case 22706:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress, true
	case 22707:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress, true
	case 22708:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService, true
	case 22709:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService, true
	case 22710:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset, true
	case 22749:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable, true
	case 22750:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable, true
	case 22751:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment, true
	case 22771:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge, true
	case 22773:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm, true
	case 22818:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 22820:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 22821:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 22853:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence, true
	case 22854:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress, true
	case 22855:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress, true
	case 22856:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService, true
	case 22857:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService, true
	case 22858:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset, true
	case 22897:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable, true
	case 22898:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable, true
	case 22899:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment, true
	case 22919:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge, true
	case 22921:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm, true
	case 22966:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 22968:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 22969:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 23001:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence, true
	case 23002:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress, true
	case 23003:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress, true
	case 23004:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService, true
	case 23005:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService, true
	case 23006:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset, true
	case 23045:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable, true
	case 23046:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable, true
	case 23047:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment, true
	case 23067:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge, true
	case 23069:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm, true
	case 23114:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 23116:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 23117:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 23149:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence, true
	case 23150:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress, true
	case 23151:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress, true
	case 23152:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService, true
	case 23153:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService, true
	case 23154:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset, true
	case 23193:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable, true
	case 23194:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable, true
	case 23195:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment, true
	case 23215:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge, true
	case 23217:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm, true
	case 23262:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 23264:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 23265:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 23297:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence, true
	case 23298:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress, true
	case 23299:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress, true
	case 23300:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService, true
	case 23301:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService, true
	case 23302:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset, true
	case 23341:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable, true
	case 23342:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable, true
	case 23343:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment, true
	case 23363:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge, true
	case 23365:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm, true
	case 23410:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 23412:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 23413:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 23445:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence, true
	case 23446:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress, true
	case 23447:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress, true
	case 23448:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService, true
	case 23449:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService, true
	case 23450:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset, true
	case 23459:
		return OpcuaNodeIdServicesMethod_AliasNameCategoryType_SubAliasNameCategories_Placeholder_FindAlias, true
	case 23462:
		return OpcuaNodeIdServicesMethod_AliasNameCategoryType_FindAlias, true
	case 23465:
		return OpcuaNodeIdServicesMethod_FindAliasMethodType, true
	case 23476:
		return OpcuaNodeIdServicesMethod_Aliases_FindAlias, true
	case 23485:
		return OpcuaNodeIdServicesMethod_TagVariables_FindAlias, true
	case 23494:
		return OpcuaNodeIdServicesMethod_Topics_FindAlias, true
	case 23526:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_GetRejectedList, true
	case 23529:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_GetRejectedList, true
	case 23531:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_GetRejectedList, true
	case 23533:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_GetRejectedList, true
	case 23535:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_GetRejectedList, true
	case 23544:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList, true
	case 23546:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList, true
	case 23548:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList, true
	case 23550:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_GetRejectedList, true
	case 23552:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_GetRejectedList, true
	case 23554:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_GetRejectedList, true
	case 23637:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder, true
	case 23640:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder, true
	case 23673:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_AddDataSetFolder, true
	case 23676:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder, true
	case 23726:
		return OpcuaNodeIdServicesMethod_GetConnectionMethodType, true
	case 23729:
		return OpcuaNodeIdServicesMethod_ModifyConnectionMethodType, true
	case 23745:
		return OpcuaNodeIdServicesMethod_GetWriterGroupMethodType, true
	case 23748:
		return OpcuaNodeIdServicesMethod_ModifyWriterGroupMethodType, true
	case 23767:
		return OpcuaNodeIdServicesMethod_GetReaderGroupMethodType, true
	case 23770:
		return OpcuaNodeIdServicesMethod_ModifyReaderGroupMethodType, true
	case 23779:
		return OpcuaNodeIdServicesMethod_GetDataSetWriterMethodType, true
	case 23781:
		return OpcuaNodeIdServicesMethod_ModifyDataSetWriterMethodType, true
	case 23790:
		return OpcuaNodeIdServicesMethod_GetDataSetReaderMethodType, true
	case 23792:
		return OpcuaNodeIdServicesMethod_ModifyDataSetReaderMethodType, true
	case 23797:
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddSubscribedDataSet, true
	case 23800:
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveSubscribedDataSet, true
	case 23802:
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddDataSetFolder, true
	case 23805:
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveDataSetFolder, true
	case 23811:
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_AddSubscribedDataSet, true
	case 23814:
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_RemoveSubscribedDataSet, true
	case 23816:
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_AddDataSetFolder, true
	case 23819:
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_RemoveDataSetFolder, true
	case 23821:
		return OpcuaNodeIdServicesMethod_AddSubscribedDataSetMethodType, true
	case 23824:
		return OpcuaNodeIdServicesMethod_RemoveSubscribedDataSetMethodType, true
	case 24004:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet, true
	case 24007:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet, true
	case 24010:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet, true
	case 24013:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet, true
	case 2426:
		return OpcuaNodeIdServicesMethod_ProgramStateMachineType_Start, true
	case 24269:
		return OpcuaNodeIdServicesMethod_UserManagementType_AddUser, true
	case 2427:
		return OpcuaNodeIdServicesMethod_ProgramStateMachineType_Suspend, true
	case 24271:
		return OpcuaNodeIdServicesMethod_UserManagementType_ModifyUser, true
	case 24273:
		return OpcuaNodeIdServicesMethod_UserManagementType_RemoveUser, true
	case 24275:
		return OpcuaNodeIdServicesMethod_UserManagementType_ChangePassword, true
	case 2428:
		return OpcuaNodeIdServicesMethod_ProgramStateMachineType_Resume, true
	case 24282:
		return OpcuaNodeIdServicesMethod_AddUserMethodType, true
	case 24284:
		return OpcuaNodeIdServicesMethod_ModifyUserMethodType, true
	case 24286:
		return OpcuaNodeIdServicesMethod_RemoveUserMethodType, true
	case 24288:
		return OpcuaNodeIdServicesMethod_ChangePasswordMethodType, true
	case 2429:
		return OpcuaNodeIdServicesMethod_ProgramStateMachineType_Halt, true
	case 2430:
		return OpcuaNodeIdServicesMethod_ProgramStateMachineType_Reset, true
	case 24304:
		return OpcuaNodeIdServicesMethod_UserManagement_AddUser, true
	case 24306:
		return OpcuaNodeIdServicesMethod_UserManagement_ModifyUser, true
	case 24308:
		return OpcuaNodeIdServicesMethod_UserManagement_RemoveUser, true
	case 24310:
		return OpcuaNodeIdServicesMethod_UserManagement_ChangePassword, true
	case 24312:
		return OpcuaNodeIdServicesMethod_DialogConditionType_Respond2, true
	case 24314:
		return OpcuaNodeIdServicesMethod_DialogResponse2MethodType, true
	case 24316:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Suppress2, true
	case 24318:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Unsuppress2, true
	case 24320:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_RemoveFromService2, true
	case 24322:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_PlaceInService2, true
	case 24324:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Reset2, true
	case 24326:
		return OpcuaNodeIdServicesMethod_WithCommentMethodType, true
	case 24328:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress2, true
	case 24330:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress2, true
	case 24332:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2, true
	case 24334:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService2, true
	case 24336:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Reset2, true
	case 24518:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Suppress2, true
	case 24520:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Unsuppress2, true
	case 24522:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_RemoveFromService2, true
	case 24524:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_PlaceInService2, true
	case 24526:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Reset2, true
	case 24528:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Suppress2, true
	case 24530:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Unsuppress2, true
	case 24532:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_RemoveFromService2, true
	case 24534:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_PlaceInService2, true
	case 24536:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Reset2, true
	case 24538:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress2, true
	case 24540:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress2, true
	case 24542:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService2, true
	case 24544:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService2, true
	case 24546:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset2, true
	case 24548:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress2, true
	case 24550:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2, true
	case 24552:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24554:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2, true
	case 24556:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset2, true
	case 24558:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress2, true
	case 24560:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress2, true
	case 24562:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService2, true
	case 24564:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService2, true
	case 24566:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset2, true
	case 24568:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress2, true
	case 24570:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2, true
	case 24572:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24574:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2, true
	case 24576:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset2, true
	case 24578:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress2, true
	case 24580:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress2, true
	case 24582:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2, true
	case 24584:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService2, true
	case 24586:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset2, true
	case 24588:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2, true
	case 24590:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2, true
	case 24592:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24594:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2, true
	case 24596:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset2, true
	case 24598:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress2, true
	case 24600:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress2, true
	case 24602:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService2, true
	case 24604:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService2, true
	case 24606:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset2, true
	case 24608:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress2, true
	case 24610:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress2, true
	case 24612:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService2, true
	case 24614:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService2, true
	case 24616:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset2, true
	case 24618:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2, true
	case 24620:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2, true
	case 24622:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2, true
	case 24624:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2, true
	case 24626:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2, true
	case 24628:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2, true
	case 24630:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2, true
	case 24632:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24634:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2, true
	case 24636:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2, true
	case 24638:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2, true
	case 24640:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2, true
	case 24642:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2, true
	case 24644:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2, true
	case 24646:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2, true
	case 24648:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2, true
	case 24650:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2, true
	case 24652:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24654:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2, true
	case 24656:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2, true
	case 24658:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2, true
	case 24660:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2, true
	case 24662:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2, true
	case 24664:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2, true
	case 24666:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2, true
	case 24668:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2, true
	case 24670:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2, true
	case 24672:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24674:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2, true
	case 24676:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2, true
	case 24678:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2, true
	case 24680:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2, true
	case 24682:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2, true
	case 24684:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2, true
	case 24686:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2, true
	case 24688:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2, true
	case 24690:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2, true
	case 24692:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24694:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2, true
	case 24696:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2, true
	case 24698:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2, true
	case 24700:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2, true
	case 24702:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2, true
	case 24704:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2, true
	case 24706:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2, true
	case 24708:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2, true
	case 24710:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2, true
	case 24712:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24714:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2, true
	case 24716:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2, true
	case 24718:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2, true
	case 24720:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2, true
	case 24722:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2, true
	case 24724:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2, true
	case 24726:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2, true
	case 24728:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2, true
	case 24730:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2, true
	case 24732:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24734:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2, true
	case 24736:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2, true
	case 24738:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_TimedShelve2, true
	case 24740:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_Unshelve2, true
	case 24742:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_OneShotShelve2, true
	case 24744:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_GetGroupMemberships, true
	case 24746:
		return OpcuaNodeIdServicesMethod_GetGroupMembershipsMethodType, true
	case 24748:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2, true
	case 24750:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2, true
	case 24752:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2, true
	case 24754:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships, true
	case 24756:
		return OpcuaNodeIdServicesMethod_ShelvedStateMachineType_TimedShelve2, true
	case 24758:
		return OpcuaNodeIdServicesMethod_ShelvedStateMachineType_Unshelve2, true
	case 24760:
		return OpcuaNodeIdServicesMethod_ShelvedStateMachineType_OneShotShelve2, true
	case 24978:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve2, true
	case 24980:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve2, true
	case 24982:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 24984:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_GetGroupMemberships, true
	case 24986:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 24988:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 24990:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 24992:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_GetGroupMemberships, true
	case 24994:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 24996:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 24998:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25000:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships, true
	case 25002:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25004:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25006:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25008:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25010:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25012:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 25014:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25016:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships, true
	case 25018:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25020:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25022:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25024:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25026:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25028:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 25030:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25032:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships, true
	case 25034:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25036:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25038:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25040:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25042:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25044:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve2, true
	case 25046:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25048:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_GetGroupMemberships, true
	case 25050:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25052:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25054:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25056:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_GetGroupMemberships, true
	case 25058:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25060:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 25062:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25064:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships, true
	case 25066:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25068:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25070:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25072:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25074:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25076:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 25078:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25080:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships, true
	case 25082:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25084:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25086:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25088:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25090:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25092:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 25094:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25096:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships, true
	case 25098:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25100:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25102:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25104:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25106:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25108:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 25110:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25112:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships, true
	case 25114:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25116:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25118:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25120:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25122:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25124:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 25126:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25128:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships, true
	case 25130:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25132:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25134:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25136:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25138:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25140:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 25142:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25144:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships, true
	case 25146:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25148:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25150:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25152:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25157:
		return OpcuaNodeIdServicesMethod_TimedShelve2MethodType, true
	case 25229:
		return OpcuaNodeIdServicesMethod_PriorityMappingTableType_AddPriorityMappingEntry, true
	case 25231:
		return OpcuaNodeIdServicesMethod_PriorityMappingTableType_DeletePriorityMappingEntry, true
	case 25233:
		return OpcuaNodeIdServicesMethod_AddPriorityMappingEntryMethodType, true
	case 25235:
		return OpcuaNodeIdServicesMethod_DeletePriorityMappingEntryMethodType, true
	case 25271:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder, true
	case 25274:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder, true
	case 25278:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_AddPushTarget, true
	case 25281:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_RemovePushTarget, true
	case 25283:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder, true
	case 25286:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder, true
	case 25288:
		return OpcuaNodeIdServicesMethod_AddSecurityGroupFolderMethodType, true
	case 25291:
		return OpcuaNodeIdServicesMethod_RemoveSecurityGroupFolderMethodType, true
	case 25293:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder, true
	case 25296:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder, true
	case 25312:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_AddSecurityGroupFolder, true
	case 25315:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_RemoveSecurityGroupFolder, true
	case 25331:
		return OpcuaNodeIdServicesMethod_ConnectSecurityGroupsMethodType, true
	case 25334:
		return OpcuaNodeIdServicesMethod_DisconnectSecurityGroupsMethodType, true
	case 25348:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget, true
	case 25351:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget, true
	case 25353:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder, true
	case 25356:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder, true
	case 25366:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_AddPushTarget, true
	case 25369:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_RemovePushTarget, true
	case 25371:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_AddPushTargetFolder, true
	case 25374:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_RemovePushTargetFolder, true
	case 25376:
		return OpcuaNodeIdServicesMethod_AddPushTargetMethodType, true
	case 25379:
		return OpcuaNodeIdServicesMethod_RemovePushTargetMethodType, true
	case 25381:
		return OpcuaNodeIdServicesMethod_AddPushTargetFolderMethodType, true
	case 25384:
		return OpcuaNodeIdServicesMethod_RemovePushTargetFolderMethodType, true
	case 25411:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Open, true
	case 25414:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Close, true
	case 25416:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Read, true
	case 25419:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Write, true
	case 25421:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_GetPosition, true
	case 25424:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_SetPosition, true
	case 25426:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_ReserveIds, true
	case 25429:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate, true
	case 25434:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder, true
	case 25437:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder, true
	case 25441:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_AddPushTarget, true
	case 25444:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_RemovePushTarget, true
	case 25446:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_AddPushTargetFolder, true
	case 25449:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_RemovePushTargetFolder, true
	case 25459:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Open, true
	case 25462:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Close, true
	case 25464:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Read, true
	case 25467:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Write, true
	case 25469:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_GetPosition, true
	case 25472:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_SetPosition, true
	case 25474:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_ReserveIds, true
	case 25477:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_CloseAndUpdate, true
	case 25505:
		return OpcuaNodeIdServicesMethod_PubSubConfigurationType_ReserveIds, true
	case 25508:
		return OpcuaNodeIdServicesMethod_PubSubConfigurationType_CloseAndUpdate, true
	case 25511:
		return OpcuaNodeIdServicesMethod_PubSubConfigurationTypeReserveIdsMethodType, true
	case 25514:
		return OpcuaNodeIdServicesMethod_PubSubConfigurationTypeCloseAndUpdateMethodType, true
	case 25572:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddIdentity, true
	case 25574:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity, true
	case 25576:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddApplication, true
	case 25578:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveApplication, true
	case 25580:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddEndpoint, true
	case 25582:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint, true
	case 25591:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddIdentity, true
	case 25593:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveIdentity, true
	case 25595:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddApplication, true
	case 25597:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveApplication, true
	case 25599:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddEndpoint, true
	case 25601:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveEndpoint, true
	case 25610:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddIdentity, true
	case 25612:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveIdentity, true
	case 25614:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddApplication, true
	case 25616:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveApplication, true
	case 25618:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddEndpoint, true
	case 25620:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint, true
	case 25622:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupName_Placeholder_InvalidateKeys, true
	case 25623:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupName_Placeholder_ForceKeyRotation, true
	case 25624:
		return OpcuaNodeIdServicesMethod_SecurityGroupType_InvalidateKeys, true
	case 25625:
		return OpcuaNodeIdServicesMethod_SecurityGroupType_ForceKeyRotation, true
	case 25632:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_InvalidateKeys, true
	case 25633:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_ForceKeyRotation, true
	case 25641:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_ConnectSecurityGroups, true
	case 25644:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_DisconnectSecurityGroups, true
	case 25647:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_TriggerKeyUpdate, true
	case 25655:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups, true
	case 25658:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups, true
	case 25661:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_TriggerKeyUpdate, true
	case 25698:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CancelChanges, true
	case 25699:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ResetToServerDefaults, true
	case 25708:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CancelChanges, true
	case 25709:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ResetToServerDefaults, true
	case 25727:
		return OpcuaNodeIdServicesMethod_RequestTicketsMethodType, true
	case 25729:
		return OpcuaNodeIdServicesMethod_SetRegistrarEndpointsMethodType, true
	case 26873:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_RequestTickets, true
	case 26875:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_SetRegistrarEndpoints, true
	case 26889:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open, true
	case 26892:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close, true
	case 26894:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read, true
	case 26897:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write, true
	case 26899:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition, true
	case 26902:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition, true
	case 26907:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks, true
	case 26910:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate, true
	case 26913:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate, true
	case 26915:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate, true
	case 26919:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList, true
	case 26954:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable, true
	case 26955:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable, true
	case 26956:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment, true
	case 26976:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge, true
	case 26978:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm, true
	case 27023:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 27025:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 27027:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 27028:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 27030:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 27031:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 27064:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence, true
	case 27065:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress, true
	case 27066:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2, true
	case 27068:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress, true
	case 27069:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2, true
	case 27071:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService, true
	case 27072:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2, true
	case 27074:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService, true
	case 27075:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2, true
	case 27077:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset, true
	case 27078:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2, true
	case 27080:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships, true
	case 27120:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable, true
	case 27121:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable, true
	case 27122:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment, true
	case 27142:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge, true
	case 27144:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm, true
	case 27189:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 27191:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 27193:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 27194:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 27196:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 27197:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 27230:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence, true
	case 27231:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress, true
	case 27232:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2, true
	case 27234:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress, true
	case 27235:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2, true
	case 27237:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService, true
	case 27238:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2, true
	case 27240:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService, true
	case 27241:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2, true
	case 27243:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset, true
	case 27244:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2, true
	case 27246:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 27261:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open, true
	case 27264:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close, true
	case 27266:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read, true
	case 27269:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write, true
	case 27271:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition, true
	case 27274:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition, true
	case 27279:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks, true
	case 27282:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate, true
	case 27285:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate, true
	case 27287:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate, true
	case 27291:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList, true
	case 27326:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable, true
	case 27327:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable, true
	case 27328:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment, true
	case 27348:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge, true
	case 27350:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm, true
	case 27395:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 27397:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 27399:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 27400:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 27402:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 27403:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 27436:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence, true
	case 27437:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress, true
	case 27438:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2, true
	case 27440:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress, true
	case 27441:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2, true
	case 27443:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService, true
	case 27444:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2, true
	case 27446:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService, true
	case 27447:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2, true
	case 27449:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset, true
	case 27450:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2, true
	case 27452:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships, true
	case 27492:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable, true
	case 27493:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable, true
	case 27494:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment, true
	case 27514:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge, true
	case 27516:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm, true
	case 27561:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 27563:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 27565:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 27566:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 27568:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 27569:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 27602:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence, true
	case 27603:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress, true
	case 27604:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2, true
	case 27606:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress, true
	case 27607:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2, true
	case 27609:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService, true
	case 27610:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2, true
	case 27612:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService, true
	case 27613:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2, true
	case 27615:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset, true
	case 27616:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2, true
	case 27618:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 27633:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open, true
	case 27636:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close, true
	case 27638:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read, true
	case 27641:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write, true
	case 27643:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition, true
	case 27646:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition, true
	case 27651:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks, true
	case 27654:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate, true
	case 27657:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate, true
	case 27659:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate, true
	case 27663:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList, true
	case 27698:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable, true
	case 27699:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable, true
	case 27700:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment, true
	case 27720:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge, true
	case 27722:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm, true
	case 27767:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 27769:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 27771:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 27772:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 27774:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 27775:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 27808:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence, true
	case 27809:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress, true
	case 27810:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2, true
	case 27812:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress, true
	case 27813:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2, true
	case 27815:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService, true
	case 27816:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2, true
	case 27818:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService, true
	case 27819:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2, true
	case 27821:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset, true
	case 27822:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2, true
	case 27824:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships, true
	case 27864:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable, true
	case 27865:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable, true
	case 27866:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment, true
	case 27886:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge, true
	case 27888:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm, true
	case 27933:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 27935:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 27937:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 27938:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 27940:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 27941:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 27974:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence, true
	case 27975:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress, true
	case 27976:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2, true
	case 27978:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress, true
	case 27979:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2, true
	case 27981:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService, true
	case 27982:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2, true
	case 27984:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService, true
	case 27985:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2, true
	case 27987:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset, true
	case 27988:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2, true
	case 27990:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 28005:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate, true
	case 28008:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ApplyChanges, true
	case 28009:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CancelChanges, true
	case 28010:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest, true
	case 28013:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_GetRejectedList, true
	case 28015:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ResetToServerDefaults, true
	case 2947:
		return OpcuaNodeIdServicesMethod_ShelvedStateMachineType_Unshelve, true
	case 2948:
		return OpcuaNodeIdServicesMethod_ShelvedStateMachineType_OneShotShelve, true
	case 2949:
		return OpcuaNodeIdServicesMethod_ShelvedStateMachineType_TimedShelve, true
	case 29880:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_RequestTickets, true
	case 29882:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_SetRegistrarEndpoints, true
	case 32282:
		return OpcuaNodeIdServicesMethod_GetCertificatesMethodType, true
	case 32296:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_GetCertificates, true
	case 32333:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_GetCertificates, true
	case 32359:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates, true
	case 32416:
		return OpcuaNodeIdServicesMethod_NonTransparentBackupRedundancyType_Failover, true
	case 3863:
		return OpcuaNodeIdServicesMethod_AddCommentMethodType, true
	case 3875:
		return OpcuaNodeIdServicesMethod_ConditionType_ConditionRefresh, true
	case 6102:
		return OpcuaNodeIdServicesMethod_TimedShelveMethodType, true
	case 9007:
		return OpcuaNodeIdServicesMethod_ConditionRefreshMethodType, true
	case 9027:
		return OpcuaNodeIdServicesMethod_ConditionType_Enable, true
	case 9028:
		return OpcuaNodeIdServicesMethod_ConditionType_Disable, true
	case 9029:
		return OpcuaNodeIdServicesMethod_ConditionType_AddComment, true
	case 9031:
		return OpcuaNodeIdServicesMethod_DialogResponseMethodType, true
	case 9069:
		return OpcuaNodeIdServicesMethod_DialogConditionType_Respond, true
	case 9111:
		return OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Acknowledge, true
	case 9113:
		return OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Confirm, true
	case 9211:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_Unshelve, true
	case 9212:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_OneShotShelve, true
	case 9213:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_TimedShelve, true
	}
	return 0, false
}

func OpcuaNodeIdServicesMethodByName(value string) (enum OpcuaNodeIdServicesMethod, ok bool) {
	switch value {
	case "ServerType_GetMonitoredItems":
		return OpcuaNodeIdServicesMethod_ServerType_GetMonitoredItems, true
	case "Server_GetMonitoredItems":
		return OpcuaNodeIdServicesMethod_Server_GetMonitoredItems, true
	case "GetMonitoredItemsMethodType":
		return OpcuaNodeIdServicesMethod_GetMonitoredItemsMethodType, true
	case "FileType_Open":
		return OpcuaNodeIdServicesMethod_FileType_Open, true
	case "FileType_Close":
		return OpcuaNodeIdServicesMethod_FileType_Close, true
	case "FileType_Read":
		return OpcuaNodeIdServicesMethod_FileType_Read, true
	case "FileType_Write":
		return OpcuaNodeIdServicesMethod_FileType_Write, true
	case "FileType_GetPosition":
		return OpcuaNodeIdServicesMethod_FileType_GetPosition, true
	case "FileType_SetPosition":
		return OpcuaNodeIdServicesMethod_FileType_SetPosition, true
	case "AddressSpaceFileType_ExportNamespace":
		return OpcuaNodeIdServicesMethod_AddressSpaceFileType_ExportNamespace, true
	case "NamespaceMetadataType_NamespaceFile_Open":
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Open, true
	case "NamespaceMetadataType_NamespaceFile_Close":
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Close, true
	case "NamespaceMetadataType_NamespaceFile_Read":
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Read, true
	case "NamespaceMetadataType_NamespaceFile_Write":
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Write, true
	case "NamespaceMetadataType_NamespaceFile_GetPosition":
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_GetPosition, true
	case "NamespaceMetadataType_NamespaceFile_SetPosition":
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_SetPosition, true
	case "NamespaceMetadataType_NamespaceFile_ExportNamespace":
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_ExportNamespace, true
	case "NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open":
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open, true
	case "NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close":
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close, true
	case "NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read":
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read, true
	case "NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write":
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write, true
	case "NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition":
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition, true
	case "NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition":
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition, true
	case "NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_ExportNamespace":
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_ExportNamespace, true
	case "OpenMethodType":
		return OpcuaNodeIdServicesMethod_OpenMethodType, true
	case "CloseMethodType":
		return OpcuaNodeIdServicesMethod_CloseMethodType, true
	case "ReadMethodType":
		return OpcuaNodeIdServicesMethod_ReadMethodType, true
	case "WriteMethodType":
		return OpcuaNodeIdServicesMethod_WriteMethodType, true
	case "GetPositionMethodType":
		return OpcuaNodeIdServicesMethod_GetPositionMethodType, true
	case "SetPositionMethodType":
		return OpcuaNodeIdServicesMethod_SetPositionMethodType, true
	case "OpenWithMasksMethodType":
		return OpcuaNodeIdServicesMethod_OpenWithMasksMethodType, true
	case "CloseAndUpdateMethodType":
		return OpcuaNodeIdServicesMethod_CloseAndUpdateMethodType, true
	case "AddCertificateMethodType":
		return OpcuaNodeIdServicesMethod_AddCertificateMethodType, true
	case "RemoveCertificateMethodType":
		return OpcuaNodeIdServicesMethod_RemoveCertificateMethodType, true
	case "TrustListType_OpenWithMasks":
		return OpcuaNodeIdServicesMethod_TrustListType_OpenWithMasks, true
	case "TrustListType_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_TrustListType_CloseAndUpdate, true
	case "TrustListType_AddCertificate":
		return OpcuaNodeIdServicesMethod_TrustListType_AddCertificate, true
	case "TrustListType_RemoveCertificate":
		return OpcuaNodeIdServicesMethod_TrustListType_RemoveCertificate, true
	case "UpdateCertificateMethodType":
		return OpcuaNodeIdServicesMethod_UpdateCertificateMethodType, true
	case "ServerConfigurationType_UpdateCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_UpdateCertificate, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate, true
	case "ServerConfigurationType_CreateSigningRequest":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CreateSigningRequest, true
	case "ServerConfigurationType_ApplyChanges":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ApplyChanges, true
	case "ServerConfiguration_CreateSigningRequest":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CreateSigningRequest, true
	case "ServerConfiguration_ApplyChanges":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ApplyChanges, true
	case "CreateSigningRequestMethodType":
		return OpcuaNodeIdServicesMethod_CreateSigningRequestMethodType, true
	case "ServerType_SetSubscriptionDurable":
		return OpcuaNodeIdServicesMethod_ServerType_SetSubscriptionDurable, true
	case "Server_SetSubscriptionDurable":
		return OpcuaNodeIdServicesMethod_Server_SetSubscriptionDurable, true
	case "SetSubscriptionDurableMethodType":
		return OpcuaNodeIdServicesMethod_SetSubscriptionDurableMethodType, true
	case "GetRejectedListMethodType":
		return OpcuaNodeIdServicesMethod_GetRejectedListMethodType, true
	case "ServerConfigurationType_GetRejectedList":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_GetRejectedList, true
	case "ServerConfiguration_GetRejectedList":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_GetRejectedList, true
	case "ServerType_ResendData":
		return OpcuaNodeIdServicesMethod_ServerType_ResendData, true
	case "Server_ResendData":
		return OpcuaNodeIdServicesMethod_Server_ResendData, true
	case "ResendDataMethodType":
		return OpcuaNodeIdServicesMethod_ResendDataMethodType, true
	case "ServerType_RequestServerStateChange":
		return OpcuaNodeIdServicesMethod_ServerType_RequestServerStateChange, true
	case "Server_RequestServerStateChange":
		return OpcuaNodeIdServicesMethod_Server_RequestServerStateChange, true
	case "RequestServerStateChangeMethodType":
		return OpcuaNodeIdServicesMethod_RequestServerStateChangeMethodType, true
	case "ConditionType_ConditionRefresh2":
		return OpcuaNodeIdServicesMethod_ConditionType_ConditionRefresh2, true
	case "ConditionRefresh2MethodType":
		return OpcuaNodeIdServicesMethod_ConditionRefresh2MethodType, true
	case "CreateDirectoryMethodType":
		return OpcuaNodeIdServicesMethod_CreateDirectoryMethodType, true
	case "CreateFileMethodType":
		return OpcuaNodeIdServicesMethod_CreateFileMethodType, true
	case "DeleteFileMethodType":
		return OpcuaNodeIdServicesMethod_DeleteFileMethodType, true
	case "MoveOrCopyMethodType":
		return OpcuaNodeIdServicesMethod_MoveOrCopyMethodType, true
	case "FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory":
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory, true
	case "FileDirectoryType_FileDirectoryName_Placeholder_CreateFile":
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile, true
	case "FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy":
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy, true
	case "FileDirectoryType_FileName_Placeholder_Open":
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Open, true
	case "FileDirectoryType_FileName_Placeholder_Close":
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Close, true
	case "FileDirectoryType_FileName_Placeholder_Read":
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Read, true
	case "FileDirectoryType_FileName_Placeholder_Write":
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Write, true
	case "FileDirectoryType_FileName_Placeholder_GetPosition":
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_GetPosition, true
	case "FileDirectoryType_FileName_Placeholder_SetPosition":
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_SetPosition, true
	case "FileDirectoryType_CreateDirectory":
		return OpcuaNodeIdServicesMethod_FileDirectoryType_CreateDirectory, true
	case "FileDirectoryType_CreateFile":
		return OpcuaNodeIdServicesMethod_FileDirectoryType_CreateFile, true
	case "FileDirectoryType_DeleteFileSystemObject":
		return OpcuaNodeIdServicesMethod_FileDirectoryType_DeleteFileSystemObject, true
	case "FileDirectoryType_MoveOrCopy":
		return OpcuaNodeIdServicesMethod_FileDirectoryType_MoveOrCopy, true
	case "CertificateGroupType_TrustList_Open":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Open, true
	case "CertificateGroupType_TrustList_Close":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Close, true
	case "CertificateGroupType_TrustList_Read":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Read, true
	case "CertificateGroupType_TrustList_Write":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Write, true
	case "CertificateGroupType_TrustList_GetPosition":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_GetPosition, true
	case "CertificateGroupType_TrustList_SetPosition":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_SetPosition, true
	case "CertificateGroupType_TrustList_OpenWithMasks":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_OpenWithMasks, true
	case "CertificateGroupType_TrustList_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_CloseAndUpdate, true
	case "CertificateGroupType_TrustList_AddCertificate":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_AddCertificate, true
	case "CertificateGroupType_TrustList_RemoveCertificate":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_RemoveCertificate, true
	case "ServerConfiguration_UpdateCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_UpdateCertificate, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate, true
	case "RemoveConnectionMethodType":
		return OpcuaNodeIdServicesMethod_RemoveConnectionMethodType, true
	case "PubSubConnectionType_RemoveGroup":
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_RemoveGroup, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Status_Enable":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Status_Enable, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Status_Disable":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Status_Disable, true
	case "PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup, true
	case "PublishSubscribeType_RemoveConnection":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_RemoveConnection, true
	case "PublishSubscribeType_PublishedDataSets_AddPublishedDataItems":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems, true
	case "PublishSubscribeType_PublishedDataSets_AddPublishedEvents":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedEvents, true
	case "PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet, true
	case "DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems":
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems, true
	case "DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents":
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents, true
	case "DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet":
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet, true
	case "DataSetFolderType_AddPublishedDataItems":
		return OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedDataItems, true
	case "DataSetFolderType_AddPublishedEvents":
		return OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedEvents, true
	case "DataSetFolderType_RemovePublishedDataSet":
		return OpcuaNodeIdServicesMethod_DataSetFolderType_RemovePublishedDataSet, true
	case "AddPublishedDataItemsMethodType":
		return OpcuaNodeIdServicesMethod_AddPublishedDataItemsMethodType, true
	case "AddPublishedEventsMethodType":
		return OpcuaNodeIdServicesMethod_AddPublishedEventsMethodType, true
	case "RemovePublishedDataSetMethodType":
		return OpcuaNodeIdServicesMethod_RemovePublishedDataSetMethodType, true
	case "PublishedDataItemsType_AddVariables":
		return OpcuaNodeIdServicesMethod_PublishedDataItemsType_AddVariables, true
	case "PublishedDataItemsType_RemoveVariables":
		return OpcuaNodeIdServicesMethod_PublishedDataItemsType_RemoveVariables, true
	case "PublishedDataItemsAddVariablesMethodType":
		return OpcuaNodeIdServicesMethod_PublishedDataItemsAddVariablesMethodType, true
	case "PublishedDataItemsRemoveVariablesMethodType":
		return OpcuaNodeIdServicesMethod_PublishedDataItemsRemoveVariablesMethodType, true
	case "PubSubConnectionType_Status_Enable":
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_Status_Enable, true
	case "PubSubConnectionType_Status_Disable":
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_Status_Disable, true
	case "PubSubConnectionTypeRemoveGroupMethodType":
		return OpcuaNodeIdServicesMethod_PubSubConnectionTypeRemoveGroupMethodType, true
	case "PubSubGroupTypeRemoveWriterMethodType":
		return OpcuaNodeIdServicesMethod_PubSubGroupTypeRemoveWriterMethodType, true
	case "PubSubGroupTypeRemoveReaderMethodType":
		return OpcuaNodeIdServicesMethod_PubSubGroupTypeRemoveReaderMethodType, true
	case "PubSubStatusType_Enable":
		return OpcuaNodeIdServicesMethod_PubSubStatusType_Enable, true
	case "PubSubStatusType_Disable":
		return OpcuaNodeIdServicesMethod_PubSubStatusType_Disable, true
	case "PublishedEventsType_ModifyFieldSelection":
		return OpcuaNodeIdServicesMethod_PublishedEventsType_ModifyFieldSelection, true
	case "PublishedEventsTypeModifyFieldSelectionMethodType":
		return OpcuaNodeIdServicesMethod_PublishedEventsTypeModifyFieldSelectionMethodType, true
	case "TargetVariablesType_AddTargetVariables":
		return OpcuaNodeIdServicesMethod_TargetVariablesType_AddTargetVariables, true
	case "TargetVariablesType_RemoveTargetVariables":
		return OpcuaNodeIdServicesMethod_TargetVariablesType_RemoveTargetVariables, true
	case "TargetVariablesTypeAddTargetVariablesMethodType":
		return OpcuaNodeIdServicesMethod_TargetVariablesTypeAddTargetVariablesMethodType, true
	case "TargetVariablesTypeRemoveTargetVariablesMethodType":
		return OpcuaNodeIdServicesMethod_TargetVariablesTypeRemoveTargetVariablesMethodType, true
	case "PublishSubscribe_GetSecurityKeys":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_GetSecurityKeys, true
	case "GetSecurityKeysMethodType":
		return OpcuaNodeIdServicesMethod_GetSecurityKeysMethodType, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Status_Enable":
		return OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Status_Enable, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Status_Disable":
		return OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Status_Disable, true
	case "CreateCredentialMethodType":
		return OpcuaNodeIdServicesMethod_CreateCredentialMethodType, true
	case "PubSubGroupType_Status_Enable":
		return OpcuaNodeIdServicesMethod_PubSubGroupType_Status_Enable, true
	case "PubSubGroupType_Status_Disable":
		return OpcuaNodeIdServicesMethod_PubSubGroupType_Status_Disable, true
	case "DataSetWriterType_Status_Enable":
		return OpcuaNodeIdServicesMethod_DataSetWriterType_Status_Enable, true
	case "DataSetWriterType_Status_Disable":
		return OpcuaNodeIdServicesMethod_DataSetWriterType_Status_Disable, true
	case "DataSetReaderType_Status_Enable":
		return OpcuaNodeIdServicesMethod_DataSetReaderType_Status_Enable, true
	case "DataSetReaderType_Status_Disable":
		return OpcuaNodeIdServicesMethod_DataSetReaderType_Status_Disable, true
	case "PublishSubscribe_GetSecurityGroup":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_GetSecurityGroup, true
	case "PublishSubscribe_SecurityGroups_AddSecurityGroup":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_AddSecurityGroup, true
	case "PublishSubscribe_SecurityGroups_RemoveSecurityGroup":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_RemoveSecurityGroup, true
	case "GetSecurityGroupMethodType":
		return OpcuaNodeIdServicesMethod_GetSecurityGroupMethodType, true
	case "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup":
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup, true
	case "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup":
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup, true
	case "SecurityGroupFolderType_AddSecurityGroup":
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_AddSecurityGroup, true
	case "SecurityGroupFolderType_RemoveSecurityGroup":
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_RemoveSecurityGroup, true
	case "AddSecurityGroupMethodType":
		return OpcuaNodeIdServicesMethod_AddSecurityGroupMethodType, true
	case "RemoveSecurityGroupMethodType":
		return OpcuaNodeIdServicesMethod_RemoveSecurityGroupMethodType, true
	case "DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField":
		return OpcuaNodeIdServicesMethod_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField, true
	case "DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField":
		return OpcuaNodeIdServicesMethod_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField, true
	case "PublishedDataSetType_ExtensionFields_AddExtensionField":
		return OpcuaNodeIdServicesMethod_PublishedDataSetType_ExtensionFields_AddExtensionField, true
	case "PublishedDataSetType_ExtensionFields_RemoveExtensionField":
		return OpcuaNodeIdServicesMethod_PublishedDataSetType_ExtensionFields_RemoveExtensionField, true
	case "ExtensionFieldsType_AddExtensionField":
		return OpcuaNodeIdServicesMethod_ExtensionFieldsType_AddExtensionField, true
	case "ExtensionFieldsType_RemoveExtensionField":
		return OpcuaNodeIdServicesMethod_ExtensionFieldsType_RemoveExtensionField, true
	case "AddExtensionFieldMethodType":
		return OpcuaNodeIdServicesMethod_AddExtensionFieldMethodType, true
	case "RemoveExtensionFieldMethodType":
		return OpcuaNodeIdServicesMethod_RemoveExtensionFieldMethodType, true
	case "ConfigurationFileType_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_ConfigurationFileType_CloseAndUpdate, true
	case "ConfigurationFileType_ConfirmUpdate":
		return OpcuaNodeIdServicesMethod_ConfigurationFileType_ConfirmUpdate, true
	case "ConfigurationFileCloseAndUpdateMethodType":
		return OpcuaNodeIdServicesMethod_ConfigurationFileCloseAndUpdateMethodType, true
	case "ConfigurationFileConfirmUpdateMethodType":
		return OpcuaNodeIdServicesMethod_ConfigurationFileConfirmUpdateMethodType, true
	case "ServerConfigurationType_ConfigurationFile_Open":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_Open, true
	case "ServerConfigurationType_ConfigurationFile_Close":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_Close, true
	case "RoleSetType_RoleName_Placeholder_AddIdentity":
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddIdentity, true
	case "RoleSetType_RoleName_Placeholder_RemoveIdentity":
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveIdentity, true
	case "RoleType_AddIdentity":
		return OpcuaNodeIdServicesMethod_RoleType_AddIdentity, true
	case "RoleType_RemoveIdentity":
		return OpcuaNodeIdServicesMethod_RoleType_RemoveIdentity, true
	case "AddIdentityMethodType":
		return OpcuaNodeIdServicesMethod_AddIdentityMethodType, true
	case "RemoveIdentityMethodType":
		return OpcuaNodeIdServicesMethod_RemoveIdentityMethodType, true
	case "WellKnownRole_Anonymous_AddIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddIdentity, true
	case "WellKnownRole_Anonymous_RemoveIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveIdentity, true
	case "WellKnownRole_AuthenticatedUser_AddIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddIdentity, true
	case "WellKnownRole_AuthenticatedUser_RemoveIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveIdentity, true
	case "WellKnownRole_Observer_AddIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddIdentity, true
	case "WellKnownRole_Observer_RemoveIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveIdentity, true
	case "WellKnownRole_Operator_AddIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddIdentity, true
	case "WellKnownRole_Operator_RemoveIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveIdentity, true
	case "WellKnownRole_Supervisor_AddIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddIdentity, true
	case "WellKnownRole_Supervisor_RemoveIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveIdentity, true
	case "WellKnownRole_SecurityAdmin_AddIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddIdentity, true
	case "WellKnownRole_SecurityAdmin_RemoveIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveIdentity, true
	case "WellKnownRole_ConfigureAdmin_AddIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddIdentity, true
	case "WellKnownRole_ConfigureAdmin_RemoveIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveIdentity, true
	case "TemporaryFileTransferType_GenerateFileForRead":
		return OpcuaNodeIdServicesMethod_TemporaryFileTransferType_GenerateFileForRead, true
	case "TemporaryFileTransferType_GenerateFileForWrite":
		return OpcuaNodeIdServicesMethod_TemporaryFileTransferType_GenerateFileForWrite, true
	case "TemporaryFileTransferType_CloseAndCommit":
		return OpcuaNodeIdServicesMethod_TemporaryFileTransferType_CloseAndCommit, true
	case "ServerConfigurationType_ConfigurationFile_Read":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_Read, true
	case "TemporaryFileTransferType_TransferState_Placeholder_Reset":
		return OpcuaNodeIdServicesMethod_TemporaryFileTransferType_TransferState_Placeholder_Reset, true
	case "GenerateFileForReadMethodType":
		return OpcuaNodeIdServicesMethod_GenerateFileForReadMethodType, true
	case "GenerateFileForWriteMethodType":
		return OpcuaNodeIdServicesMethod_GenerateFileForWriteMethodType, true
	case "CloseAndCommitMethodType":
		return OpcuaNodeIdServicesMethod_CloseAndCommitMethodType, true
	case "ServerConfigurationType_ConfigurationFile_Write":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_Write, true
	case "ServerConfigurationType_ConfigurationFile_GetPosition":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_GetPosition, true
	case "ServerConfigurationType_ConfigurationFile_SetPosition":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_SetPosition, true
	case "FileTransferStateMachineType_Reset":
		return OpcuaNodeIdServicesMethod_FileTransferStateMachineType_Reset, true
	case "PublishSubscribeType_Status_Enable":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_Status_Enable, true
	case "PublishSubscribeType_Status_Disable":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_Status_Disable, true
	case "ServerConfigurationType_ConfigurationFile_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_CloseAndUpdate, true
	case "ServerConfigurationType_ConfigurationFile_ConfirmUpdate":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ConfigurationFile_ConfirmUpdate, true
	case "PubSubKeyServiceType_GetSecurityKeys":
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_GetSecurityKeys, true
	case "PubSubKeyServiceType_GetSecurityGroup":
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_GetSecurityGroup, true
	case "PubSubKeyServiceType_SecurityGroups_AddSecurityGroup":
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup, true
	case "PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup":
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup, true
	case "OPCUANamespaceMetadata_NamespaceFile_Open":
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Open, true
	case "OPCUANamespaceMetadata_NamespaceFile_Close":
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Close, true
	case "OPCUANamespaceMetadata_NamespaceFile_Read":
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Read, true
	case "OPCUANamespaceMetadata_NamespaceFile_Write":
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Write, true
	case "OPCUANamespaceMetadata_NamespaceFile_GetPosition":
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_GetPosition, true
	case "OPCUANamespaceMetadata_NamespaceFile_SetPosition":
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_SetPosition, true
	case "OPCUANamespaceMetadata_NamespaceFile_ExportNamespace":
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_ExportNamespace, true
	case "RoleSetType_AddRole":
		return OpcuaNodeIdServicesMethod_RoleSetType_AddRole, true
	case "RoleSetType_RemoveRole":
		return OpcuaNodeIdServicesMethod_RoleSetType_RemoveRole, true
	case "AddRoleMethodType":
		return OpcuaNodeIdServicesMethod_AddRoleMethodType, true
	case "RemoveRoleMethodType":
		return OpcuaNodeIdServicesMethod_RemoveRoleMethodType, true
	case "ServerConfiguration_ConfigurationFile_Open":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_Open, true
	case "WellKnownRole_Engineer_AddIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddIdentity, true
	case "WellKnownRole_Engineer_RemoveIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveIdentity, true
	case "ServerConfiguration_ConfigurationFile_Close":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_Close, true
	case "ServerConfiguration_ConfigurationFile_Read":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_Read, true
	case "ServerConfiguration_ConfigurationFile_Write":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_Write, true
	case "ServerConfiguration_ConfigurationFile_GetPosition":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_GetPosition, true
	case "ServerConfiguration_ConfigurationFile_SetPosition":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_SetPosition, true
	case "RoleSetType_RoleName_Placeholder_AddApplication":
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddApplication, true
	case "RoleSetType_RoleName_Placeholder_RemoveApplication":
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveApplication, true
	case "RoleSetType_RoleName_Placeholder_AddEndpoint":
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddEndpoint, true
	case "RoleSetType_RoleName_Placeholder_RemoveEndpoint":
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveEndpoint, true
	case "RoleType_AddApplication":
		return OpcuaNodeIdServicesMethod_RoleType_AddApplication, true
	case "RoleType_RemoveApplication":
		return OpcuaNodeIdServicesMethod_RoleType_RemoveApplication, true
	case "RoleType_AddEndpoint":
		return OpcuaNodeIdServicesMethod_RoleType_AddEndpoint, true
	case "RoleType_RemoveEndpoint":
		return OpcuaNodeIdServicesMethod_RoleType_RemoveEndpoint, true
	case "AddApplicationMethodType":
		return OpcuaNodeIdServicesMethod_AddApplicationMethodType, true
	case "RemoveApplicationMethodType":
		return OpcuaNodeIdServicesMethod_RemoveApplicationMethodType, true
	case "AddEndpointMethodType":
		return OpcuaNodeIdServicesMethod_AddEndpointMethodType, true
	case "RemoveEndpointMethodType":
		return OpcuaNodeIdServicesMethod_RemoveEndpointMethodType, true
	case "WellKnownRole_Anonymous_AddApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddApplication, true
	case "WellKnownRole_Anonymous_RemoveApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveApplication, true
	case "WellKnownRole_Anonymous_AddEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddEndpoint, true
	case "WellKnownRole_Anonymous_RemoveEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveEndpoint, true
	case "WellKnownRole_AuthenticatedUser_AddApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddApplication, true
	case "WellKnownRole_AuthenticatedUser_RemoveApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveApplication, true
	case "WellKnownRole_AuthenticatedUser_AddEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddEndpoint, true
	case "WellKnownRole_AuthenticatedUser_RemoveEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveEndpoint, true
	case "WellKnownRole_Observer_AddApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddApplication, true
	case "WellKnownRole_Observer_RemoveApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveApplication, true
	case "WellKnownRole_Observer_AddEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddEndpoint, true
	case "WellKnownRole_Observer_RemoveEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveEndpoint, true
	case "WellKnownRole_Operator_AddApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddApplication, true
	case "WellKnownRole_Operator_RemoveApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveApplication, true
	case "WellKnownRole_Operator_AddEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddEndpoint, true
	case "WellKnownRole_Operator_RemoveEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveEndpoint, true
	case "WellKnownRole_Engineer_AddApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddApplication, true
	case "WellKnownRole_Engineer_RemoveApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveApplication, true
	case "WellKnownRole_Engineer_AddEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddEndpoint, true
	case "WellKnownRole_Engineer_RemoveEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveEndpoint, true
	case "WellKnownRole_Supervisor_AddApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddApplication, true
	case "WellKnownRole_Supervisor_RemoveApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveApplication, true
	case "WellKnownRole_Supervisor_AddEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddEndpoint, true
	case "WellKnownRole_Supervisor_RemoveEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveEndpoint, true
	case "WellKnownRole_SecurityAdmin_AddApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddApplication, true
	case "WellKnownRole_SecurityAdmin_RemoveApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveApplication, true
	case "WellKnownRole_SecurityAdmin_AddEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddEndpoint, true
	case "WellKnownRole_SecurityAdmin_RemoveEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveEndpoint, true
	case "WellKnownRole_ConfigureAdmin_AddApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddApplication, true
	case "WellKnownRole_ConfigureAdmin_RemoveApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveApplication, true
	case "WellKnownRole_ConfigureAdmin_AddEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddEndpoint, true
	case "WellKnownRole_ConfigureAdmin_RemoveEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveEndpoint, true
	case "ServerType_ServerCapabilities_RoleSet_AddRole":
		return OpcuaNodeIdServicesMethod_ServerType_ServerCapabilities_RoleSet_AddRole, true
	case "ServerType_ServerCapabilities_RoleSet_RemoveRole":
		return OpcuaNodeIdServicesMethod_ServerType_ServerCapabilities_RoleSet_RemoveRole, true
	case "ServerCapabilitiesType_RoleSet_AddRole":
		return OpcuaNodeIdServicesMethod_ServerCapabilitiesType_RoleSet_AddRole, true
	case "ServerCapabilitiesType_RoleSet_RemoveRole":
		return OpcuaNodeIdServicesMethod_ServerCapabilitiesType_RoleSet_RemoveRole, true
	case "Server_ServerCapabilities_RoleSet_AddRole":
		return OpcuaNodeIdServicesMethod_Server_ServerCapabilities_RoleSet_AddRole, true
	case "Server_ServerCapabilities_RoleSet_RemoveRole":
		return OpcuaNodeIdServicesMethod_Server_ServerCapabilities_RoleSet_RemoveRole, true
	case "ServerConfiguration_ConfigurationFile_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_CloseAndUpdate, true
	case "ServerConfiguration_ConfigurationFile_ConfirmUpdate":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ConfigurationFile_ConfirmUpdate, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open":
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Close":
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Close, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read":
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Write":
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Write, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition":
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SetPosition":
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SetPosition, true
	case "FileSystem_CreateDirectory":
		return OpcuaNodeIdServicesMethod_FileSystem_CreateDirectory, true
	case "FileSystem_CreateFile":
		return OpcuaNodeIdServicesMethod_FileSystem_CreateFile, true
	case "FileSystem_DeleteFileSystemObject":
		return OpcuaNodeIdServicesMethod_FileSystem_DeleteFileSystemObject, true
	case "FileSystem_MoveOrCopy":
		return OpcuaNodeIdServicesMethod_FileSystem_MoveOrCopy, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate, true
	case "AlarmConditionType_Silence":
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Silence, true
	case "AlarmConditionType_Suppress":
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Suppress, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_Disable":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Disable, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_Enable":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Enable, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ConfirmUpdate":
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ConfirmUpdate, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_Silence":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Silence, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress, true
	case "PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup, true
	case "PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup, true
	case "PublishSubscribeType_AddConnection":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_AddConnection, true
	case "PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate, true
	case "PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate, true
	case "PublishSubscribeType_PublishedDataSets_AddDataSetFolder":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddDataSetFolder, true
	case "PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder, true
	case "AddConnectionMethodType":
		return OpcuaNodeIdServicesMethod_AddConnectionMethodType, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm, true
	case "DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate":
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case "DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate":
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate, true
	case "DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder":
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService, true
	case "DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder":
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships, true
	case "DataSetFolderType_AddPublishedDataItemsTemplate":
		return OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedDataItemsTemplate, true
	case "DataSetFolderType_AddPublishedEventsTemplate":
		return OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedEventsTemplate, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment, true
	case "DataSetFolderType_AddDataSetFolder":
		return OpcuaNodeIdServicesMethod_DataSetFolderType_AddDataSetFolder, true
	case "DataSetFolderType_RemoveDataSetFolder":
		return OpcuaNodeIdServicesMethod_DataSetFolderType_RemoveDataSetFolder, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm, true
	case "AddPublishedDataItemsTemplateMethodType":
		return OpcuaNodeIdServicesMethod_AddPublishedDataItemsTemplateMethodType, true
	case "AddPublishedEventsTemplateMethodType":
		return OpcuaNodeIdServicesMethod_AddPublishedEventsTemplateMethodType, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case "AddDataSetFolderMethodType":
		return OpcuaNodeIdServicesMethod_AddDataSetFolderMethodType, true
	case "RemoveDataSetFolderMethodType":
		return OpcuaNodeIdServicesMethod_RemoveDataSetFolderMethodType, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter":
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter, true
	case "PublishSubscribeType_SetSecurityKeys":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SetSecurityKeys, true
	case "SetSecurityKeysMethodType":
		return OpcuaNodeIdServicesMethod_SetSecurityKeysMethodType, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Status_Enable":
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Status_Enable, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Status_Disable":
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Status_Disable, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter":
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Status_Enable":
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Status_Enable, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Status_Disable":
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Status_Disable, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader":
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader":
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader, true
	case "PublishSubscribe_SetSecurityKeys":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SetSecurityKeys, true
	case "PublishSubscribe_AddConnection":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_AddConnection, true
	case "PublishSubscribe_RemoveConnection":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_RemoveConnection, true
	case "PublishSubscribe_PublishedDataSets_AddPublishedDataItems":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedDataItems, true
	case "PublishSubscribe_PublishedDataSets_AddPublishedEvents":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedEvents, true
	case "PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate, true
	case "PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate, true
	case "PublishSubscribe_PublishedDataSets_RemovePublishedDataSet":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_RemovePublishedDataSet, true
	case "DataSetReaderType_CreateTargetVariables":
		return OpcuaNodeIdServicesMethod_DataSetReaderType_CreateTargetVariables, true
	case "DataSetReaderType_CreateDataSetMirror":
		return OpcuaNodeIdServicesMethod_DataSetReaderType_CreateDataSetMirror, true
	case "DataSetReaderTypeCreateTargetVariablesMethodType":
		return OpcuaNodeIdServicesMethod_DataSetReaderTypeCreateTargetVariablesMethodType, true
	case "DataSetReaderTypeCreateDataSetMirrorMethodType":
		return OpcuaNodeIdServicesMethod_DataSetReaderTypeCreateDataSetMirrorMethodType, true
	case "PublishSubscribe_PublishedDataSets_AddDataSetFolder":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddDataSetFolder, true
	case "PublishSubscribe_PublishedDataSets_RemoveDataSetFolder":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_RemoveDataSetFolder, true
	case "PublishSubscribe_Status_Enable":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_Status_Enable, true
	case "PublishSubscribe_Status_Disable":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_Status_Disable, true
	case "PublishSubscribe_Diagnostics_Reset":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_Diagnostics_Reset, true
	case "PubSubConnectionType_AddWriterGroup":
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_AddWriterGroup, true
	case "PubSubConnectionType_AddReaderGroup":
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_AddReaderGroup, true
	case "KeyCredentialConfigurationFolderType_ServiceName_Placeholder_GetEncryptingKey":
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_GetEncryptingKey, true
	case "KeyCredentialConfigurationFolderType_ServiceName_Placeholder_UpdateCredential":
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_UpdateCredential, true
	case "KeyCredentialConfigurationFolderType_ServiceName_Placeholder_DeleteCredential":
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_DeleteCredential, true
	case "KeyCredentialConfigurationFolderType_CreateCredential":
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_CreateCredential, true
	case "KeyCredentialConfiguration_CreateCredential":
		return OpcuaNodeIdServicesMethod_KeyCredentialConfiguration_CreateCredential, true
	case "GetEncryptingKeyMethodType":
		return OpcuaNodeIdServicesMethod_GetEncryptingKeyMethodType, true
	case "KeyCredentialConfigurationType_GetEncryptingKey":
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_GetEncryptingKey, true
	case "PubSubConnectionTypeAddWriterGroupMethodType":
		return OpcuaNodeIdServicesMethod_PubSubConnectionTypeAddWriterGroupMethodType, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships, true
	case "PubSubConnectionAddReaderGroupGroupMethodType":
		return OpcuaNodeIdServicesMethod_PubSubConnectionAddReaderGroupGroupMethodType, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm, true
	case "FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject":
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Status_Enable":
		return OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Status_Enable, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Status_Disable":
		return OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Status_Disable, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Reset":
		return OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Reset, true
	case "WriterGroupType_Diagnostics_Reset":
		return OpcuaNodeIdServicesMethod_WriterGroupType_Diagnostics_Reset, true
	case "AlarmConditionType_Unsuppress":
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Unsuppress, true
	case "AlarmConditionType_RemoveFromService":
		return OpcuaNodeIdServicesMethod_AlarmConditionType_RemoveFromService, true
	case "AlarmConditionType_PlaceInService":
		return OpcuaNodeIdServicesMethod_AlarmConditionType_PlaceInService, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2, true
	case "WriterGroupType_AddDataSetWriter":
		return OpcuaNodeIdServicesMethod_WriterGroupType_AddDataSetWriter, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2, true
	case "WriterGroupType_RemoveDataSetWriter":
		return OpcuaNodeIdServicesMethod_WriterGroupType_RemoveDataSetWriter, true
	case "PubSubGroupTypeAddWriterMethodType":
		return OpcuaNodeIdServicesMethod_PubSubGroupTypeAddWriterMethodType, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships, true
	case "KeyCredentialConfigurationType_UpdateCredential":
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_UpdateCredential, true
	case "KeyCredentialConfigurationType_DeleteCredential":
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_DeleteCredential, true
	case "KeyCredentialUpdateMethodType":
		return OpcuaNodeIdServicesMethod_KeyCredentialUpdateMethodType, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Status_Enable":
		return OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Status_Enable, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Status_Disable":
		return OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Status_Disable, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Reset":
		return OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Reset, true
	case "AlarmConditionType_Reset":
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Reset, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_Reset":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Reset, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_UpdateCertificate":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_UpdateCertificate, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_GetCertificates":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_GetCertificates, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_ApplyChanges":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ApplyChanges, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CancelChanges":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CancelChanges, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CreateSigningRequest":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CreateSigningRequest, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_GetRejectedList":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_GetRejectedList, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_ResetToServerDefaults":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ResetToServerDefaults, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Open":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Open, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Close":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Close, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Read":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Read, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Write":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_Write, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_GetPosition":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_GetPosition, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_SetPosition":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_SetPosition, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_ConfirmUpdate":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile_ConfirmUpdate, true
	case "WellKnownRole_TrustedApplication_AddIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_AddIdentity, true
	case "WellKnownRole_TrustedApplication_RemoveIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_RemoveIdentity, true
	case "WellKnownRole_TrustedApplication_AddApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_AddApplication, true
	case "WellKnownRole_TrustedApplication_RemoveApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_RemoveApplication, true
	case "WellKnownRole_TrustedApplication_AddEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_AddEndpoint, true
	case "WellKnownRole_TrustedApplication_RemoveEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_TrustedApplication_RemoveEndpoint, true
	case "AlarmMetricsType_Reset":
		return OpcuaNodeIdServicesMethod_AlarmMetricsType_Reset, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Reset":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Reset, true
	case "PublishSubscribeType_Diagnostics_Reset":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_Diagnostics_Reset, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Reset":
		return OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Reset, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Reset":
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Reset, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Reset":
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Reset, true
	case "PubSubConnectionType_Diagnostics_Reset":
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_Diagnostics_Reset, true
	case "CreateSelfSignedCertificateMethodType":
		return OpcuaNodeIdServicesMethod_CreateSelfSignedCertificateMethodType, true
	case "DeleteCertificateMethodType":
		return OpcuaNodeIdServicesMethod_DeleteCertificateMethodType, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CreateSelfSignedCertificate":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CreateSelfSignedCertificate, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_DeleteCertificate":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_DeleteCertificate, true
	case "ServerConfigurationType_CreateSelfSignedCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CreateSelfSignedCertificate, true
	case "ServerConfigurationType_DeleteCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_DeleteCertificate, true
	case "ServerConfiguration_CreateSelfSignedCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CreateSelfSignedCertificate, true
	case "ServerConfiguration_DeleteCertificate":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_DeleteCertificate, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate":
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_DeleteCertificate":
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_DeleteCertificate, true
	case "LogObjectType_GetRecords":
		return OpcuaNodeIdServicesMethod_LogObjectType_GetRecords, true
	case "GetRecordsMethodType":
		return OpcuaNodeIdServicesMethod_GetRecordsMethodType, true
	case "ServerLog_GetRecords":
		return OpcuaNodeIdServicesMethod_ServerLog_GetRecords, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_KeyCredentials_CreateCredential":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationFolderType_ApplicationName_Placeholder_KeyCredentials_CreateCredential, true
	case "ApplicationConfigurationType_KeyCredentials_CreateCredential":
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_KeyCredentials_CreateCredential, true
	case "CertificateGroupType_CertificateExpired_Disable":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Disable, true
	case "CertificateGroupType_CertificateExpired_Enable":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Enable, true
	case "CertificateGroupType_CertificateExpired_AddComment":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_AddComment, true
	case "CertificateGroupType_CertificateExpired_Acknowledge":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Acknowledge, true
	case "CertificateGroupType_CertificateExpired_Confirm":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Confirm, true
	case "DataSetWriterType_Diagnostics_Reset":
		return OpcuaNodeIdServicesMethod_DataSetWriterType_Diagnostics_Reset, true
	case "DataSetReaderType_Diagnostics_Reset":
		return OpcuaNodeIdServicesMethod_DataSetReaderType_Diagnostics_Reset, true
	case "PubSubDiagnosticsType_Reset":
		return OpcuaNodeIdServicesMethod_PubSubDiagnosticsType_Reset, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential":
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve, true
	case "CertificateGroupType_CertificateExpired_Silence":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Silence, true
	case "CertificateGroupType_CertificateExpired_Suppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Suppress, true
	case "CertificateGroupType_CertificateExpired_Unsuppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Unsuppress, true
	case "CertificateGroupType_CertificateExpired_RemoveFromService":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_RemoveFromService, true
	case "CertificateGroupType_CertificateExpired_PlaceInService":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_PlaceInService, true
	case "CertificateGroupType_CertificateExpired_Reset":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Reset, true
	case "CertificateGroupType_TrustListOutOfDate_Disable":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Disable, true
	case "CertificateGroupType_TrustListOutOfDate_Enable":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Enable, true
	case "CertificateGroupType_TrustListOutOfDate_AddComment":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_AddComment, true
	case "CertificateGroupType_TrustListOutOfDate_Acknowledge":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Acknowledge, true
	case "CertificateGroupType_TrustListOutOfDate_Confirm":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Confirm, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case "CertificateGroupType_TrustListOutOfDate_Silence":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Silence, true
	case "CertificateGroupType_TrustListOutOfDate_Suppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Suppress, true
	case "CertificateGroupType_TrustListOutOfDate_Unsuppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Unsuppress, true
	case "CertificateGroupType_TrustListOutOfDate_RemoveFromService":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_RemoveFromService, true
	case "CertificateGroupType_TrustListOutOfDate_PlaceInService":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_PlaceInService, true
	case "CertificateGroupType_TrustListOutOfDate_Reset":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Reset, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Disable":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Disable, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Enable":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Enable, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Silence":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Silence, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Disable":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Disable, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Enable":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Enable, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Silence":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Silence, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Disable":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Disable, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Enable":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Enable, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Silence":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Silence, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Disable":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Disable, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Enable":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Enable, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Silence":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Silence, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Disable":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Disable, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Enable":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Enable, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Confirm":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Confirm, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables":
		return OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror":
		return OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror, true
	case "ReaderGroupType_Diagnostics_Reset":
		return OpcuaNodeIdServicesMethod_ReaderGroupType_Diagnostics_Reset, true
	case "ReaderGroupType_AddDataSetReader":
		return OpcuaNodeIdServicesMethod_ReaderGroupType_AddDataSetReader, true
	case "ReaderGroupType_RemoveDataSetReader":
		return OpcuaNodeIdServicesMethod_ReaderGroupType_RemoveDataSetReader, true
	case "PubSubGroupTypeAddReaderMethodType":
		return OpcuaNodeIdServicesMethod_PubSubGroupTypeAddReaderMethodType, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Silence":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Silence, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Disable":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Disable, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Enable":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Enable, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Confirm":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Confirm, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Silence":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Silence, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Disable":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Disable, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Enable":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Enable, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Confirm":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Confirm, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Silence":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Silence, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Disable":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Disable, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Enable":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Enable, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Confirm":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Confirm, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Silence":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Silence, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset, true
	case "AliasNameCategoryType_SubAliasNameCategories_Placeholder_FindAlias":
		return OpcuaNodeIdServicesMethod_AliasNameCategoryType_SubAliasNameCategories_Placeholder_FindAlias, true
	case "AliasNameCategoryType_FindAlias":
		return OpcuaNodeIdServicesMethod_AliasNameCategoryType_FindAlias, true
	case "FindAliasMethodType":
		return OpcuaNodeIdServicesMethod_FindAliasMethodType, true
	case "Aliases_FindAlias":
		return OpcuaNodeIdServicesMethod_Aliases_FindAlias, true
	case "TagVariables_FindAlias":
		return OpcuaNodeIdServicesMethod_TagVariables_FindAlias, true
	case "Topics_FindAlias":
		return OpcuaNodeIdServicesMethod_Topics_FindAlias, true
	case "CertificateGroupType_GetRejectedList":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_GetRejectedList, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_GetRejectedList":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_GetRejectedList, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_GetRejectedList":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_GetRejectedList, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_GetRejectedList":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_GetRejectedList, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_GetRejectedList":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_GetRejectedList, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_GetRejectedList":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_GetRejectedList, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_GetRejectedList":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_GetRejectedList, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_GetRejectedList":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_GetRejectedList, true
	case "PublishSubscribeType_SubscribedDataSets_AddDataSetFolder":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder, true
	case "PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder, true
	case "PublishSubscribe_SubscribedDataSets_AddDataSetFolder":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_AddDataSetFolder, true
	case "PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder, true
	case "GetConnectionMethodType":
		return OpcuaNodeIdServicesMethod_GetConnectionMethodType, true
	case "ModifyConnectionMethodType":
		return OpcuaNodeIdServicesMethod_ModifyConnectionMethodType, true
	case "GetWriterGroupMethodType":
		return OpcuaNodeIdServicesMethod_GetWriterGroupMethodType, true
	case "ModifyWriterGroupMethodType":
		return OpcuaNodeIdServicesMethod_ModifyWriterGroupMethodType, true
	case "GetReaderGroupMethodType":
		return OpcuaNodeIdServicesMethod_GetReaderGroupMethodType, true
	case "ModifyReaderGroupMethodType":
		return OpcuaNodeIdServicesMethod_ModifyReaderGroupMethodType, true
	case "GetDataSetWriterMethodType":
		return OpcuaNodeIdServicesMethod_GetDataSetWriterMethodType, true
	case "ModifyDataSetWriterMethodType":
		return OpcuaNodeIdServicesMethod_ModifyDataSetWriterMethodType, true
	case "GetDataSetReaderMethodType":
		return OpcuaNodeIdServicesMethod_GetDataSetReaderMethodType, true
	case "ModifyDataSetReaderMethodType":
		return OpcuaNodeIdServicesMethod_ModifyDataSetReaderMethodType, true
	case "SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddSubscribedDataSet":
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddSubscribedDataSet, true
	case "SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveSubscribedDataSet":
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveSubscribedDataSet, true
	case "SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddDataSetFolder":
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddDataSetFolder, true
	case "SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveDataSetFolder":
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveDataSetFolder, true
	case "SubscribedDataSetFolderType_AddSubscribedDataSet":
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_AddSubscribedDataSet, true
	case "SubscribedDataSetFolderType_RemoveSubscribedDataSet":
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_RemoveSubscribedDataSet, true
	case "SubscribedDataSetFolderType_AddDataSetFolder":
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_AddDataSetFolder, true
	case "SubscribedDataSetFolderType_RemoveDataSetFolder":
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_RemoveDataSetFolder, true
	case "AddSubscribedDataSetMethodType":
		return OpcuaNodeIdServicesMethod_AddSubscribedDataSetMethodType, true
	case "RemoveSubscribedDataSetMethodType":
		return OpcuaNodeIdServicesMethod_RemoveSubscribedDataSetMethodType, true
	case "PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet, true
	case "PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet, true
	case "PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet, true
	case "PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet, true
	case "ProgramStateMachineType_Start":
		return OpcuaNodeIdServicesMethod_ProgramStateMachineType_Start, true
	case "UserManagementType_AddUser":
		return OpcuaNodeIdServicesMethod_UserManagementType_AddUser, true
	case "ProgramStateMachineType_Suspend":
		return OpcuaNodeIdServicesMethod_ProgramStateMachineType_Suspend, true
	case "UserManagementType_ModifyUser":
		return OpcuaNodeIdServicesMethod_UserManagementType_ModifyUser, true
	case "UserManagementType_RemoveUser":
		return OpcuaNodeIdServicesMethod_UserManagementType_RemoveUser, true
	case "UserManagementType_ChangePassword":
		return OpcuaNodeIdServicesMethod_UserManagementType_ChangePassword, true
	case "ProgramStateMachineType_Resume":
		return OpcuaNodeIdServicesMethod_ProgramStateMachineType_Resume, true
	case "AddUserMethodType":
		return OpcuaNodeIdServicesMethod_AddUserMethodType, true
	case "ModifyUserMethodType":
		return OpcuaNodeIdServicesMethod_ModifyUserMethodType, true
	case "RemoveUserMethodType":
		return OpcuaNodeIdServicesMethod_RemoveUserMethodType, true
	case "ChangePasswordMethodType":
		return OpcuaNodeIdServicesMethod_ChangePasswordMethodType, true
	case "ProgramStateMachineType_Halt":
		return OpcuaNodeIdServicesMethod_ProgramStateMachineType_Halt, true
	case "ProgramStateMachineType_Reset":
		return OpcuaNodeIdServicesMethod_ProgramStateMachineType_Reset, true
	case "UserManagement_AddUser":
		return OpcuaNodeIdServicesMethod_UserManagement_AddUser, true
	case "UserManagement_ModifyUser":
		return OpcuaNodeIdServicesMethod_UserManagement_ModifyUser, true
	case "UserManagement_RemoveUser":
		return OpcuaNodeIdServicesMethod_UserManagement_RemoveUser, true
	case "UserManagement_ChangePassword":
		return OpcuaNodeIdServicesMethod_UserManagement_ChangePassword, true
	case "DialogConditionType_Respond2":
		return OpcuaNodeIdServicesMethod_DialogConditionType_Respond2, true
	case "DialogResponse2MethodType":
		return OpcuaNodeIdServicesMethod_DialogResponse2MethodType, true
	case "AlarmConditionType_Suppress2":
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Suppress2, true
	case "AlarmConditionType_Unsuppress2":
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Unsuppress2, true
	case "AlarmConditionType_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_AlarmConditionType_RemoveFromService2, true
	case "AlarmConditionType_PlaceInService2":
		return OpcuaNodeIdServicesMethod_AlarmConditionType_PlaceInService2, true
	case "AlarmConditionType_Reset2":
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Reset2, true
	case "WithCommentMethodType":
		return OpcuaNodeIdServicesMethod_WithCommentMethodType, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress2":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress2, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress2":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress2, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService2":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService2, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_Reset2":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Reset2, true
	case "CertificateGroupType_CertificateExpired_Suppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Suppress2, true
	case "CertificateGroupType_CertificateExpired_Unsuppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Unsuppress2, true
	case "CertificateGroupType_CertificateExpired_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_RemoveFromService2, true
	case "CertificateGroupType_CertificateExpired_PlaceInService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_PlaceInService2, true
	case "CertificateGroupType_CertificateExpired_Reset2":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Reset2, true
	case "CertificateGroupType_TrustListOutOfDate_Suppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Suppress2, true
	case "CertificateGroupType_TrustListOutOfDate_Unsuppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Unsuppress2, true
	case "CertificateGroupType_TrustListOutOfDate_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_RemoveFromService2, true
	case "CertificateGroupType_TrustListOutOfDate_PlaceInService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_PlaceInService2, true
	case "CertificateGroupType_TrustListOutOfDate_Reset2":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Reset2, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress2, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress2, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService2, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService2, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset2, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress2, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset2, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress2, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress2, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService2, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService2, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset2, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress2, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset2, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress2, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress2, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService2, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset2, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset2, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress2, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress2, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService2, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService2, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset2, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress2, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress2, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService2, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService2, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset2, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2, true
	case "AlarmConditionType_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_TimedShelve2, true
	case "AlarmConditionType_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_Unshelve2, true
	case "AlarmConditionType_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_OneShotShelve2, true
	case "AlarmConditionType_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_AlarmConditionType_GetGroupMemberships, true
	case "GetGroupMembershipsMethodType":
		return OpcuaNodeIdServicesMethod_GetGroupMembershipsMethodType, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships, true
	case "ShelvedStateMachineType_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ShelvedStateMachineType_TimedShelve2, true
	case "ShelvedStateMachineType_Unshelve2":
		return OpcuaNodeIdServicesMethod_ShelvedStateMachineType_Unshelve2, true
	case "ShelvedStateMachineType_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ShelvedStateMachineType_OneShotShelve2, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve2, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve2, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve2, true
	case "CertificateGroupType_CertificateExpired_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_GetGroupMemberships, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case "CertificateGroupType_TrustListOutOfDate_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_GetGroupMemberships, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve2, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve2, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve2, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_GetGroupMemberships, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_GetGroupMemberships, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships, true
	case "TimedShelve2MethodType":
		return OpcuaNodeIdServicesMethod_TimedShelve2MethodType, true
	case "PriorityMappingTableType_AddPriorityMappingEntry":
		return OpcuaNodeIdServicesMethod_PriorityMappingTableType_AddPriorityMappingEntry, true
	case "PriorityMappingTableType_DeletePriorityMappingEntry":
		return OpcuaNodeIdServicesMethod_PriorityMappingTableType_DeletePriorityMappingEntry, true
	case "AddPriorityMappingEntryMethodType":
		return OpcuaNodeIdServicesMethod_AddPriorityMappingEntryMethodType, true
	case "DeletePriorityMappingEntryMethodType":
		return OpcuaNodeIdServicesMethod_DeletePriorityMappingEntryMethodType, true
	case "PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder":
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder, true
	case "PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder":
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder, true
	case "PubSubKeyServiceType_KeyPushTargets_AddPushTarget":
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_AddPushTarget, true
	case "PubSubKeyServiceType_KeyPushTargets_RemovePushTarget":
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_RemovePushTarget, true
	case "PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder":
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder, true
	case "PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder":
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder, true
	case "AddSecurityGroupFolderMethodType":
		return OpcuaNodeIdServicesMethod_AddSecurityGroupFolderMethodType, true
	case "RemoveSecurityGroupFolderMethodType":
		return OpcuaNodeIdServicesMethod_RemoveSecurityGroupFolderMethodType, true
	case "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder":
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder, true
	case "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder":
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder, true
	case "SecurityGroupFolderType_AddSecurityGroupFolder":
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_AddSecurityGroupFolder, true
	case "SecurityGroupFolderType_RemoveSecurityGroupFolder":
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_RemoveSecurityGroupFolder, true
	case "ConnectSecurityGroupsMethodType":
		return OpcuaNodeIdServicesMethod_ConnectSecurityGroupsMethodType, true
	case "DisconnectSecurityGroupsMethodType":
		return OpcuaNodeIdServicesMethod_DisconnectSecurityGroupsMethodType, true
	case "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget":
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget, true
	case "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget":
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget, true
	case "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder":
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder, true
	case "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder":
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder, true
	case "PubSubKeyPushTargetFolderType_AddPushTarget":
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_AddPushTarget, true
	case "PubSubKeyPushTargetFolderType_RemovePushTarget":
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_RemovePushTarget, true
	case "PubSubKeyPushTargetFolderType_AddPushTargetFolder":
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_AddPushTargetFolder, true
	case "PubSubKeyPushTargetFolderType_RemovePushTargetFolder":
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_RemovePushTargetFolder, true
	case "AddPushTargetMethodType":
		return OpcuaNodeIdServicesMethod_AddPushTargetMethodType, true
	case "RemovePushTargetMethodType":
		return OpcuaNodeIdServicesMethod_RemovePushTargetMethodType, true
	case "AddPushTargetFolderMethodType":
		return OpcuaNodeIdServicesMethod_AddPushTargetFolderMethodType, true
	case "RemovePushTargetFolderMethodType":
		return OpcuaNodeIdServicesMethod_RemovePushTargetFolderMethodType, true
	case "PublishSubscribeType_PubSubConfiguration_Open":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Open, true
	case "PublishSubscribeType_PubSubConfiguration_Close":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Close, true
	case "PublishSubscribeType_PubSubConfiguration_Read":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Read, true
	case "PublishSubscribeType_PubSubConfiguration_Write":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Write, true
	case "PublishSubscribeType_PubSubConfiguration_GetPosition":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_GetPosition, true
	case "PublishSubscribeType_PubSubConfiguration_SetPosition":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_SetPosition, true
	case "PublishSubscribeType_PubSubConfiguration_ReserveIds":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_ReserveIds, true
	case "PublishSubscribeType_PubSubConfiguration_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate, true
	case "PublishSubscribe_SecurityGroups_AddSecurityGroupFolder":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder, true
	case "PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder, true
	case "PublishSubscribe_KeyPushTargets_AddPushTarget":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_AddPushTarget, true
	case "PublishSubscribe_KeyPushTargets_RemovePushTarget":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_RemovePushTarget, true
	case "PublishSubscribe_KeyPushTargets_AddPushTargetFolder":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_AddPushTargetFolder, true
	case "PublishSubscribe_KeyPushTargets_RemovePushTargetFolder":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_RemovePushTargetFolder, true
	case "PublishSubscribe_PubSubConfiguration_Open":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Open, true
	case "PublishSubscribe_PubSubConfiguration_Close":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Close, true
	case "PublishSubscribe_PubSubConfiguration_Read":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Read, true
	case "PublishSubscribe_PubSubConfiguration_Write":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Write, true
	case "PublishSubscribe_PubSubConfiguration_GetPosition":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_GetPosition, true
	case "PublishSubscribe_PubSubConfiguration_SetPosition":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_SetPosition, true
	case "PublishSubscribe_PubSubConfiguration_ReserveIds":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_ReserveIds, true
	case "PublishSubscribe_PubSubConfiguration_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_CloseAndUpdate, true
	case "PubSubConfigurationType_ReserveIds":
		return OpcuaNodeIdServicesMethod_PubSubConfigurationType_ReserveIds, true
	case "PubSubConfigurationType_CloseAndUpdate":
		return OpcuaNodeIdServicesMethod_PubSubConfigurationType_CloseAndUpdate, true
	case "PubSubConfigurationTypeReserveIdsMethodType":
		return OpcuaNodeIdServicesMethod_PubSubConfigurationTypeReserveIdsMethodType, true
	case "PubSubConfigurationTypeCloseAndUpdateMethodType":
		return OpcuaNodeIdServicesMethod_PubSubConfigurationTypeCloseAndUpdateMethodType, true
	case "WellKnownRole_SecurityKeyServerAdmin_AddIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddIdentity, true
	case "WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity, true
	case "WellKnownRole_SecurityKeyServerAdmin_AddApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddApplication, true
	case "WellKnownRole_SecurityKeyServerAdmin_RemoveApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveApplication, true
	case "WellKnownRole_SecurityKeyServerAdmin_AddEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddEndpoint, true
	case "WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint, true
	case "WellKnownRole_SecurityKeyServerPush_AddIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddIdentity, true
	case "WellKnownRole_SecurityKeyServerPush_RemoveIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveIdentity, true
	case "WellKnownRole_SecurityKeyServerPush_AddApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddApplication, true
	case "WellKnownRole_SecurityKeyServerPush_RemoveApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveApplication, true
	case "WellKnownRole_SecurityKeyServerPush_AddEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddEndpoint, true
	case "WellKnownRole_SecurityKeyServerPush_RemoveEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveEndpoint, true
	case "WellKnownRole_SecurityKeyServerAccess_AddIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddIdentity, true
	case "WellKnownRole_SecurityKeyServerAccess_RemoveIdentity":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveIdentity, true
	case "WellKnownRole_SecurityKeyServerAccess_AddApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddApplication, true
	case "WellKnownRole_SecurityKeyServerAccess_RemoveApplication":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveApplication, true
	case "WellKnownRole_SecurityKeyServerAccess_AddEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddEndpoint, true
	case "WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint":
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint, true
	case "SecurityGroupFolderType_SecurityGroupName_Placeholder_InvalidateKeys":
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupName_Placeholder_InvalidateKeys, true
	case "SecurityGroupFolderType_SecurityGroupName_Placeholder_ForceKeyRotation":
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupName_Placeholder_ForceKeyRotation, true
	case "SecurityGroupType_InvalidateKeys":
		return OpcuaNodeIdServicesMethod_SecurityGroupType_InvalidateKeys, true
	case "SecurityGroupType_ForceKeyRotation":
		return OpcuaNodeIdServicesMethod_SecurityGroupType_ForceKeyRotation, true
	case "PubSubKeyPushTargetType_SecurityGroupName_Placeholder_InvalidateKeys":
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_InvalidateKeys, true
	case "PubSubKeyPushTargetType_SecurityGroupName_Placeholder_ForceKeyRotation":
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_ForceKeyRotation, true
	case "PubSubKeyPushTargetType_ConnectSecurityGroups":
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_ConnectSecurityGroups, true
	case "PubSubKeyPushTargetType_DisconnectSecurityGroups":
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_DisconnectSecurityGroups, true
	case "PubSubKeyPushTargetType_TriggerKeyUpdate":
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_TriggerKeyUpdate, true
	case "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups":
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups, true
	case "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups":
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups, true
	case "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_TriggerKeyUpdate":
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_TriggerKeyUpdate, true
	case "ServerConfigurationType_CancelChanges":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CancelChanges, true
	case "ServerConfigurationType_ResetToServerDefaults":
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ResetToServerDefaults, true
	case "ServerConfiguration_CancelChanges":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CancelChanges, true
	case "ServerConfiguration_ResetToServerDefaults":
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ResetToServerDefaults, true
	case "RequestTicketsMethodType":
		return OpcuaNodeIdServicesMethod_RequestTicketsMethodType, true
	case "SetRegistrarEndpointsMethodType":
		return OpcuaNodeIdServicesMethod_SetRegistrarEndpointsMethodType, true
	case "ProvisionableDeviceType_RequestTickets":
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_RequestTickets, true
	case "ProvisionableDeviceType_SetRegistrarEndpoints":
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_SetRegistrarEndpoints, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open":
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close":
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read":
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write":
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicat