/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BrowseResult is the corresponding interface of BrowseResult
type BrowseResult interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetStatusCode returns StatusCode (property field)
	GetStatusCode() StatusCode
	// GetContinuationPoint returns ContinuationPoint (property field)
	GetContinuationPoint() PascalByteString
	// GetReferences returns References (property field)
	GetReferences() []ReferenceDescription
	// IsBrowseResult is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBrowseResult()
	// CreateBuilder creates a BrowseResultBuilder
	CreateBrowseResultBuilder() BrowseResultBuilder
}

// _BrowseResult is the data-structure of this message
type _BrowseResult struct {
	ExtensionObjectDefinitionContract
	StatusCode        StatusCode
	ContinuationPoint PascalByteString
	References        []ReferenceDescription
}

var _ BrowseResult = (*_BrowseResult)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_BrowseResult)(nil)

// NewBrowseResult factory function for _BrowseResult
func NewBrowseResult(statusCode StatusCode, continuationPoint PascalByteString, references []ReferenceDescription) *_BrowseResult {
	if statusCode == nil {
		panic("statusCode of type StatusCode for BrowseResult must not be nil")
	}
	if continuationPoint == nil {
		panic("continuationPoint of type PascalByteString for BrowseResult must not be nil")
	}
	_result := &_BrowseResult{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		StatusCode:                        statusCode,
		ContinuationPoint:                 continuationPoint,
		References:                        references,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BrowseResultBuilder is a builder for BrowseResult
type BrowseResultBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(statusCode StatusCode, continuationPoint PascalByteString, references []ReferenceDescription) BrowseResultBuilder
	// WithStatusCode adds StatusCode (property field)
	WithStatusCode(StatusCode) BrowseResultBuilder
	// WithStatusCodeBuilder adds StatusCode (property field) which is build by the builder
	WithStatusCodeBuilder(func(StatusCodeBuilder) StatusCodeBuilder) BrowseResultBuilder
	// WithContinuationPoint adds ContinuationPoint (property field)
	WithContinuationPoint(PascalByteString) BrowseResultBuilder
	// WithContinuationPointBuilder adds ContinuationPoint (property field) which is build by the builder
	WithContinuationPointBuilder(func(PascalByteStringBuilder) PascalByteStringBuilder) BrowseResultBuilder
	// WithReferences adds References (property field)
	WithReferences(...ReferenceDescription) BrowseResultBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the BrowseResult or returns an error if something is wrong
	Build() (BrowseResult, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BrowseResult
}

// NewBrowseResultBuilder() creates a BrowseResultBuilder
func NewBrowseResultBuilder() BrowseResultBuilder {
	return &_BrowseResultBuilder{_BrowseResult: new(_BrowseResult)}
}

type _BrowseResultBuilder struct {
	*_BrowseResult

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (BrowseResultBuilder) = (*_BrowseResultBuilder)(nil)

func (b *_BrowseResultBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._BrowseResult
}

func (b *_BrowseResultBuilder) WithMandatoryFields(statusCode StatusCode, continuationPoint PascalByteString, references []ReferenceDescription) BrowseResultBuilder {
	return b.WithStatusCode(statusCode).WithContinuationPoint(continuationPoint).WithReferences(references...)
}

func (b *_BrowseResultBuilder) WithStatusCode(statusCode StatusCode) BrowseResultBuilder {
	b.StatusCode = statusCode
	return b
}

func (b *_BrowseResultBuilder) WithStatusCodeBuilder(builderSupplier func(StatusCodeBuilder) StatusCodeBuilder) BrowseResultBuilder {
	builder := builderSupplier(b.StatusCode.CreateStatusCodeBuilder())
	var err error
	b.StatusCode, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "StatusCodeBuilder failed"))
	}
	return b
}

func (b *_BrowseResultBuilder) WithContinuationPoint(continuationPoint PascalByteString) BrowseResultBuilder {
	b.ContinuationPoint = continuationPoint
	return b
}

func (b *_BrowseResultBuilder) WithContinuationPointBuilder(builderSupplier func(PascalByteStringBuilder) PascalByteStringBuilder) BrowseResultBuilder {
	builder := builderSupplier(b.ContinuationPoint.CreatePascalByteStringBuilder())
	var err error
	b.ContinuationPoint, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalByteStringBuilder failed"))
	}
	return b
}

func (b *_BrowseResultBuilder) WithReferences(references ...ReferenceDescription) BrowseResultBuilder {
	b.References = references
	return b
}

func (b *_BrowseResultBuilder) Build() (BrowseResult, error) {
	if b.StatusCode == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'statusCode' not set"))
	}
	if b.ContinuationPoint == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'continuationPoint' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BrowseResult.deepCopy(), nil
}

func (b *_BrowseResultBuilder) MustBuild() BrowseResult {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BrowseResultBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_BrowseResultBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_BrowseResultBuilder) DeepCopy() any {
	_copy := b.CreateBrowseResultBuilder().(*_BrowseResultBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBrowseResultBuilder creates a BrowseResultBuilder
func (b *_BrowseResult) CreateBrowseResultBuilder() BrowseResultBuilder {
	if b == nil {
		return NewBrowseResultBuilder()
	}
	return &_BrowseResultBuilder{_BrowseResult: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BrowseResult) GetExtensionId() int32 {
	return int32(524)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BrowseResult) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BrowseResult) GetStatusCode() StatusCode {
	return m.StatusCode
}

func (m *_BrowseResult) GetContinuationPoint() PascalByteString {
	return m.ContinuationPoint
}

func (m *_BrowseResult) GetReferences() []ReferenceDescription {
	return m.References
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBrowseResult(structType any) BrowseResult {
	if casted, ok := structType.(BrowseResult); ok {
		return casted
	}
	if casted, ok := structType.(*BrowseResult); ok {
		return *casted
	}
	return nil
}

func (m *_BrowseResult) GetTypeName() string {
	return "BrowseResult"
}

func (m *_BrowseResult) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (statusCode)
	lengthInBits += m.StatusCode.GetLengthInBits(ctx)

	// Simple field (continuationPoint)
	lengthInBits += m.ContinuationPoint.GetLengthInBits(ctx)

	// Implicit Field (noOfReferences)
	lengthInBits += 32

	// Array field
	if len(m.References) > 0 {
		for _curItem, element := range m.References {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.References), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_BrowseResult) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BrowseResult) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__browseResult BrowseResult, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BrowseResult"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BrowseResult")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	statusCode, err := ReadSimpleField[StatusCode](ctx, "statusCode", ReadComplex[StatusCode](StatusCodeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'statusCode' field"))
	}
	m.StatusCode = statusCode

	continuationPoint, err := ReadSimpleField[PascalByteString](ctx, "continuationPoint", ReadComplex[PascalByteString](PascalByteStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'continuationPoint' field"))
	}
	m.ContinuationPoint = continuationPoint

	noOfReferences, err := ReadImplicitField[int32](ctx, "noOfReferences", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfReferences' field"))
	}
	_ = noOfReferences

	references, err := ReadCountArrayField[ReferenceDescription](ctx, "references", ReadComplex[ReferenceDescription](ExtensionObjectDefinitionParseWithBufferProducer[ReferenceDescription]((int32)(int32(520))), readBuffer), uint64(noOfReferences))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'references' field"))
	}
	m.References = references

	if closeErr := readBuffer.CloseContext("BrowseResult"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BrowseResult")
	}

	return m, nil
}

func (m *_BrowseResult) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BrowseResult) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BrowseResult"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BrowseResult")
		}

		if err := WriteSimpleField[StatusCode](ctx, "statusCode", m.GetStatusCode(), WriteComplex[StatusCode](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'statusCode' field")
		}

		if err := WriteSimpleField[PascalByteString](ctx, "continuationPoint", m.GetContinuationPoint(), WriteComplex[PascalByteString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'continuationPoint' field")
		}
		noOfReferences := int32(utils.InlineIf(bool((m.GetReferences()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetReferences()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfReferences", noOfReferences, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfReferences' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "references", m.GetReferences(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'references' field")
		}

		if popErr := writeBuffer.PopContext("BrowseResult"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BrowseResult")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BrowseResult) IsBrowseResult() {}

func (m *_BrowseResult) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BrowseResult) deepCopy() *_BrowseResult {
	if m == nil {
		return nil
	}
	_BrowseResultCopy := &_BrowseResult{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[StatusCode](m.StatusCode),
		utils.DeepCopy[PascalByteString](m.ContinuationPoint),
		utils.DeepCopySlice[ReferenceDescription, ReferenceDescription](m.References),
	}
	_BrowseResultCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _BrowseResultCopy
}

func (m *_BrowseResult) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
